import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::EKS::Cluster`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html
 */
export interface CfnClusterProps {
    /**
     * `AWS::EKS::Cluster.ResourcesVpcConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-resourcesvpcconfig
     */
    readonly resourcesVpcConfig: CfnCluster.ResourcesVpcConfigProperty | cdk.IResolvable;
    /**
     * `AWS::EKS::Cluster.RoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::EKS::Cluster.EncryptionConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-encryptionconfig
     */
    readonly encryptionConfig?: Array<CfnCluster.EncryptionConfigProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EKS::Cluster.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-name
     */
    readonly name?: string;
    /**
     * `AWS::EKS::Cluster.Version`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-version
     */
    readonly version?: string;
}
/**
 * A CloudFormation `AWS::EKS::Cluster`
 *
 * @cloudformationResource AWS::EKS::Cluster
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html
 */
export declare class CfnCluster extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EKS::Cluster";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute CertificateAuthorityData
     */
    readonly attrCertificateAuthorityData: string;
    /**
     * @cloudformationAttribute ClusterSecurityGroupId
     */
    readonly attrClusterSecurityGroupId: string;
    /**
     * @cloudformationAttribute EncryptionConfigKeyArn
     */
    readonly attrEncryptionConfigKeyArn: string;
    /**
     * @cloudformationAttribute Endpoint
     */
    readonly attrEndpoint: string;
    /**
     * `AWS::EKS::Cluster.ResourcesVpcConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-resourcesvpcconfig
     */
    resourcesVpcConfig: CfnCluster.ResourcesVpcConfigProperty | cdk.IResolvable;
    /**
     * `AWS::EKS::Cluster.RoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-rolearn
     */
    roleArn: string;
    /**
     * `AWS::EKS::Cluster.EncryptionConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-encryptionconfig
     */
    encryptionConfig: Array<CfnCluster.EncryptionConfigProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::EKS::Cluster.Name`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-name
     */
    name: string | undefined;
    /**
     * `AWS::EKS::Cluster.Version`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-cluster.html#cfn-eks-cluster-version
     */
    version: string | undefined;
    /**
     * Create a new `AWS::EKS::Cluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnClusterProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-encryptionconfig.html
     */
    interface EncryptionConfigProperty {
        /**
         * `CfnCluster.EncryptionConfigProperty.Provider`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-encryptionconfig.html#cfn-eks-cluster-encryptionconfig-provider
         */
        readonly provider?: CfnCluster.ProviderProperty | cdk.IResolvable;
        /**
         * `CfnCluster.EncryptionConfigProperty.Resources`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-encryptionconfig.html#cfn-eks-cluster-encryptionconfig-resources
         */
        readonly resources?: string[];
    }
}
export declare namespace CfnCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-provider.html
     */
    interface ProviderProperty {
        /**
         * `CfnCluster.ProviderProperty.KeyArn`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-provider.html#cfn-eks-cluster-provider-keyarn
         */
        readonly keyArn?: string;
    }
}
export declare namespace CfnCluster {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-resourcesvpcconfig.html
     */
    interface ResourcesVpcConfigProperty {
        /**
         * `CfnCluster.ResourcesVpcConfigProperty.SecurityGroupIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-resourcesvpcconfig.html#cfn-eks-cluster-resourcesvpcconfig-securitygroupids
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnCluster.ResourcesVpcConfigProperty.SubnetIds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-cluster-resourcesvpcconfig.html#cfn-eks-cluster-resourcesvpcconfig-subnetids
         */
        readonly subnetIds: string[];
    }
}
/**
 * Properties for defining a `AWS::EKS::FargateProfile`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html
 */
export interface CfnFargateProfileProps {
    /**
     * `AWS::EKS::FargateProfile.ClusterName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-clustername
     */
    readonly clusterName: string;
    /**
     * `AWS::EKS::FargateProfile.PodExecutionRoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-podexecutionrolearn
     */
    readonly podExecutionRoleArn: string;
    /**
     * `AWS::EKS::FargateProfile.Selectors`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-selectors
     */
    readonly selectors: Array<CfnFargateProfile.SelectorProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EKS::FargateProfile.FargateProfileName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-fargateprofilename
     */
    readonly fargateProfileName?: string;
    /**
     * `AWS::EKS::FargateProfile.Subnets`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-subnets
     */
    readonly subnets?: string[];
    /**
     * `AWS::EKS::FargateProfile.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::EKS::FargateProfile`
 *
 * @cloudformationResource AWS::EKS::FargateProfile
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html
 */
export declare class CfnFargateProfile extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EKS::FargateProfile";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::EKS::FargateProfile.ClusterName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-clustername
     */
    clusterName: string;
    /**
     * `AWS::EKS::FargateProfile.PodExecutionRoleArn`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-podexecutionrolearn
     */
    podExecutionRoleArn: string;
    /**
     * `AWS::EKS::FargateProfile.Selectors`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-selectors
     */
    selectors: Array<CfnFargateProfile.SelectorProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::EKS::FargateProfile.FargateProfileName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-fargateprofilename
     */
    fargateProfileName: string | undefined;
    /**
     * `AWS::EKS::FargateProfile.Subnets`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-subnets
     */
    subnets: string[] | undefined;
    /**
     * `AWS::EKS::FargateProfile.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-fargateprofile.html#cfn-eks-fargateprofile-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::EKS::FargateProfile`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFargateProfileProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnFargateProfile {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-fargateprofile-label.html
     */
    interface LabelProperty {
        /**
         * `CfnFargateProfile.LabelProperty.Key`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-fargateprofile-label.html#cfn-eks-fargateprofile-label-key
         */
        readonly key: string;
        /**
         * `CfnFargateProfile.LabelProperty.Value`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-fargateprofile-label.html#cfn-eks-fargateprofile-label-value
         */
        readonly value: string;
    }
}
export declare namespace CfnFargateProfile {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-fargateprofile-selector.html
     */
    interface SelectorProperty {
        /**
         * `CfnFargateProfile.SelectorProperty.Labels`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-fargateprofile-selector.html#cfn-eks-fargateprofile-selector-labels
         */
        readonly labels?: Array<CfnFargateProfile.LabelProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnFargateProfile.SelectorProperty.Namespace`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-fargateprofile-selector.html#cfn-eks-fargateprofile-selector-namespace
         */
        readonly namespace: string;
    }
}
/**
 * Properties for defining a `AWS::EKS::Nodegroup`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html
 */
export interface CfnNodegroupProps {
    /**
     * `AWS::EKS::Nodegroup.ClusterName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-clustername
     */
    readonly clusterName: string;
    /**
     * `AWS::EKS::Nodegroup.NodeRole`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-noderole
     */
    readonly nodeRole: string;
    /**
     * `AWS::EKS::Nodegroup.Subnets`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-subnets
     */
    readonly subnets: string[];
    /**
     * `AWS::EKS::Nodegroup.AmiType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-amitype
     */
    readonly amiType?: string;
    /**
     * `AWS::EKS::Nodegroup.DiskSize`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-disksize
     */
    readonly diskSize?: number;
    /**
     * `AWS::EKS::Nodegroup.ForceUpdateEnabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-forceupdateenabled
     */
    readonly forceUpdateEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::EKS::Nodegroup.InstanceTypes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-instancetypes
     */
    readonly instanceTypes?: string[];
    /**
     * `AWS::EKS::Nodegroup.Labels`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-labels
     */
    readonly labels?: any | cdk.IResolvable;
    /**
     * `AWS::EKS::Nodegroup.LaunchTemplate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-launchtemplate
     */
    readonly launchTemplate?: CfnNodegroup.LaunchTemplateSpecificationProperty | cdk.IResolvable;
    /**
     * `AWS::EKS::Nodegroup.NodegroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-nodegroupname
     */
    readonly nodegroupName?: string;
    /**
     * `AWS::EKS::Nodegroup.ReleaseVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-releaseversion
     */
    readonly releaseVersion?: string;
    /**
     * `AWS::EKS::Nodegroup.RemoteAccess`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-remoteaccess
     */
    readonly remoteAccess?: CfnNodegroup.RemoteAccessProperty | cdk.IResolvable;
    /**
     * `AWS::EKS::Nodegroup.ScalingConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-scalingconfig
     */
    readonly scalingConfig?: CfnNodegroup.ScalingConfigProperty | cdk.IResolvable;
    /**
     * `AWS::EKS::Nodegroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-tags
     */
    readonly tags?: any;
    /**
     * `AWS::EKS::Nodegroup.Version`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-version
     */
    readonly version?: string;
}
/**
 * A CloudFormation `AWS::EKS::Nodegroup`
 *
 * @cloudformationResource AWS::EKS::Nodegroup
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html
 */
export declare class CfnNodegroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::EKS::Nodegroup";
    /**
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @cloudformationAttribute ClusterName
     */
    readonly attrClusterName: string;
    /**
     * @cloudformationAttribute NodegroupName
     */
    readonly attrNodegroupName: string;
    /**
     * `AWS::EKS::Nodegroup.ClusterName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-clustername
     */
    clusterName: string;
    /**
     * `AWS::EKS::Nodegroup.NodeRole`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-noderole
     */
    nodeRole: string;
    /**
     * `AWS::EKS::Nodegroup.Subnets`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-subnets
     */
    subnets: string[];
    /**
     * `AWS::EKS::Nodegroup.AmiType`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-amitype
     */
    amiType: string | undefined;
    /**
     * `AWS::EKS::Nodegroup.DiskSize`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-disksize
     */
    diskSize: number | undefined;
    /**
     * `AWS::EKS::Nodegroup.ForceUpdateEnabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-forceupdateenabled
     */
    forceUpdateEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::EKS::Nodegroup.InstanceTypes`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-instancetypes
     */
    instanceTypes: string[] | undefined;
    /**
     * `AWS::EKS::Nodegroup.Labels`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-labels
     */
    labels: any | cdk.IResolvable | undefined;
    /**
     * `AWS::EKS::Nodegroup.LaunchTemplate`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-launchtemplate
     */
    launchTemplate: CfnNodegroup.LaunchTemplateSpecificationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EKS::Nodegroup.NodegroupName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-nodegroupname
     */
    nodegroupName: string | undefined;
    /**
     * `AWS::EKS::Nodegroup.ReleaseVersion`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-releaseversion
     */
    releaseVersion: string | undefined;
    /**
     * `AWS::EKS::Nodegroup.RemoteAccess`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-remoteaccess
     */
    remoteAccess: CfnNodegroup.RemoteAccessProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EKS::Nodegroup.ScalingConfig`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-scalingconfig
     */
    scalingConfig: CfnNodegroup.ScalingConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::EKS::Nodegroup.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::EKS::Nodegroup.Version`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-eks-nodegroup.html#cfn-eks-nodegroup-version
     */
    version: string | undefined;
    /**
     * Create a new `AWS::EKS::Nodegroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnNodegroupProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnNodegroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-launchtemplatespecification.html
     */
    interface LaunchTemplateSpecificationProperty {
        /**
         * `CfnNodegroup.LaunchTemplateSpecificationProperty.Id`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-launchtemplatespecification.html#cfn-eks-nodegroup-launchtemplatespecification-id
         */
        readonly id?: string;
        /**
         * `CfnNodegroup.LaunchTemplateSpecificationProperty.Name`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-launchtemplatespecification.html#cfn-eks-nodegroup-launchtemplatespecification-name
         */
        readonly name?: string;
        /**
         * `CfnNodegroup.LaunchTemplateSpecificationProperty.Version`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-launchtemplatespecification.html#cfn-eks-nodegroup-launchtemplatespecification-version
         */
        readonly version?: string;
    }
}
export declare namespace CfnNodegroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-remoteaccess.html
     */
    interface RemoteAccessProperty {
        /**
         * `CfnNodegroup.RemoteAccessProperty.Ec2SshKey`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-remoteaccess.html#cfn-eks-nodegroup-remoteaccess-ec2sshkey
         */
        readonly ec2SshKey: string;
        /**
         * `CfnNodegroup.RemoteAccessProperty.SourceSecurityGroups`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-remoteaccess.html#cfn-eks-nodegroup-remoteaccess-sourcesecuritygroups
         */
        readonly sourceSecurityGroups?: string[];
    }
}
export declare namespace CfnNodegroup {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-scalingconfig.html
     */
    interface ScalingConfigProperty {
        /**
         * `CfnNodegroup.ScalingConfigProperty.DesiredSize`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-scalingconfig.html#cfn-eks-nodegroup-scalingconfig-desiredsize
         */
        readonly desiredSize?: number;
        /**
         * `CfnNodegroup.ScalingConfigProperty.MaxSize`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-scalingconfig.html#cfn-eks-nodegroup-scalingconfig-maxsize
         */
        readonly maxSize?: number;
        /**
         * `CfnNodegroup.ScalingConfigProperty.MinSize`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-eks-nodegroup-scalingconfig.html#cfn-eks-nodegroup-scalingconfig-minsize
         */
        readonly minSize?: number;
    }
}
