# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_utils.ipynb.

# %% auto 0
__all__ = ['whisper_norm', 'is_target_text_in_range', 'get_text', 'normalise', 'data', 'get_model_size', 'clear_gpu_memory']

# %% ../nbs/00_utils.ipynb 3
import gc

import torch
from transformers.models.whisper.english_normalizer import BasicTextNormalizer
from numerize import numerize

# %% ../nbs/00_utils.ipynb 4
whisper_norm = BasicTextNormalizer()

# %% ../nbs/00_utils.ipynb 5
def is_target_text_in_range(ref):
    if ref.strip() == "ignore time segment in scoring":
        return False
    else:
        return ref.strip() != ""


def get_text(sample):
    if "text" in sample:
        return sample["text"]
    elif "sentence" in sample:
        return sample["sentence"]
    elif "normalized_text" in sample:
        return sample["normalized_text"]
    elif "transcript" in sample:
        return sample["transcript"]
    elif "transcription" in sample:
        return sample["transcription"]
    else:
        raise ValueError(
            f"Expected transcript column of either 'text', 'sentence', 'normalized_text' or 'transcript'. Got sample of "
            ".join{sample.keys()}. Ensure a text column name is present in the dataset."
        )


def normalise(batch):
    batch["norm_text"] = whisper_norm(get_text(batch))
    return batch


def data(dataset):
    for i, item in enumerate(dataset):
        yield {**item["audio"], "reference": item["norm_text"]}

# %% ../nbs/00_utils.ipynb 6
def get_model_size(model):
    total_params = sum(param.numel() for param in model.parameters())
    return numerize.numerize(total_params)

# %% ../nbs/00_utils.ipynb 7
def clear_gpu_memory():
    torch.cuda.empty_cache()
    gc.collect()
