Flexible framework to check permissions to URIs and forward HTTP requests

Tested with

- **Python:** 3.7, **Django:** 3.2 ([LTS](https://www.djangoproject.com/download/)), **Django Rest Framework:** 3.12
- **Python:** 3.10, **Django:** 4.0 (latest), **Django Rest Framework:** 3.12
- **Python:** 2.7, **Django:** 1.11 (legacy), **Django Rest Framework:** 3.9.4

This project contains bare bone templates. To see it in action, integrated into
a full-fledged subscription-based session proxy with bootstrap-styled
dashboards, take a look at [djaoapp](https://github.com/djaodjin/djaoapp/).

Development
===========

After cloning the repository, create a virtualenv environment and install
the prerequisites:

    $ virtualenv _installTop_
    $ source _installTop_/bin/activate
    $ pip install -r testsite/requirements.txt

It remains to create the database and populate it with test data.

    $ python ./manage.py migrate --run-syncdb --noinput
    $ python ./manage.py loaddata testsite/fixtures/test_data.json

Run the testsite

    $ python ./manage.py runserver


Release Notes
=============

0.4.0

  * adds toggle to enable/disable CORS checks
  * selects rules.App based on path_prefix
  * supports forwarded "OPTIONS" HTTP requests
  * defaults new rule to authenticated and at the top of the list
  * uses up/down arrows in rules dashboard
  * downloads user engagement

[previous release notes](changelog)
