"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.filterLogicalId = exports.formatFailure = exports.matchSection = void 0;
const match_1 = require("../match");
const matcher_1 = require("../matcher");
function matchSection(section, props) {
    const matcher = matcher_1.Matcher.isMatcher(props) ? props : match_1.Match.objectLike(props);
    let closestResult = undefined;
    let matching = {};
    let count = 0;
    eachEntryInSection(section, (logicalId, entry) => {
        const result = matcher.test(entry);
        result.finished();
        if (!result.hasFailed()) {
            matching[logicalId] = entry;
        }
        else {
            count++;
            if (closestResult === undefined || closestResult.failCount > result.failCount) {
                closestResult = result;
            }
        }
    });
    if (Object.keys(matching).length > 0) {
        return { match: true, matches: matching };
    }
    else {
        return { match: false, closestResult, analyzedCount: count };
    }
}
exports.matchSection = matchSection;
function eachEntryInSection(section, cb) {
    for (const logicalId of Object.keys(section !== null && section !== void 0 ? section : {})) {
        const resource = section[logicalId];
        cb(logicalId, resource);
    }
}
function formatFailure(closestResult) {
    return [
        'The closest result is:',
        leftPad(JSON.stringify(closestResult.target, undefined, 2)),
        'with the following mismatches:',
        ...closestResult.toHumanStrings().map(s => `\t${s}`),
    ].join('\n');
}
exports.formatFailure = formatFailure;
function leftPad(x, indent = 2) {
    const pad = ' '.repeat(indent);
    return pad + x.split('\n').join(`\n${pad}`);
}
function filterLogicalId(section, logicalId) {
    // default signal for all logicalIds is '*'
    if (logicalId === '*')
        return section;
    return Object.entries(section !== null && section !== void 0 ? section : {})
        .filter(([k, _]) => k === logicalId)
        .reduce((agg, [k, v]) => { return { ...agg, [k]: v }; }, {});
}
exports.filterLogicalId = filterLogicalId;
//# sourceMappingURL=data:application/json;base64,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