"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MatchResult = exports.Matcher = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents a matcher that can perform special data matching capabilities between a given pattern and a target.
 *
 * @stability stable
 */
class Matcher {
    /**
     * Check whether the provided object is a subtype of the `IMatcher`.
     *
     * @stability stable
     */
    static isMatcher(x) {
        return x && x instanceof Matcher;
    }
}
exports.Matcher = Matcher;
_a = JSII_RTTI_SYMBOL_1;
Matcher[_a] = { fqn: "@aws-cdk/assertions.Matcher", version: "1.135.0" };
/**
 * The result of `Match.test()`.
 *
 * @stability stable
 */
class MatchResult {
    /**
     * @stability stable
     */
    constructor(target) {
        this.failures = [];
        this.captures = new Map();
        this.finalized = false;
        this.target = target;
    }
    /**
     * (deprecated) DEPRECATED.
     *
     * @deprecated use recordFailure()
     */
    push(matcher, path, message) {
        jsiiDeprecationWarnings.print("@aws-cdk/assertions.MatchResult#push", "use recordFailure()");
        jsiiDeprecationWarnings._aws_cdk_assertions_Matcher(matcher);
        return this.recordFailure({ matcher, path, message });
    }
    /**
     * Record a new failure into this result at a specific path.
     *
     * @stability stable
     */
    recordFailure(failure) {
        jsiiDeprecationWarnings._aws_cdk_assertions_MatchFailure(failure);
        this.failures.push(failure);
        return this;
    }
    /**
     * Does the result contain any failures.
     *
     * If not, the result is a success
     *
     * @stability stable
     */
    hasFailed() {
        return this.failures.length !== 0;
    }
    /**
     * The number of failures.
     *
     * @stability stable
     */
    get failCount() {
        return this.failures.length;
    }
    /**
     * Compose the results of a previous match as a subtree.
     *
     * @param id the id of the parent tree.
     * @stability stable
     */
    compose(id, inner) {
        jsiiDeprecationWarnings._aws_cdk_assertions_MatchResult(inner);
        const innerF = inner.failures;
        this.failures.push(...innerF.map(f => {
            return { path: [id, ...f.path], message: f.message, matcher: f.matcher };
        }));
        inner.captures.forEach((vals, capture) => {
            vals.forEach(value => this.recordCapture({ capture, value }));
        });
        return this;
    }
    /**
     * Prepare the result to be analyzed.
     *
     * This API *must* be called prior to analyzing these results.
     *
     * @stability stable
     */
    finished() {
        if (this.finalized) {
            return this;
        }
        if (this.failCount === 0) {
            this.captures.forEach((vals, cap) => cap._captured.push(...vals));
        }
        this.finalized = true;
        return this;
    }
    /**
     * Get the list of failures as human readable strings.
     *
     * @stability stable
     */
    toHumanStrings() {
        return this.failures.map(r => {
            const loc = r.path.length === 0 ? '' : ` at ${r.path.join('')}`;
            return '' + r.message + loc + ` (using ${r.matcher.name} matcher)`;
        });
    }
    /**
     * Record a capture against in this match result.
     *
     * @stability stable
     */
    recordCapture(options) {
        jsiiDeprecationWarnings._aws_cdk_assertions_MatchCapture(options);
        let values = this.captures.get(options.capture);
        if (values === undefined) {
            values = [];
        }
        values.push(options.value);
        this.captures.set(options.capture, values);
    }
}
exports.MatchResult = MatchResult;
_b = JSII_RTTI_SYMBOL_1;
MatchResult[_b] = { fqn: "@aws-cdk/assertions.MatchResult", version: "1.135.0" };
//# sourceMappingURL=data:application/json;base64,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