# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from regula.documentreader.webclient.gen.models.graphic_field_type import GraphicFieldType
from regula.documentreader.webclient.gen.models.parsed_data import ParsedData
from regula.documentreader.webclient.gen.models.rfid_data_file_type import RfidDataFileType
from regula.documentreader.webclient.gen.models.rfid_error_codes import RFIDErrorCodes
from regula.documentreader.webclient.gen.models.security_object_certificates import SecurityObjectCertificates
from regula.documentreader.webclient.gen.models.text_field_type import TextFieldType
from regula.documentreader.webclient.gen.models.trf_ft_bytes import TrfFtBytes
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class RfidDataFile(BaseModel):
    """
    Structure is used to describe the contents of a single file of the LDS of electronic document and the analysis of its contents within the context of the communication session with electronic document
    """ # noqa: E501
    file_id: SkipValidation[Optional[str]] = Field(alias="FileID", default=None, description="File identifier. Each byte of FileID represented by its hexadecimal value. The individual bytes are separated by spaces (e.g. 01 1E)")
    type: SkipValidation[RfidDataFileType] = Field(alias="Type")
    file_data: SkipValidation[Optional[TrfFtBytes]] = Field(alias="FileData", default=None)
    reading_status: SkipValidation[RFIDErrorCodes] = Field(alias="ReadingStatus")
    reading_time: SkipValidation[Optional[float]] = Field(alias="ReadingTime", default=None, description="Time of reading, milliseconds")
    pa_status: SkipValidation[Optional[RFIDErrorCodes]] = Field(alias="PA_Status", default=None)
    notifications: SkipValidation[Optional[List[int]]] = Field(alias="Notifications", default=None, description="List of remarks arisen when reading data from the memory of the chip and analysing their ASN.1-structure. Can be ParsingErrorCodes or ParsingNotificationCodes enum.")
    doc_fields_text: SkipValidation[Optional[List[TextFieldType]]] = Field(alias="DocFields_Text", default=None, description="List of document text fields formed on the basis of the file contents")
    doc_fields_graphics: SkipValidation[Optional[List[GraphicFieldType]]] = Field(alias="DocFields_Graphics", default=None, description="List of document graphic fields formed on the basis of the file contents")
    doc_fields_originals: SkipValidation[Optional[List[GraphicFieldType]]] = Field(alias="DocFields_Originals", default=None, description="List of the original binary representation of graphic document fields formed on the basis of the file contents")
    parsed_data: SkipValidation[Optional[ParsedData]] = Field(alias="ParsedData", default=None)
    security_object_certificates: SkipValidation[Optional[SecurityObjectCertificates]] = Field(alias="SecurityObject_Certificates", default=None)
    __properties: ClassVar[List[str]] = ["FileID", "Type", "FileData", "ReadingStatus", "ReadingTime", "PA_Status", "Notifications", "DocFields_Text", "DocFields_Graphics", "DocFields_Originals", "ParsedData", "SecurityObject_Certificates"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RfidDataFile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of file_data
        if self.file_data:
            _dict['FileData'] = self.file_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of parsed_data
        if self.parsed_data:
            _dict['ParsedData'] = self.parsed_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of security_object_certificates
        if self.security_object_certificates:
            _dict['SecurityObject_Certificates'] = self.security_object_certificates.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RfidDataFile from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "FileID": obj.get("FileID"),
            "Type": obj.get("Type"),
            "FileData": TrfFtBytes.from_dict(obj["FileData"]) if obj.get("FileData") is not None else None,
            "ReadingStatus": obj.get("ReadingStatus"),
            "ReadingTime": obj.get("ReadingTime"),
            "PA_Status": obj.get("PA_Status"),
            "Notifications": obj.get("Notifications"),
            "DocFields_Text": obj.get("DocFields_Text"),
            "DocFields_Graphics": obj.get("DocFields_Graphics"),
            "DocFields_Originals": obj.get("DocFields_Originals"),
            "ParsedData": ParsedData.from_dict(obj["ParsedData"]) if obj.get("ParsedData") is not None else None,
            "SecurityObject_Certificates": SecurityObjectCertificates.from_dict(obj["SecurityObject_Certificates"]) if obj.get("SecurityObject_Certificates") is not None else None
        })
        return _obj


