# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from regula.documentreader.webclient.gen.models.authenticity_check_result_item import AuthenticityCheckResultItem
from regula.documentreader.webclient.gen.models.authenticity_result_type import AuthenticityResultType
from regula.documentreader.webclient.gen.models.check_diagnose import CheckDiagnose
from regula.documentreader.webclient.gen.models.check_result import CheckResult
from regula.documentreader.webclient.gen.models.light import Light
from regula.documentreader.webclient.gen.models.rectangle_coordinates import RectangleCoordinates
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class FiberResult(AuthenticityCheckResultItem):
    """
    FiberResult
    """ # noqa: E501
    rect_count: SkipValidation[int] = Field(alias="RectCount", description="For UV_Fibers authenticity result type")
    expected_count: SkipValidation[int] = Field(alias="ExpectedCount", description="Expected fibers number. For UV_Fibers authentication result type")
    light_value: SkipValidation[Optional[Light]] = Field(alias="LightValue", default=None)
    light_disp: SkipValidation[Optional[int]] = Field(alias="LightDisp", default=None, description="For UV_Background authentication result type")
    rect_array: SkipValidation[List[RectangleCoordinates]] = Field(alias="RectArray", description="Coordinates of located areas for defined fibers type")
    width: SkipValidation[List[int]] = Field(alias="Width", description="Fibers width value for located areas (in pixels)")
    length: SkipValidation[List[int]] = Field(alias="Length", description="Fibers length value for located areas (in pixels)")
    area: SkipValidation[List[int]] = Field(alias="Area", description="Fibers value for areas (in pixels)")
    color_values: SkipValidation[List[int]] = Field(alias="ColorValues", description="Fibers color value")
    __properties: ClassVar[List[str]] = ["Type", "ElementResult", "ElementDiagnose", "PercentValue", "RectCount", "ExpectedCount", "LightValue", "LightDisp", "RectArray", "Width", "Length", "Area", "ColorValues"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FiberResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in rect_array (list)
        _items = []
        if self.rect_array:
            for _item_rect_array in self.rect_array:
                if _item_rect_array:
                    _items.append(_item_rect_array.to_dict())
            _dict['RectArray'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FiberResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Type": obj.get("Type"),
            "ElementResult": obj.get("ElementResult"),
            "ElementDiagnose": obj.get("ElementDiagnose"),
            "PercentValue": obj.get("PercentValue"),
            "RectCount": obj.get("RectCount"),
            "ExpectedCount": obj.get("ExpectedCount"),
            "LightValue": obj.get("LightValue"),
            "LightDisp": obj.get("LightDisp"),
            "RectArray": [RectangleCoordinates.from_dict(_item) for _item in obj.get("RectArray", []) if RectangleCoordinates.from_dict(_item) is not None],
            "Width": obj.get("Width"),
            "Length": obj.get("Length"),
            "Area": obj.get("Area"),
            "ColorValues": obj.get("ColorValues")
        })
        return _obj


