# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from regula.documentreader.webclient.gen.models.document_format import DocumentFormat
from regula.documentreader.webclient.gen.models.document_type import DocumentType
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class FDSIDList(BaseModel):
    """
    Extended document type info and Regula's 'Information Reference Systems' links
    """ # noqa: E501
    icao_code: SkipValidation[str] = Field(alias="ICAOCode", description="ICAO code of the issuing country")
    count: SkipValidation[Optional[float]] = Field(alias="Count", default=None, description="Number of elements in the List")
    list: SkipValidation[Optional[List[int]]] = Field(alias="List", default=None, description="Document identifiers in &#39;Information Reference Systems&#39;")
    d_type: SkipValidation[DocumentType] = Field(alias="dType")
    d_format: SkipValidation[DocumentFormat] = Field(alias="dFormat")
    d_mrz: SkipValidation[bool] = Field(alias="dMRZ", description="Flag indicating the presence of MRZ on the document")
    d_description: SkipValidation[Optional[str]] = Field(alias="dDescription", default=None, description="Document description")
    d_year: SkipValidation[Optional[str]] = Field(alias="dYear", default=None, description="Year of publication of the document")
    d_country_name: SkipValidation[str] = Field(alias="dCountryName", description="Issuing country name")
    d_state_code: SkipValidation[Optional[str]] = Field(alias="dStateCode", default=None, description="Issuing state code")
    d_state_name: SkipValidation[Optional[str]] = Field(alias="dStateName", default=None, description="Issuing state name")
    is_deprecated: SkipValidation[bool] = Field(alias="isDeprecated", description="Whether the document is deprecated")
    __properties: ClassVar[List[str]] = ["ICAOCode", "Count", "List", "dType", "dFormat", "dMRZ", "dDescription", "dYear", "dCountryName", "dStateCode", "dStateName", "isDeprecated"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FDSIDList from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FDSIDList from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ICAOCode": obj.get("ICAOCode"),
            "Count": obj.get("Count"),
            "List": obj.get("List"),
            "dType": obj.get("dType"),
            "dFormat": obj.get("dFormat"),
            "dMRZ": obj.get("dMRZ"),
            "dDescription": obj.get("dDescription"),
            "dYear": obj.get("dYear"),
            "dCountryName": obj.get("dCountryName"),
            "dStateCode": obj.get("dStateCode"),
            "dStateName": obj.get("dStateName"),
            "isDeprecated": obj.get("isDeprecated")
        })
        return _obj


