# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from regula.documentreader.webclient.gen.models.lcid import LCID
from regula.documentreader.webclient.gen.models.rectangle_coordinates import RectangleCoordinates
from regula.documentreader.webclient.gen.models.string_recognition_result import StringRecognitionResult
from regula.documentreader.webclient.gen.models.text_field_type import TextFieldType
from typing import Optional, Set
from typing_extensions import Self
from pydantic import SkipValidation, Field

class DocVisualExtendedField(BaseModel):
    """
    DocVisualExtendedField
    """ # noqa: E501
    w_field_type: SkipValidation[TextFieldType] = Field(alias="wFieldType")
    field_name: SkipValidation[str] = Field(alias="FieldName", description="Field symbolic name (null-terminated string)")
    strings_count: SkipValidation[float] = Field(alias="StringsCount", description="Number of StringsResult array elements")
    strings_result: SkipValidation[List[StringRecognitionResult]] = Field(alias="StringsResult", description="Array of recognizing probabilities for a each line of text field. Only for Result.VISUAL_TEXT and Result.MRZ_TEXT results.")
    buf_length: SkipValidation[float] = Field(alias="Buf_Length", description="Buf_Text text string length")
    buf_text: SkipValidation[Optional[str]] = Field(alias="Buf_Text", default=None, description="Text field data in UTF8 format. Results of reading different lines of a multi-line field are separated by &#39;^&#39;")
    field_mask: SkipValidation[Optional[str]] = Field(alias="FieldMask", default=None)
    validity: SkipValidation[Optional[int]] = Field(alias="Validity", default=None)
    in_comparison: SkipValidation[Optional[int]] = Field(alias="InComparison", default=None)
    w_lcid: SkipValidation[Optional[LCID]] = Field(alias="wLCID", default=None)
    reserved2: SkipValidation[Optional[int]] = Field(alias="Reserved2", default=None)
    reserved3: SkipValidation[Optional[int]] = Field(alias="Reserved3", default=None)
    field_rect: SkipValidation[RectangleCoordinates] = Field(alias="FieldRect")
    __properties: ClassVar[List[str]] = ["wFieldType", "FieldName", "StringsCount", "StringsResult", "Buf_Length", "Buf_Text", "FieldMask", "Validity", "InComparison", "wLCID", "Reserved2", "Reserved3", "FieldRect"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
        arbitrary_types_allowed=True,
        use_enum_values=True
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DocVisualExtendedField from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in strings_result (list)
        _items = []
        if self.strings_result:
            for _item_strings_result in self.strings_result:
                if _item_strings_result:
                    _items.append(_item_strings_result.to_dict())
            _dict['StringsResult'] = _items
        # override the default output from pydantic by calling `to_dict()` of field_rect
        if self.field_rect:
            _dict['FieldRect'] = self.field_rect.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DocVisualExtendedField from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "wFieldType": obj.get("wFieldType"),
            "FieldName": obj.get("FieldName"),
            "StringsCount": obj.get("StringsCount"),
            "StringsResult": [StringRecognitionResult.from_dict(_item) for _item in obj.get("StringsResult", []) if StringRecognitionResult.from_dict(_item) is not None],
            "Buf_Length": obj.get("Buf_Length"),
            "Buf_Text": obj.get("Buf_Text"),
            "FieldMask": obj.get("FieldMask"),
            "Validity": obj.get("Validity"),
            "InComparison": obj.get("InComparison"),
            "wLCID": obj.get("wLCID"),
            "Reserved2": obj.get("Reserved2"),
            "Reserved3": obj.get("Reserved3"),
            "FieldRect": RectangleCoordinates.from_dict(obj["FieldRect"]) if obj.get("FieldRect") is not None else None
        })
        return _obj


