"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebsiteBucket = void 0;
const path = require("path");
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const aws_s3_deployment_1 = require("@aws-cdk/aws-s3-deployment");
const core_1 = require("@aws-cdk/core");
const cdk_deletable_bucket_1 = require("@cloudcomponents/cdk-deletable-bucket");
class WebsiteBucket extends core_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        const { bucketName, removalPolicy = core_1.RemovalPolicy.RETAIN, disableUpload = false, source, websiteIndexDocument, websiteErrorDocument, } = props;
        const bucket = new aws_s3_1.Bucket(this, 'WebsiteBucket', {
            bucketName,
            removalPolicy,
            websiteIndexDocument: websiteIndexDocument || 'index.html',
            websiteErrorDocument: websiteErrorDocument || 'error.html',
        });
        if (removalPolicy === core_1.RemovalPolicy.DESTROY) {
            new cdk_deletable_bucket_1.EmptyBucket(this, 'EmptyBucket', {
                bucket,
            });
        }
        const originAccessIdentity = new aws_cloudfront_1.OriginAccessIdentity(this, 'OriginAccessIdentity', {
            comment: `CloudFront OriginAccessIdentity for ${bucket.bucketName}`,
        });
        bucket.grantRead(originAccessIdentity.grantPrincipal);
        if (!disableUpload) {
            const placeHolderSource = path.join(__dirname, '..', 'website');
            new aws_s3_deployment_1.BucketDeployment(this, 'Deployment', {
                sources: [aws_s3_deployment_1.Source.asset(source || placeHolderSource)],
                destinationBucket: bucket,
                retainOnDelete: removalPolicy === core_1.RemovalPolicy.RETAIN,
            });
        }
        this.s3OriginConfig = {
            originAccessIdentity,
            s3BucketSource: bucket,
        };
    }
}
exports.WebsiteBucket = WebsiteBucket;
//# sourceMappingURL=data:application/json;base64,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