"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaticWebsite = void 0;
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_route53_targets_1 = require("@aws-cdk/aws-route53-targets");
const core_1 = require("@aws-cdk/core");
const website_alias_record_1 = require("./website-alias-record");
const website_bucket_1 = require("./website-bucket");
class StaticWebsite extends core_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        const { aliasConfiguration, bucketConfiguration, webACLId, disableIPv6, } = props;
        const websiteBucket = new website_bucket_1.WebsiteBucket(this, 'Bucket', {
            ...bucketConfiguration,
        });
        const distibutionConfig = {
            webACLId,
            enableIpV6: !disableIPv6,
            originConfigs: [
                {
                    s3OriginSource: {
                        ...websiteBucket.s3OriginConfig,
                    },
                    behaviors: [{ isDefaultBehavior: true }],
                },
            ],
            aliasConfiguration,
        };
        this.distribution = new aws_cloudfront_1.CloudFrontWebDistribution(this, 'Distribution', distibutionConfig);
        if (aliasConfiguration) {
            new website_alias_record_1.WebsiteAliasRecord(this, 'AliasRecord', {
                domainName: aliasConfiguration.domainName,
                recordNames: aliasConfiguration.names,
                target: new aws_route53_targets_1.CloudFrontTarget(this.distribution),
                disableIPv6,
            });
        }
    }
    addLambdaFunctionAssociation(assosiation) {
        this.addLambdaFunctionAssociations([assosiation]);
    }
    addLambdaFunctionAssociations(assosiations) {
        const cfDist = this.distribution.node.findChild('CFDistribution');
        cfDist.addOverride('Properties.DistributionConfig.DefaultCacheBehavior.LambdaFunctionAssociations', assosiations.map((assosiation) => ({
            EventType: assosiation.eventType,
            LambdaFunctionARN: assosiation.lambdaFunction.functionArn,
        })));
    }
}
exports.StaticWebsite = StaticWebsite;
//# sourceMappingURL=data:application/json;base64,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