"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunctionAssociations = void 0;
const core_1 = require("@aws-cdk/core");
class LambdaFunctionAssociations extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const cfDist = props.distribution.node.findChild('CFDistribution');
        const assosiations = props.assosiations.map((assosiation) => ({
            EventType: assosiation.eventType,
            LambdaFunctionARN: `${assosiation.functionArn}:${assosiation.functionVersion}`,
        }));
        cfDist.addOverride('Properties.DistributionConfig.DefaultCacheBehavior.LambdaFunctionAssociations', assosiations);
    }
}
exports.LambdaFunctionAssociations = LambdaFunctionAssociations;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLWZ1bmN0aW9uLWFzc29jaWF0aW9ucy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9sYW1iZGEtZnVuY3Rpb24tYXNzb2NpYXRpb25zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUlBLHdDQUEwQztBQW1DMUMsTUFBYSwwQkFBMkIsU0FBUSxnQkFBUztJQUN2RCxZQUNFLEtBQWdCLEVBQ2hCLEVBQVUsRUFDVixLQUFzQztRQUV0QyxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sTUFBTSxHQUFHLEtBQUssQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FDOUMsZ0JBQWdCLENBQ0UsQ0FBQztRQUVyQixNQUFNLFlBQVksR0FBRyxLQUFLLENBQUMsWUFBWSxDQUFDLEdBQUcsQ0FBQyxDQUFDLFdBQXdCLEVBQUUsRUFBRSxDQUFDLENBQUM7WUFDekUsU0FBUyxFQUFFLFdBQVcsQ0FBQyxTQUFTO1lBQ2hDLGlCQUFpQixFQUFFLEdBQUcsV0FBVyxDQUFDLFdBQVcsSUFBSSxXQUFXLENBQUMsZUFBZSxFQUFFO1NBQy9FLENBQUMsQ0FBQyxDQUFDO1FBRUosTUFBTSxDQUFDLFdBQVcsQ0FDaEIsK0VBQStFLEVBQy9FLFlBQVksQ0FDYixDQUFDO0lBQ0osQ0FBQztDQUNGO0FBdEJELGdFQXNCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XG4gIENmbkRpc3RyaWJ1dGlvbixcbiAgQ2xvdWRGcm9udFdlYkRpc3RyaWJ1dGlvbixcbn0gZnJvbSAnQGF3cy1jZGsvYXdzLWNsb3VkZnJvbnQnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgQXNzb2NpYXRpb24ge1xuICAvKipcbiAgICogVGhlIEFSTiBvZiB0aGUgTGFtYmRhIGZ1bmN0aW9uXG4gICAqL1xuICByZWFkb25seSBmdW5jdGlvbkFybjogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgdmVyc2lvbiBvZiB0aGUgTGFtYmRhIGZ1bmN0aW9uXG4gICAqL1xuICByZWFkb25seSBmdW5jdGlvblZlcnNpb246IHN0cmluZztcblxuICAvKipcbiAgICogU3BlY2lmaWVzIHRoZSBldmVudCB0eXBlIHRoYXQgdHJpZ2dlcnMgYSBMYW1iZGEgZnVuY3Rpb24gaW52b2NhdGlvblxuICAgKi9cbiAgcmVhZG9ubHkgZXZlbnRUeXBlOlxuICAgIHwgJ3ZpZXdlci1yZXF1ZXN0J1xuICAgIHwgJ29yaWdpbi1yZXF1ZXN0J1xuICAgIHwgJ29yaWdpbi1yZXNwb25zZSdcbiAgICB8ICd2aWV3ZXItcmVzcG9uc2UnO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIExhbWJkYUZ1bmN0aW9uQXNzb2NpYXRpb25zUHJvcHMge1xuICAvKipcbiAgICogVGhlIENsb3VkRnJvbnQgZGlzdHJpYnV0aW9uXG4gICAqL1xuICByZWFkb25seSBkaXN0cmlidXRpb246IENsb3VkRnJvbnRXZWJEaXN0cmlidXRpb247XG5cbiAgLyoqXG4gICAqIFRoZSBMYW1iZGEgZnVuY3Rpb24gYXNzb2NpYXRpb25zXG4gICAqL1xuICByZWFkb25seSBhc3Nvc2lhdGlvbnM6IEFzc29jaWF0aW9uW107XG59XG5cbmV4cG9ydCBjbGFzcyBMYW1iZGFGdW5jdGlvbkFzc29jaWF0aW9ucyBleHRlbmRzIENvbnN0cnVjdCB7XG4gIGNvbnN0cnVjdG9yKFxuICAgIHNjb3BlOiBDb25zdHJ1Y3QsXG4gICAgaWQ6IHN0cmluZyxcbiAgICBwcm9wczogTGFtYmRhRnVuY3Rpb25Bc3NvY2lhdGlvbnNQcm9wcyxcbiAgKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGNvbnN0IGNmRGlzdCA9IHByb3BzLmRpc3RyaWJ1dGlvbi5ub2RlLmZpbmRDaGlsZChcbiAgICAgICdDRkRpc3RyaWJ1dGlvbicsXG4gICAgKSBhcyBDZm5EaXN0cmlidXRpb247XG5cbiAgICBjb25zdCBhc3Nvc2lhdGlvbnMgPSBwcm9wcy5hc3Nvc2lhdGlvbnMubWFwKChhc3Nvc2lhdGlvbjogQXNzb2NpYXRpb24pID0+ICh7XG4gICAgICBFdmVudFR5cGU6IGFzc29zaWF0aW9uLmV2ZW50VHlwZSxcbiAgICAgIExhbWJkYUZ1bmN0aW9uQVJOOiBgJHthc3Nvc2lhdGlvbi5mdW5jdGlvbkFybn06JHthc3Nvc2lhdGlvbi5mdW5jdGlvblZlcnNpb259YCxcbiAgICB9KSk7XG5cbiAgICBjZkRpc3QuYWRkT3ZlcnJpZGUoXG4gICAgICAnUHJvcGVydGllcy5EaXN0cmlidXRpb25Db25maWcuRGVmYXVsdENhY2hlQmVoYXZpb3IuTGFtYmRhRnVuY3Rpb25Bc3NvY2lhdGlvbnMnLFxuICAgICAgYXNzb3NpYXRpb25zLFxuICAgICk7XG4gIH1cbn1cbiJdfQ==