# coding: utf-8

"""
    VeeRoute.LSS Routing

    VeeRoute.LSS Routing API  # noqa: E501

    The version of the OpenAPI document: 3.6.163569
    Contact: support@veeroute.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from vrt_lss_routing.configuration import Configuration


class RoutingMatrix(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'waypoints': 'list[Waypoint]',
        'distances': 'list[list]',
        'durations': 'list[list]'
    }

    attribute_map = {
        'waypoints': 'waypoints',
        'distances': 'distances',
        'durations': 'durations'
    }

    def __init__(self, waypoints=None, distances=None, durations=None, local_vars_configuration=None):  # noqa: E501
        """RoutingMatrix - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._waypoints = None
        self._distances = None
        self._durations = None
        self.discriminator = None

        self.waypoints = waypoints
        self.distances = distances
        self.durations = durations

    @property
    def waypoints(self):
        """Gets the waypoints of this RoutingMatrix.  # noqa: E501

        Array of geographical points with distances and times calculated between them.  # noqa: E501

        :return: The waypoints of this RoutingMatrix.  # noqa: E501
        :rtype: list[Waypoint]
        """
        return self._waypoints

    @waypoints.setter
    def waypoints(self, waypoints):
        """Sets the waypoints of this RoutingMatrix.

        Array of geographical points with distances and times calculated between them.  # noqa: E501

        :param waypoints: The waypoints of this RoutingMatrix.  # noqa: E501
        :type: list[Waypoint]
        """
        if self.local_vars_configuration.client_side_validation and waypoints is None:  # noqa: E501
            raise ValueError("Invalid value for `waypoints`, must not be `None`")  # noqa: E501

        self._waypoints = waypoints

    @property
    def distances(self):
        """Gets the distances of this RoutingMatrix.  # noqa: E501

        Routes length between two neighbour locations, in meters.         The values in the array are ordered according to the elements order in the `waypoints` parameter. Each matrix row is an array of distances from the desired point to every other point.   # noqa: E501

        :return: The distances of this RoutingMatrix.  # noqa: E501
        :rtype: list[list]
        """
        return self._distances

    @distances.setter
    def distances(self, distances):
        """Sets the distances of this RoutingMatrix.

        Routes length between two neighbour locations, in meters.         The values in the array are ordered according to the elements order in the `waypoints` parameter. Each matrix row is an array of distances from the desired point to every other point.   # noqa: E501

        :param distances: The distances of this RoutingMatrix.  # noqa: E501
        :type: list[list]
        """
        if self.local_vars_configuration.client_side_validation and distances is None:  # noqa: E501
            raise ValueError("Invalid value for `distances`, must not be `None`")  # noqa: E501

        self._distances = distances

    @property
    def durations(self):
        """Gets the durations of this RoutingMatrix.  # noqa: E501

        Array of route durations between two neighbour locations, in minutes. The values in the array are ordered according to the elements order in the `waypoints` parameter. Each matrix row is an array of distances from the desired point to every other point.   # noqa: E501

        :return: The durations of this RoutingMatrix.  # noqa: E501
        :rtype: list[list]
        """
        return self._durations

    @durations.setter
    def durations(self, durations):
        """Sets the durations of this RoutingMatrix.

        Array of route durations between two neighbour locations, in minutes. The values in the array are ordered according to the elements order in the `waypoints` parameter. Each matrix row is an array of distances from the desired point to every other point.   # noqa: E501

        :param durations: The durations of this RoutingMatrix.  # noqa: E501
        :type: list[list]
        """
        if self.local_vars_configuration.client_side_validation and durations is None:  # noqa: E501
            raise ValueError("Invalid value for `durations`, must not be `None`")  # noqa: E501

        self._durations = durations

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RoutingMatrix):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RoutingMatrix):
            return True

        return self.to_dict() != other.to_dict()
