"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtNetwork
from PyQt5 import QtCore
from PyQt5.QtXmlPatterns import *
from PyQt5 import sip


class QXmlSchema(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qxmlschema.html

    **Detailed Description**

    The QXmlSchema class loads, compiles and validates W3C XML Schema files that
    can be used further for validation of XML instance documents via
    **QXmlSchemaValidator** .

    The following example shows how to load a XML Schema file from the network
    and test whether it is a valid schema document:

    **QUrl**  url("http://www.schema-example.org/myschema.xsd");
    **QXmlSchema**  schema;
            if (schema.load(url) == true)
    **qDebug** () << "schema is valid";
            else
                **qDebug** ()
    << "schema is invalid";

    **XML Schema Version**

    This class is used to represent schemas that conform to the **XML Schema**
    1.0 specification.

    **See also** **QXmlSchemaValidator**  and **XML Schema Validation Example**
    .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlschema.html#QXmlSchema

        **QXmlSchema::QXmlSchema()**

        Constructs an invalid, empty schema that cannot be used until **load**
        () is called.
        """
        ...

    @typing.overload
    def __init__(self, other: "QXmlSchema") -> None:
        """
        https://doc.qt.io/qt-5/qxmlschema.html#QXmlSchema-1

        **QXmlSchema::QXmlSchema(const QXmlSchema & other )**

        Constructs a QXmlSchema that is a copy of **other**. The new instance
        will share resources with the existing schema to the extent possible.
        """
        ...

    def networkAccessManager(self) -> QtNetwork.QNetworkAccessManager:
        """
        https://doc.qt.io/qt-5/qxmlschema.html#networkAccessManager

        **QNetworkAccessManager *QXmlSchema::networkAccessManager() const**

        Returns the network manager, or 0 if it has not been set.

        **See also** **setNetworkAccessManager** ().
        """
        ...

    def setNetworkAccessManager(
        self, networkmanager: QtNetwork.QNetworkAccessManager
    ) -> None:
        """
        https://doc.qt.io/qt-5/qxmlschema.html#setNetworkAccessManager

        **void QXmlSchema::setNetworkAccessManager(QNetworkAccessManager *
        manager )**

        Sets the network manager to **manager**. **QXmlSchema**  does not take
        ownership of **manager**.

        **See also** **networkAccessManager** ().
        """
        ...

    def uriResolver(self) -> QAbstractUriResolver:
        """
        https://doc.qt.io/qt-5/qxmlschema.html#uriResolver

        **const QAbstractUriResolver *QXmlSchema::uriResolver() const**

        Returns the schema's URI resolver. If no URI resolver has been set, Qt
        XML Patterns will use the URIs in schemas as they are.

        The URI resolver provides a level of abstraction, or **polymorphic
        URIs**. A resolver can rewrite **logical** URIs to physical ones, or it
        can translate obsolete or invalid URIs to valid ones.

        When Qt XML Patterns calls **QAbstractUriResolver::resolve** () the
        absolute URI is the URI mandated by the schema specification, and the
        relative URI is the URI specified by the user.

        **See also** **setUriResolver** ().
        """
        ...

    def setUriResolver(self, resolver: QAbstractUriResolver) -> None:
        """
        https://doc.qt.io/qt-5/qxmlschema.html#setUriResolver

        **void QXmlSchema::setUriResolver(const QAbstractUriResolver * resolver
        )**

        Sets the URI resolver to **resolver**. **QXmlSchema**  does not take
        ownership of **resolver**.

        **See also** **uriResolver** ().
        """
        ...

    def messageHandler(self) -> QAbstractMessageHandler:
        """
        https://doc.qt.io/qt-5/qxmlschema.html#messageHandler

        **QAbstractMessageHandler *QXmlSchema::messageHandler() const**

        Returns the message handler that handles compile and validation messages
        for this **QXmlSchema** .

        **See also** **setMessageHandler** ().
        """
        ...

    def setMessageHandler(self, handler: QAbstractMessageHandler) -> None:
        """
        https://doc.qt.io/qt-5/qxmlschema.html#setMessageHandler

        **void QXmlSchema::setMessageHandler(QAbstractMessageHandler * handler
        )**

        Changes the **message handler**  for this **QXmlSchema**  to
        **handler**. The schema sends all compile and validation messages to
        this message handler. **QXmlSchema**  does not take ownership of
        **handler**.

        Normally, the default message handler is sufficient. It writes compile
        and validation messages to **stderr**. The default message handler
        includes color codes if **stderr** can render colors.

        When **QXmlSchema**  calls **QAbstractMessageHandler::message** (), the
        arguments are as follows:

        message() argumentSemantics
        **QtMsgType**  typeOnly **QtWarningMsg**
        and **QtFatalMsg**  are used. The former identifies a warning, while the
        latter identifies an error.
        const **QString**  & descriptionAn XHTML
        document which is the actual message. It is translated into the current
        language.
        const **QUrl**  &identifierIdentifies the error with a URI,
        where the fragment is the error code, and the rest of the URI is the
        error namespace.
        const **QSourceLocation**  & sourceLocationIdentifies
        where the error occurred.

        **See also** **messageHandler** ().
        """
        ...

    def documentUri(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qxmlschema.html#documentUri

        **QUrl QXmlSchema::documentUri() const**

        Returns the document URI of the schema or an empty URI if no schema has
        been set.
        """
        ...

    def namePool(self) -> QXmlNamePool:
        """
        https://doc.qt.io/qt-5/qxmlschema.html#namePool

        **QXmlNamePool QXmlSchema::namePool() const**

        Returns the name pool used by this **QXmlSchema**  for constructing
        **names** . There is no setter for the name pool, because mixing name
        pools causes errors due to name confusion.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlschema.html#isValid

        **bool QXmlSchema::isValid() const**

        Returns true if this schema is valid. Examples of invalid schemas are
        ones that contain syntax errors or that do not conform the W3C XML
        Schema specification.
        """
        ...

    @typing.overload
    def load(self, source: QtCore.QUrl) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlschema.html#load

        **bool QXmlSchema::load(const QUrl & source )**

        Sets this **QXmlSchema**  to a schema loaded from the **source** URI.

        If the schema **is invalid** , `false` is returned and the behavior is
        undefined.

        Example:

        **QUrl**  url("http://www.schema-example.org/myschema.xsd");
        **QXmlSchema**  schema;
                if (schema.load(url) == true)
        **qDebug** () << "schema is valid";
                else
                    **qDebug**
        () << "schema is invalid";

        **See also** **isValid** ().
        """
        ...

    @typing.overload
    def load(self, source: QtCore.QIODevice, documentUri: QtCore.QUrl = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlschema.html#load-1

        **bool QXmlSchema::load(QIODevice * source , const QUrl & documentUri =
        QUrl())**

        Sets this **QXmlSchema**  to a schema read from the **source** device.
        The device must have been opened with at least **QIODevice::ReadOnly** .

        **documentUri** represents the schema obtained from the **source**
        device. It is the base URI of the schema, that is used internally to
        resolve relative URIs that appear in the schema, and for message
        reporting.

        If **source** is `null` or not readable, or if **documentUri** is not a
        valid URI, behavior is undefined.

        If the schema **is invalid** , `false` is returned and the behavior is
        undefined.

        Example:

        **QFile**  file("myschema.xsd");
                file.open(**QIODevice**
        ::ReadOnly);

                **QXmlSchema**  schema;
        schema.load(&file, **QUrl** ::fromLocalFile(file.fileName()));
        if (schema.isValid())
                    **qDebug** () << "schema is valid";
        else
                    **qDebug** () << "schema is invalid";

        **See also** **isValid** ().
        """
        ...

    @typing.overload
    def load(
        self,
        data: typing.Union[QtCore.QByteArray, bytes, bytearray],
        documentUri: QtCore.QUrl = ...,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlschema.html#load-2

        **bool QXmlSchema::load(const QByteArray & data , const QUrl &
        documentUri = QUrl())**

        Sets this **QXmlSchema**  to a schema read from the **data**

        **documentUri** represents the schema obtained from the **data**. It is
        the base URI of the schema, that is used internally to resolve relative
        URIs that appear in the schema, and for message reporting.

        If **documentUri** is not a valid URI, behavior is undefined.

        If the schema **is invalid** , `false` is returned and the behavior is
        undefined.

        Example:

        **QByteArray**  data( "<?xml version=\\"1.0\\" encoding=\\"UTF-8\\"?>"
        "<xsd:schema"
                                 "
        xmlns:xsd=\\"http://www.w3.org/2001/XMLSchema\\""
        "        xmlns=\\"http://www.qt-project.org/xmlschematest\\""
        "        targetNamespace=\\"http://www.qt-project.org/xmlschematest\\""
        "        version=\\"1.0\\""
                                 "
        elementFormDefault=\\"qualified\\">"
        "</xsd:schema>" );

                **QXmlSchema**  schema;
        schema.load(data);

                if (schema.isValid())
        **qDebug** () << "schema is valid";
                else
                    **qDebug**
        () << "schema is invalid";

        **See also** **isValid** () and **isValid** ().
        """
        ...
