"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import sip


class QXmlNamePool(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qxmlnamepool.html

    **Detailed Description**

    QXmlNamePool is used to optimize operations on instances of **QXmlName** .
    An instance of **QXmlName**  represents an XML name in a way that allows the
    XML name to be compared and passed around efficiently. The efficiency is
    achieved by storing the strings comprising the XML names in an instance of
    QXmlNamePool, where they are mapped to binary identifiers, which are then
    packed into a key which is stored in the **QXmlName** .

    This means that each instance of **QXmlName**  is tied to the name pool it
    was created with, and that name pool should be kept in scope and used to
    create all instances of **QXmlName**  that might be compared. Note also that
    the name pool is required if you must reconstitute the **QXmlName**  as
    text, or if you must access any of its component strings, so although
    instances of **QXmlName**  can be compared without reference to a name pool,
    the name pool must be kept in scope if the name's strings must be accessed
    later.

    **See also** **QXmlName**  and **QXmlQuery::namePool** ().
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlnamepool.html#QXmlNamePool

        **QXmlNamePool::QXmlNamePool()**

        Constructs an empty name pool.
        """
        ...

    @typing.overload
    def __init__(self, other: "QXmlNamePool") -> None:
        """
        https://doc.qt.io/qt-5/qxmlnamepool.html#QXmlNamePool-1

        **QXmlNamePool::QXmlNamePool(const QXmlNamePool & other )**

        Constructs a copy of the **other** name pool.
        """
        ...
