"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtXmlPatterns import *
from PyQt5 import sip


class QXmlName(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qxmlname.html

    **Detailed Description**

    The name of an XML node has three components: The **namespace URI** , the
    **local name** , and the **prefix**. To see what these refer to in XML,
    consider the following snippet.

    <book xmlns:dc='http://purl.org/dc/elements/1.1'
    xmlns='http://example.com/MyDefault'>
            <dc:title>Mobey
    Dick</dc:title> ...
        </book>

    For the element named **book** , **localName** () returns **book** ,
    **namespaceUri** () returns **http://example.com/MyDefault** , and
    **prefix** () returns an empty string. For the element named **title** ,
    **localName** () returns **title** , **namespaceUri** () returns
    **http://purl.org/dc/elements/1.1** , and **prefix** () returns **dc**.

    To ensure that operations with QXmlName are efficient, e.g., copying names
    and comparing them, each instance of QXmlName is associated with a **name
    pool** , which must be specified at QXmlName construction time. The three
    components of the QXmlName, i.e., the namespace URI, the local name, and the
    prefix, are stored in the name pool mapped to identifiers so they can be
    shared. For this reason, the only way to create a valid instance of QXmlName
    is to use the class constructor, where the **name pool** , local name,
    namespace URI, and prefix must all be specified.

    Note that QXmlName's default constructor constructs a null instance. It is
    typically used for allocating unused entries in collections of QXmlName.

    A side effect of associating each instance of QXmlName with a **name pool**
    is that each instance of QXmlName is tied to the **QXmlNamePool**  with
    which it was created. However, the QXmlName class does not keep track of the
    name pool, so all the accessor functions, e.g., **namespaceUri** (),
    **prefix** (), **localName** (), and **toClarkName** () require that the
    correct name pool be passed to them. Failure to provide the correct name
    pool to these accessor functions results in undefined behavior.

    Note that a **name pool**  is **not** an XML namespace. One **name pool**
    can represent instances of QXmlName from different XML namespaces, and the
    instances of QXmlName from one XML namespace can be distributed over
    multiple **name pools** .

    **Comparing QXmlNames**

    To determine what a QXmlName refers to, the **namespace URI** and the
    **local name** are used. The **prefix** is not used because the prefix is
    simply a shorthand name for use in place of the normally much longer
    namespace URI. Nor is the prefix used in name comparisons. For example, the
    following two element nodes represent the same element and compare equal.

    <svg xmlns="http://www.w3.org/2000/svg"/>

    <x:svg xmlns:x="http://www.w3.org/2000/svg"/>

    Although the second name has the prefix **x** , the two names compare equal
    as instances of QXmlName, because the prefix is not used in the comparison.

    A local name can never be an empty string, although the prefix and namespace
    URI can. If the prefix is not empty, the namespace URI cannot be empty.
    Local names and prefixes must be valid **NCNames** , e.g., **abc.def** or
    **abc123**.

    QXmlName represents what is sometimes called an **expanded QName** , or
    simply a QName.

    **See also** **Namespaces in XML 1.0 (Second Edition), [4] NCName** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlname.html#QXmlName

        **QXmlName::QXmlName()**

        Constructs an uninitialized QXmlName. To build a valid QXmlName, you
        normally use the other constructor, which takes a **name pool** ,
        namespace URI, local name, and prefix as parameters. But you can also
        use this constructor to build a null QXmlName and then assign an
        existing QXmlName to it.

        **See also** **isNull** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        namePool: "QXmlNamePool",
        localName: str,
        namespaceUri: str = ...,
        prefix: str = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qxmlname.html#QXmlName-1

        **QXmlName::QXmlName(QXmlNamePool & namePool , const QString & localName
        , const QString & namespaceURI = QString(), const QString & prefix =
        QString())**

        Constructs a QXmlName instance that inserts **localName** ,
        **namespaceURI** and **prefix** into **namePool** if they aren't already
        there. The accessor functions **namespaceUri** (), **prefix** (),
        **localName** (), and **toClarkName** () must be passed the **namePool**
        used here, so the **namePool** must remain in scope while the accessor
        functions might be used. However, two instances can be compared with
        **==** or **!=** and copied without the **namePool**.

        The user guarantees that the string components are valid for a QName. In
        particular, the local name, and the prefix (if present), must be valid
        **NCNames** . The function **isNCName** () can be used to test validity
        of these names. The namespace URI should be an absolute URI.
        **QUrl::isRelative** () can be used to test whether the namespace URI is
        relative or absolute. Finally, providing a prefix is not valid when no
        namespace URI is provided.

        **namePool** is not copied. Nor is the reference to it retained in this
        instance. This constructor inserts the three strings into **namePool**.
        """
        ...

    @typing.overload
    def __init__(self, other: "QXmlName") -> None:
        """
        https://doc.qt.io/qt-5/qxmlname.html#QXmlName-2

        **QXmlName::QXmlName(const QXmlName & other )**

        Constructs a copy of **other**.

        This function was introduced in Qt 5.9.

        **See also** **operator=** ().
        """
        ...

    def __hash__(self) -> int:
        ...

    @staticmethod
    def fromClarkName(clarkName: str, namePool: "QXmlNamePool") -> "QXmlName":
        """
        https://doc.qt.io/qt-5/qxmlname.html#fromClarkName

        **[static] QXmlName QXmlName::fromClarkName(const QString & clarkName ,
        const QXmlNamePool & namePool )**

        Converts **clarkName** into a **QXmlName** , inserts into **namePool** ,
        and returns it.

        A clark name is a way to present a full QName with only one string,
        where the namespace cannot contain braces. Here are a couple of
        examples:

        Clark NameDescription
        `html`The local name `html`, in no namespace
        `http://www.w3.org/1999/xhtml`htmlThe local name `html`, in the XHTML
        namespace
        `http://www.w3.org/1999/xhtml`my:htmlThe local name `html`,
        in the XHTML namespace, with the prefix `my`

        If the namespace contains braces, the returned value is either invalid
        or has undefined content.

        If **clarkName** is an invalid name, a default constructed **QXmlName**
        is returned.

        This function was introduced in Qt 4.5.

        **See also** **toClarkName** ().
        """
        ...

    @staticmethod
    def isNCName(candidate: str) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlname.html#isNCName

        **[static] bool QXmlName::isNCName(const QString & candidate )**

        Returns true if **candidate** is an `NCName`. An `NCName` is a string
        that can be used as a name in XML and **XQuery** , e.g., the prefix or
        local name in an element or attribute, or the name of a variable.

        **See also** **Namespaces in XML 1.0 (Second Edition), [4] NCName** .
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlname.html#isNull

        **bool QXmlName::isNull() const**

        Returns true if this **QXmlName**  is not initialized with a valid
        combination of **namespace URI** , **local name** , and **prefix**.

        A valid local name is always required. The prefix and namespace URI can
        be empty, but if the prefix is not empty, the namespace URI must not be
        empty. Local names and prefixes must be valid **NCNames** , e.g.,
        **abc.def** or **abc123**.
        """
        ...

    def toClarkName(self, query: "QXmlNamePool") -> str:
        """
        https://doc.qt.io/qt-5/qxmlname.html#toClarkName

        **QString QXmlName::toClarkName(const QXmlNamePool & namePool ) const**

        Returns this **QXmlName**  formatted as a Clark Name. For example, if
        the local name is `html`, the prefix is `x`, and the namespace URI is
        `http://www.w3.org/1999/xhtml/`, then the Clark Name returned is:

        {http://www.w3.org/1999/xhtml/}x:html.

        If the local name is **MyWidget** and the namespace is empty, the Clark
        Name returned is:

        MyWidget

        Note that for efficiency, the namespace URI, local name, and prefix
        strings are not stored in the **QXmlName**  but in the **QXmlNamePool**
        that was passed to the constructor. Hence, that same **namePool** must
        be passed to this function, so it can be used for looking up the three
        string components.

        This function can be useful for debugging.

        **See also** **XML Namespaces, James Clark**  and **fromClarkName** ().
        """
        ...

    def localName(self, query: "QXmlNamePool") -> str:
        """
        https://doc.qt.io/qt-5/qxmlname.html#localName

        **QString QXmlName::localName(const QXmlNamePool & namePool ) const**

        Returns the local name.

        Note that for efficiency, the local name string is not stored in the
        **QXmlName**  but in the **QXmlNamePool**  that was passed to the
        constructor. Hence, that same **namePool** must be passed to this
        function, so it can be used for looking up the local name.
        """
        ...

    def prefix(self, query: "QXmlNamePool") -> str:
        """
        https://doc.qt.io/qt-5/qxmlname.html#prefix

        **QString QXmlName::prefix(const QXmlNamePool & namePool ) const**

        Returns the prefix.

        Note that for efficiency, the prefix string is not stored in the
        **QXmlName**  but in the **QXmlNamePool**  that was passed to the
        constructor. Hence, that same **namePool** must be passed to this
        function, so it can be used for looking up the prefix.
        """
        ...

    def namespaceUri(self, query: "QXmlNamePool") -> str:
        """
        https://doc.qt.io/qt-5/qxmlname.html#namespaceUri

        **QString QXmlName::namespaceUri(const QXmlNamePool & namePool ) const**

        Returns the namespace URI.

        Note that for efficiency, the namespace URI string is not stored in the
        **QXmlName**  but in the **QXmlNamePool**  that was passed to the
        constructor. Hence, that same **namePool** must be passed to this
        function, so it can be used for looking up the namespace URI.
        """
        ...
