"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtXmlPatterns import *
from PyQt5 import sip


class QAbstractXmlReceiver(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qabstractxmlreceiver.html

    **Detailed Description**

    QAbstractXmlReceiver is an abstract base class that provides a callback
    interface for receiving an **XQuery sequence** , usually the output of an
    **QXmlQuery** , and transforming that sequence into a structure of your
    choosing, usually XML. Consider the example:

    **QXmlQuery**  query;
    query.setQuery("doc('index.html')/html/body/p[1]");
    **QXmlSerializer**  serializer(query, myOutputDevice);
    query.evaluateTo(&serializer);

    First it constructs a **query**  that gets the first paragraph from document
    `index.html`. Then it constructs an **XML serializer**  with the **query**
    and **myOutputDevice**  (Note the **serializer**  is an **XML receiver** ,
    ie a subclass of QAbstractXmlReceiver). Finally, it **evaluates**  the
    **query** , producing an ordered sequence of calls to the **serializer's**
    callback functions. The sequence of callbacks transforms the query output to
    XML and writes it to **myOutputDevice** .

    Although the example uses **QXmlQuery**  to produce the sequence of
    callbacks to functions in QAbstractXmlReceiver, you can call the callback
    functions directly as long as your sequence of calls represents a valid
    **XQuery sequence** .

    **XQuery Sequences**

    An **XQuery**  **sequence** is an ordered collection of zero, one, or many
    **items**. Each **item** is either an **atomic value** or a **node**. An
    **atomic value** is a simple data value.

    There are six kinds of **nodes**.

    * An **Element Node** represents an XML element.
      * An **Attribute Node**
    represents an XML attribute.
      * A **Document Node** represents an entire
    XML document.
      * A **Text Node** represents character data (element
    content).
      * A **Processing Instruction Node** represents an XML processing
    instruction, which is used in an XML document to tell the application
    reading the document to perform some action. A typical example is to use a
    processing instruction to tell the application to use a particular XSLT
    stylesheet to display the document.
      * And a **Comment node** represents an
    XML comment.

    The **sequence** of **nodes** and **atomic values** obeys the following
    rules. Note that **Namespace Node** refers to a special **Attribute Node**
    with name **xmlns**.

    * Each **node** appears in the **sequence** before its children and their
    descendants appear.
      * A **node** 's descendants appear in the **sequence**
    before any of its siblings appear.
      * A **Document Node** represents an
    entire document. Zero or more **Document Nodes** can appear in a
    **sequence** , but they can only be top level items (i.e., a **Document
    Node** can't be a child of another **node**.
      * **Namespace Nodes**
    immediately follow the **Element Node** with which they are associated.
      *
    **Attribute Nodes** immediately follow the **Namespace Nodes** of the
    element with which they are associated, or...
      * If there are no
    **Namespace Nodes** following an element, then the **Attribute Nodes**
    immediately follow the element.
      * An **atomic value** can only appear as a
    top level **item** , i.e., it can't appear as a child of a **node**.
      *
    **Processing Instruction Nodes** do not have children, and their parent is
    either a **Document Node** or an **Element Node**.
      * **Comment Nodes** do
    not have children, and their parent is either a **Document Node** or an
    **Element Node**.

    The **sequence** of **nodes** and **atomic values** is sent to an
    QAbstractXmlReceiver (**QXmlSerializer**  in the example above) as a
    sequence of calls to the receiver's callback functions. The mapping of
    callback functions to sequence items is as follows.

    * **startDocument** () and **endDocument** () are called for each **Document
    Node** in the **sequence**. **endDocument** () is not called until all the
    **Document Node's** children have appeared in the **sequence**.
      *
    **startElement** () and **endElement** () are called for each **Element
    Node**. **endElement** () is not called until all the **Element Node's**
    children have appeared in the **sequence**.
      * **attribute** () is called
    for each **Attribute Node**.
      * **comment** () is called for each **Comment
    Node**.
      * **characters** () is called for each **Text Node**.
      *
    **processingInstruction** () is called for each **Processing Instruction
    Node**.
      * **namespaceBinding** () is called for each **Namespace Node**.
    * **atomicValue** () is called for each **atomic value**.

    For a complete explanation of **XQuery**  sequences, visit **XQuery Data
    Model** .

    **See also** **W3C XQuery 1.0 and XPath 2.0 Data Model (XDM)** ,
    **QXmlSerializer** , and **QXmlResultItems** .
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qabstractxmlreceiver.html#QAbstractXmlReceiver

        **QAbstractXmlReceiver::QAbstractXmlReceiver()**

        Constructs an abstract xml receiver.
        """
        ...

    def endOfSequence(self) -> None:
        """
        https://doc.qt.io/qt-5/qabstractxmlreceiver.html#endOfSequence

        **[pure virtual] void QAbstractXmlReceiver::endOfSequence()**

        This callback is called once only, right after the **sequence**  ends.
        """
        ...

    def startOfSequence(self) -> None:
        """
        https://doc.qt.io/qt-5/qabstractxmlreceiver.html#startOfSequence

        **[pure virtual] void QAbstractXmlReceiver::startOfSequence()**

        This callback is called once only, right before the **sequence**
        begins.
        """
        ...

    def namespaceBinding(self, name: "QXmlName") -> None:
        """
        https://doc.qt.io/qt-5/qabstractxmlreceiver.html#namespaceBinding

        **[pure virtual] void QAbstractXmlReceiver::namespaceBinding(const
        QXmlName & name )**

        This callback is called when a namespace binding is in scope of an
        element. A namespace is defined by a URI. In the **QXmlName**  **name**
        , the value of **QXmlName::namespaceUri** () is that URI. The value of
        **QXmlName::prefix** () is the prefix that the URI is bound to. The
        local name is insignificant and can be an arbitrary value.
        """
        ...

    def atomicValue(self, value: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qabstractxmlreceiver.html#atomicValue

        **[pure virtual] void QAbstractXmlReceiver::atomicValue(const QVariant &
        value )**

        This callback is called when an atomic value appears in the **sequence**
        . The **value** is a simple **data value** . It is guaranteed to be
        **valid** .
        """
        ...

    def processingInstruction(self, target: "QXmlName", value: str) -> None:
        """
        https://doc.qt.io/qt-5/qabstractxmlreceiver.html#processingInstruction

        **[pure virtual] void QAbstractXmlReceiver::processingInstruction(const
        QXmlName & target , const QString & value )**

        This callback is called when a processing instruction appears in the
        **sequence** . A processing instruction is used in an XML document to
        tell the application reading the document to perform some action. A
        typical example is to use a processing instruction to tell the
        application to use a particular XSLT stylesheet to process the document.

        <?xml-stylesheet type="test/xsl" href="formatter.xsl"?>

        **target** is the **name**  of the processing instruction. Its
        **prefix** and **namespace URI** must both be empty. Its **local name**
        is the target. In the above example, the name is **xml-stylesheet**.

        The **value** specifies the action to be taken. Note that the **value**
        must not contain the string "?>". In the above example, the **value** is
        **type="test/xsl" href="formatter.xsl**.

        Generally, use of processing instructions should be avoided, because
        they are not namespace aware and in many contexts are stripped out
        anyway. Processing instructions can often be replaced with elements from
        a custom namespace.
        """
        ...

    def endDocument(self) -> None:
        """
        https://doc.qt.io/qt-5/qabstractxmlreceiver.html#endDocument

        **[pure virtual] void QAbstractXmlReceiver::endDocument()**

        This callback is called when the end of a document node appears in the
        **sequence** .
        """
        ...

    def startDocument(self) -> None:
        """
        https://doc.qt.io/qt-5/qabstractxmlreceiver.html#startDocument

        **[pure virtual] void QAbstractXmlReceiver::startDocument()**

        This callback is called when a document node appears in the **sequence**
        .
        """
        ...

    def characters(self, value: str) -> None:
        """
        https://doc.qt.io/qt-5/qabstractxmlreceiver.html#characters

        **[pure virtual] void QAbstractXmlReceiver::characters(const QStringRef
        & value )**

        This callback is called when a text node appears in the **sequence** .
        The **value** contains the text. Adjacent text nodes may not occur in
        the **sequence** , i.e., this callback must not be called twice in a
        row.
        """
        ...

    def comment(self, value: str) -> None:
        """
        https://doc.qt.io/qt-5/qabstractxmlreceiver.html#comment

        **[pure virtual] void QAbstractXmlReceiver::comment(const QString &
        value )**

        This callback is called when a comment node appears in the **sequence**
        . The **value** is the comment text, which must not contain the string
        "--".
        """
        ...

    def attribute(self, name: "QXmlName", value: str) -> None:
        """
        https://doc.qt.io/qt-5/qabstractxmlreceiver.html#attribute

        **[pure virtual] void QAbstractXmlReceiver::attribute(const QXmlName &
        name , const QStringRef & value )**

        This callback is called when an attribute node appears in the
        **sequence** . **name** is the **attribute name**  and the **value**
        string contains the attribute value.
        """
        ...

    def endElement(self) -> None:
        """
        https://doc.qt.io/qt-5/qabstractxmlreceiver.html#endElement

        **[pure virtual] void QAbstractXmlReceiver::endElement()**

        This callback is called when the end of an element node appears in the
        **sequence** .
        """
        ...

    def startElement(self, name: "QXmlName") -> None:
        """
        https://doc.qt.io/qt-5/qabstractxmlreceiver.html#startElement

        **[pure virtual] void QAbstractXmlReceiver::startElement(const QXmlName
        & name )**

        This callback is called when a new element node appears in the
        **sequence** . **name** is the valid **name**  of the node element.
        """
        ...
