"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtXmlPatterns import *
from PyQt5 import sip


class QAbstractXmlNodeModel(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qabstractxmlnodemodel.html

    **Detailed Description**

    The QAbstractXmlNodeModel specifies the interface that a node model must
    implement for that node model be accessible to the query engine for
    processing **XQuery**  queries. A node model represents data as a structure
    that can be queried as if the data were XML.

    The node model represented by a subclass of QAbstractXmlNodeModel is meant
    to be accessed by the Qt XML Patterns query engine. If the API seems a
    little strange in a few places, it is because the member functions are
    called by the query engine as it evaluates an **XQuery** . They aren't meant
    to be used programatically.

    **Usage**

    QAbstractXmlNodeModel bridges the gap between the arbitrary structure of the
    non-XML data to be queried and the well-defined structure of XML data
    understood by **QXmlQuery** .

    Consider a chemistry application that reads the file `chemistryData`, which
    contains non-XML data that represents a chemical structure composed of
    molecules and atoms. The application will query this chemistry data with an
    **XQuery**  it reads from file `queryFile`. We write a custom subclass of
    QAbstractXmlNodeModel (`ChemistryNodeModel`) that reads `chemistryData` and
    builds a data structure, perhaps composed of objects of our own classes
    `molecule` and `atom`. Clearly, this data structure is not XML. Our custom
    subclass will know how to traverse this non-XML structure and present it
    through the **XPath Data Model interface** .

    **QFile**  queryFile(argv[1]);
        **QFile**  chemistryData(argv[2]);
    **QString**  moleculeName = argv[3];

        **QXmlQuery**  query;
    query.setQuery(&queryFile, **QUrl** ::fromLocalFile(queryFile.fileName()));
    ChemistryNodeModel myNodeModel(query.namePool(), chemistryData);
    **QXmlNodeModelIndex**  startNode = myNodeModel.nodeFor(moleculeName);
    query.bindVariable("queryRoot", startNode);

        **QFile**  out;
    out.open(stdout, **QIODevice** ::WriteOnly);

        **QXmlSerializer**
    serializer(query, &out);
        query.evaluateTo(&serializer);

    The application first creates an instance of **QXmlQuery**  and calls
    **setQuery()**  to read `queryFile` containing the **XQuery**  we want to
    run. Then it creates an instance of our custom node model class,
    `ChemistryNodeModel`, which is a subclass of QAbstractXmlNodeModel. Its
    constructor is called with the **name pool**  obtained from our
    **QXmlQuery** , and with the `chemistryFile` containing the structure of
    molecules and atoms to be queried. The **name pool**  is required because
    our custom node model has the member function **name()** , which returns the
    **name**  of any node in the model. The **query**  and the custom node model
    must use the same name pool for constructing these **names** . The
    constructor would then read `chemistryFile` and build the custom node model
    structure.

    To connect the `query` to the custom node model, we must bind a variable
    name used in the query to a node in the model. The variable can then be used
    in the query as a starting node. First, an **index**  for the desired
    starting node is retrieved by calling **QAbstractXmlNodeModel::createIndex**
    (). Then the index is bound to a variable name, in this case `queryRoot`, by
    passing the name and the index to **QXmlQuery::bindVariable** (). The query
    can then use a variable reference `$queryRoot` to refer to the starting
    node. Note that if the **query**  uses multiple variable references, a call
    to **QXmlQuery::bindVariable** () is required to bind each different
    variable name to a node in the model.

    The query is executed when the application calls one of the **QXmlQuery**
    evaluation functions. The application uses **QXmlQuery::evaluateTo**
    (**QAbstractXmlReceiver**  *), because it then uses a **serializer**  to out
    the query result as XML to `stdout`. We could have used
    **QXmlQuery::evaluateTo** (**QXmlResultItems**  *) to get a list of result
    items, or **QXmlQuery::evaluateTo** (**QStringList**  *) if the query
    evaluated to a sequence of `xs:string` values.

    During query execution, the engine iterates over the node model using
    **nextFromSimpleAxis** () to get the **index**  of the next node to be
    visited. The engine can get the name of a node by calling **name** () with
    the node's **index** . **stringValue** (), **baseUri** (), **documentUri**
    () and **kind** () are also called as needed with a node **index** .

    The example demonstrates the standard pattern for using a subclass of
    QAbstractXmlNodeModel in combination with **QXmlQuery**  to perform an
    **XQuery** .

    1. Instantiate **QXmlQuery**  and give it the **XQuery**  to be run;
      2.
    Instantiate a subclass of QAbstractXmlNodeModel or **QSimpleXmlNodeModel** ;
    3. Retrieve a **QXmlNodeModelIndex**  for the node in the model where the
    **QXmlQuery**  should start the query;
      4. Use **QXmlQuery::bindVariable**
    () to bind the **QXmlNodeModelIndex**  to `$variable name`;
      5. Call one of
    the **QXmlQuery**  evaluation functions to run the query.

    **Subclassing**

    Because the **XPath Data Model interface**  presented by
    QAbstractXmlNodeModel allows **QXmlQuery**  to operate on non-XML data as if
    it were XML, implementing subclasses of QAbstractXmlNodeModel can involve a
    significant amount of work. The **QSimpleXmlNodeModel**  class is provided
    to simplify the implementation for many common use cases.

    **Thread Safety**

    Because the node model can be accessed concurrently by threads in the Qt XML
    Patterns module, subclasses of QAbstractXmlNodeModel must be written to be
    **thread-safe** . Classes that simplify implementing thread-safety include
    **QReadLocker**  and **QWriteLocker** .

    See the example **File System Example**  for a demonstration.
    """

    class SimpleAxis(int):
        Parent: QAbstractXmlNodeModel = ...
        FirstChild: QAbstractXmlNodeModel = ...
        PreviousSibling: QAbstractXmlNodeModel = ...
        NextSibling: QAbstractXmlNodeModel = ...

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qabstractxmlnodemodel.html#QAbstractXmlNodeModel

        **QAbstractXmlNodeModel::QAbstractXmlNodeModel()**

        Default constructor.
        """
        ...

    @typing.overload
    def createIndex(self, data: int) -> QXmlNodeModelIndex:
        """
        https://doc.qt.io/qt-5/qabstractxmlnodemodel.html#createIndex

        **[protected] QXmlNodeModelIndex
        QAbstractXmlNodeModel::createIndex(qint64 data ) const**

        Creates a node index with **data** as its internal data. **data** is not
        constrained.
        """
        ...

    @typing.overload
    def createIndex(self, data: int, additionalData: int) -> QXmlNodeModelIndex:
        """
        https://doc.qt.io/qt-5/qabstractxmlnodemodel.html#createIndex-1

        **[protected] QXmlNodeModelIndex QAbstractXmlNodeModel::createIndex(void
        * pointer , qint64 additionalData = 0) const**

        Creates a node index with **pointer** and **additionalData** as its
        internal data.

        What **pointer** and **additionalData** is, is not constrained.
        """
        ...

    @typing.overload
    def createIndex(
        self, pointer: typing.Any, additionalData: int = ...
    ) -> QXmlNodeModelIndex:
        """
        https://doc.qt.io/qt-5/qabstractxmlnodemodel.html#createIndex-2

        **[protected] QXmlNodeModelIndex
        QAbstractXmlNodeModel::createIndex(qint64 data , qint64 additionalData )
        const**

        This is an overloaded function.

        Creates a **QXmlNodeModelIndex**  containing **data** and
        **additionalData**.
        """
        ...

    def attributes(
        self, element: QXmlNodeModelIndex
    ) -> typing.List[QXmlNodeModelIndex]:
        """
        https://doc.qt.io/qt-5/qabstractxmlnodemodel.html#attributes

        **[pure virtual protected] QVector<QXmlNodeModelIndex>
        QAbstractXmlNodeModel::attributes(const QXmlNodeModelIndex & element )
        const**

        Returns the attributes of **element**. The caller guarantees that
        **element** is an element in this node model.
        """
        ...

    def nextFromSimpleAxis(
        self, axis: "QAbstractXmlNodeModel.SimpleAxis", origin: QXmlNodeModelIndex
    ) -> QXmlNodeModelIndex:
        """
        https://doc.qt.io/qt-5/qabstractxmlnodemodel.html#nextFromSimpleAxis

        **[pure virtual protected] QXmlNodeModelIndex QAbstractXmlNodeModel::nex
        tFromSimpleAxis(QAbstractXmlNodeModel::SimpleAxis axis , const
        QXmlNodeModelIndex & origin ) const**

        When Qt XML Patterns evaluate path expressions, it emulate them through
        a combination of calls with **QSimpleXmlNodeModel::SimpleAxis**  values.
        Therefore, the implementation of this function must return the node, if
        any, that appears on the **axis** emanating from the **origin**.

        If no such node is available, a default constructed
        **QXmlNodeModelIndex**  is returned.

        **QSimpleXmlNodeModel**  eliminates the need to handle redundant corner
        cases by guaranteeing that it will never ask for:

        * Children or siblings for attributes.
          * Children for comments,
        processing instructions, and text nodes.
          * Siblings or parents for
        document nodes.

        A typical implementation performs a `switch` on the value of **axis** :

        **QXmlNodeModelIndex**  MyTreeModel::nextFromSimpleAxis(SimpleAxis axis,
        const **QXmlNodeModelIndex**  &origin) const
            {
              // Convert the
        QXmlNodeModelIndex to a value that is specific to what we represent.
        const MyValue value = toMyValue(ni);

              switch(axis)
              {
        case Parent:
                      return toNodeIndex(value.parent());
        case FirstChild:
                  case PreviousSibling:
                  case
        NextSibling:
                      // and so on
              }
            }
        """
        ...

    def sourceLocation(self, index: QXmlNodeModelIndex) -> "QSourceLocation":
        """
        https://doc.qt.io/qt-5/qabstractxmlnodemodel.html#sourceLocation

        **QSourceLocation QAbstractXmlNodeModel::sourceLocation(const
        QXmlNodeModelIndex & index ) const**

        Returns the source location for the object with the given **index** or a
        default constructed **QSourceLocation**  in case no location information
        is available.

        This function was introduced in Qt 4.6.
        """
        ...

    def nodesByIdref(self, NCName: "QXmlName") -> typing.List[QXmlNodeModelIndex]:
        """
        https://doc.qt.io/qt-5/qabstractxmlnodemodel.html#nodesByIdref

        **[pure virtual] QVector<QXmlNodeModelIndex>
        QAbstractXmlNodeModel::nodesByIdref(const QXmlName & idref ) const**

        Returns the elements and/or attributes that have an `IDREF` value equal
        to **idref**. **XQuery** 's `idref()` function calls this function.

        The implementor guarantees that the nodes identified by the returned
        indexes are elements or attributes.

        It is not sufficient for an attribute or element to merely be called
        `idref`. It must also be of type `IDREF`. Elements must be typed as
        `xs:IDREF` or `xs:IDREFS`, or, in the case of attributes, as `IDREF` or
        `IDREFS` in the schema.

        In **idref** , the `namespace URI` and the `prefix` are undefined, and
        the `local name` is the ID that should be looked up.

        **See also** **XQuery 1.0 and XPath 2.0 Functions and Operators, 15.5.3
        fn:idref** .
        """
        ...

    def elementById(self, NCName: "QXmlName") -> QXmlNodeModelIndex:
        """
        https://doc.qt.io/qt-5/qabstractxmlnodemodel.html#elementById

        **[pure virtual] QXmlNodeModelIndex
        QAbstractXmlNodeModel::elementById(const QXmlName & id ) const**

        Returns the index of the element identified as **id**. **XQuery** 's
        `id()` function calls this function.

        The node index returned will be the element node whose value is of type
        `ID` and equals **id** , or it will be the element node that has an
        attribute whose typed value is of type `ID` and equals **id**. If there
        is no such element, a default constructed **QXmlNodeModelIndex**
        instance is returned. The implementor guarantees that if the returned
        node index is not null, it identifies an element.

        It is not sufficient for an attribute or element to merely be called
        `id`. Its value type must also be `ID`. However, the reserved name
        `xml:id` is sufficient.

        In **id** , the `namespace URI` and the `prefix` are undefined, and the
        `local name` is the ID that should be looked up.

        **See also** **XQuery 1.0 and XPath 2.0 Functions and Operators, 15.5.2
        fn:id** .
        """
        ...

    def namespaceBindings(self, n: QXmlNodeModelIndex) -> typing.List["QXmlName"]:
        """
        https://doc.qt.io/qt-5/qabstractxmlnodemodel.html#namespaceBindings

        **[pure virtual] QVector<QXmlName>
        QAbstractXmlNodeModel::namespaceBindings(const QXmlNodeModelIndex & n )
        const**

        Returns the in-scope namespaces of **n**. The caller guarantees that
        **n** is not `null` and that it belongs to this
        **QAbstractXmlNodeModel** .

        This function corresponds to the `dm:namespace-nodes` accessor.

        The returned vector of namespace declarations includes namespaces of the
        ancestors of **n**.

        The caller guarantees that **n** is an Element that belongs to this
        **QAbstractXmlNodeModel** .
        """
        ...

    def typedValue(self, n: QXmlNodeModelIndex) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qabstractxmlnodemodel.html#typedValue

        **[pure virtual] QVariant QAbstractXmlNodeModel::typedValue(const
        QXmlNodeModelIndex & node ) const**

        Returns the typed value for node **node**.

        The typed value is an atomic value, which an element or attribute
        contains.

        The caller guarantees that **node** is either an element or an
        attribute. The implementor guarantees that the returned **QVariant**
        has a value which is supported in **XQuery** . It cannot be an arbitrary
        **QVariant**  value. The implementor also guarantees that
        **stringValue** () returns a lexical representation of typedValue()
        (this is guaranteed by **QSimpleXmlNodeModel::stringValue** ()).

        If the return **QVariant**  is a default constructed variant, it signals
        that **node** has no typed value.
        """
        ...

    def stringValue(self, n: QXmlNodeModelIndex) -> str:
        """
        https://doc.qt.io/qt-5/qabstractxmlnodemodel.html#stringValue

        **[pure virtual] QString QAbstractXmlNodeModel::stringValue(const
        QXmlNodeModelIndex & n ) const**

        Returns the string value for node **n**.

        The caller guarantees that **n** is not `null` and that it belong to
        this **QAbstractXmlNodeModel**  instance.

        This function maps to the `dm:string-value()` accessor, which the
        specification completely specifies. Here's a summary:

        * For processing instructions, the string value is the data
        section(excluding any whitespace appearing between the name and the
        data).
          * For text nodes, the string value equals the text node.
          *
        For comments, the content of the comment
          * For elements, the
        concatenation of all text nodes that are descendants. Note, this is not
        only the children, but the childrens' childrens' text nodes, and so
        forth.
          * For document nodes, the concatenation of all text nodes in
        the document.

        **See also** **XQuery 1.0 and XPath 2.0 Data Model (XDM), 5.13 string-
        value Accessor** .
        """
        ...

    def name(self, ni: QXmlNodeModelIndex) -> "QXmlName":
        """
        https://doc.qt.io/qt-5/qabstractxmlnodemodel.html#name

        **[pure virtual] QXmlName QAbstractXmlNodeModel::name(const
        QXmlNodeModelIndex & ni ) const**

        Returns the name of **ni**. The caller guarantees that **ni** is not
        `null` and that it belongs to this **QAbstractXmlNodeModel** .

        If a node does not have a name, e.g., comment nodes, a null **QXmlName**
        is returned. QXmlNames must be created with the instance of
        **QXmlQuery**  that is being used for evaluating queries using this
        **QAbstractXmlNodeModel** .

        This function maps to the `dm:node-name()` accessor.

        If **ni** is a processing instruction, a **QXmlName**  is returned with
        the local name as the target name and the namespace URI and prefix both
        empty.

        **See also** **XQuery 1.0 and XPath 2.0 Data Model (XDM), 5.11 node-name
        Accessor**  and **QXmlName** .
        """
        ...

    def root(self, n: QXmlNodeModelIndex) -> QXmlNodeModelIndex:
        """
        https://doc.qt.io/qt-5/qabstractxmlnodemodel.html#root

        **[pure virtual] QXmlNodeModelIndex QAbstractXmlNodeModel::root(const
        QXmlNodeModelIndex & n ) const**

        Returns the root node of the tree that contains the node whose index is
        **n**. The caller guarantees that **n** is not `null` and that it
        identifies a node in this node model.

        If **n** identifies a node that is a direct child of the root, parent()
        would return the same **QXmlNodeModelIndex**  returned by this function.
        """
        ...

    def compareOrder(
        self, ni1: QXmlNodeModelIndex, ni2: QXmlNodeModelIndex
    ) -> QXmlNodeModelIndex.DocumentOrder:
        """
        https://doc.qt.io/qt-5/qabstractxmlnodemodel.html#compareOrder

        **[pure virtual] QXmlNodeModelIndex::DocumentOrder
        QAbstractXmlNodeModel::compareOrder(const QXmlNodeModelIndex & ni1 ,
        const QXmlNodeModelIndex & ni2 ) const**

        This function returns the relative document order for the nodes indexed
        by **ni1** and **ni2**. It is used for the `Is` operator and for sorting
        nodes in document order.

        The caller guarantees that **ni1** and **ni2** are not `null` and that
        both identify nodes in this node model.

        If **ni1** is identical to **ni2** , **QXmlNodeModelIndex::Is**  is
        returned. If **ni1** precedes **ni2** in document order,
        **QXmlNodeModelIndex::Precedes**  is returned. If **ni1** follows
        **ni2** in document order, **QXmlNodeModelIndex::Follows**  is returned.

        **See also** **XQuery 1.0 and XPath 2.0 Data Model (XDM), 2.4 Document
        Order** .
        """
        ...

    def kind(self, ni: QXmlNodeModelIndex) -> QXmlNodeModelIndex.NodeKind:
        """
        https://doc.qt.io/qt-5/qabstractxmlnodemodel.html#kind

        **[pure virtual] QXmlNodeModelIndex::NodeKind
        QAbstractXmlNodeModel::kind(const QXmlNodeModelIndex & ni ) const**

        Returns a value indicating the kind of node identified by **ni**. The
        caller guarantees that **ni** is not null and that it identifies a node
        in this node model. This function maps to the `dm:node-kind()` accessor.

        **See also** **XQuery 1.0 and XPath 2.0 Data Model (XDM), 5.10 node-kind
        Accessor** .
        """
        ...

    def documentUri(self, ni: QXmlNodeModelIndex) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qabstractxmlnodemodel.html#documentUri

        **[pure virtual] QUrl QAbstractXmlNodeModel::documentUri(const
        QXmlNodeModelIndex & n ) const**

        Returns the document URI of **n**. The document URI identifies the
        resource which is the document. For example, the document could be a
        regular file, e.g., `file:/`, or it could be the `http://` URL of the
        location of a file. The document URI is used for resolving URIs and to
        simply know where the document is.

        If the node model maps to a URI in a natural way, return that URI.
        Otherwise, return the company or product URI. The document URI can be
        any URI as long as its valid and absolute.

        The caller guarantees that **n** is not `null` and that it belongs to
        this **QAbstractXmlNodeModel** .

        This function maps to the `dm:document-uri` accessor, which returns a
        document URI according to the following:

        * If **n** is a document node, return an absolute **QUrl**  containing
        the document URI, or a default constructed **QUrl** . The latter signals
        that no document URI is available for the document node.
          * For all
        other nodes, return a default constructed **QUrl** .

        **See also** **XQuery 1.0 and XPath 2.0 Data Model (XDM), 5.4 document-
        uri Accessor** , **QUrl::isValid** (), and **QUrl::isRelative** ().
        """
        ...

    def baseUri(self, ni: QXmlNodeModelIndex) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qabstractxmlnodemodel.html#baseUri

        **[pure virtual] QUrl QAbstractXmlNodeModel::baseUri(const
        QXmlNodeModelIndex & n ) const**

        Returns the base URI for the node whose index is **n**. The caller
        guarantees that **n** is not `null` and that it belongs to a node in
        this node model.

        The base URI of a node can be extracted using the `fn:base-uri()`
        function. The base URI is typically used for resolving relative URIs
        that appear in the node or its children. It is conformant to just return
        the document URI, although that might not properly reflect the
        underlying data.

        This function maps to the `dm:base-uri` accessor, which returns a base
        URI according to the following:

        * For document nodes, the base URI and the document URI are the same.
        * For elements, the base URI is the URI appearing in the element's
        `xml:base` attribute, if present, or it is resolved to the parent
        element's base URI.
          * Namespace nodes have no base URI.
          * The base
        URI for a processing instruction, comment, attribute, or text node is
        the base URI of the node's parent element.

        The implementation guarantees to return a valid **QUrl** , or a default
        constructed **QUrl** . If a node has no base URI, as in the case where a
        comment has no parent, a default constructed **QUrl**  is returned.

        **See also** **XQuery 1.0 and XPath 2.0 Data Model (XDM), 5.2 base-uri
        Accessor** .
        """
        ...
