"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore


class QAbstractUriResolver(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qabstracturiresolver.html

    **Detailed Description**

    For example, one could write a QAbstractUriResolver subclass that rewrites
    library ISBN number URIs as book title URLs, e.g.,
    **urn:isbn:0-345-33973-8** would be rewritten as
    **file:///books/returnOfTheKing.doc**. Or a QAbstractUriResolver subclass
    could be written for a web browser to let the web browser protect the user's
    private files by mapping incoming requests for them to null URIs.

    **See also** <http://en.wikipedia.org/wiki/Uniform_Resource_Identifier>.
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qabstracturiresolver.html#QAbstractUriResolver

        **QAbstractUriResolver::QAbstractUriResolver(QObject * parent =
        nullptr)**

        Constructs a QAbstractUriResolver with the specified **parent**.
        """
        ...

    def resolve(self, relative: QtCore.QUrl, baseURI: QtCore.QUrl) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qabstracturiresolver.html#resolve

        **[pure virtual] QUrl QAbstractUriResolver::resolve(const QUrl &
        relative , const QUrl & baseURI ) const**

        Returns the **relative** URI resolved using the **baseURI**.

        The caller guarantees that both **relative** and **baseURI** are valid,
        and that **baseURI** is absolute. **relative** can be relative,
        absolute, or empty.

        The returned **QUrl**  can be a default constructed **QUrl** . If it is
        not a default constructed **QUrl** , it will be absolute and valid. If a
        default constructed **QUrl**  is returned, it means the **relative** URI
        was not accepted to be resolved.

        If the reimplemented resolve() function decides it has nothing to do
        about resolving the **relative** URI, it should simply return the
        **relative** URI resolved against the **baseURI** , i.e.:

        return baseURI.resolved(relative);

        **See also** **QUrl::isRelative** () and **QUrl::isValid** ().
        """
        ...
