"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5.QtXml import *
from PyQt5 import sip


class QXmlReader(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qxmlreader.html

    **Detailed Description**

    This abstract class provides an interface for all of Qt's XML readers.
    Currently there is only one implementation of a reader included in Qt's XML
    module: **QXmlSimpleReader** . In future releases there might be more
    readers with different properties available (e.g. a validating parser).

    The design of the XML classes follows the **SAX2 Java interface** , with the
    names adapted to fit Qt naming conventions. It should be very easy for
    anybody who has worked with SAX2 to get started with the Qt XML classes.

    All readers use the class **QXmlInputSource**  to read the input document.
    Since you are normally interested in particular content in the XML document,
    the reader reports the content through special handler classes
    (**QXmlDTDHandler** , **QXmlDeclHandler** , **QXmlContentHandler** ,
    **QXmlEntityResolver** , **QXmlErrorHandler**  and **QXmlLexicalHandler** ),
    which you must subclass, if you want to process the contents.

    Since the handler classes only describe interfaces you must implement all
    the functions. We provide the **QXmlDefaultHandler**  class to make this
    easier: it implements a default behavior (do nothing) for all functions, so
    you can subclass it and just implement the functions you are interested in.

    Features and properties of the reader can be set with **setFeature** () and
    **setProperty** () respectively. You can set the reader to use your own
    subclasses with **setEntityResolver** (), **setDTDHandler** (),
    **setContentHandler** (), **setErrorHandler** (), **setLexicalHandler** ()
    and **setDeclHandler** (). The parse itself is started with a call to
    **parse** ().

    Note that this class is now deprecated, please use **QXmlStreamReader**  or
    **QDomDocument**  for reading XML files.

    **See also** **QXmlSimpleReader** .
    """

    @typing.overload
    def __init__(self) -> None:
        ...

    @typing.overload
    def __init__(self, a0: "QXmlReader") -> None:
        ...

    @typing.overload
    def parse(self, input: QXmlInputSource) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlreader.html#parse-1

        **[pure virtual] bool QXmlReader::parse(const QXmlInputSource * input
        )**

        Reads an XML document from **input** and parses it. Returns `true` if
        the parsing was successful; otherwise returns `false`.
        """
        ...

    @typing.overload
    def parse(self, input: QXmlInputSource) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlreader.html#parse-1

        **[pure virtual] bool QXmlReader::parse(const QXmlInputSource * input
        )**

        Reads an XML document from **input** and parses it. Returns `true` if
        the parsing was successful; otherwise returns `false`.
        """
        ...

    def declHandler(self) -> "QXmlDeclHandler":
        """
        https://doc.qt.io/qt-5/qxmlreader.html#declHandler

        **[pure virtual] QXmlDeclHandler *QXmlReader::declHandler() const**

        Returns the declaration handler or `nullptr` if none was set.

        **See also** **setDeclHandler** ().
        """
        ...

    def setDeclHandler(self, handler: "QXmlDeclHandler") -> None:
        """
        https://doc.qt.io/qt-5/qxmlreader.html#setDeclHandler

        **[pure virtual] void QXmlReader::setDeclHandler(QXmlDeclHandler *
        handler )**

        Sets the declaration handler to **handler**.

        **See also** **declHandler** ().
        """
        ...

    def lexicalHandler(self) -> "QXmlLexicalHandler":
        """
        https://doc.qt.io/qt-5/qxmlreader.html#lexicalHandler

        **[pure virtual] QXmlLexicalHandler *QXmlReader::lexicalHandler()
        const**

        Returns the lexical handler or `nullptr` if none was set.

        **See also** **setLexicalHandler** ().
        """
        ...

    def setLexicalHandler(self, handler: "QXmlLexicalHandler") -> None:
        """
        https://doc.qt.io/qt-5/qxmlreader.html#setLexicalHandler

        **[pure virtual] void QXmlReader::setLexicalHandler(QXmlLexicalHandler *
        handler )**

        Sets the lexical handler to **handler**.

        **See also** **lexicalHandler** ().
        """
        ...

    def errorHandler(self) -> "QXmlErrorHandler":
        """
        https://doc.qt.io/qt-5/qxmlreader.html#errorHandler

        **[pure virtual] QXmlErrorHandler *QXmlReader::errorHandler() const**

        Returns the error handler or `nullptr` if none is set.

        **See also** **setErrorHandler** ().
        """
        ...

    def setErrorHandler(self, handler: "QXmlErrorHandler") -> None:
        """
        https://doc.qt.io/qt-5/qxmlreader.html#setErrorHandler

        **[pure virtual] void QXmlReader::setErrorHandler(QXmlErrorHandler *
        handler )**

        Sets the error handler to **handler**. Clears the error handler if
        **handler** is 0.

        **See also** **errorHandler** ().
        """
        ...

    def contentHandler(self) -> "QXmlContentHandler":
        """
        https://doc.qt.io/qt-5/qxmlreader.html#contentHandler

        **[pure virtual] QXmlContentHandler *QXmlReader::contentHandler()
        const**

        Returns the content handler or `nullptr` if none was set.

        **See also** **setContentHandler** ().
        """
        ...

    def setContentHandler(self, handler: "QXmlContentHandler") -> None:
        """
        https://doc.qt.io/qt-5/qxmlreader.html#setContentHandler

        **[pure virtual] void QXmlReader::setContentHandler(QXmlContentHandler *
        handler )**

        Sets the content handler to **handler**.

        **See also** **contentHandler** ().
        """
        ...

    def DTDHandler(self) -> "QXmlDTDHandler":
        """
        https://doc.qt.io/qt-5/qxmlreader.html#DTDHandler

        **[pure virtual] QXmlDTDHandler *QXmlReader::DTDHandler() const**

        Returns the DTD handler or `nullptr` if none was set.

        **See also** **setDTDHandler** ().
        """
        ...

    def setDTDHandler(self, handler: "QXmlDTDHandler") -> None:
        """
        https://doc.qt.io/qt-5/qxmlreader.html#setDTDHandler

        **[pure virtual] void QXmlReader::setDTDHandler(QXmlDTDHandler * handler
        )**

        Sets the DTD handler to **handler**.

        **See also** **DTDHandler** ().
        """
        ...

    def entityResolver(self) -> "QXmlEntityResolver":
        """
        https://doc.qt.io/qt-5/qxmlreader.html#entityResolver

        **[pure virtual] QXmlEntityResolver *QXmlReader::entityResolver()
        const**

        Returns the entity resolver or `nullptr` if none was set.

        **See also** **setEntityResolver** ().
        """
        ...

    def setEntityResolver(self, handler: "QXmlEntityResolver") -> None:
        """
        https://doc.qt.io/qt-5/qxmlreader.html#setEntityResolver

        **[pure virtual] void QXmlReader::setEntityResolver(QXmlEntityResolver *
        handler )**

        Sets the entity resolver to **handler**.

        **See also** **entityResolver** ().
        """
        ...

    def hasProperty(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlreader.html#hasProperty

        **[pure virtual] bool QXmlReader::hasProperty(const QString & name )
        const**

        Returns `true` if the reader has the property **name** ; otherwise
        returns `false`.

        **See also** **property** () and **setProperty** ().
        """
        ...

    def setProperty(self, name: str, value: PyQt5.sip.voidptr) -> None:
        """
        https://doc.qt.io/qt-5/qxmlreader.html#setProperty

        **[pure virtual] void QXmlReader::setProperty(const QString & name ,
        void * value )**

        Sets the property **name** to **value**. If the reader doesn't have the
        property nothing happens.

        **See also** **property** () and **hasProperty** ().
        """
        ...

    def property(self, name: str) -> typing.Tuple[PyQt5.sip.voidptr, bool]:
        """
        https://doc.qt.io/qt-5/qxmlreader.html#property

        **[pure virtual] void *QXmlReader::property(const QString & name , bool
        * ok = nullptr) const**

        If the reader has the property **name** , this function returns the
        value of the property; otherwise the return value is undefined.

        If **ok** is not `nullptr`: if the reader has the **name** property `*`
        **ok** is set to true; otherwise `*` **ok** is set to false.

        **See also** **setProperty** () and **hasProperty** ().
        """
        ...

    def hasFeature(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlreader.html#hasFeature

        **[pure virtual] bool QXmlReader::hasFeature(const QString & name )
        const**

        Returns `true` if the reader has the feature called **name** ; otherwise
        returns `false`.

        **See also** **feature** () and **setFeature** ().
        """
        ...

    def setFeature(self, name: str, value: bool) -> None:
        """
        https://doc.qt.io/qt-5/qxmlreader.html#setFeature

        **[pure virtual] void QXmlReader::setFeature(const QString & name , bool
        value )**

        Sets the feature called **name** to the given **value**. If the reader
        doesn't have the feature nothing happens.

        **See also** **feature** () and **hasFeature** ().
        """
        ...

    def feature(self, name: str) -> typing.Tuple[bool, bool]:
        """
        https://doc.qt.io/qt-5/qxmlreader.html#feature

        **[pure virtual] bool QXmlReader::feature(const QString & name , bool *
        ok = nullptr) const**

        If the reader has the feature called **name** , the feature's value is
        returned. If no such feature exists the return value is undefined.

        If **ok** is not `nullptr`: `*` **ok** is set to true if the reader has
        the feature called **name** ; otherwise `*` **ok** is set to false.

        **See also** **setFeature** () and **hasFeature** ().
        """
        ...
