"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import sip


class QXmlNamespaceSupport(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qxmlnamespacesupport.html

    **Detailed Description**

    You can set the prefix for the current namespace with **setPrefix** (), and
    get the list of current prefixes (or those for a given URI) with
    **prefixes** (). The namespace URI is available from **uri** (). Use
    **pushContext** () to start a new namespace context, and **popContext** ()
    to return to the previous namespace context. Use **splitName** () or
    **processName** () to split a name into its prefix and local name.

    **See also**  Namespace Support via Features.
    """

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlnamespacesupport.html#QXmlNamespaceSupport

        **QXmlNamespaceSupport::QXmlNamespaceSupport()**

        Constructs a QXmlNamespaceSupport.
        """
        ...

    def reset(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlnamespacesupport.html#reset

        **void QXmlNamespaceSupport::reset()**

        Resets this namespace support object ready for reuse.
        """
        ...

    def popContext(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlnamespacesupport.html#popContext

        **void QXmlNamespaceSupport::popContext()**

        Reverts to the previous namespace context.

        Normally, you should pop the context at the end of each XML element.
        After popping the context, all namespace prefix mappings that were
        previously in force are restored.

        **See also** **pushContext** ().
        """
        ...

    def pushContext(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlnamespacesupport.html#pushContext

        **void QXmlNamespaceSupport::pushContext()**

        Starts a new namespace context.

        Normally, you should push a new context at the beginning of each XML
        element: the new context automatically inherits the declarations of its
        parent context, and it also keeps track of which declarations were made
        within this context.

        **See also** **popContext** ().
        """
        ...

    @typing.overload
    def prefixes(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qxmlnamespacesupport.html#prefixes

        **QStringList QXmlNamespaceSupport::prefixes() const**

        Returns a list of all the prefixes currently declared.

        If there is a default prefix, this function does not return it in the
        list; check for the default prefix using **uri** () with an argument of
        "".
        """
        ...

    @typing.overload
    def prefixes(self, a0: str) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qxmlnamespacesupport.html#prefixes-1

        **QStringList QXmlNamespaceSupport::prefixes(const QString & uri )
        const**

        This is an overloaded function.

        Returns a list of all prefixes currently declared for the namespace URI
        **uri**.

        The "xml:" prefix is included. If you only want one prefix that is
        mapped to the namespace URI, and you don't care which one you get, use
        the **prefix** () function instead.

        Note: The empty (default) prefix is never included in this list; to
        check for the presence of a default namespace, call **uri** () with ""
        as the argument.
        """
        ...

    def processName(self, a0: str, a1: bool, a2: str, a3: str) -> None:
        """
        https://doc.qt.io/qt-5/qxmlnamespacesupport.html#processName

        **void QXmlNamespaceSupport::processName(const QString & qname , bool
        isAttribute , QString & nsuri , QString & localname ) const**

        Processes a raw XML 1.0 name in the current context by removing the
        prefix and looking it up among the prefixes currently declared.

        **qname** is the raw XML 1.0 name to be processed. **isAttribute** is
        true if the name is an attribute name.

        This function stores the namespace URI in **nsuri** (which will be set
        to an empty string if the raw name has an undeclared prefix), and stores
        the local name (without prefix) in **localname** (which will be set to
        an empty string if no namespace is in use).

        Note that attribute names are processed differently than element names:
        an unprefixed element name gets the default namespace (if any), while an
        unprefixed attribute name does not.
        """
        ...

    def splitName(self, a0: str, a1: str, a2: str) -> None:
        """
        https://doc.qt.io/qt-5/qxmlnamespacesupport.html#splitName

        **void QXmlNamespaceSupport::splitName(const QString & qname , QString &
        prefix , QString & localname ) const**

        Splits the name **qname** at the ':' and returns the prefix in
        **prefix** and the local name in **localname**.

        **See also** **processName** ().
        """
        ...

    def uri(self, a0: str) -> str:
        """
        https://doc.qt.io/qt-5/qxmlnamespacesupport.html#uri

        **QString QXmlNamespaceSupport::uri(const QString & prefix ) const**

        Looks up the prefix **prefix** in the current context and returns the
        currently-mapped namespace URI. Use the empty string ("") for the
        default namespace.
        """
        ...

    def prefix(self, a0: str) -> str:
        """
        https://doc.qt.io/qt-5/qxmlnamespacesupport.html#prefix

        **QString QXmlNamespaceSupport::prefix(const QString & uri ) const**

        Returns one of the prefixes mapped to the namespace URI **uri**.

        If more than one prefix is currently mapped to the same URI, this
        function makes an arbitrary selection; if you want all of the prefixes,
        use **prefixes** () instead.

        Note: to check for a default prefix, use the **uri** () function with an
        argument of "".

        **See also** **setPrefix** ().
        """
        ...

    def setPrefix(self, a0: str, a1: str) -> None:
        """
        https://doc.qt.io/qt-5/qxmlnamespacesupport.html#setPrefix

        **void QXmlNamespaceSupport::setPrefix(const QString & pre , const
        QString & uri )**

        This function declares a prefix **pre** in the current namespace context
        to be the namespace URI **uri**. The prefix remains in force until this
        context is popped, unless it is shadowed in a descendant context.

        Note that there is an asymmetry in this library. **prefix** () does not
        return the default "" prefix, even if you have declared one; to check
        for a default prefix, you must look it up explicitly using **uri** ().
        This asymmetry exists to make it easier to look up prefixes for
        attribute names, where the default prefix is not allowed.

        **See also** **prefix** ().
        """
        ...
