"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5 import sip


class QXmlInputSource(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qxmlinputsource.html

    **Detailed Description**

    All subclasses of **QXmlReader**  read the input XML document from this
    class.

    This class recognizes the encoding of the data by reading the encoding
    declaration in the XML file if it finds one, and reading the data using the
    corresponding encoding. If it does not find an encoding declaration, then it
    assumes that the data is either in UTF-8 or UTF-16, depending on whether it
    can find a byte-order mark.

    There are two ways to populate the input source with data: you can construct
    it with a **QIODevice** * so that the input source reads the data from that
    device. Or you can set the data explicitly with one of the **setData** ()
    functions.

    Usually you either construct a QXmlInputSource that works on a **QIODevice**
    * or you construct an empty QXmlInputSource and set the data with
    **setData** (). There are only rare occasions where you would want to mix
    both methods.

    The **QXmlReader**  subclasses use the **next** () function to read the
    input character by character. If you want to start from the beginning again,
    use **reset** ().

    The functions **data** () and **fetchData** () are useful if you want to do
    something with the data other than parsing, e.g. displaying the raw XML
    file. The benefit of using the QXmlInputClass in such cases is that it tries
    to use the correct encoding.

    **See also** **QXmlReader**  and **QXmlSimpleReader** .
    """

    EndOfData: int = ...
    EndOfDocument: int = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlinputsource.html#QXmlInputSource

        **QXmlInputSource::QXmlInputSource()**

        Constructs an input source which contains no data.

        **See also** **setData** ().
        """
        ...

    @typing.overload
    def __init__(self, dev: QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-5/qxmlinputsource.html#QXmlInputSource-1

        **QXmlInputSource::QXmlInputSource(QIODevice * dev )**

        Constructs an input source and gets the data from device **dev**. If
        **dev** is not open, it is opened in read-only mode. If **dev** is 0 or
        it is not possible to read from the device, the input source will
        contain no data.

        **See also** **setData** (), **fetchData** (), and **QIODevice** .
        """
        ...

    @typing.overload
    def __init__(self, a0: "QXmlInputSource") -> None:
        """
        https://doc.qt.io/qt-5/qxmlinputsource.html#QXmlInputSource

        **QXmlInputSource::QXmlInputSource()**

        Constructs an input source which contains no data.

        **See also** **setData** ().
        """
        ...

    def fromRawData(
        self,
        data: typing.Union[QtCore.QByteArray, bytes, bytearray],
        beginning: bool = ...,
    ) -> str:
        """
        https://doc.qt.io/qt-5/qxmlinputsource.html#fromRawData

        **[virtual protected] QString QXmlInputSource::fromRawData(const
        QByteArray & data , bool beginning = false)**

        This function reads the XML file from **data** and tries to recognize
        the encoding. It converts the raw data **data** into a **QString**  and
        returns it. It tries its best to get the correct encoding for the XML
        file.

        If **beginning** is true, this function assumes that the data starts at
        the beginning of a new XML document and looks for an encoding
        declaration. If **beginning** is false, it converts the raw data using
        the encoding determined from prior calls.
        """
        ...

    def reset(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlinputsource.html#reset

        **[virtual] void QXmlInputSource::reset()**

        This function sets the position used by **next** () to the beginning of
        the data returned by **data** (). This is useful if you want to use the
        input source for more than one parse.

        **Note:** In the case that the underlying data source is a **QIODevice**
        , the current position in the device is not automatically set to the
        start of input. Call **QIODevice::seek** (0) on the device to do this.

        **See also** **next** ().
        """
        ...

    def next(self) -> str:
        """
        https://doc.qt.io/qt-5/qxmlinputsource.html#next

        **[virtual] QChar QXmlInputSource::next()**

        Returns the next character of the input source. If this function reaches
        the end of available data, it returns QXmlInputSource::EndOfData. If you
        call next() after that, it tries to fetch more data by calling
        **fetchData** (). If the **fetchData** () call results in new data, this
        function returns the first character of that data; otherwise it returns
        QXmlInputSource::EndOfDocument.

        Readers, such as QXmlSimpleReader, will assume that the end of the XML
        document has been reached if the this function returns
        QXmlInputSource::EndOfDocument, and will check that the supplied input
        is well-formed. Therefore, when reimplementing this function, it is
        important to ensure that this behavior is duplicated.

        **See also** **reset** (), **fetchData** (), **QXmlSimpleReader::parse**
        (), and **QXmlSimpleReader::parseContinue** ().
        """
        ...

    def data(self) -> str:
        """
        https://doc.qt.io/qt-5/qxmlinputsource.html#data

        **[virtual] QString QXmlInputSource::data() const**

        Returns the data the input source contains or an empty string if the
        input source does not contain any data.

        **See also** **setData** (), **QXmlInputSource** (), and **fetchData**
        ().
        """
        ...

    def fetchData(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlinputsource.html#fetchData

        **[virtual] void QXmlInputSource::fetchData()**

        This function reads more data from the device that was set during
        construction. If the input source already contained data, this function
        deletes that data first.

        This object contains no data after a call to this function if the object
        was constructed without a device to read data from or if this function
        was not able to get more data from the device.

        There are two occasions where a fetch is done implicitly by another
        function call: during construction (so that the object starts out with
        some initial data where available), and during a call to **next** () (if
        the data had run out).

        You don't normally need to use this function if you use **next** ().

        **See also** **data** (), **next** (), and **QXmlInputSource** ().
        """
        ...

    @typing.overload
    def setData(self, dat: str) -> None:
        """
        https://doc.qt.io/qt-5/qxmlinputsource.html#setData

        **[virtual] void QXmlInputSource::setData(const QString & dat )**

        Sets the data of the input source to **dat**.

        If the input source already contains data, this function deletes that
        data first.

        **See also** **data** ().
        """
        ...

    @typing.overload
    def setData(self, dat: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None:
        """
        https://doc.qt.io/qt-5/qxmlinputsource.html#setData-1

        **[virtual] void QXmlInputSource::setData(const QByteArray & dat )**

        This is an overloaded function.

        The data **dat** is passed through the correct text-codec, before it is
        set.
        """
        ...
