"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import sip


class QXmlAttributes(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qxmlattributes.html

    **Detailed Description**

    If attributes are reported by **QXmlContentHandler::startElement** () this
    class is used to pass the attribute values.

    Use **index** () to locate the position of an attribute in the list,
    **count** () to retrieve the number of attributes, and **clear** () to
    remove the attributes. New attributes can be added with **append** (). Use
    **type** () to get an attribute's type and **value** () to get its value.
    The attribute's name is available from **localName** () or **qName** (), and
    its namespace URI from **uri** ().
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlattributes.html#QXmlAttributes

        **QXmlAttributes::QXmlAttributes()**

        Constructs an empty attribute list.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QXmlAttributes") -> None:
        """
        https://doc.qt.io/qt-5/qxmlattributes.html#QXmlAttributes

        **QXmlAttributes::QXmlAttributes()**

        Constructs an empty attribute list.
        """
        ...

    def swap(self, other: "QXmlAttributes") -> None:
        """
        https://doc.qt.io/qt-5/qxmlattributes.html#swap

        **void QXmlAttributes::swap(QXmlAttributes & other )**

        Swaps `this` with **other**.
        """
        ...

    def __len__(self) -> int:
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-5/qxmlattributes.html#count

        **int QXmlAttributes::count() const**

        Returns the number of attributes in the list. This function is
        equivalent to **length** ().
        """
        ...

    def append(self, qName: str, uri: str, localPart: str, value: str) -> None:
        """
        https://doc.qt.io/qt-5/qxmlattributes.html#append

        **void QXmlAttributes::append(const QString & qName , const QString &
        uri , const QString & localPart , const QString & value )**

        Appends a new attribute entry to the list of attributes. The qualified
        name of the attribute is **qName** , the namespace URI is **uri** and
        the local name is **localPart**. The value of the attribute is
        **value**.

        **See also** **qName** (), **uri** (), **localName** (), and **value**
        ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlattributes.html#clear

        **void QXmlAttributes::clear()**

        Clears the list of attributes.

        **See also** **append** ().
        """
        ...

    @typing.overload
    def value(self, index: int) -> str:
        """
        https://doc.qt.io/qt-5/qxmlattributes.html#value

        **QString QXmlAttributes::value(int index ) const**

        Returns an attribute's value for the attribute at position **index**.
        The index must be a valid position (i.e., 0 <= **index** < **count**
        ()).
        """
        ...

    @typing.overload
    def value(self, qName: str) -> str:
        """
        https://doc.qt.io/qt-5/qxmlattributes.html#value-1

        **QString QXmlAttributes::value(const QString & qName ) const**

        This is an overloaded function.

        Returns an attribute's value for the qualified name **qName** , or an
        empty string if no attribute exists for the name given.

        **See also**  Namespace Support via Features.
        """
        ...

    @typing.overload
    def value(self, uri: str, localName: str) -> str:
        """
        https://doc.qt.io/qt-5/qxmlattributes.html#value-2

        **QString QXmlAttributes::value(QLatin1String qName ) const**

        This is an overloaded function.

        Returns an attribute's value for the qualified name **qName** , or an
        empty string if no attribute exists for the name given.

        **See also**  Namespace Support via Features.
        """
        ...

    @typing.overload
    def type(self, index: int) -> str:
        """
        https://doc.qt.io/qt-5/qxmlattributes.html#type

        **QString QXmlAttributes::type(int index ) const**

        Looks up an attribute's type for the attribute at position **index**.

        Currently only "CDATA" is returned.
        """
        ...

    @typing.overload
    def type(self, qName: str) -> str:
        """
        https://doc.qt.io/qt-5/qxmlattributes.html#type-1

        **QString QXmlAttributes::type(const QString & qName ) const**

        This is an overloaded function.

        Looks up an attribute's type for the qualified name **qName**.

        Currently only "CDATA" is returned.
        """
        ...

    @typing.overload
    def type(self, uri: str, localName: str) -> str:
        """
        https://doc.qt.io/qt-5/qxmlattributes.html#type-2

        **QString QXmlAttributes::type(const QString & uri , const QString &
        localName ) const**

        This is an overloaded function.

        Looks up an attribute's type by namespace name.

        **uri** specifies the namespace URI and **localName** specifies the
        local name. If the name has no namespace URI, use an empty string for
        **uri**.

        Currently only "CDATA" is returned.
        """
        ...

    def uri(self, index: int) -> str:
        """
        https://doc.qt.io/qt-5/qxmlattributes.html#uri

        **QString QXmlAttributes::uri(int index ) const**

        Looks up an attribute's namespace URI for the attribute at position
        **index**. If no namespace processing is done or if the attribute has no
        namespace, the namespace URI is an empty string.

        **See also**  Namespace Support via Features.
        """
        ...

    def qName(self, index: int) -> str:
        """
        https://doc.qt.io/qt-5/qxmlattributes.html#qName

        **QString QXmlAttributes::qName(int index ) const**

        Looks up an attribute's XML 1.0 qualified name for the attribute at
        position **index**.

        **See also**  Namespace Support via Features.
        """
        ...

    def localName(self, index: int) -> str:
        """
        https://doc.qt.io/qt-5/qxmlattributes.html#localName

        **QString QXmlAttributes::localName(int index ) const**

        Looks up an attribute's local name for the attribute at position
        **index**. If no namespace processing is done, the local name is an
        empty string.

        **See also**  Namespace Support via Features.
        """
        ...

    def length(self) -> int:
        """
        https://doc.qt.io/qt-5/qxmlattributes.html#length

        **int QXmlAttributes::length() const**

        Returns the number of attributes in the list.

        **See also** **count** ().
        """
        ...

    @typing.overload
    def index(self, qName: str) -> int:
        """
        https://doc.qt.io/qt-5/qxmlattributes.html#index

        **int QXmlAttributes::index(const QString & qName ) const**

        Looks up the index of an attribute by the qualified name **qName**.

        Returns the index of the attribute or -1 if it wasn't found.

        **See also**  Namespace Support via Features.
        """
        ...

    @typing.overload
    def index(self, uri: str, localPart: str) -> int:
        """
        https://doc.qt.io/qt-5/qxmlattributes.html#index-1

        **int QXmlAttributes::index(QLatin1String qName ) const**

        This is an overloaded function.
        """
        ...
