"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtXml import *


class QDomEntity(QDomNode):
    """
    https://doc.qt.io/qt-5/qdomentity.html

    **Detailed Description**

    This class represents an entity in an XML document, either parsed or
    unparsed. Note that this models the entity itself not the entity
    declaration.

    DOM does not support editing entity nodes; if a user wants to make changes
    to the contents of an entity, every related **QDomEntityReference**  node
    must be replaced in the DOM tree by a clone of the entity's contents, and
    then the desired changes must be made to each of the clones instead. All the
    descendants of an entity node are read-only.

    An entity node does not have any parent.

    You can access the entity's **publicId** (), **systemId** () and
    **notationName** () when available.

    For further information about the Document Object Model see **Level 1**  and
    **Level 2 Core** . For a more general introduction of the DOM implementation
    see the **QDomDocument**  documentation.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qdomentity.html#QDomEntity

        **QDomEntity::QDomEntity()**

        Constructs an empty entity.
        """
        ...

    @typing.overload
    def __init__(self, x: "QDomEntity") -> None:
        """
        https://doc.qt.io/qt-5/qdomentity.html#QDomEntity-1

        **QDomEntity::QDomEntity(const QDomEntity & x )**

        Constructs a copy of **x**.

        The data of the copy is shared (shallow copy): modifying one node will
        also change the other. If you want to make a deep copy, use
        **cloneNode** ().
        """
        ...

    def nodeType(self) -> QDomNode.NodeType:
        """
        https://doc.qt.io/qt-5/qdomentity.html#nodeType

        **QDomNode::NodeType QDomEntity::nodeType() const**

        Returns `EntityNode`.
        """
        ...

    def notationName(self) -> str:
        """
        https://doc.qt.io/qt-5/qdomentity.html#notationName

        **QString QDomEntity::notationName() const**

        For unparsed entities this function returns the name of the notation for
        the entity. For parsed entities this function returns an empty string.
        """
        ...

    def systemId(self) -> str:
        """
        https://doc.qt.io/qt-5/qdomentity.html#systemId

        **QString QDomEntity::systemId() const**

        Returns the system identifier associated with this entity. If the system
        identifier was not specified an empty string is returned.
        """
        ...

    def publicId(self) -> str:
        """
        https://doc.qt.io/qt-5/qdomentity.html#publicId

        **QString QDomEntity::publicId() const**

        Returns the public identifier associated with this entity. If the public
        identifier was not specified an empty string is returned.
        """
        ...
