"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtXml import *


class QDomElement(QDomNode):
    """
    https://doc.qt.io/qt-5/qdomelement.html

    **Detailed Description**

    Elements have a **tagName** () and zero or more attributes associated with
    them. The tag name can be changed with **setTagName** ().

    Element attributes are represented by **QDomAttr**  objects that can be
    queried using the **attribute** () and **attributeNode** () functions. You
    can set attributes with the **setAttribute** () and **setAttributeNode** ()
    functions. Attributes can be removed with **removeAttribute** (). There are
    namespace-aware equivalents to these functions, i.e. **setAttributeNS** (),
    **setAttributeNodeNS** () and **removeAttributeNS** ().

    If you want to access the text of a node use **text** (), e.g.

    **QDomElement**  e = //...
        //...
        **QString**  s = e.text()

    The **text** () function operates recursively to find the text (since not
    all elements contain text). If you want to find all the text in all of a
    node's children, iterate over the children looking for **QDomText**  nodes,
    e.g.

    **QString**  text;
        **QDomElement**  element = doc.documentElement();
    for(**QDomNode**  n = element.firstChild(); !n.isNull(); n =
    n.nextSibling())
        {
            **QDomText**  t = n.toText();
            if
    (!t.isNull())
                text += t.data();
        }

    Note that we attempt to convert each node to a text node and use **text** ()
    rather than using **firstChild** ().**toText** ().data() or n.**toText**
    ().data() directly on the node, because the node may not be a text element.

    You can get a list of all the decendents of an element which have a
    specified tag name with **elementsByTagName** () or **elementsByTagNameNS**
    ().

    To browse the elements of a dom document use **firstChildElement** (),
    **lastChildElement** (), **nextSiblingElement** () and
    **previousSiblingElement** (). For example, to iterate over all child
    elements called "entry" in a root element called "database", you can use:

    **QDomDocument**  doc = // ...
        **QDomElement**  root =
    doc.firstChildElement("database");
        **QDomElement**  elt =
    root.firstChildElement("entry");
        for (; !elt.isNull(); elt =
    elt.nextSiblingElement("entry")) {
            // ...
        }

    For further information about the Document Object Model see **Level 1**  and
    **Level 2 Core** . For a more general introduction of the DOM implementation
    see the **QDomDocument**  documentation.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qdomelement.html#QDomElement

        **QDomElement::QDomElement()**

        Constructs an empty element. Use the **QDomDocument::createElement** ()
        function to construct elements with content.
        """
        ...

    @typing.overload
    def __init__(self, x: "QDomElement") -> None:
        """
        https://doc.qt.io/qt-5/qdomelement.html#QDomElement-1

        **QDomElement::QDomElement(const QDomElement & x )**

        Constructs a copy of **x**.

        The data of the copy is shared (shallow copy): modifying one node will
        also change the other. If you want to make a deep copy, use
        **cloneNode** ().
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-5/qdomelement.html#text

        **QString QDomElement::text() const**

        Returns the element's text or an empty string.

        Example:

        <h1>Hello <b>Qt</b> <![CDATA[<xml is cool>]]></h1>

        The function text() of the **QDomElement**  for the `<h1>` tag, will
        return the following text:

        Hello Qt <xml is cool>

        Comments are ignored by this function. It only evaluates **QDomText**
        and **QDomCDATASection**  objects.
        """
        ...

    def nodeType(self) -> QDomNode.NodeType:
        """
        https://doc.qt.io/qt-5/qdomelement.html#nodeType

        **QDomNode::NodeType QDomElement::nodeType() const**

        Returns `ElementNode`.
        """
        ...

    def attributes(self) -> QDomNamedNodeMap:
        """
        https://doc.qt.io/qt-5/qdomelement.html#attributes

        **QDomNamedNodeMap QDomElement::attributes() const**

        Returns a **QDomNamedNodeMap**  containing all this element's
        attributes.

        **See also** **attribute** (), **setAttribute** (), **attributeNode**
        (), and **setAttributeNode** ().
        """
        ...

    def setTagName(self, name: str) -> None:
        """
        https://doc.qt.io/qt-5/qdomelement.html#setTagName

        **void QDomElement::setTagName(const QString & name )**

        Sets this element's tag name to **name**.

        **See also** **tagName** ().
        """
        ...

    def tagName(self) -> str:
        """
        https://doc.qt.io/qt-5/qdomelement.html#tagName

        **QString QDomElement::tagName() const**

        Returns the tag name of this element. For an XML element like this:

        <img src="myimg.png">

        the tagname would return "img".

        **See also** **setTagName** ().
        """
        ...

    def hasAttributeNS(self, nsURI: str, localName: str) -> bool:
        """
        https://doc.qt.io/qt-5/qdomelement.html#hasAttributeNS

        **bool QDomElement::hasAttributeNS(const QString & nsURI , const QString
        & localName ) const**

        Returns `true` if this element has an attribute with the local name
        **localName** and the namespace URI **nsURI** ; otherwise returns false.
        """
        ...

    def elementsByTagNameNS(self, nsURI: str, localName: str) -> QDomNodeList:
        """
        https://doc.qt.io/qt-5/qdomelement.html#elementsByTagNameNS

        **QDomNodeList QDomElement::elementsByTagNameNS(const QString & nsURI ,
        const QString & localName ) const**

        Returns a **QDomNodeList**  containing all descendants of this element
        with local name **localName** and namespace URI **nsURI** encountered
        during a preorder traversal of the element subtree with this element as
        its root. The order of the elements in the returned list is the order
        they are encountered during the preorder traversal.

        **See also** **elementsByTagName** () and
        **QDomDocument::elementsByTagNameNS** ().
        """
        ...

    def setAttributeNodeNS(self, newAttr: QDomAttr) -> QDomAttr:
        """
        https://doc.qt.io/qt-5/qdomelement.html#setAttributeNodeNS

        **QDomAttr QDomElement::setAttributeNodeNS(const QDomAttr & newAttr )**

        Adds the attribute **newAttr** to this element.

        If the element has another attribute that has the same local name and
        namespace URI as **newAttr** , this function replaces that attribute and
        returns it; otherwise the function returns a **null attribute** .

        **See also** **attributeNodeNS** (), **setAttributeNS** (), and
        **setAttributeNode** ().
        """
        ...

    def attributeNodeNS(self, nsURI: str, localName: str) -> QDomAttr:
        """
        https://doc.qt.io/qt-5/qdomelement.html#attributeNodeNS

        **QDomAttr QDomElement::attributeNodeNS(const QString & nsURI , const
        QString & localName )**

        Returns the **QDomAttr**  object that corresponds to the attribute with
        the local name **localName** and the namespace URI **nsURI**. If no such
        attribute exists a **null attribute**  is returned.

        **See also** **setAttributeNodeNS** (), **setAttributeNode** (),
        **attribute** (), and **setAttribute** ().
        """
        ...

    def removeAttributeNS(self, nsURI: str, localName: str) -> None:
        """
        https://doc.qt.io/qt-5/qdomelement.html#removeAttributeNS

        **void QDomElement::removeAttributeNS(const QString & nsURI , const
        QString & localName )**

        Removes the attribute with the local name **localName** and the
        namespace URI **nsURI** from this element.

        **See also** **setAttributeNS** (), **attributeNS** (), and
        **removeAttribute** ().
        """
        ...

    @typing.overload
    def setAttributeNS(self, nsURI: str, qName: str, value: str) -> None:
        """
        https://doc.qt.io/qt-5/qdomelement.html#setAttributeNS

        **void QDomElement::setAttributeNS(const QString nsURI , const QString &
        qName , const QString & value )**

        Adds an attribute with the qualified name **qName** and the namespace
        URI **nsURI** with the value **value**. If an attribute with the same
        local name and namespace URI exists, its prefix is replaced by the
        prefix of **qName** and its value is repaced by **value**.

        Although **qName** is the qualified name, the local name is used to
        decide if an existing attribute's value should be replaced.

        **See also** **attributeNS** (), **setAttributeNodeNS** (), and
        **setAttribute** ().
        """
        ...

    @typing.overload
    def setAttributeNS(self, nsURI: str, qName: str, value: int) -> None:
        """
        https://doc.qt.io/qt-5/qdomelement.html#setAttributeNS-1

        **void QDomElement::setAttributeNS(const QString nsURI , const QString &
        qName , int value )**

        This is an overloaded function.
        """
        ...

    @typing.overload
    def setAttributeNS(self, nsURI: str, qName: str, value: int) -> None:
        """
        https://doc.qt.io/qt-5/qdomelement.html#setAttributeNS-2

        **void QDomElement::setAttributeNS(const QString nsURI , const QString &
        qName , uint value )**

        This is an overloaded function.
        """
        ...

    @typing.overload
    def setAttributeNS(self, nsURI: str, qName: str, value: float) -> None:
        """
        https://doc.qt.io/qt-5/qdomelement.html#setAttributeNS-3

        **void QDomElement::setAttributeNS(const QString nsURI , const QString &
        qName , qlonglong value )**

        This is an overloaded function.
        """
        ...

    @typing.overload
    def setAttributeNS(self, nsURI: str, qName: str, value: int) -> None:
        """
        https://doc.qt.io/qt-5/qdomelement.html#setAttributeNS-4

        **void QDomElement::setAttributeNS(const QString nsURI , const QString &
        qName , qulonglong value )**

        This is an overloaded function.
        """
        ...

    def attributeNS(self, nsURI: str, localName: str, defaultValue: str = ...) -> str:
        """
        https://doc.qt.io/qt-5/qdomelement.html#attributeNS

        **QString QDomElement::attributeNS(const QString nsURI , const QString &
        localName , const QString & defValue = QString()) const**

        Returns the attribute with the local name **localName** and the
        namespace URI **nsURI**. If the attribute does not exist **defValue** is
        returned.

        **See also** **setAttributeNS** (), **attributeNodeNS** (),
        **setAttributeNodeNS** (), and **attribute** ().
        """
        ...

    def hasAttribute(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-5/qdomelement.html#hasAttribute

        **bool QDomElement::hasAttribute(const QString & name ) const**

        Returns `true` if this element has an attribute called **name** ;
        otherwise returns `false`.

        **Note:** This function does not take the presence of namespaces into
        account. As a result, the specified name will be tested against fully-
        qualified attribute names that include any namespace prefixes that may
        be present.

        Use **hasAttributeNS** () to explicitly test for attributes with
        specific namespaces and names.
        """
        ...

    def elementsByTagName(self, tagname: str) -> QDomNodeList:
        """
        https://doc.qt.io/qt-5/qdomelement.html#elementsByTagName

        **QDomNodeList QDomElement::elementsByTagName(const QString & tagname )
        const**

        Returns a **QDomNodeList**  containing all descendants of this element
        named **tagname** encountered during a preorder traversal of the element
        subtree with this element as its root. The order of the elements in the
        returned list is the order they are encountered during the preorder
        traversal.

        **See also** **elementsByTagNameNS** () and
        **QDomDocument::elementsByTagName** ().
        """
        ...

    def removeAttributeNode(self, oldAttr: QDomAttr) -> QDomAttr:
        """
        https://doc.qt.io/qt-5/qdomelement.html#removeAttributeNode

        **QDomAttr QDomElement::removeAttributeNode(const QDomAttr & oldAttr )**

        Removes the attribute **oldAttr** from the element and returns it.

        **See also** **attributeNode** () and **setAttributeNode** ().
        """
        ...

    def setAttributeNode(self, newAttr: QDomAttr) -> QDomAttr:
        """
        https://doc.qt.io/qt-5/qdomelement.html#setAttributeNode

        **QDomAttr QDomElement::setAttributeNode(const QDomAttr & newAttr )**

        Adds the attribute **newAttr** to this element.

        If the element has another attribute that has the same name as
        **newAttr** , this function replaces that attribute and returns it;
        otherwise the function returns a **null attribute** .

        **See also** **attributeNode** (), **setAttribute** (), and
        **setAttributeNodeNS** ().
        """
        ...

    def attributeNode(self, name: str) -> QDomAttr:
        """
        https://doc.qt.io/qt-5/qdomelement.html#attributeNode

        **QDomAttr QDomElement::attributeNode(const QString & name )**

        Returns the **QDomAttr**  object that corresponds to the attribute
        called **name**. If no such attribute exists a **null attribute**  is
        returned.

        **See also** **setAttributeNode** (), **attribute** (), **setAttribute**
        (), and **attributeNodeNS** ().
        """
        ...

    def removeAttribute(self, name: str) -> None:
        """
        https://doc.qt.io/qt-5/qdomelement.html#removeAttribute

        **void QDomElement::removeAttribute(const QString & name )**

        Removes the attribute called name **name** from this element.

        **See also** **setAttribute** (), **attribute** (), and
        **removeAttributeNS** ().
        """
        ...

    @typing.overload
    def setAttribute(self, name: str, value: str) -> None:
        """
        https://doc.qt.io/qt-5/qdomelement.html#setAttribute

        **void QDomElement::setAttribute(const QString & name , const QString &
        value )**

        Adds an attribute called **name** with value **value**. If an attribute
        with the same name exists, its value is replaced by **value**.

        **See also** **attribute** (), **setAttributeNode** (), and
        **setAttributeNS** ().
        """
        ...

    @typing.overload
    def setAttribute(self, name: str, value: int) -> None:
        """
        https://doc.qt.io/qt-5/qdomelement.html#setAttribute-1

        **void QDomElement::setAttribute(const QString & name , qlonglong value
        )**

        This is an overloaded function.

        The formatting always uses **QLocale::C** .
        """
        ...

    @typing.overload
    def setAttribute(self, name: str, value: int) -> None:
        """
        https://doc.qt.io/qt-5/qdomelement.html#setAttribute-2

        **void QDomElement::setAttribute(const QString & name , qulonglong value
        )**

        This is an overloaded function.

        The formatting always uses **QLocale::C** .
        """
        ...

    @typing.overload
    def setAttribute(self, name: str, value: float) -> None:
        """
        https://doc.qt.io/qt-5/qdomelement.html#setAttribute-3

        **void QDomElement::setAttribute(const QString & name , int value )**

        This is an overloaded function.

        The formatting always uses **QLocale::C** .
        """
        ...

    @typing.overload
    def setAttribute(self, name: str, value: int) -> None:
        """
        https://doc.qt.io/qt-5/qdomelement.html#setAttribute-4

        **void QDomElement::setAttribute(const QString & name , uint value )**

        This is an overloaded function.

        The formatting always uses **QLocale::C** .
        """
        ...

    def attribute(self, name: str, defaultValue: str = ...) -> str:
        """
        https://doc.qt.io/qt-5/qdomelement.html#attribute

        **QString QDomElement::attribute(const QString & name , const QString &
        defValue = QString()) const**

        Returns the attribute called **name**. If the attribute does not exist
        **defValue** is returned.

        **See also** **setAttribute** (), **attributeNode** (),
        **setAttributeNode** (), and **attributeNS** ().
        """
        ...
