"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtXml import *


class QDomDocument(QDomNode):
    """
    https://doc.qt.io/qt-5/qdomdocument.html

    **Detailed Description**

    The QDomDocument class represents the entire XML document. Conceptually, it
    is the root of the document tree, and provides the primary access to the
    document's data.

    Since elements, text nodes, comments, processing instructions, etc., cannot
    exist outside the context of a document, the document class also contains
    the factory functions needed to create these objects. The node objects
    created have an **ownerDocument** () function which associates them with the
    document within whose context they were created. The DOM classes that will
    be used most often are **QDomNode** , QDomDocument, **QDomElement**  and
    **QDomText** .

    The parsed XML is represented internally by a tree of objects that can be
    accessed using the various QDom classes. All QDom classes only **reference**
    objects in the internal tree. The internal objects in the DOM tree will get
    deleted once the last QDom object referencing them or the QDomDocument
    itself is deleted.

    Creation of elements, text nodes, etc. is done using the various factory
    functions provided in this class. Using the default constructors of the QDom
    classes will only result in empty objects that cannot be manipulated or
    inserted into the Document.

    The QDomDocument class has several functions for creating document data, for
    example, **createElement** (), **createTextNode** (), **createComment** (),
    **createCDATASection** (), **createProcessingInstruction** (),
    **createAttribute** () and **createEntityReference** (). Some of these
    functions have versions that support namespaces, i.e. **createElementNS** ()
    and **createAttributeNS** (). The **createDocumentFragment** () function is
    used to hold parts of the document; this is useful for manipulating for
    complex documents.

    The entire content of the document is set with **setContent** (). This
    function parses the string it is passed as an XML document and creates the
    DOM tree that represents the document. The root element is available using
    **documentElement** (). The textual representation of the document can be
    obtained using **toString** ().

    **Note:** The DOM tree might end up reserving a lot of memory if the XML
    document is big. For such documents, the **QXmlStreamReader**  or the
    QXmlQuery classes might be better solutions.

    It is possible to insert a node from another document into the document
    using **importNode** ().

    You can obtain a list of all the elements that have a particular tag with
    **elementsByTagName** () or with **elementsByTagNameNS** ().

    The QDom classes are typically used as follows:

    **QDomDocument**  doc("mydocument");
        **QFile**  file("mydocument.xml");
    if (!file.open(**QIODevice** ::ReadOnly))
            return;
        if
    (!doc.setContent(&file)) {
            file.close();
            return;
        }
    file.close();

        // print out the element names of all elements that
    are direct children
        // of the outermost element.
        **QDomElement**
    docElem = doc.documentElement();

        **QDomNode**  n =
    docElem.firstChild();
        while(!n.isNull()) {
            **QDomElement**  e =
    n.toElement(); // try to convert the node to an element.
    if(!e.isNull()) {
                cout << **qPrintable** (e.tagName()) <<
    Qt::endl; // the node really is an element.
            }
            n =
    n.nextSibling();
        }

        // Here we append a new element to the end
    of the document
        **QDomElement**  elem = doc.createElement("img");
    elem.setAttribute("src", "myimage.png");
        docElem.appendChild(elem);

    Once `doc` and `elem` go out of scope, the whole internal tree representing
    the XML document is deleted.

    To create a document using DOM use code like this:

    **QDomDocument**  doc("MyML");
        **QDomElement**  root =
    doc.createElement("MyML");
        doc.appendChild(root);
    **QDomElement**  tag = doc.createElement("Greeting");
    root.appendChild(tag);

        **QDomText**  t = doc.createTextNode("Hello
    World");
        tag.appendChild(t);

        **QString**  xml = doc.toString();

    For further information about the Document Object Model see the Document
    Object Model (DOM) **Level 1**  and **Level 2 Core**  Specifications.

    **See also** **DOM Bookmarks Example**  and **Simple DOM Model Example** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qdomdocument.html#QDomDocument

        **QDomDocument::QDomDocument()**

        Constructs an empty document.
        """
        ...

    @typing.overload
    def __init__(self, name: str) -> None:
        """
        https://doc.qt.io/qt-5/qdomdocument.html#QDomDocument-1

        **QDomDocument::QDomDocument(const QString & name )**

        Creates a document and sets the name of the document type to **name**.
        """
        ...

    @typing.overload
    def __init__(self, doctype: QDomDocumentType) -> None:
        """
        https://doc.qt.io/qt-5/qdomdocument.html#QDomDocument-2

        **QDomDocument::QDomDocument(const QDomDocumentType & doctype )**

        Creates a document with the document type **doctype**.

        **See also** **QDomImplementation::createDocumentType** ().
        """
        ...

    @typing.overload
    def __init__(self, x: "QDomDocument") -> None:
        """
        https://doc.qt.io/qt-5/qdomdocument.html#QDomDocument-3

        **QDomDocument::QDomDocument(const QDomDocument & x )**

        Constructs a copy of **x**.

        The data of the copy is shared (shallow copy): modifying one node will
        also change the other. If you want to make a deep copy, use
        **cloneNode** ().
        """
        ...

    def toByteArray(self, indent: int = ...) -> QtCore.QByteArray:
        """
        https://doc.qt.io/qt-5/qdomdocument.html#toByteArray

        **QByteArray QDomDocument::toByteArray(int indent = 1) const**

        Converts the parsed document back to its textual representation and
        returns a **QByteArray**  containing the data encoded as UTF-8.

        This function uses **indent** as the amount of space to indent
        subelements.

        **See also** **toString** ().
        """
        ...

    def toString(self, indent: int = ...) -> str:
        """
        https://doc.qt.io/qt-5/qdomdocument.html#toString

        **QString QDomDocument::toString(int indent = 1) const**

        Converts the parsed document back to its textual representation.

        This function uses **indent** as the amount of space to indent
        subelements.

        If **indent** is -1, no whitespace at all is added.
        """
        ...

    @typing.overload
    def setContent(
        self,
        text: typing.Union[QtCore.QByteArray, bytes, bytearray],
        namespaceProcessing: bool,
    ) -> typing.Tuple[bool, str, int, int]:
        """
        https://doc.qt.io/qt-5/qdomdocument.html#setContent

        **bool QDomDocument::setContent(const QByteArray & data , bool
        namespaceProcessing , QString * errorMsg = nullptr, int * errorLine =
        nullptr, int * errorColumn = nullptr)**

        This function parses the XML document from the byte array **data** and
        sets it as the content of the document. It tries to detect the encoding
        of the document as required by the XML specification.

        If **namespaceProcessing** is true, the parser recognizes namespaces in
        the XML file and sets the prefix name, local name and namespace URI to
        appropriate values. If **namespaceProcessing** is false, the parser does
        no namespace processing when it reads the XML file.

        If a parse error occurs, this function returns `false` and the error
        message is placed in `*` **errorMsg** , the line number in `*`
        **errorLine** and the column number in `*` **errorColumn** (unless the
        associated pointer is set to 0); otherwise this function returns `true`.
        The various error messages are described in the QXmlParseException class
        documentation. Note that, if you want to display these error messages to
        your application's users, they will be displayed in English unless they
        are explicitly translated.

        If **namespaceProcessing** is true, the function **QDomNode::prefix** ()
        returns a string for all elements and attributes. It returns an empty
        string if the element or attribute has no prefix.

        Text nodes consisting only of whitespace are stripped and won't appear
        in the **QDomDocument** . If this behavior is not desired, one can use
        the setContent() overload that allows a QXmlReader to be supplied.

        If **namespaceProcessing** is false, the functions **QDomNode::prefix**
        (), **QDomNode::localName** () and **QDomNode::namespaceURI** () return
        an empty string.

        Entity references are handled as follows:

        * References to internal general entities and character entities
        occurring in the content are included. The result is a **QDomText**
        node with the references replaced by their corresponding entity values.
        * References to parameter entities occurring in the internal subset are
        included. The result is a **QDomDocumentType**  node which contains
        entity and notation declarations with the references replaced by their
        corresponding entity values.
          * Any general parsed entity reference
        which is not defined in the internal subset and which occurs in the
        content is represented as a **QDomEntityReference**  node.
          * Any
        parsed entity reference which is not defined in the internal subset and
        which occurs outside of the content is replaced with an empty string.
        * Any unparsed entity reference is replaced with an empty string.

        **See also** **QDomNode::namespaceURI** (), **QDomNode::localName** (),
        **QDomNode::prefix** (), **QString::isNull** (), and
        **QString::isEmpty** ().
        """
        ...

    @typing.overload
    def setContent(
        self, text: str, namespaceProcessing: bool
    ) -> typing.Tuple[bool, str, int, int]:
        """
        https://doc.qt.io/qt-5/qdomdocument.html#setContent-1

        **bool QDomDocument::setContent(const QString & text , bool
        namespaceProcessing , QString * errorMsg = nullptr, int * errorLine =
        nullptr, int * errorColumn = nullptr)**

        This is an overloaded function.

        This function reads the XML document from the string **text** ,
        returning true if the content was successfully parsed; otherwise returns
        `false`. Since **text** is already a Unicode string, no encoding
        detection is done.
        """
        ...

    @typing.overload
    def setContent(
        self, dev: QtCore.QIODevice, namespaceProcessing: bool
    ) -> typing.Tuple[bool, str, int, int]:
        """
        https://doc.qt.io/qt-5/qdomdocument.html#setContent-2

        **bool QDomDocument::setContent(QIODevice * dev , bool
        namespaceProcessing , QString * errorMsg = nullptr, int * errorLine =
        nullptr, int * errorColumn = nullptr)**

        This is an overloaded function.

        This function reads the XML document from the IO device **dev** ,
        returning true if the content was successfully parsed; otherwise returns
        `false`.
        """
        ...

    @typing.overload
    def setContent(
        self, source: "QXmlInputSource", namespaceProcessing: bool
    ) -> typing.Tuple[bool, str, int, int]:
        """
        https://doc.qt.io/qt-5/qdomdocument.html#setContent-4

        **bool QDomDocument::setContent(const QByteArray & buffer , QString *
        errorMsg = nullptr, int * errorLine = nullptr, int * errorColumn =
        nullptr)**

        This is an overloaded function.

        This function reads the XML document from the byte array **buffer** ,
        returning true if the content was successfully parsed; otherwise returns
        false.

        No namespace processing is performed.
        """
        ...

    @typing.overload
    def setContent(
        self, text: typing.Union[QtCore.QByteArray, bytes, bytearray]
    ) -> typing.Tuple[bool, str, int, int]:
        """
        https://doc.qt.io/qt-5/qdomdocument.html#setContent-5

        **bool QDomDocument::setContent(const QString & text , QString *
        errorMsg = nullptr, int * errorLine = nullptr, int * errorColumn =
        nullptr)**

        This is an overloaded function.

        This function reads the XML document from the string **text** ,
        returning true if the content was successfully parsed; otherwise returns
        `false`. Since **text** is already a Unicode string, no encoding
        detection is performed.

        No namespace processing is performed either.
        """
        ...

    @typing.overload
    def setContent(self, text: str) -> typing.Tuple[bool, str, int, int]:
        """
        https://doc.qt.io/qt-5/qdomdocument.html#setContent-8

        **bool QDomDocument::setContent(QXmlStreamReader * reader , bool
        namespaceProcessing , QString * errorMsg = nullptr, int * errorLine =
        nullptr, int * errorColumn = nullptr)**

        This is an overloaded function.

        This function reads the XML document from the **QXmlStreamReader**
        **reader** and parses it. Returns `true` if the content was successfully
        parsed; otherwise returns `false`.

        If **namespaceProcessing** is `true`, the parser recognizes namespaces
        in the XML file and sets the prefix name, local name and namespace URI
        to appropriate values. If **namespaceProcessing** is `false`, the parser
        does no namespace processing when it reads the XML file.

        If a parse error occurs, the error message is placed in `*` **errorMsg**
        , the line number in `*` **errorLine** and the column number in `*`
        **errorColumn** (unless the associated pointer is set to 0).

        This function was introduced in Qt 5.15.

        **See also** **QXmlStreamReader** .
        """
        ...

    @typing.overload
    def setContent(self, dev: QtCore.QIODevice) -> typing.Tuple[bool, str, int, int]:
        """
        https://doc.qt.io/qt-5/qdomdocument.html#setContent

        **bool QDomDocument::setContent(const QByteArray & data , bool
        namespaceProcessing , QString * errorMsg = nullptr, int * errorLine =
        nullptr, int * errorColumn = nullptr)**

        This function parses the XML document from the byte array **data** and
        sets it as the content of the document. It tries to detect the encoding
        of the document as required by the XML specification.

        If **namespaceProcessing** is true, the parser recognizes namespaces in
        the XML file and sets the prefix name, local name and namespace URI to
        appropriate values. If **namespaceProcessing** is false, the parser does
        no namespace processing when it reads the XML file.

        If a parse error occurs, this function returns `false` and the error
        message is placed in `*` **errorMsg** , the line number in `*`
        **errorLine** and the column number in `*` **errorColumn** (unless the
        associated pointer is set to 0); otherwise this function returns `true`.
        The various error messages are described in the QXmlParseException class
        documentation. Note that, if you want to display these error messages to
        your application's users, they will be displayed in English unless they
        are explicitly translated.

        If **namespaceProcessing** is true, the function **QDomNode::prefix** ()
        returns a string for all elements and attributes. It returns an empty
        string if the element or attribute has no prefix.

        Text nodes consisting only of whitespace are stripped and won't appear
        in the **QDomDocument** . If this behavior is not desired, one can use
        the setContent() overload that allows a QXmlReader to be supplied.

        If **namespaceProcessing** is false, the functions **QDomNode::prefix**
        (), **QDomNode::localName** () and **QDomNode::namespaceURI** () return
        an empty string.

        Entity references are handled as follows:

        * References to internal general entities and character entities
        occurring in the content are included. The result is a **QDomText**
        node with the references replaced by their corresponding entity values.
        * References to parameter entities occurring in the internal subset are
        included. The result is a **QDomDocumentType**  node which contains
        entity and notation declarations with the references replaced by their
        corresponding entity values.
          * Any general parsed entity reference
        which is not defined in the internal subset and which occurs in the
        content is represented as a **QDomEntityReference**  node.
          * Any
        parsed entity reference which is not defined in the internal subset and
        which occurs outside of the content is replaced with an empty string.
        * Any unparsed entity reference is replaced with an empty string.

        **See also** **QDomNode::namespaceURI** (), **QDomNode::localName** (),
        **QDomNode::prefix** (), **QString::isNull** (), and
        **QString::isEmpty** ().
        """
        ...

    @typing.overload
    def setContent(
        self, source: "QXmlInputSource", reader: "QXmlReader"
    ) -> typing.Tuple[bool, str, int, int]:
        """
        https://doc.qt.io/qt-5/qdomdocument.html#setContent

        **bool QDomDocument::setContent(const QByteArray & data , bool
        namespaceProcessing , QString * errorMsg = nullptr, int * errorLine =
        nullptr, int * errorColumn = nullptr)**

        This function parses the XML document from the byte array **data** and
        sets it as the content of the document. It tries to detect the encoding
        of the document as required by the XML specification.

        If **namespaceProcessing** is true, the parser recognizes namespaces in
        the XML file and sets the prefix name, local name and namespace URI to
        appropriate values. If **namespaceProcessing** is false, the parser does
        no namespace processing when it reads the XML file.

        If a parse error occurs, this function returns `false` and the error
        message is placed in `*` **errorMsg** , the line number in `*`
        **errorLine** and the column number in `*` **errorColumn** (unless the
        associated pointer is set to 0); otherwise this function returns `true`.
        The various error messages are described in the QXmlParseException class
        documentation. Note that, if you want to display these error messages to
        your application's users, they will be displayed in English unless they
        are explicitly translated.

        If **namespaceProcessing** is true, the function **QDomNode::prefix** ()
        returns a string for all elements and attributes. It returns an empty
        string if the element or attribute has no prefix.

        Text nodes consisting only of whitespace are stripped and won't appear
        in the **QDomDocument** . If this behavior is not desired, one can use
        the setContent() overload that allows a QXmlReader to be supplied.

        If **namespaceProcessing** is false, the functions **QDomNode::prefix**
        (), **QDomNode::localName** () and **QDomNode::namespaceURI** () return
        an empty string.

        Entity references are handled as follows:

        * References to internal general entities and character entities
        occurring in the content are included. The result is a **QDomText**
        node with the references replaced by their corresponding entity values.
        * References to parameter entities occurring in the internal subset are
        included. The result is a **QDomDocumentType**  node which contains
        entity and notation declarations with the references replaced by their
        corresponding entity values.
          * Any general parsed entity reference
        which is not defined in the internal subset and which occurs in the
        content is represented as a **QDomEntityReference**  node.
          * Any
        parsed entity reference which is not defined in the internal subset and
        which occurs outside of the content is replaced with an empty string.
        * Any unparsed entity reference is replaced with an empty string.

        **See also** **QDomNode::namespaceURI** (), **QDomNode::localName** (),
        **QDomNode::prefix** (), **QString::isNull** (), and
        **QString::isEmpty** ().
        """
        ...

    @typing.overload
    def setContent(
        self, reader: QtCore.QXmlStreamReader, namespaceProcessing: bool
    ) -> typing.Tuple[bool, str, int, int]:
        """
        https://doc.qt.io/qt-5/qdomdocument.html#setContent

        **bool QDomDocument::setContent(const QByteArray & data , bool
        namespaceProcessing , QString * errorMsg = nullptr, int * errorLine =
        nullptr, int * errorColumn = nullptr)**

        This function parses the XML document from the byte array **data** and
        sets it as the content of the document. It tries to detect the encoding
        of the document as required by the XML specification.

        If **namespaceProcessing** is true, the parser recognizes namespaces in
        the XML file and sets the prefix name, local name and namespace URI to
        appropriate values. If **namespaceProcessing** is false, the parser does
        no namespace processing when it reads the XML file.

        If a parse error occurs, this function returns `false` and the error
        message is placed in `*` **errorMsg** , the line number in `*`
        **errorLine** and the column number in `*` **errorColumn** (unless the
        associated pointer is set to 0); otherwise this function returns `true`.
        The various error messages are described in the QXmlParseException class
        documentation. Note that, if you want to display these error messages to
        your application's users, they will be displayed in English unless they
        are explicitly translated.

        If **namespaceProcessing** is true, the function **QDomNode::prefix** ()
        returns a string for all elements and attributes. It returns an empty
        string if the element or attribute has no prefix.

        Text nodes consisting only of whitespace are stripped and won't appear
        in the **QDomDocument** . If this behavior is not desired, one can use
        the setContent() overload that allows a QXmlReader to be supplied.

        If **namespaceProcessing** is false, the functions **QDomNode::prefix**
        (), **QDomNode::localName** () and **QDomNode::namespaceURI** () return
        an empty string.

        Entity references are handled as follows:

        * References to internal general entities and character entities
        occurring in the content are included. The result is a **QDomText**
        node with the references replaced by their corresponding entity values.
        * References to parameter entities occurring in the internal subset are
        included. The result is a **QDomDocumentType**  node which contains
        entity and notation declarations with the references replaced by their
        corresponding entity values.
          * Any general parsed entity reference
        which is not defined in the internal subset and which occurs in the
        content is represented as a **QDomEntityReference**  node.
          * Any
        parsed entity reference which is not defined in the internal subset and
        which occurs outside of the content is replaced with an empty string.
        * Any unparsed entity reference is replaced with an empty string.

        **See also** **QDomNode::namespaceURI** (), **QDomNode::localName** (),
        **QDomNode::prefix** (), **QString::isNull** (), and
        **QString::isEmpty** ().
        """
        ...

    def nodeType(self) -> QDomNode.NodeType:
        """
        https://doc.qt.io/qt-5/qdomdocument.html#nodeType

        **QDomNode::NodeType QDomDocument::nodeType() const**

        Returns `DocumentNode`.
        """
        ...

    def documentElement(self) -> "QDomElement":
        """
        https://doc.qt.io/qt-5/qdomdocument.html#documentElement

        **QDomElement QDomDocument::documentElement() const**

        Returns the root element of the document.
        """
        ...

    def implementation(self) -> QDomImplementation:
        """
        https://doc.qt.io/qt-5/qdomdocument.html#implementation

        **QDomImplementation QDomDocument::implementation() const**

        Returns a **QDomImplementation**  object.
        """
        ...

    def doctype(self) -> QDomDocumentType:
        """
        https://doc.qt.io/qt-5/qdomdocument.html#doctype

        **QDomDocumentType QDomDocument::doctype() const**

        Returns the document type of this document.
        """
        ...

    def elementById(self, elementId: str) -> "QDomElement":
        """
        https://doc.qt.io/qt-5/qdomdocument.html#elementById

        **QDomElement QDomDocument::elementById(const QString & elementId )**

        Returns the element whose ID is equal to **elementId**. If no element
        with the ID was found, this function returns a **null element** .

        Since the QDomClasses do not know which attributes are element IDs, this
        function returns always a **null element** . This may change in a future
        version.
        """
        ...

    def elementsByTagNameNS(self, nsURI: str, localName: str) -> QDomNodeList:
        """
        https://doc.qt.io/qt-5/qdomdocument.html#elementsByTagNameNS

        **QDomNodeList QDomDocument::elementsByTagNameNS(const QString & nsURI ,
        const QString & localName )**

        Returns a **QDomNodeList**  that contains all the elements in the
        document with the local name **localName** and a namespace URI of
        **nsURI**. The order of the node list is the order they are encountered
        in a preorder traversal of the element tree.

        **See also** **elementsByTagName** () and
        **QDomElement::elementsByTagNameNS** ().
        """
        ...

    def createAttributeNS(self, nsURI: str, qName: str) -> "QDomAttr":
        """
        https://doc.qt.io/qt-5/qdomdocument.html#createAttributeNS

        **QDomAttr QDomDocument::createAttributeNS(const QString & nsURI , const
        QString & qName )**

        Creates a new attribute with namespace support that can be inserted into
        an element. The name of the attribute is **qName** and the namespace URI
        is **nsURI**. This function also sets **QDomNode::prefix** () and
        **QDomNode::localName** () to appropriate values (depending on **qName**
        ).

        If **qName** is not a valid XML name, the behavior of this function is
        governed by **QDomImplementation::InvalidDataPolicy** .

        **See also** **createAttribute** ().
        """
        ...

    def createElementNS(self, nsURI: str, qName: str) -> "QDomElement":
        """
        https://doc.qt.io/qt-5/qdomdocument.html#createElementNS

        **QDomElement QDomDocument::createElementNS(const QString & nsURI ,
        const QString & qName )**

        Creates a new element with namespace support that can be inserted into
        the DOM tree. The name of the element is **qName** and the namespace URI
        is **nsURI**. This function also sets **QDomNode::prefix** () and
        **QDomNode::localName** () to appropriate values (depending on **qName**
        ).

        If **qName** is an empty string, returns a null element regardless of
        whether the invalid data policy is set.

        **See also** **createElement** ().
        """
        ...

    def importNode(self, importedNode: QDomNode, deep: bool) -> QDomNode:
        """
        https://doc.qt.io/qt-5/qdomdocument.html#importNode

        **QDomNode QDomDocument::importNode(const QDomNode & importedNode , bool
        deep )**

        Imports the node **importedNode** from another document to this
        document. **importedNode** remains in the original document; this
        function creates a copy that can be used within this document.

        This function returns the imported node that belongs to this document.
        The returned node has no parent. It is not possible to import
        **QDomDocument**  and **QDomDocumentType**  nodes. In those cases this
        function returns a **null node** .

        If **importedNode** is a **null node** , a null node is returned.

        If **deep** is true, this function imports not only the node
        **importedNode** but its whole subtree; if it is false, only the
        **importedNode** is imported. The argument **deep** has no effect on
        **QDomAttr**  and **QDomEntityReference**  nodes, since the descendants
        of **QDomAttr**  nodes are always imported and those of
        **QDomEntityReference**  nodes are never imported.

        The behavior of this function is slightly different depending on the
        node types:

        Node TypeBehavior
        **QDomAttr** The owner element is set to 0 and the
        specified flag is set to true in the generated attribute. The whole
        subtree of **importedNode** is always imported for attribute nodes:
        **deep** has no effect.
        **QDomDocument** Document nodes cannot be
        imported.
        **QDomDocumentFragment** If **deep** is true, this function
        imports the whole document fragment; otherwise it only generates an
        empty document fragment.
        **QDomDocumentType** Document type nodes
        cannot be imported.
        **QDomElement** Attributes for which
        **QDomAttr::specified** () is true are also imported, other attributes
        are not imported. If **deep** is true, this function also imports the
        subtree of **importedNode** ; otherwise it imports only the element node
        (and some attributes, see above).
        **QDomEntity** Entity nodes can be
        imported, but at the moment there is no way to use them since the
        document type is read-only in DOM level 2.
        **QDomEntityReference**
        Descendants of entity reference nodes are never imported: **deep** has
        no effect.
        **QDomNotation** Notation nodes can be imported, but at the
        moment there is no way to use them since the document type is read-only
        in DOM level 2.
        **QDomProcessingInstruction** The target and value of
        the processing instruction is copied to the new node.
        **QDomText** The
        text is copied to the new node.
        **QDomCDATASection** The text is
        copied to the new node.
        **QDomComment** The text is copied to the new
        node.

        **See also** **QDomElement::setAttribute** (),
        **QDomNode::insertBefore** (), **QDomNode::insertAfter** (),
        **QDomNode::replaceChild** (), **QDomNode::removeChild** (), and
        **QDomNode::appendChild** ().
        """
        ...

    def elementsByTagName(self, tagname: str) -> QDomNodeList:
        """
        https://doc.qt.io/qt-5/qdomdocument.html#elementsByTagName

        **QDomNodeList QDomDocument::elementsByTagName(const QString & tagname )
        const**

        Returns a **QDomNodeList** , that contains all the elements in the
        document with the name **tagname**. The order of the node list is the
        order they are encountered in a preorder traversal of the element tree.

        **See also** **elementsByTagNameNS** () and
        **QDomElement::elementsByTagName** ().
        """
        ...

    def createEntityReference(self, name: str) -> "QDomEntityReference":
        """
        https://doc.qt.io/qt-5/qdomdocument.html#createEntityReference

        **QDomEntityReference QDomDocument::createEntityReference(const QString
        & name )**

        Creates a new entity reference called **name** that can be inserted into
        the document, e.g. using **QDomNode::appendChild** ().

        If **name** is not a valid XML name, the behavior of this function is
        governed by **QDomImplementation::InvalidDataPolicy** .

        **See also** **QDomNode::appendChild** (), **QDomNode::insertBefore**
        (), and **QDomNode::insertAfter** ().
        """
        ...

    def createAttribute(self, name: str) -> "QDomAttr":
        """
        https://doc.qt.io/qt-5/qdomdocument.html#createAttribute

        **QDomAttr QDomDocument::createAttribute(const QString & name )**

        Creates a new attribute called **name** that can be inserted into an
        element, e.g. using **QDomElement::setAttributeNode** ().

        If **name** is not a valid XML name, the behavior of this function is
        governed by **QDomImplementation::InvalidDataPolicy** .

        **See also** **createAttributeNS** ().
        """
        ...

    def createProcessingInstruction(
        self, target: str, data: str
    ) -> "QDomProcessingInstruction":
        """
        https://doc.qt.io/qt-5/qdomdocument.html#createProcessingInstruction

        **QDomProcessingInstruction
        QDomDocument::createProcessingInstruction(const QString & target , const
        QString & data )**

        Creates a new processing instruction that can be inserted into the
        document, e.g. using **QDomNode::appendChild** (). This function sets
        the target for the processing instruction to **target** and the data to
        **data**.

        If **target** is not a valid XML name, or data if contains characters
        which cannot appear in a processing instruction, the behavior of this
        function is governed by **QDomImplementation::InvalidDataPolicy** .

        **See also** **QDomNode::appendChild** (), **QDomNode::insertBefore**
        (), and **QDomNode::insertAfter** ().
        """
        ...

    def createCDATASection(self, data: str) -> "QDomCDATASection":
        """
        https://doc.qt.io/qt-5/qdomdocument.html#createCDATASection

        **QDomCDATASection QDomDocument::createCDATASection(const QString &
        value )**

        Creates a new CDATA section for the string **value** that can be
        inserted into the document, e.g. using **QDomNode::appendChild** ().

        If **value** contains characters which cannot be stored in a CDATA
        section, the behavior of this function is governed by
        **QDomImplementation::InvalidDataPolicy** .

        **See also** **QDomNode::appendChild** (), **QDomNode::insertBefore**
        (), and **QDomNode::insertAfter** ().
        """
        ...

    def createComment(self, data: str) -> "QDomComment":
        """
        https://doc.qt.io/qt-5/qdomdocument.html#createComment

        **QDomComment QDomDocument::createComment(const QString & value )**

        Creates a new comment for the string **value** that can be inserted into
        the document, e.g. using **QDomNode::appendChild** ().

        If **value** contains characters which cannot be stored in an XML
        comment, the behavior of this function is governed by
        **QDomImplementation::InvalidDataPolicy** .

        **See also** **QDomNode::appendChild** (), **QDomNode::insertBefore**
        (), and **QDomNode::insertAfter** ().
        """
        ...

    def createTextNode(self, data: str) -> "QDomText":
        """
        https://doc.qt.io/qt-5/qdomdocument.html#createTextNode

        **QDomText QDomDocument::createTextNode(const QString & value )**

        Creates a text node for the string **value** that can be inserted into
        the document tree, e.g. using **QDomNode::appendChild** ().

        If **value** contains characters which cannot be stored as character
        data of an XML document (even in the form of character references), the
        behavior of this function is governed by
        **QDomImplementation::InvalidDataPolicy** .

        **See also** **QDomNode::appendChild** (), **QDomNode::insertBefore**
        (), and **QDomNode::insertAfter** ().
        """
        ...

    def createDocumentFragment(self) -> "QDomDocumentFragment":
        """
        https://doc.qt.io/qt-5/qdomdocument.html#createDocumentFragment

        **QDomDocumentFragment QDomDocument::createDocumentFragment()**

        Creates a new document fragment, that can be used to hold parts of the
        document, e.g. when doing complex manipulations of the document tree.
        """
        ...

    def createElement(self, tagName: str) -> "QDomElement":
        """
        https://doc.qt.io/qt-5/qdomdocument.html#createElement

        **QDomElement QDomDocument::createElement(const QString & tagName )**

        Creates a new element called **tagName** that can be inserted into the
        DOM tree, e.g. using **QDomNode::appendChild** ().

        If **tagName** is not a valid XML name, the behavior of this function is
        governed by **QDomImplementation::InvalidDataPolicy** .

        **See also** **createElementNS** (), **QDomNode::appendChild** (),
        **QDomNode::insertBefore** (), and **QDomNode::insertAfter** ().
        """
        ...
