"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtXml import *


class QDomAttr(QDomNode):
    """
    https://doc.qt.io/qt-5/qdomattr.html

    **Detailed Description**

    For example, the following piece of XML produces an element with no
    children, but two attributes:

    <link href="http://qt-project.org" color="red" />

    You can access the attributes of an element with code like this:

    **QDomElement**  e = //...
        //...
        **QDomAttr**  a =
    e.attributeNode("href");
        cout << a.value() << Qt::endl;
    // prints "http://qt-project.org"
        a.setValue("http://qt-
    project.org/doc"); // change the node's attribute
        **QDomAttr**  a2 =
    e.attributeNode("href");
        cout << a2.value() << Qt::endl;
    // prints "http://qt-project.org/doc"

    This example also shows that changing an attribute received from an element
    changes the attribute of the element. If you do not want to change the value
    of the element's attribute you must use **cloneNode** () to get an
    independent copy of the attribute.

    QDomAttr can return the **name** () and **value** () of an attribute. An
    attribute's value is set with **setValue** (). If **specified** () returns
    true the value was set with **setValue** (). The node this attribute is
    attached to (if any) is returned by **ownerElement** ().

    For further information about the Document Object Model see
    <http://www.w3.org/TR/REC-DOM-Level-1/> and <http://www.w3.org/TR/DOM-
    Level-2-Core/>. For a more general introduction of the DOM implementation
    see the **QDomDocument**  documentation.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qdomattr.html#QDomAttr

        **QDomAttr::QDomAttr()**

        Constructs an empty attribute.
        """
        ...

    @typing.overload
    def __init__(self, x: "QDomAttr") -> None:
        """
        https://doc.qt.io/qt-5/qdomattr.html#QDomAttr-1

        **QDomAttr::QDomAttr(const QDomAttr & x )**

        Constructs a copy of **x**.

        The data of the copy is shared (shallow copy): modifying one node will
        also change the other. If you want to make a deep copy, use
        **cloneNode** ().
        """
        ...

    def nodeType(self) -> QDomNode.NodeType:
        """
        https://doc.qt.io/qt-5/qdomattr.html#nodeType

        **QDomNode::NodeType QDomAttr::nodeType() const**

        Returns **AttributeNode** .
        """
        ...

    def setValue(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qdomattr.html#setValue

        **void QDomAttr::setValue(const QString & v )**

        Sets the attribute's value to **v**.

        **See also** **value** ().
        """
        ...

    def value(self) -> str:
        """
        https://doc.qt.io/qt-5/qdomattr.html#value

        **QString QDomAttr::value() const**

        Returns the value of the attribute or an empty string if the attribute
        has not been specified.

        **See also** **specified** () and **setValue** ().
        """
        ...

    def ownerElement(self) -> "QDomElement":
        """
        https://doc.qt.io/qt-5/qdomattr.html#ownerElement

        **QDomElement QDomAttr::ownerElement() const**

        Returns the element node this attribute is attached to or a **null
        node**  if this attribute is not attached to any element.
        """
        ...

    def specified(self) -> bool:
        """
        https://doc.qt.io/qt-5/qdomattr.html#specified

        **bool QDomAttr::specified() const**

        Returns `true` if the attribute has been set by the user with
        **setValue** (). Returns `false` if the value hasn't been specified or
        set.

        **See also** **setValue** ().
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-5/qdomattr.html#name

        **QString QDomAttr::name() const**

        Returns the attribute's name.
        """
        ...
