"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtWinExtras import *


class QWinTaskbarButton(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qwintaskbarbutton.html

    **Detailed Description**

    The QWinTaskbarButton class enables you to set overlay icons on a taskbar
    button, and provides access to its progress indicator.

    An overlay icon indicates change in the state of an application, whereas a
    progress indicator shows how time-consuming tasks are progressing.

    ![Taskbar Button](images/taskbar-button.png)

    The following example code illustrates how to use the QWinTaskbarButton and
    **QWinTaskbarProgress**  classes to adjust the look of the taskbar button:

    **QWinTaskbarButton**  *button = new **QWinTaskbarButton** (widget);
    button->setWindow(widget->windowHandle());
    button->setOverlayIcon(**QIcon** (":/loading.png"));
    **QWinTaskbarProgress**  *progress = button->progress();
    progress->setVisible(true);
            progress->setValue(50);

    **Note:****QWidget::windowHandle** () returns a valid instance of a
    **QWindow**  only after the widget has been shown. It is therefore
    recommended to delay the initialization of the QWinTaskbarButton instances
    until **QWidget::showEvent** ().

    **Note:** The class wraps API only available since Windows 7. Instantiating
    it on Windows XP or Windows Vista causes a runtime warning.

    **See also** **QWinTaskbarProgress** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qwintaskbarbutton.html#QWinTaskbarButton

        **QWinTaskbarButton::QWinTaskbarButton(QObject * parent = nullptr)**

        Constructs a QWinTaskbarButton with the specified **parent**.

        If **parent** is an instance of **QWindow** , it is automatically
        assigned as the taskbar button's **window** .
        """
        ...

    def clearOverlayIcon(self) -> None:
        ...

    def setOverlayAccessibleDescription(self, description: str) -> None:
        """
        https://doc.qt.io/qt-5/qwintaskbarbutton.html#overlayAccessibleDescripti
        on-prop

        **overlayAccessibleDescription : QString**

        This property holds the description of the overlay for accessibility
        purposes

        **Access functions:**

        QString **overlayAccessibleDescription** () const
        void
        **setOverlayAccessibleDescription** (const QString & **description** )

        **See also** **overlayIcon** .
        """
        ...

    def setOverlayIcon(self, icon: QtGui.QIcon) -> None:
        """
        https://doc.qt.io/qt-5/qwintaskbarbutton.html#overlayIcon-prop

        **overlayIcon : QIcon**

        This property holds the overlay icon of the taskbar button

        **Access functions:**

        QIcon **overlayIcon** () const
        void **setOverlayIcon** (const QIcon &
        **icon** )
        void **clearOverlayIcon** ()
        """
        ...

    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool:
        ...

    def progress(self) -> "QWinTaskbarProgress":
        """
        https://doc.qt.io/qt-5/qwintaskbarbutton.html#progress-prop

        **progress : QWinTaskbarProgress* const**

        This property holds the progress indicator of the taskbar button

        **Note:** The progress indicator is not **visible**  by default.

        **Access functions:**

        QWinTaskbarProgress * **progress** () const
        """
        ...

    def overlayAccessibleDescription(self) -> str:
        """
        https://doc.qt.io/qt-5/qwintaskbarbutton.html#overlayAccessibleDescripti
        on-prop

        **overlayAccessibleDescription : QString**

        This property holds the description of the overlay for accessibility
        purposes

        **Access functions:**

        QString **overlayAccessibleDescription** () const
        void
        **setOverlayAccessibleDescription** (const QString & **description** )

        **See also** **overlayIcon** .
        """
        ...

    def overlayIcon(self) -> QtGui.QIcon:
        """
        https://doc.qt.io/qt-5/qwintaskbarbutton.html#overlayIcon-prop

        **overlayIcon : QIcon**

        This property holds the overlay icon of the taskbar button

        **Access functions:**

        QIcon **overlayIcon** () const
        void **setOverlayIcon** (const QIcon &
        **icon** )
        void **clearOverlayIcon** ()
        """
        ...

    def window(self) -> QtGui.QWindow:
        """
        https://doc.qt.io/qt-5/qwintaskbarbutton.html#window-prop

        **window : QWindow***

        This property holds the window whose taskbar button is manipulated

        **Access functions:**

        QWindow * **window** () const
        void **setWindow** (QWindow * **window**
        )

        **Member Function Documentation**
        """
        ...

    def setWindow(self, window: QtGui.QWindow) -> None:
        """
        https://doc.qt.io/qt-5/qwintaskbarbutton.html#window-prop

        **window : QWindow***

        This property holds the window whose taskbar button is manipulated

        **Access functions:**

        QWindow * **window** () const
        void **setWindow** (QWindow * **window**
        )

        **Member Function Documentation**
        """
        ...
