"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QUndoGroup(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qundogroup.html

    **Detailed Description**

    For an overview of the Qt's undo framework, see the **overview** .

    An application often has multiple undo stacks, one for each opened document.
    At the same time, an application usually has one undo action and one redo
    action, which triggers undo or redo in the active document.

    QUndoGroup is a group of **QUndoStack**  objects, one of which may be
    active. It has an **undo** () and **redo** () slot, which calls
    **QUndoStack::undo** () and **QUndoStack::redo** () for the active stack. It
    also has the functions **createUndoAction** () and **createRedoAction** ().
    The actions returned by these functions behave in the same way as those
    returned by **QUndoStack::createUndoAction** () and
    **QUndoStack::createRedoAction** () of the active stack.

    Stacks are added to a group with **addStack** () and removed with
    **removeStack** (). A stack is implicitly added to a group when it is
    created with the group as its parent **QObject** .

    It is the programmer's responsibility to specify which stack is active by
    calling **QUndoStack::setActive** (), usually when the associated document
    window receives focus. The active stack may also be set with
    **setActiveStack** (), and is returned by **activeStack** ().

    When a stack is added to a group using **addStack** (), the group does not
    take ownership of the stack. This means the stack has to be deleted
    separately from the group. When a stack is deleted, it is automatically
    removed from a group. A stack may belong to only one group. Adding it to
    another group will cause it to be removed from the previous group.

    A QUndoGroup is also useful in conjunction with **QUndoView** . If a
    **QUndoView**  is set to watch a group using **QUndoView::setGroup** (), it
    will update itself to display the active stack.
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qundogroup.html#QUndoGroup

        **QUndoGroup::QUndoGroup(QObject * parent = nullptr)**

        Creates an empty QUndoGroup object with parent **parent**.

        **See also** **addStack** ().
        """
        ...

    def undo(self) -> None:
        """
        https://doc.qt.io/qt-5/qundogroup.html#undo

        **[slot] void QUndoGroup::undo()**

        Calls **QUndoStack::undo** () on the active stack.

        If none of the stacks are active, or if the group is empty, this
        function does nothing.

        **See also** **redo** (), **canUndo** (), and **setActiveStack** ().
        """
        ...

    def setActiveStack(self, stack: "QUndoStack") -> None:
        """
        https://doc.qt.io/qt-5/qundogroup.html#setActiveStack

        **[slot] void QUndoGroup::setActiveStack(QUndoStack * stack )**

        Sets the active stack of this group to **stack**.

        If the stack is not a member of this group, this function does nothing.

        Synonymous with calling **QUndoStack::setActive** () on **stack**.

        The actions returned by **createUndoAction** () and **createRedoAction**
        () will now behave in the same way as those returned by **stack** 's
        **QUndoStack::createUndoAction** () and **QUndoStack::createRedoAction**
        ().

        **See also** **QUndoStack::setActive** () and **activeStack** ().
        """
        ...

    def redo(self) -> None:
        """
        https://doc.qt.io/qt-5/qundogroup.html#redo

        **[slot] void QUndoGroup::redo()**

        Calls **QUndoStack::redo** () on the active stack.

        If none of the stacks are active, or if the group is empty, this
        function does nothing.

        **See also** **undo** (), **canRedo** (), and **setActiveStack** ().
        """
        ...

    def isClean(self) -> bool:
        """
        https://doc.qt.io/qt-5/qundogroup.html#isClean

        **bool QUndoGroup::isClean() const**

        Returns the value of the active stack's **QUndoStack::isClean** ().

        If none of the stacks are active, or if the group is empty, this
        function returns `true`.

        **See also** **setActiveStack** ().
        """
        ...

    def redoText(self) -> str:
        """
        https://doc.qt.io/qt-5/qundogroup.html#redoText

        **QString QUndoGroup::redoText() const**

        Returns the value of the active stack's **QUndoStack::redoText** ().

        If none of the stacks are active, or if the group is empty, this
        function returns an empty string.

        **See also** **undoText** () and **setActiveStack** ().
        """
        ...

    def undoText(self) -> str:
        """
        https://doc.qt.io/qt-5/qundogroup.html#undoText

        **QString QUndoGroup::undoText() const**

        Returns the value of the active stack's **QUndoStack::undoText** ().

        If none of the stacks are active, or if the group is empty, this
        function returns an empty string.

        **See also** **redoText** () and **setActiveStack** ().
        """
        ...

    def canRedo(self) -> bool:
        """
        https://doc.qt.io/qt-5/qundogroup.html#canRedo

        **bool QUndoGroup::canRedo() const**

        Returns the value of the active stack's **QUndoStack::canRedo** ().

        If none of the stacks are active, or if the group is empty, this
        function returns `false`.

        **See also** **canUndo** () and **setActiveStack** ().
        """
        ...

    def canUndo(self) -> bool:
        """
        https://doc.qt.io/qt-5/qundogroup.html#canUndo

        **bool QUndoGroup::canUndo() const**

        Returns the value of the active stack's **QUndoStack::canUndo** ().

        If none of the stacks are active, or if the group is empty, this
        function returns `false`.

        **See also** **canRedo** () and **setActiveStack** ().
        """
        ...

    def createUndoAction(self, parent: QtCore.QObject, prefix: str = ...) -> QAction:
        """
        https://doc.qt.io/qt-5/qundogroup.html#createUndoAction

        **QAction *QUndoGroup::createUndoAction(QObject * parent , const QString
        & prefix = QString()) const**

        Creates an undo **QAction**  object with parent **parent**.

        Triggering this action will cause a call to **QUndoStack::undo** () on
        the active stack. The text of this action will always be the text of the
        command which will be undone in the next call to **undo** (), prefixed
        by **prefix**. If there is no command available for undo, if the group
        is empty or if none of the stacks are active, this action will be
        disabled.

        If **prefix** is empty, the default template "Undo %1" is used instead
        of prefix. Before Qt 4.8, the prefix "Undo" was used by default.

        **See also** **createRedoAction** (), **canUndo** (), and
        **QUndoCommand::text** ().
        """
        ...

    def createRedoAction(self, parent: QtCore.QObject, prefix: str = ...) -> QAction:
        """
        https://doc.qt.io/qt-5/qundogroup.html#createRedoAction

        **QAction *QUndoGroup::createRedoAction(QObject * parent , const QString
        & prefix = QString()) const**

        Creates an redo **QAction**  object with parent **parent**.

        Triggering this action will cause a call to **QUndoStack::redo** () on
        the active stack. The text of this action will always be the text of the
        command which will be redone in the next call to **redo** (), prefixed
        by **prefix**. If there is no command available for redo, if the group
        is empty or if none of the stacks are active, this action will be
        disabled.

        If **prefix** is empty, the default template "Redo %1" is used instead
        of prefix. Before Qt 4.8, the prefix "Redo" was used by default.

        **See also** **createUndoAction** (), **canRedo** (), and
        **QUndoCommand::text** ().
        """
        ...

    def activeStack(self) -> "QUndoStack":
        """
        https://doc.qt.io/qt-5/qundogroup.html#activeStack

        **QUndoStack *QUndoGroup::activeStack() const**

        Returns the active stack of this group.

        If none of the stacks are active, or if the group is empty, this
        function returns `nullptr`.

        **See also** **setActiveStack** () and **QUndoStack::setActive** ().
        """
        ...

    def stacks(self) -> typing.List["QUndoStack"]:
        """
        https://doc.qt.io/qt-5/qundogroup.html#stacks

        **QList<QUndoStack *> QUndoGroup::stacks() const**

        Returns a list of stacks in this group.

        **See also** **addStack** () and **removeStack** ().
        """
        ...

    def removeStack(self, stack: "QUndoStack") -> None:
        """
        https://doc.qt.io/qt-5/qundogroup.html#removeStack

        **void QUndoGroup::removeStack(QUndoStack * stack )**

        Removes **stack** from this group. If the stack was the active stack in
        the group, the active stack becomes 0.

        **See also** **addStack** (), **stacks** (), and
        **QUndoStack::~QUndoStack** ().
        """
        ...

    def addStack(self, stack: "QUndoStack") -> None:
        """
        https://doc.qt.io/qt-5/qundogroup.html#addStack

        **void QUndoGroup::addStack(QUndoStack * stack )**

        Adds **stack** to this group. The group does not take ownership of the
        stack. Another way of adding a stack to a group is by specifying the
        group as the stack's parent **QObject**  in **QUndoStack::QUndoStack**
        (). In this case, the stack is deleted when the group is deleted, in the
        usual manner of QObjects.

        **See also** **removeStack** (), **stacks** (), and
        **QUndoStack::QUndoStack** ().
        """
        ...

    @property
    def activeStackChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qundogroup.html#activeStackChanged

        **[signal] void QUndoGroup::activeStackChanged(QUndoStack * stack )**

        This signal is emitted whenever the active stack of the group changes.
        This can happen when **setActiveStack** () or **QUndoStack::setActive**
        () is called, or when the active stack is removed form the group.
        **stack** is the new active stack. If no stack is active, **stack** is
        0.

        **See also** **setActiveStack** () and **QUndoStack::setActive** ().
        """
        ...

    @property
    def canRedoChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qundogroup.html#canRedoChanged

        **[signal] void QUndoGroup::canRedoChanged(bool canRedo )**

        This signal is emitted whenever the active stack emits
        **QUndoStack::canRedoChanged** () or the active stack changes.

        **canRedo** is the new state, or false if the active stack is 0.

        **See also** **QUndoStack::canRedoChanged** () and **setActiveStack**
        ().
        """
        ...

    @property
    def canUndoChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qundogroup.html#canUndoChanged

        **[signal] void QUndoGroup::canUndoChanged(bool canUndo )**

        This signal is emitted whenever the active stack emits
        **QUndoStack::canUndoChanged** () or the active stack changes.

        **canUndo** is the new state, or false if the active stack is 0.

        **See also** **QUndoStack::canUndoChanged** () and **setActiveStack**
        ().
        """
        ...

    @property
    def cleanChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qundogroup.html#cleanChanged

        **[signal] void QUndoGroup::cleanChanged(bool clean )**

        This signal is emitted whenever the active stack emits
        **QUndoStack::cleanChanged** () or the active stack changes.

        **clean** is the new state, or true if the active stack is 0.

        **See also** **QUndoStack::cleanChanged** () and **setActiveStack** ().
        """
        ...

    @property
    def indexChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qundogroup.html#indexChanged

        **[signal] void QUndoGroup::indexChanged(int idx )**

        This signal is emitted whenever the active stack emits
        **QUndoStack::indexChanged** () or the active stack changes.

        **idx** is the new current index, or 0 if the active stack is 0.

        **See also** **QUndoStack::indexChanged** () and **setActiveStack** ().
        """
        ...

    @property
    def redoTextChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qundogroup.html#redoTextChanged

        **[signal] void QUndoGroup::redoTextChanged(const QString & redoText )**

        This signal is emitted whenever the active stack emits
        **QUndoStack::redoTextChanged** () or the active stack changes.

        **redoText** is the new state, or an empty string if the active stack is
        0.

        **See also** **QUndoStack::redoTextChanged** () and **setActiveStack**
        ().
        """
        ...

    @property
    def undoTextChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qundogroup.html#undoTextChanged

        **[signal] void QUndoGroup::undoTextChanged(const QString & undoText )**

        This signal is emitted whenever the active stack emits
        **QUndoStack::undoTextChanged** () or the active stack changes.

        **undoText** is the new state, or an empty string if the active stack is
        0.

        **See also** **QUndoStack::undoTextChanged** () and **setActiveStack**
        ().
        """
        ...
