"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QTableWidget(QTableView):
    """
    https://doc.qt.io/qt-5/qtablewidget.html

    **Detailed Description**

    ![](images/windows-tableview.png)

    Table widgets provide standard table display facilities for applications.
    The items in a QTableWidget are provided by **QTableWidgetItem** .

    If you want a table that uses your own data model you should use
    **QTableView**  rather than this class.

    Table widgets can be constructed with the required numbers of rows and
    columns:

    tableWidget = new **QTableWidget** (12, 3, this);

    Alternatively, tables can be constructed without a given size and resized
    later:

    tableWidget = new **QTableWidget** (this);
    tableWidget->setRowCount(10);
            tableWidget->setColumnCount(5);

    Items are created outside the table (with no parent widget) and inserted
    into the table with **setItem** ():

    **QTableWidgetItem**  *newItem = new **QTableWidgetItem** (tr("%1").arg(
    (row+1)*(column+1)));
            tableWidget->setItem(row, column, newItem);

    If you want to enable sorting in your table widget, do so after you have
    populated it with items, otherwise sorting may interfere with the insertion
    order (see **setItem** () for details).

    Tables can be given both horizontal and vertical headers. The simplest way
    to create the headers is to supply a list of strings to the
    **setHorizontalHeaderLabels** () and **setVerticalHeaderLabels** ()
    functions. These will provide simple textual headers for the table's columns
    and rows. More sophisticated headers can be created from existing table
    items that are usually constructed outside the table. For example, we can
    construct a table item with an icon and aligned text, and use it as the
    header for a particular column:

    **QTableWidgetItem**  *cubesHeaderItem = new **QTableWidgetItem**
    (tr("Cubes"));
            cubesHeaderItem->setIcon(**QIcon** (**QPixmap**
    (":/Images/cubed.png")));
    cubesHeaderItem->setTextAlignment(Qt::AlignVCenter);

    The number of rows in the table can be found with **rowCount** (), and the
    number of columns with **columnCount** (). The table can be cleared with the
    **clear** () function.

    **See also** **QTableWidgetItem** , **QTableView** , and **Model/View
    Programming** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#QTableWidget

        **QTableWidget::QTableWidget(QWidget * parent = nullptr)**

        Creates a new table view with the given **parent**.
        """
        ...

    @typing.overload
    def __init__(
        self, rows: int, columns: int, parent: typing.Optional[QWidget] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#QTableWidget-1

        **QTableWidget::QTableWidget(int rows , int columns , QWidget * parent =
        nullptr)**

        Creates a new table view with the given **rows** and **columns** , and
        with the given **parent**.
        """
        ...

    def isPersistentEditorOpen(self, item: QTableWidgetItem) -> bool:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#isPersistentEditorOpen

        **bool QTableWidget::isPersistentEditorOpen(QTableWidgetItem * item )
        const**

        Returns whether a persistent editor is open for item **item**.

        This function was introduced in Qt 5.10.

        **See also** **openPersistentEditor** () and **closePersistentEditor**
        ().
        """
        ...

    def dropEvent(self, event: QtGui.QDropEvent) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#dropEvent

        **[override virtual protected] void QTableWidget::dropEvent(QDropEvent *
        event )**

        Reimplements: **QAbstractItemView::dropEvent** (QDropEvent *event).
        """
        ...

    def event(self, e: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#event

        **[override virtual protected] bool QTableWidget::event(QEvent * e )**

        Reimplements: **QAbstractItemView::event** (QEvent *event).
        """
        ...

    def itemFromIndex(self, index: QtCore.QModelIndex) -> QTableWidgetItem:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#itemFromIndex

        **[protected] QTableWidgetItem *QTableWidget::itemFromIndex(const
        QModelIndex & index ) const**

        Returns a pointer to the **QTableWidgetItem**  associated with the given
        **index**.
        """
        ...

    def indexFromItem(self, item: QTableWidgetItem) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#indexFromItem

        **[protected] QModelIndex QTableWidget::indexFromItem(const
        QTableWidgetItem * item ) const**

        Returns the **QModelIndex**  associated with the given **item**.

        **Note:** In Qt versions prior to 5.10, this function took a non-`const`
        **item**.
        """
        ...

    def items(self, data: QtCore.QMimeData) -> typing.List[QTableWidgetItem]:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#items

        **[protected] QList<QTableWidgetItem *> QTableWidget::items(const
        QMimeData * data ) const**

        Returns a list of pointers to the items contained in the **data**
        object. If the object was not created by a **QTreeWidget**  in the same
        process, the list is empty.
        """
        ...

    def supportedDropActions(self) -> QtCore.Qt.DropActions:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#supportedDropActions

        **[virtual protected] Qt::DropActions
        QTableWidget::supportedDropActions() const**

        Returns the drop actions supported by this view.

        **See also** **Qt::DropActions** .
        """
        ...

    def dropMimeData(
        self,
        row: int,
        column: int,
        data: QtCore.QMimeData,
        action: QtCore.Qt.DropAction,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#dropMimeData

        **[virtual protected] bool QTableWidget::dropMimeData(int row , int
        column , const QMimeData * data , Qt::DropAction action )**

        Handles the **data** supplied by a drag and drop operation that ended
        with the given **action** in the given **row** and **column**. Returns
        `true` if the data and action can be handled by the model; otherwise
        returns `false`.

        **See also** **supportedDropActions** ().
        """
        ...

    def mimeData(self, items: typing.Iterable[QTableWidgetItem]) -> QtCore.QMimeData:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#mimeData

        **[virtual protected] QMimeData *QTableWidget::mimeData(const
        QList<QTableWidgetItem *> items ) const**

        Returns an object that contains a serialized description of the
        specified **items**. The format used to describe the items is obtained
        from the **mimeTypes** () function.

        If the list of items is empty, `nullptr` is returned rather than a
        serialized empty list.
        """
        ...

    def mimeTypes(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#mimeTypes

        **[virtual protected] QStringList QTableWidget::mimeTypes() const**

        Returns a list of MIME types that can be used to describe a list of
        tablewidget items.

        **See also** **mimeData** ().
        """
        ...

    def clearContents(self) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#clearContents

        **[slot] void QTableWidget::clearContents()**

        Removes all items not in the headers from the view. This will also
        remove all selections. The table dimensions stay the same.

        This function was introduced in Qt 4.2.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#clear

        **[slot] void QTableWidget::clear()**

        Removes all items in the view. This will also remove all selections and
        headers. If you don't want to remove the headers, use
        **QTableWidget::clearContents** (). The table dimensions stay the same.
        """
        ...

    def removeColumn(self, column: int) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#removeColumn

        **[slot] void QTableWidget::removeColumn(int column )**

        Removes the column **column** and all its items from the table.
        """
        ...

    def removeRow(self, row: int) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#removeRow

        **[slot] void QTableWidget::removeRow(int row )**

        Removes the row **row** and all its items from the table.
        """
        ...

    def insertColumn(self, column: int) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#insertColumn

        **[slot] void QTableWidget::insertColumn(int column )**

        Inserts an empty column into the table at **column**.
        """
        ...

    def insertRow(self, row: int) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#insertRow

        **[slot] void QTableWidget::insertRow(int row )**

        Inserts an empty row into the table at **row**.
        """
        ...

    def scrollToItem(
        self, item: QTableWidgetItem, hint: QAbstractItemView.ScrollHint = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#scrollToItem

        **[slot] void QTableWidget::scrollToItem(const QTableWidgetItem * item ,
        QAbstractItemView::ScrollHint hint = EnsureVisible)**

        Scrolls the view if necessary to ensure that the **item** is visible.
        The **hint** parameter specifies more precisely where the **item**
        should be located after the operation.
        """
        ...

    def setItemPrototype(self, item: QTableWidgetItem) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#setItemPrototype

        **void QTableWidget::setItemPrototype(const QTableWidgetItem * item )**

        Sets the item prototype for the table to the specified **item**.

        The table widget will use the item prototype clone function when it
        needs to create a new table item. For example when the user is editing
        in an empty cell. This is useful when you have a **QTableWidgetItem**
        subclass and want to make sure that **QTableWidget**  creates instances
        of your subclass.

        The table takes ownership of the prototype.

        **See also** **itemPrototype** ().
        """
        ...

    def itemPrototype(self) -> QTableWidgetItem:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#itemPrototype

        **const QTableWidgetItem *QTableWidget::itemPrototype() const**

        Returns the item prototype used by the table.

        **See also** **setItemPrototype** ().
        """
        ...

    def visualItemRect(self, item: QTableWidgetItem) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#visualItemRect

        **QRect QTableWidget::visualItemRect(const QTableWidgetItem * item )
        const**

        Returns the rectangle on the viewport occupied by the item at **item**.
        """
        ...

    @typing.overload
    def itemAt(self, p: QtCore.QPoint) -> QTableWidgetItem:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#itemAt

        **QTableWidgetItem *QTableWidget::itemAt(const QPoint & point ) const**

        Returns a pointer to the item at the given **point** , or returns
        `nullptr` if **point** is not covered by an item in the table widget.

        **See also** **item** ().
        """
        ...

    @typing.overload
    def itemAt(self, ax: int, ay: int) -> QTableWidgetItem:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#itemAt-1

        **QTableWidgetItem *QTableWidget::itemAt(int ax , int ay ) const**

        Returns the item at the position equivalent to **QPoint** ( **ax** ,
        **ay** ) in the table widget's coordinate system, or returns `nullptr`
        if the specified point is not covered by an item in the table widget.

        **See also** **item** ().
        """
        ...

    def visualColumn(self, logicalColumn: int) -> int:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#visualColumn

        **int QTableWidget::visualColumn(int logicalColumn ) const**

        Returns the visual column of the given **logicalColumn**.
        """
        ...

    def visualRow(self, logicalRow: int) -> int:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#visualRow

        **int QTableWidget::visualRow(int logicalRow ) const**

        Returns the visual row of the given **logicalRow**.
        """
        ...

    def findItems(
        self, text: str, flags: typing.Union[QtCore.Qt.MatchFlags, QtCore.Qt.MatchFlag]
    ) -> typing.List[QTableWidgetItem]:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#findItems

        **QList<QTableWidgetItem *> QTableWidget::findItems(const QString & text
        , Qt::MatchFlags flags ) const**

        Finds items that matches the **text** using the given **flags**.
        """
        ...

    def selectedItems(self) -> typing.List[QTableWidgetItem]:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#selectedItems

        **QList<QTableWidgetItem *> QTableWidget::selectedItems() const**

        Returns a list of all selected items.

        This function returns a list of pointers to the contents of the selected
        cells. Use the **selectedIndexes** () function to retrieve the complete
        selection **including** empty cells.

        **See also** **selectedIndexes** ().
        """
        ...

    def selectedRanges(self) -> typing.List[QTableWidgetSelectionRange]:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#selectedRanges

        **QList<QTableWidgetSelectionRange> QTableWidget::selectedRanges()
        const**

        Returns a list of all selected ranges.

        **See also** **QTableWidgetSelectionRange** .
        """
        ...

    def setRangeSelected(self, range: QTableWidgetSelectionRange, select: bool) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#setRangeSelected

        **void QTableWidget::setRangeSelected(const QTableWidgetSelectionRange &
        range , bool select )**

        Selects or deselects the **range** depending on **select**.
        """
        ...

    def removeCellWidget(self, arow: int, acolumn: int) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#removeCellWidget

        **void QTableWidget::removeCellWidget(int row , int column )**

        Removes the widget set on the cell indicated by **row** and **column**.

        This function was introduced in Qt 4.3.
        """
        ...

    def setCellWidget(self, row: int, column: int, widget: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#setCellWidget

        **void QTableWidget::setCellWidget(int row , int column , QWidget *
        widget )**

        Sets the given **widget** to be displayed in the cell in the given
        **row** and **column** , passing the ownership of the widget to the
        table.

        If cell widget A is replaced with cell widget B, cell widget A will be
        deleted. For example, in the code snippet below, the **QLineEdit**
        object will be deleted.

        setCellWidget(row, column, new **QLineEdit** );
            ...
        setCellWidget(row, column, new **QTextEdit** );

        This function was introduced in Qt 4.1.

        **See also** **cellWidget** ().
        """
        ...

    def cellWidget(self, row: int, column: int) -> QWidget:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#cellWidget

        **QWidget *QTableWidget::cellWidget(int row , int column ) const**

        Returns the widget displayed in the cell in the given **row** and
        **column**.

        **Note:** The table takes ownership of the widget.

        This function was introduced in Qt 4.1.

        **See also** **setCellWidget** ().
        """
        ...

    def closePersistentEditor(self, item: QTableWidgetItem) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#closePersistentEditor

        **void QTableWidget::closePersistentEditor(QTableWidgetItem * item )**

        Closes the persistent editor for **item**.

        **See also** **openPersistentEditor** () and **isPersistentEditorOpen**
        ().
        """
        ...

    def openPersistentEditor(self, item: QTableWidgetItem) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#openPersistentEditor

        **void QTableWidget::openPersistentEditor(QTableWidgetItem * item )**

        Opens an editor for the give **item**. The editor remains open after
        editing.

        **See also** **closePersistentEditor** () and **isPersistentEditorOpen**
        ().
        """
        ...

    def editItem(self, item: QTableWidgetItem) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#editItem

        **void QTableWidget::editItem(QTableWidgetItem * item )**

        Starts editing the **item** if it is editable.
        """
        ...

    def isSortingEnabled(self) -> bool:
        ...

    def setSortingEnabled(self, enable: bool) -> None:
        ...

    def sortItems(self, column: int, order: QtCore.Qt.SortOrder = ...) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#sortItems

        **void QTableWidget::sortItems(int column , Qt::SortOrder order =
        Qt::AscendingOrder)**

        Sorts all the rows in the table widget based on **column** and
        **order**.
        """
        ...

    @typing.overload
    def setCurrentCell(self, row: int, column: int) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#setCurrentCell

        **void QTableWidget::setCurrentCell(int row , int column )**

        Sets the current cell to be the cell at position ( **row** , **column**
        ).

        Depending on the current **selection mode** , the cell may also be
        selected.

        This function was introduced in Qt 4.1.

        **See also** **setCurrentItem** (), **currentRow** (), and
        **currentColumn** ().
        """
        ...

    @typing.overload
    def setCurrentCell(
        self,
        row: int,
        column: int,
        command: typing.Union[
            QtCore.QItemSelectionModel.SelectionFlags,
            QtCore.QItemSelectionModel.SelectionFlag,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#setCurrentCell-1

        **void QTableWidget::setCurrentCell(int row , int column ,
        QItemSelectionModel::SelectionFlags command )**

        Sets the current cell to be the cell at position ( **row** , **column**
        ), using the given **command**.

        This function was introduced in Qt 4.4.

        **See also** **setCurrentItem** (), **currentRow** (), and
        **currentColumn** ().
        """
        ...

    @typing.overload
    def setCurrentItem(self, item: QTableWidgetItem) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#setCurrentItem

        **void QTableWidget::setCurrentItem(QTableWidgetItem * item )**

        Sets the current item to **item**.

        Unless the selection mode is **NoSelection** , the item is also
        selected.

        **See also** **currentItem** () and **setCurrentCell** ().
        """
        ...

    @typing.overload
    def setCurrentItem(
        self,
        item: QTableWidgetItem,
        command: typing.Union[
            QtCore.QItemSelectionModel.SelectionFlags,
            QtCore.QItemSelectionModel.SelectionFlag,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#setCurrentItem-1

        **void QTableWidget::setCurrentItem(QTableWidgetItem * item ,
        QItemSelectionModel::SelectionFlags command )**

        Sets the current item to be **item** , using the given **command**.

        This function was introduced in Qt 4.4.

        **See also** **currentItem** () and **setCurrentCell** ().
        """
        ...

    def currentItem(self) -> QTableWidgetItem:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#currentItem

        **QTableWidgetItem *QTableWidget::currentItem() const**

        Returns the current item.

        **See also** **setCurrentItem** ().
        """
        ...

    def currentColumn(self) -> int:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#currentColumn

        **int QTableWidget::currentColumn() const**

        Returns the column of the current item.

        **See also** **currentRow** () and **setCurrentCell** ().
        """
        ...

    def currentRow(self) -> int:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#currentRow

        **int QTableWidget::currentRow() const**

        Returns the row of the current item.

        **See also** **currentColumn** () and **setCurrentCell** ().
        """
        ...

    def setHorizontalHeaderLabels(self, labels: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#setHorizontalHeaderLabels

        **void QTableWidget::setHorizontalHeaderLabels(const QStringList &
        labels )**

        Sets the horizontal header labels using **labels**.
        """
        ...

    def setVerticalHeaderLabels(self, labels: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#setVerticalHeaderLabels

        **void QTableWidget::setVerticalHeaderLabels(const QStringList & labels
        )**

        Sets the vertical header labels using **labels**.
        """
        ...

    def takeHorizontalHeaderItem(self, column: int) -> QTableWidgetItem:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#takeHorizontalHeaderItem

        **QTableWidgetItem *QTableWidget::takeHorizontalHeaderItem(int column
        )**

        Removes the horizontal header item at **column** from the header without
        deleting it.

        This function was introduced in Qt 4.1.
        """
        ...

    def setHorizontalHeaderItem(self, column: int, item: QTableWidgetItem) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#setHorizontalHeaderItem

        **void QTableWidget::setHorizontalHeaderItem(int column ,
        QTableWidgetItem * item )**

        Sets the horizontal header item for column **column** to **item**. If
        necessary, the column count is increased to fit the item. The previous
        header item (if there was one) is deleted.

        **See also** **horizontalHeaderItem** ().
        """
        ...

    def horizontalHeaderItem(self, column: int) -> QTableWidgetItem:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#horizontalHeaderItem

        **QTableWidgetItem *QTableWidget::horizontalHeaderItem(int column )
        const**

        Returns the horizontal header item for column, **column** , if one has
        been set; otherwise returns `nullptr`.

        **See also** **setHorizontalHeaderItem** ().
        """
        ...

    def takeVerticalHeaderItem(self, row: int) -> QTableWidgetItem:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#takeVerticalHeaderItem

        **QTableWidgetItem *QTableWidget::takeVerticalHeaderItem(int row )**

        Removes the vertical header item at **row** from the header without
        deleting it.

        This function was introduced in Qt 4.1.
        """
        ...

    def setVerticalHeaderItem(self, row: int, item: QTableWidgetItem) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#setVerticalHeaderItem

        **void QTableWidget::setVerticalHeaderItem(int row , QTableWidgetItem *
        item )**

        Sets the vertical header item for row **row** to **item**.

        **See also** **verticalHeaderItem** ().
        """
        ...

    def verticalHeaderItem(self, row: int) -> QTableWidgetItem:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#verticalHeaderItem

        **QTableWidgetItem *QTableWidget::verticalHeaderItem(int row ) const**

        Returns the vertical header item for row **row**.

        **See also** **setVerticalHeaderItem** ().
        """
        ...

    def takeItem(self, row: int, column: int) -> QTableWidgetItem:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#takeItem

        **QTableWidgetItem *QTableWidget::takeItem(int row , int column )**

        Removes the item at **row** and **column** from the table without
        deleting it.
        """
        ...

    def setItem(self, row: int, column: int, item: QTableWidgetItem) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#setItem

        **void QTableWidget::setItem(int row , int column , QTableWidgetItem *
        item )**

        Sets the item for the given **row** and **column** to **item**.

        The table takes ownership of the item.

        Note that if sorting is enabled (see **sortingEnabled** ) and **column**
        is the current sort column, the **row** will be moved to the sorted
        position determined by **item**.

        If you want to set several items of a particular row (say, by calling
        setItem() in a loop), you may want to turn off sorting before doing so,
        and turn it back on afterwards; this will allow you to use the same
        **row** argument for all items in the same row (i.e. setItem() will not
        move the row).

        **See also** **item** () and **takeItem** ().
        """
        ...

    def item(self, row: int, column: int) -> QTableWidgetItem:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#item

        **QTableWidgetItem *QTableWidget::item(int row , int column ) const**

        Returns the item for the given **row** and **column** if one has been
        set; otherwise returns `nullptr`.

        **See also** **setItem** ().
        """
        ...

    def column(self, item: QTableWidgetItem) -> int:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#column

        **int QTableWidget::column(const QTableWidgetItem * item ) const**

        Returns the column for the **item**.
        """
        ...

    def row(self, item: QTableWidgetItem) -> int:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#row

        **int QTableWidget::row(const QTableWidgetItem * item ) const**

        Returns the row for the **item**.
        """
        ...

    def columnCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#columnCount

        **int QTableWidget::columnCount() const**

        Returns the number of columns.

        **Note:** Getter function for property columnCount.

        **See also** **setColumnCount** ().
        """
        ...

    def setColumnCount(self, columns: int) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#setColumnCount

        **void QTableWidget::setColumnCount(int columns )**

        Sets the number of columns in this table's model to **columns**. If this
        is less than **columnCount** (), the data in the unwanted columns is
        discarded.

        **Note:** Setter function for property **columnCount** .

        **See also** **columnCount** () and **setRowCount** ().
        """
        ...

    def rowCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#rowCount

        **int QTableWidget::rowCount() const**

        Returns the number of rows.

        **Note:** Getter function for property rowCount.

        **See also** **setRowCount** ().
        """
        ...

    def setRowCount(self, rows: int) -> None:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#setRowCount

        **void QTableWidget::setRowCount(int rows )**

        Sets the number of rows in this table's model to **rows**. If this is
        less than **rowCount** (), the data in the unwanted rows is discarded.

        **Note:** Setter function for property **rowCount** .

        **See also** **rowCount** () and **setColumnCount** ().
        """
        ...

    @property
    def cellActivated(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#cellActivated

        **[signal] void QTableWidget::cellActivated(int row , int column )**

        This signal is emitted when the cell specified by **row** and **column**
        has been activated

        This function was introduced in Qt 4.1.
        """
        ...

    @property
    def cellChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#cellChanged

        **[signal] void QTableWidget::cellChanged(int row , int column )**

        This signal is emitted whenever the data of the item in the cell
        specified by **row** and **column** has changed.

        This function was introduced in Qt 4.1.
        """
        ...

    @property
    def cellClicked(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#cellClicked

        **[signal] void QTableWidget::cellClicked(int row , int column )**

        This signal is emitted whenever a cell in the table is clicked. The
        **row** and **column** specified is the cell that was clicked.

        This function was introduced in Qt 4.1.
        """
        ...

    @property
    def cellDoubleClicked(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#cellDoubleClicked

        **[signal] void QTableWidget::cellDoubleClicked(int row , int column )**

        This signal is emitted whenever a cell in the table is double clicked.
        The **row** and **column** specified is the cell that was double
        clicked.

        This function was introduced in Qt 4.1.
        """
        ...

    @property
    def cellEntered(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#cellEntered

        **[signal] void QTableWidget::cellEntered(int row , int column )**

        This signal is emitted when the mouse cursor enters a cell. The cell is
        specified by **row** and **column**.

        This signal is only emitted when **mouseTracking**  is turned on, or
        when a mouse button is pressed while moving into an item.

        This function was introduced in Qt 4.1.
        """
        ...

    @property
    def cellPressed(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#cellPressed

        **[signal] void QTableWidget::cellPressed(int row , int column )**

        This signal is emitted whenever a cell in the table is pressed. The
        **row** and **column** specified is the cell that was pressed.

        This function was introduced in Qt 4.1.
        """
        ...

    @property
    def currentCellChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#currentCellChanged

        **[signal] void QTableWidget::currentCellChanged(int currentRow , int
        currentColumn , int previousRow , int previousColumn )**

        This signal is emitted whenever the current cell changes. The cell
        specified by **previousRow** and **previousColumn** is the cell that
        previously had the focus, the cell specified by **currentRow** and
        **currentColumn** is the new current cell.

        This function was introduced in Qt 4.1.
        """
        ...

    @property
    def currentItemChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#currentItemChanged

        **[signal] void QTableWidget::currentItemChanged(QTableWidgetItem *
        current , QTableWidgetItem * previous )**

        This signal is emitted whenever the current item changes. The
        **previous** item is the item that previously had the focus, **current**
        is the new current item.
        """
        ...

    @property
    def itemActivated(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#itemActivated

        **[signal] void QTableWidget::itemActivated(QTableWidgetItem * item )**

        This signal is emitted when the specified **item** has been activated
        """
        ...

    @property
    def itemChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#itemChanged

        **[signal] void QTableWidget::itemChanged(QTableWidgetItem * item )**

        This signal is emitted whenever the data of **item** has changed.
        """
        ...

    @property
    def itemClicked(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#itemClicked

        **[signal] void QTableWidget::itemClicked(QTableWidgetItem * item )**

        This signal is emitted whenever an item in the table is clicked. The
        **item** specified is the item that was clicked.
        """
        ...

    @property
    def itemDoubleClicked(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#itemDoubleClicked

        **[signal] void QTableWidget::itemDoubleClicked(QTableWidgetItem * item
        )**

        This signal is emitted whenever an item in the table is double clicked.
        The **item** specified is the item that was double clicked.
        """
        ...

    @property
    def itemEntered(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#itemEntered

        **[signal] void QTableWidget::itemEntered(QTableWidgetItem * item )**

        This signal is emitted when the mouse cursor enters an item. The
        **item** is the item entered.

        This signal is only emitted when **mouseTracking**  is turned on, or
        when a mouse button is pressed while moving into an item.
        """
        ...

    @property
    def itemPressed(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#itemPressed

        **[signal] void QTableWidget::itemPressed(QTableWidgetItem * item )**

        This signal is emitted whenever an item in the table is pressed. The
        **item** specified is the item that was pressed.
        """
        ...

    @property
    def itemSelectionChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qtablewidget.html#itemSelectionChanged

        **[signal] void QTableWidget::itemSelectionChanged()**

        This signal is emitted whenever the selection changes.

        **See also** **selectedItems** () and **QTableWidgetItem::isSelected**
        ().
        """
        ...
