"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QStyledItemDelegate(QAbstractItemDelegate):
    """
    https://doc.qt.io/qt-5/qstyleditemdelegate.html

    **Detailed Description**

    When displaying data from models in Qt item views, e.g., a **QTableView** ,
    the individual items are drawn by a delegate. Also, when an item is edited,
    it provides an editor widget, which is placed on top of the item view while
    editing takes place. QStyledItemDelegate is the default delegate for all Qt
    item views, and is installed upon them when they are created.

    The QStyledItemDelegate class is one of the **Model/View Classes**  and is
    part of Qt's **model/view framework** . The delegate allows the display and
    editing of items to be developed independently from the model and view.

    The data of items in models are assigned an **ItemDataRole** ; each item can
    store a **QVariant**  for each role. QStyledItemDelegate implements display
    and editing for the most common datatypes expected by users, including
    booleans, integers, and strings.

    The data will be drawn differently depending on which role they have in the
    model. The following table describes the roles and the data types the
    delegate can handle for each of them. It is often sufficient to ensure that
    the model returns appropriate data for each of the roles to determine the
    appearance of items in views.

    RoleAccepted Types
    **Qt::BackgroundRole** **QBrush**  (
    **Qt::BackgroundColorRole** **QColor**  (obsolete; use
    **Qt::BackgroundRole**  instead)
    **Qt::CheckStateRole** **Qt::CheckState**
    **Qt::DecorationRole** **QIcon** , **QPixmap** , **QImage**  and **QColor**
    **Qt::DisplayRole** **QString**  and types with a string representation
    **Qt::EditRole** See **QItemEditorFactory**  for details
    **Qt::FontRole**
    **QFont**
    **Qt::SizeHintRole** **QSize**
    **Qt::TextAlignmentRole**
    **Qt::Alignment**
    **Qt::ForegroundRole** **QBrush**  (
    **Qt::TextColorRole** **QColor**  (obsolete; use **Qt::ForegroundRole**
    instead)

    Editors are created with a **QItemEditorFactory** ; a default static
    instance provided by **QItemEditorFactory**  is installed on all item
    delegates. You can set a custom factory using **setItemEditorFactory** () or
    set a new default factory with **QItemEditorFactory::setDefaultFactory** ().
    It is the data stored in the item model with the **EditRole**  that is
    edited. See the **QItemEditorFactory**  class for a more high-level
    introduction to item editor factories. The **Color Editor Factory**  example
    shows how to create custom editors with a factory.

    **Subclassing QStyledItemDelegate**

    If the delegate does not support painting of the data types you need or you
    want to customize the drawing of items, you need to subclass
    QStyledItemDelegate, and reimplement **paint** () and possibly **sizeHint**
    (). The **paint** () function is called individually for each item, and with
    **sizeHint** (), you can specify the hint for each of them.

    When reimplementing **paint** (), one would typically handle the datatypes
    one would like to draw and use the superclass implementation for other
    types.

    The painting of check box indicators are performed by the current style. The
    style also specifies the size and the bounding rectangles in which to draw
    the data for the different data roles. The bounding rectangle of the item
    itself is also calculated by the style. When drawing already supported
    datatypes, it is therefore a good idea to ask the style for these bounding
    rectangles. The **QStyle**  class description describes this in more detail.

    If you wish to change any of the bounding rectangles calculated by the style
    or the painting of check box indicators, you can subclass **QStyle** . Note,
    however, that the size of the items can also be affected by reimplementing
    **sizeHint** ().

    It is possible for a custom delegate to provide editors without the use of
    an editor item factory. In this case, the following virtual functions must
    be reimplemented:

    * **createEditor** () returns the widget used to change data from the model
    and can be reimplemented to customize editing behavior.
      *
    **setEditorData** () provides the widget with data to manipulate.
      *
    **updateEditorGeometry** () ensures that the editor is displayed correctly
    with respect to the item view.
      * **setModelData** () returns updated data
    to the model.

    The **Star Delegate**  example creates editors by reimplementing these
    methods.

    **QStyledItemDelegate vs. QItemDelegate**

    Since Qt 4.4, there are two delegate classes: **QItemDelegate**  and
    QStyledItemDelegate. However, the default delegate is QStyledItemDelegate.
    These two classes are independent alternatives to painting and providing
    editors for items in views. The difference between them is that
    QStyledItemDelegate uses the current style to paint its items. We therefore
    recommend using QStyledItemDelegate as the base class when implementing
    custom delegates or when working with Qt style sheets. The code required for
    either class should be equal unless the custom delegate needs to use the
    style for drawing.

    If you wish to customize the painting of item views, you should implement a
    custom style. Please see the **QStyle**  class documentation for details.

    **See also** **Delegate Classes** , **QItemDelegate** ,
    **QAbstractItemDelegate** , **QStyle** , **Spin Box Delegate Example** ,
    **Star Delegate Example** , and **Color Editor Factory Example** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qstyleditemdelegate.html#QStyledItemDelegate

        **QStyledItemDelegate::QStyledItemDelegate(QObject * parent = nullptr)**

        Constructs an item delegate with the given **parent**.
        """
        ...

    def editorEvent(
        self,
        event: QtCore.QEvent,
        model: QtCore.QAbstractItemModel,
        option: "QStyleOptionViewItem",
        index: QtCore.QModelIndex,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qstyleditemdelegate.html#editorEvent

        **[override virtual protected] bool
        QStyledItemDelegate::editorEvent(QEvent * event , QAbstractItemModel *
        model , const QStyleOptionViewItem & option , const QModelIndex & index
        )**

        Reimplements: **QAbstractItemDelegate::editorEvent** (QEvent *event,
        QAbstractItemModel *model, const QStyleOptionViewItem &option, const
        QModelIndex &index).
        """
        ...

    def eventFilter(self, object: QtCore.QObject, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qstyleditemdelegate.html#eventFilter

        **[override virtual protected] bool
        QStyledItemDelegate::eventFilter(QObject * editor , QEvent * event )**

        Reimplements: **QObject::eventFilter** (QObject *watched, QEvent
        *event).

        Returns `true` if the given **editor** is a valid **QWidget**  and the
        given **event** is handled; otherwise returns `false`. The following key
        press events are handled by default:

        * **Tab**
          * **Backtab**
          * **Enter**
          * **Return**
          * **Esc**

        If the **editor** 's type is **QTextEdit**  or **QPlainTextEdit**  then
        **Enter** and **Return** keys are **not** handled.

        In the case of **Tab** , **Backtab** , **Enter** and **Return** key
        press events, the **editor** 's data is committed to the model and the
        editor is closed. If the **event** is a **Tab** key press the view will
        open an editor on the next item in the view. Likewise, if the **event**
        is a **Backtab** key press the view will open an editor on the
        **previous** item in the view.

        If the event is a **Esc** key press event, the **editor** is closed
        **without** committing its data.

        **See also** **commitData** () and **closeEditor** ().
        """
        ...

    def initStyleOption(
        self, option: "QStyleOptionViewItem", index: QtCore.QModelIndex
    ) -> None:
        """
        https://doc.qt.io/qt-5/qstyleditemdelegate.html#initStyleOption

        **[virtual protected] void
        QStyledItemDelegate::initStyleOption(QStyleOptionViewItem * option ,
        const QModelIndex & index ) const**

        Initialize **option** with the values using the index **index**. This
        method is useful for subclasses when they need a
        **QStyleOptionViewItem** , but don't want to fill in all the information
        themselves.

        **See also** **QStyleOption::initFrom** ().
        """
        ...

    def displayText(self, value: typing.Any, locale: QtCore.QLocale) -> str:
        """
        https://doc.qt.io/qt-5/qstyleditemdelegate.html#displayText

        **[virtual] QString QStyledItemDelegate::displayText(const QVariant &
        value , const QLocale & locale ) const**

        This function returns the string that the delegate will use to display
        the **Qt::DisplayRole**  of the model in **locale**. **value** is the
        value of the **Qt::DisplayRole**  provided by the model.

        The default implementation uses the **QLocale::toString**  to convert
        **value** into a **QString** .

        This function is not called for empty model indices, i.e., indices for
        which the model returns an invalid **QVariant** .

        **See also** **QAbstractItemModel::data** ().
        """
        ...

    def setItemEditorFactory(self, factory: QItemEditorFactory) -> None:
        """
        https://doc.qt.io/qt-5/qstyleditemdelegate.html#setItemEditorFactory

        **void QStyledItemDelegate::setItemEditorFactory(QItemEditorFactory *
        factory )**

        Sets the editor factory to be used by the item delegate to be the
        **factory** specified. If no editor factory is set, the item delegate
        will use the default editor factory.

        **See also** **itemEditorFactory** ().
        """
        ...

    def itemEditorFactory(self) -> QItemEditorFactory:
        """
        https://doc.qt.io/qt-5/qstyleditemdelegate.html#itemEditorFactory

        **QItemEditorFactory *QStyledItemDelegate::itemEditorFactory() const**

        Returns the editor factory used by the item delegate. If no editor
        factory is set, the function will return null.

        **See also** **setItemEditorFactory** ().
        """
        ...

    def updateEditorGeometry(
        self, editor: QWidget, option: "QStyleOptionViewItem", index: QtCore.QModelIndex
    ) -> None:
        """
        https://doc.qt.io/qt-5/qstyleditemdelegate.html#updateEditorGeometry

        **[override virtual] void
        QStyledItemDelegate::updateEditorGeometry(QWidget * editor , const
        QStyleOptionViewItem & option , const QModelIndex & index ) const**

        Reimplements: **QAbstractItemDelegate::updateEditorGeometry** (QWidget
        *editor, const QStyleOptionViewItem &option, const QModelIndex &index)
        const.

        Updates the **editor** for the item specified by **index** according to
        the style **option** given.
        """
        ...

    def setModelData(
        self,
        editor: QWidget,
        model: QtCore.QAbstractItemModel,
        index: QtCore.QModelIndex,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qstyleditemdelegate.html#setModelData

        **[override virtual] void QStyledItemDelegate::setModelData(QWidget *
        editor , QAbstractItemModel * model , const QModelIndex & index )
        const**

        Reimplements: **QAbstractItemDelegate::setModelData** (QWidget *editor,
        QAbstractItemModel *model, const QModelIndex &index) const.

        Gets data from the **editor** widget and stores it in the specified
        **model** at the item **index**.

        The default implementation gets the value to be stored in the data model
        from the **editor** widget's **user property** .

        **See also** **QMetaProperty::isUser** ().
        """
        ...

    def setEditorData(self, editor: QWidget, index: QtCore.QModelIndex) -> None:
        """
        https://doc.qt.io/qt-5/qstyleditemdelegate.html#setEditorData

        **[override virtual] void QStyledItemDelegate::setEditorData(QWidget *
        editor , const QModelIndex & index ) const**

        Reimplements: **QAbstractItemDelegate::setEditorData** (QWidget *editor,
        const QModelIndex &index) const.

        Sets the data to be displayed and edited by the **editor** from the data
        model item specified by the model **index**.

        The default implementation stores the data in the **editor** widget's
        **user property** .

        **See also** **QMetaProperty::isUser** ().
        """
        ...

    def createEditor(
        self, parent: QWidget, option: "QStyleOptionViewItem", index: QtCore.QModelIndex
    ) -> QWidget:
        """
        https://doc.qt.io/qt-5/qstyleditemdelegate.html#createEditor

        **[override virtual] QWidget *QStyledItemDelegate::createEditor(QWidget
        * parent , const QStyleOptionViewItem & option , const QModelIndex &
        index ) const**

        Reimplements: **QAbstractItemDelegate::createEditor** (QWidget *parent,
        const QStyleOptionViewItem &option, const QModelIndex &index) const.

        Returns the widget used to edit the item specified by **index** for
        editing. The **parent** widget and style **option** are used to control
        how the editor widget appears.

        **See also** **QAbstractItemDelegate::createEditor** ().
        """
        ...

    def sizeHint(
        self, option: "QStyleOptionViewItem", index: QtCore.QModelIndex
    ) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qstyleditemdelegate.html#sizeHint

        **[override virtual] QSize QStyledItemDelegate::sizeHint(const
        QStyleOptionViewItem & option , const QModelIndex & index ) const**

        Reimplements: **QAbstractItemDelegate::sizeHint** (const
        QStyleOptionViewItem &option, const QModelIndex &index) const.

        Returns the size needed by the delegate to display the item specified by
        **index** , taking into account the style information provided by
        **option**.

        This function uses the view's **QStyle**  to determine the size of the
        item.

        **See also** **QStyle::sizeFromContents** () and
        **QStyle::CT_ItemViewItem** .
        """
        ...

    def paint(
        self,
        painter: QtGui.QPainter,
        option: "QStyleOptionViewItem",
        index: QtCore.QModelIndex,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qstyleditemdelegate.html#paint

        **[override virtual] void QStyledItemDelegate::paint(QPainter * painter
        , const QStyleOptionViewItem & option , const QModelIndex & index )
        const**

        Reimplements: **QAbstractItemDelegate::paint** (QPainter *painter, const
        QStyleOptionViewItem &option, const QModelIndex &index) const.

        Renders the delegate using the given **painter** and style **option**
        for the item specified by **index**.

        This function paints the item using the view's **QStyle** .

        When reimplementing paint in a subclass. Use the **initStyleOption** ()
        to set up the **option** in the same way as the **QStyledItemDelegate**
        .

        Whenever possible, use the **option** while painting. Especially its
        **rect**  variable to decide where to draw and its **state**  to
        determine if it is enabled or selected.

        After painting, you should ensure that the painter is returned to the
        state it was supplied in when this function was called. For example, it
        may be useful to call **QPainter::save** () before painting and
        **QPainter::restore** () afterwards.

        **See also** **QItemDelegate::paint** (), **QStyle::drawControl** (),
        and **QStyle::CE_ItemViewItem** .
        """
        ...
