"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *
from PyQt5 import sip


class QStyleOption(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qstyleoption.html

    **Detailed Description**

    QStyleOption and its subclasses contain all the information that **QStyle**
    functions need to draw a graphical element.

    For performance reasons, there are few member functions and the access to
    the member variables is direct (i.e., using the `.` or `->` operator). This
    low-level feel makes the structures straightforward to use and emphasizes
    that these are simply parameters used by the style functions.

    The caller of a **QStyle**  function usually creates QStyleOption objects on
    the stack. This combined with Qt's extensive use of **implicit sharing**
    for types such as **QString** , **QPalette** , and **QColor**  ensures that
    no memory allocation needlessly takes place.

    The following code snippet shows how to use a specific QStyleOption subclass
    to paint a push button:

    void MyPushButton::paintEvent(**QPaintEvent**  *)
        {
    **QStyleOptionButton**  option;
            option.initFrom(this);
    option.state = isDown() ? **QStyle** ::State_Sunken : **QStyle**
    ::State_Raised;
            if (isDefault())
                option.features |=
    **QStyleOptionButton** ::DefaultButton;
            option.text = text();
    option.icon = icon();

            **QPainter**  painter(this);
    style()->drawControl(**QStyle** ::CE_PushButton, &option, &painter, this);
    }

    In our example, the control is a **QStyle::CE_PushButton** , and according
    to the **QStyle::drawControl** () documentation the corresponding class is
    **QStyleOptionButton** .

    When reimplementing **QStyle**  functions that take a QStyleOption
    parameter, you often need to cast the QStyleOption to a subclass. For
    safety, you can use **qstyleoption_cast** () to ensure that the pointer type
    is correct. For example:

    void MyStyle::drawPrimitive(PrimitiveElement element,
    const **QStyleOption**  *option,
    **QPainter**  *painter,
                                    const **QWidget**
    *widget)
        {
            if (element == PE_FrameFocusRect) {
                const
    **QStyleOptionFocusRect**  *focusRectOption =
    qstyleoption_cast<const **QStyleOptionFocusRect**  *>(option);
    if (focusRectOption) {
                    // ...
                }
            }
    // ...
        }

    The **qstyleoption_cast** () function will return 0 if the object to which
    `option` points is not of the correct type.

    For an example demonstrating how style options can be used, see the
    **Styles**  example.

    **See also** **QStyle**  and **QStylePainter** .
    """

    class StyleOptionVersion(int):
        Version: QStyleOption = ...

    class StyleOptionType(int):
        Type: QStyleOption = ...

    class OptionType(int):
        SO_Default: QStyleOption = ...
        SO_FocusRect: QStyleOption = ...
        SO_Button: QStyleOption = ...
        SO_Tab: QStyleOption = ...
        SO_MenuItem: QStyleOption = ...
        SO_Frame: QStyleOption = ...
        SO_ProgressBar: QStyleOption = ...
        SO_ToolBox: QStyleOption = ...
        SO_Header: QStyleOption = ...
        SO_DockWidget: QStyleOption = ...
        SO_ViewItem: QStyleOption = ...
        SO_TabWidgetFrame: QStyleOption = ...
        SO_TabBarBase: QStyleOption = ...
        SO_RubberBand: QStyleOption = ...
        SO_ToolBar: QStyleOption = ...
        SO_Complex: QStyleOption = ...
        SO_Slider: QStyleOption = ...
        SO_SpinBox: QStyleOption = ...
        SO_ToolButton: QStyleOption = ...
        SO_ComboBox: QStyleOption = ...
        SO_TitleBar: QStyleOption = ...
        SO_GroupBox: QStyleOption = ...
        SO_ComplexCustomBase: QStyleOption = ...
        SO_GraphicsItem: QStyleOption = ...
        SO_SizeGrip: QStyleOption = ...
        SO_CustomBase: QStyleOption = ...

    direction: QtCore = ...
    fontMetrics: QtGui = ...
    palette: QtGui = ...
    rect: QtCore = ...
    state: typing = ...
    styleObject: QtCore = ...
    type: int = ...
    version: int = ...

    @typing.overload
    def __init__(self, version: int = ..., type: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qstyleoption.html#QStyleOption

        **QStyleOption::QStyleOption(int version = QStyleOption::Version, int
        type = SO_Default)**

        Constructs a QStyleOption with the specified **version** and **type**.

        The version has no special meaning for QStyleOption; it can be used by
        subclasses to distinguish between different version of the same option
        type.

        The **state**  member variable is initialized to **QStyle::State_None**
        .

        **See also** **version**  and **type** .
        """
        ...

    @typing.overload
    def __init__(self, other: "QStyleOption") -> None:
        """
        https://doc.qt.io/qt-5/qstyleoption.html#QStyleOption-1

        **QStyleOption::QStyleOption(const QStyleOption & other )**

        Constructs a copy of **other**.
        """
        ...

    def initFrom(self, w: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qstyleoption.html#initFrom

        **void QStyleOption::initFrom(const QWidget * widget )**

        Initializes the **state** , **direction** , **rect** , **palette** ,
        **fontMetrics**  and **styleObject**  member variables based on the
        specified **widget**.

        This is a convenience function; the member variables can also be
        initialized manually.

        This function was introduced in Qt 4.1.

        **See also** **QWidget::layoutDirection** (), **QWidget::rect** (),
        **QWidget::palette** (), and **QWidget::fontMetrics** ().
        """
        ...
