"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QShortcut(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qshortcut.html

    **Detailed Description**

    The QShortcut class provides a way of connecting keyboard shortcuts to Qt's
    **signals and slots**  mechanism, so that objects can be informed when a
    shortcut is executed. The shortcut can be set up to contain all the key
    presses necessary to describe a keyboard shortcut, including the states of
    modifier keys such as **Shift** , **Ctrl** , and **Alt**.

    On certain widgets, using '&' in front of a character will automatically
    create a mnemonic (a shortcut) for that character, e.g. "E&xit" will create
    the shortcut **Alt+X** (use '&&' to display an actual ampersand). The widget
    might consume and perform an action on a given shortcut. On X11 the
    ampersand will not be shown and the character will be underlined. On
    Windows, shortcuts are normally not displayed until the user presses the
    **Alt** key, but this is a setting the user can change. On Mac, shortcuts
    are disabled by default. Call **qt_set_sequence_auto_mnemonic** () to enable
    them. However, because mnemonic shortcuts do not fit in with Aqua's
    guidelines, Qt will not show the shortcut character underlined.

    For applications that use menus, it may be more convenient to use the
    convenience functions provided in the **QMenu**  class to assign keyboard
    shortcuts to menu items as they are created. Alternatively, shortcuts may be
    associated with other types of actions in the **QAction**  class.

    The simplest way to create a shortcut for a particular widget is to
    construct the shortcut with a key sequence. For example:

    shortcut = new **QShortcut** (**QKeySequence** (tr("Ctrl+O", "File|Open")),
    parent);

    When the user types the **key sequence**  for a given shortcut, the
    shortcut's **activated** () signal is emitted. (In the case of ambiguity,
    the **activatedAmbiguously** () signal is emitted.) A shortcut is "listened
    for" by Qt's event loop when the shortcut's parent widget is receiving
    events.

    A shortcut's key sequence can be set with **setKey** () and retrieved with
    **key** (). A shortcut can be enabled or disabled with **setEnabled** (),
    and can have "What's This?" help text set with **setWhatsThis** ().

    **See also** **QShortcutEvent** , **QKeySequence** , and **QAction** .
    """

    @typing.overload
    def __init__(self, parent: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qshortcut.html#QShortcut

        **QShortcut::QShortcut(QWidget * parent )**

        Constructs a QShortcut object for the **parent** widget. Since no
        shortcut key sequence is specified, the shortcut will not emit any
        signals.

        **See also** **setKey** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        key: typing.Union[QtGui.QKeySequence, QtGui.QKeySequence.StandardKey, str, int],
        parent: QWidget,
        member: PYQT_SLOT = ...,
        ambiguousMember: PYQT_SLOT = ...,
        context: QtCore.Qt.ShortcutContext = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qshortcut.html#QShortcut-1

        **QShortcut::QShortcut(const QKeySequence & key , QWidget * parent ,
        const char * member = nullptr, const char * ambiguousMember = nullptr,
        Qt::ShortcutContext shortcutContext = Qt::WindowShortcut)**

        Constructs a QShortcut object for the **parent** widget. The shortcut
        operates on its parent, listening for **QShortcutEvent** s that match
        the **key** sequence. Depending on the ambiguity of the event, the
        shortcut will call the **member** function, or the **ambiguousMember**
        function, if the key press was in the shortcut's **shortcutContext**.
        """
        ...

    def event(self, e: QtCore.QEvent) -> bool:
        ...

    def autoRepeat(self) -> bool:
        """
        https://doc.qt.io/qt-5/qshortcut.html#autoRepeat-prop

        **autoRepeat : bool**

        This property holds whether the shortcut can auto repeat

        If true, the shortcut will auto repeat when the keyboard shortcut
        combination is held down, provided that keyboard auto repeat is enabled
        on the system. The default value is true.

        This property was introduced in Qt 4.2.

        **Access functions:**

        bool **autoRepeat** () const
        void **setAutoRepeat** (bool **on** )
        """
        ...

    def setAutoRepeat(self, on: bool) -> None:
        """
        https://doc.qt.io/qt-5/qshortcut.html#autoRepeat-prop

        **autoRepeat : bool**

        This property holds whether the shortcut can auto repeat

        If true, the shortcut will auto repeat when the keyboard shortcut
        combination is held down, provided that keyboard auto repeat is enabled
        on the system. The default value is true.

        This property was introduced in Qt 4.2.

        **Access functions:**

        bool **autoRepeat** () const
        void **setAutoRepeat** (bool **on** )
        """
        ...

    def parentWidget(self) -> QWidget:
        """
        https://doc.qt.io/qt-5/qshortcut.html#parentWidget

        **QWidget *QShortcut::parentWidget() const**

        Returns the shortcut's parent widget.
        """
        ...

    def id(self) -> int:
        """
        https://doc.qt.io/qt-5/qshortcut.html#id

        **int QShortcut::id() const**

        Returns the shortcut's ID.

        **See also** **QShortcutEvent::shortcutId** ().
        """
        ...

    def whatsThis(self) -> str:
        """
        https://doc.qt.io/qt-5/qshortcut.html#whatsThis-prop

        **whatsThis : QString**

        This property holds the shortcut's "What's This?" help text

        The text will be shown when the application is in "What's This?" mode
        and the user types the shortcut **key** () sequence.

        To set "What's This?" help on a menu item (with or without a shortcut
        key), set the help on the item's action.

        By default, this property contains an empty string.

        **Access functions:**

        QString **whatsThis** () const
        void **setWhatsThis** (const QString &
        **text** )

        **See also** **QWhatsThis::inWhatsThisMode** () and
        **QAction::setWhatsThis** ().

        **Member Function Documentation**
        """
        ...

    def setWhatsThis(self, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qshortcut.html#whatsThis-prop

        **whatsThis : QString**

        This property holds the shortcut's "What's This?" help text

        The text will be shown when the application is in "What's This?" mode
        and the user types the shortcut **key** () sequence.

        To set "What's This?" help on a menu item (with or without a shortcut
        key), set the help on the item's action.

        By default, this property contains an empty string.

        **Access functions:**

        QString **whatsThis** () const
        void **setWhatsThis** (const QString &
        **text** )

        **See also** **QWhatsThis::inWhatsThisMode** () and
        **QAction::setWhatsThis** ().

        **Member Function Documentation**
        """
        ...

    def context(self) -> QtCore.Qt.ShortcutContext:
        """
        https://doc.qt.io/qt-5/qshortcut.html#context-prop

        **context : Qt::ShortcutContext**

        This property holds the context in which the shortcut is valid

        A shortcut's context decides in which circumstances a shortcut is
        allowed to be triggered. The normal context is **Qt::WindowShortcut** ,
        which allows the shortcut to trigger if the parent (the widget
        containing the shortcut) is a subwidget of the active top-level window.

        By default, this property is set to **Qt::WindowShortcut** .

        **Access functions:**

        Qt::ShortcutContext **context** () const
        void **setContext**
        (Qt::ShortcutContext **context** )
        """
        ...

    def setContext(self, context: QtCore.Qt.ShortcutContext) -> None:
        """
        https://doc.qt.io/qt-5/qshortcut.html#context-prop

        **context : Qt::ShortcutContext**

        This property holds the context in which the shortcut is valid

        A shortcut's context decides in which circumstances a shortcut is
        allowed to be triggered. The normal context is **Qt::WindowShortcut** ,
        which allows the shortcut to trigger if the parent (the widget
        containing the shortcut) is a subwidget of the active top-level window.

        By default, this property is set to **Qt::WindowShortcut** .

        **Access functions:**

        Qt::ShortcutContext **context** () const
        void **setContext**
        (Qt::ShortcutContext **context** )
        """
        ...

    def isEnabled(self) -> bool:
        ...

    def setEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qshortcut.html#enabled-prop

        **enabled : bool**

        This property holds whether the shortcut is enabled

        An enabled shortcut emits the **activated** () or
        **activatedAmbiguously** () signal when a **QShortcutEvent**  occurs
        that matches the shortcut's **key** () sequence.

        If the application is in `WhatsThis` mode the shortcut will not emit the
        signals, but will show the "What's This?" text instead.

        By default, this property is `true`.

        **Access functions:**

        bool **isEnabled** () const
        void **setEnabled** (bool **enable** )

        **See also** **whatsThis** .
        """
        ...

    def key(self) -> QtGui.QKeySequence:
        """
        https://doc.qt.io/qt-5/qshortcut.html#key-prop

        **key : QKeySequence**

        This property holds the shortcut's key sequence

        This is a key sequence with an optional combination of Shift, Ctrl, and
        Alt. The key sequence may be supplied in a number of ways:

        setKey(0);                  // no signal emitted
        setKey(**QKeySequence** ());     // no signal emitted
            setKey(0x3b1);
        // Greek letter alpha
            setKey(Qt::Key_D);              // 'd', e.g.
        to delete
            setKey('q');                // 'q', e.g. to quit
        setKey(Qt::CTRL + Qt::Key_P);       // Ctrl+P, e.g. to print document
        setKey("Ctrl+P");           // Ctrl+P, e.g. to print document

        By default, this property contains an empty key sequence.

        **Access functions:**

        QKeySequence **key** () const
        void **setKey** (const QKeySequence &
        **key** )
        """
        ...

    def setKey(
        self,
        key: typing.Union[QtGui.QKeySequence, QtGui.QKeySequence.StandardKey, str, int],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qshortcut.html#key-prop

        **key : QKeySequence**

        This property holds the shortcut's key sequence

        This is a key sequence with an optional combination of Shift, Ctrl, and
        Alt. The key sequence may be supplied in a number of ways:

        setKey(0);                  // no signal emitted
        setKey(**QKeySequence** ());     // no signal emitted
            setKey(0x3b1);
        // Greek letter alpha
            setKey(Qt::Key_D);              // 'd', e.g.
        to delete
            setKey('q');                // 'q', e.g. to quit
        setKey(Qt::CTRL + Qt::Key_P);       // Ctrl+P, e.g. to print document
        setKey("Ctrl+P");           // Ctrl+P, e.g. to print document

        By default, this property contains an empty key sequence.

        **Access functions:**

        QKeySequence **key** () const
        void **setKey** (const QKeySequence &
        **key** )
        """
        ...

    @property
    def activated(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qshortcut.html#activated

        **[signal] void QShortcut::activated()**

        This signal is emitted when the user types the shortcut's key sequence.

        **See also** **activatedAmbiguously** ().
        """
        ...

    @property
    def activatedAmbiguously(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qshortcut.html#activatedAmbiguously

        **[signal] void QShortcut::activatedAmbiguously()**

        When a key sequence is being typed at the keyboard, it is said to be
        ambiguous as long as it matches the start of more than one shortcut.

        When a shortcut's key sequence is completed, activatedAmbiguously() is
        emitted if the key sequence is still ambiguous (i.e., it is the start of
        one or more other shortcuts). The **activated** () signal is not emitted
        in this case.

        **See also** **activated** ().
        """
        ...
