"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *
from PyQt5 import sip


class QMdiSubWindow(QWidget):
    """
    https://doc.qt.io/qt-5/qmdisubwindow.html

    **Detailed Description**

    QMdiSubWindow represents a top-level window in a **QMdiArea** , and consists
    of a title bar with window decorations, an internal widget, and (depending
    on the current style) a window frame and a size grip. QMdiSubWindow has its
    own layout, which consists of the title bar and a center area for the
    internal widget.

    ![](images/qmdisubwindowlayout.png)

    The most common way to construct a QMdiSubWindow is to call
    **QMdiArea::addSubWindow** () with the internal widget as the argument. You
    can also create a subwindow yourself, and set an internal widget by calling
    **setWidget** ().

    You use the same API when programming with subwindows as with regular top-
    level windows (e.g., you can call functions such as **show** (), **hide**
    (), **showMaximized** (), and **setWindowTitle** ()).

    **Subwindow Handling**

    QMdiSubWindow also supports behavior specific to subwindows in an MDI area.

    By default, each QMdiSubWindow is visible inside the MDI area viewport when
    moved around, but it is also possible to specify transparent window movement
    and resizing behavior, where only the outline of a subwindow is updated
    during these operations. The **setOption** () function is used to enable
    this behavior.

    The **isShaded** () function detects whether the subwindow is currently
    shaded (i.e., the window is collapsed so that only the title bar is
    visible). To enter shaded mode, call **showShaded** (). QMdiSubWindow emits
    the **windowStateChanged** () signal whenever the window state has changed
    (e.g., when the window becomes minimized, or is restored). It also emits
    **aboutToActivate** () before it is activated.

    In keyboard-interactive mode, the windows are moved and resized with the
    keyboard. You can enter this mode through the system menu of the window. The
    **keyboardSingleStep**  and **keyboardPageStep**  properties control the
    distance the widget is moved or resized for each keypress event. When shift
    is pressed down page step is used; otherwise single step is used.

    You can also change the active window with the keyboard. By pressing the
    control and tab keys at the same time, the next (using the current
    **WindowOrder** ) subwindow will be activated. By pressing control, shift,
    and tab, you will activate the previous window. This is equivalent to
    calling **activateNextSubWindow()**  and **activatePreviousSubWindow()** .
    Note that these shortcuts overrides global shortcuts, but not the
    **QMdiArea** s shortcuts.

    **See also** **QMdiArea** .
    """

    class SubWindowOption(int):
        RubberBandResize: QMdiSubWindow = ...
        RubberBandMove: QMdiSubWindow = ...

    class SubWindowOptions(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QMdiSubWindow.SubWindowOptions", "QMdiSubWindow.SubWindowOption"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QMdiSubWindow.SubWindowOptions") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QMdiSubWindow.SubWindowOptions":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(
        self,
        parent: typing.Optional[QWidget] = ...,
        flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#QMdiSubWindow

        **QMdiSubWindow::QMdiSubWindow(QWidget * parent = nullptr,
        Qt::WindowFlags flags = Qt::WindowFlags())**

        Constructs a new QMdiSubWindow widget. The **parent** and **flags**
        arguments are passed to **QWidget** 's constructor.

        Instead of using addSubWindow(), it is also simply possible to use
        **setParent** () when you add the subwindow to a **QMdiArea** .

        Note that only **QMdiSubWindow** s can be set as children of
        **QMdiArea** ; you cannot, for instance, write:

        //bad code
            **QMdiArea**  mdiArea;
            **QTextEdit**
        editor(&mdiArea); // invalid child widget

        **See also** **QMdiArea::addSubWindow** ().
        """
        ...

    def childEvent(self, childEvent: QtCore.QChildEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#childEvent

        **[override virtual protected] void
        QMdiSubWindow::childEvent(QChildEvent * childEvent )**

        Reimplements: **QObject::childEvent** (QChildEvent *event).
        """
        ...

    def focusOutEvent(self, focusOutEvent: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#focusOutEvent

        **[override virtual protected] void
        QMdiSubWindow::focusOutEvent(QFocusEvent * focusOutEvent )**

        Reimplements: **QWidget::focusOutEvent** (QFocusEvent *event).
        """
        ...

    def focusInEvent(self, focusInEvent: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#focusInEvent

        **[override virtual protected] void
        QMdiSubWindow::focusInEvent(QFocusEvent * focusInEvent )**

        Reimplements: **QWidget::focusInEvent** (QFocusEvent *event).
        """
        ...

    def contextMenuEvent(self, contextMenuEvent: QtGui.QContextMenuEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#contextMenuEvent

        **[override virtual protected] void
        QMdiSubWindow::contextMenuEvent(QContextMenuEvent * contextMenuEvent )**

        Reimplements: **QWidget::contextMenuEvent** (QContextMenuEvent *event).
        """
        ...

    def keyPressEvent(self, keyEvent: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#keyPressEvent

        **[override virtual protected] void
        QMdiSubWindow::keyPressEvent(QKeyEvent * keyEvent )**

        Reimplements: **QWidget::keyPressEvent** (QKeyEvent *event).
        """
        ...

    def mouseMoveEvent(self, mouseEvent: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#mouseMoveEvent

        **[override virtual protected] void
        QMdiSubWindow::mouseMoveEvent(QMouseEvent * mouseEvent )**

        Reimplements: **QWidget::mouseMoveEvent** (QMouseEvent *event).
        """
        ...

    def mouseReleaseEvent(self, mouseEvent: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#mouseReleaseEvent

        **[override virtual protected] void
        QMdiSubWindow::mouseReleaseEvent(QMouseEvent * mouseEvent )**

        Reimplements: **QWidget::mouseReleaseEvent** (QMouseEvent *event).
        """
        ...

    def mouseDoubleClickEvent(self, mouseEvent: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#mouseDoubleClickEvent

        **[override virtual protected] void
        QMdiSubWindow::mouseDoubleClickEvent(QMouseEvent * mouseEvent )**

        Reimplements: **QWidget::mouseDoubleClickEvent** (QMouseEvent *event).
        """
        ...

    def mousePressEvent(self, mouseEvent: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#mousePressEvent

        **[override virtual protected] void
        QMdiSubWindow::mousePressEvent(QMouseEvent * mouseEvent )**

        Reimplements: **QWidget::mousePressEvent** (QMouseEvent *event).
        """
        ...

    def paintEvent(self, paintEvent: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#paintEvent

        **[override virtual protected] void
        QMdiSubWindow::paintEvent(QPaintEvent * paintEvent )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    def moveEvent(self, moveEvent: QtGui.QMoveEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#moveEvent

        **[override virtual protected] void QMdiSubWindow::moveEvent(QMoveEvent
        * moveEvent )**

        Reimplements: **QWidget::moveEvent** (QMoveEvent *event).
        """
        ...

    def timerEvent(self, timerEvent: QtCore.QTimerEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#timerEvent

        **[override virtual protected] void
        QMdiSubWindow::timerEvent(QTimerEvent * timerEvent )**

        Reimplements: **QObject::timerEvent** (QTimerEvent *event).
        """
        ...

    def resizeEvent(self, resizeEvent: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#resizeEvent

        **[override virtual protected] void
        QMdiSubWindow::resizeEvent(QResizeEvent * resizeEvent )**

        Reimplements: **QWidget::resizeEvent** (QResizeEvent *event).

        **Warning:** When maximizing or restoring a subwindow, the resulting
        call to this function may have an invalid **QResizeEvent::oldSize** ().
        """
        ...

    def leaveEvent(self, leaveEvent: QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#leaveEvent

        **[override virtual protected] void QMdiSubWindow::leaveEvent(QEvent *
        leaveEvent )**

        Reimplements: **QWidget::leaveEvent** (QEvent *event).
        """
        ...

    def closeEvent(self, closeEvent: QtGui.QCloseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#closeEvent

        **[override virtual protected] void
        QMdiSubWindow::closeEvent(QCloseEvent * closeEvent )**

        Reimplements: **QWidget::closeEvent** (QCloseEvent *event).
        """
        ...

    def changeEvent(self, changeEvent: QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#changeEvent

        **[override virtual protected] void QMdiSubWindow::changeEvent(QEvent *
        changeEvent )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    def hideEvent(self, hideEvent: QtGui.QHideEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#hideEvent

        **[override virtual protected] void QMdiSubWindow::hideEvent(QHideEvent
        * hideEvent )**

        Reimplements: **QWidget::hideEvent** (QHideEvent *event).
        """
        ...

    def showEvent(self, showEvent: QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#showEvent

        **[override virtual protected] void QMdiSubWindow::showEvent(QShowEvent
        * showEvent )**

        Reimplements: **QWidget::showEvent** (QShowEvent *event).
        """
        ...

    def event(self, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#event

        **[override virtual protected] bool QMdiSubWindow::event(QEvent * event
        )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def eventFilter(self, object: QtCore.QObject, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#eventFilter

        **[override virtual protected] bool QMdiSubWindow::eventFilter(QObject *
        object , QEvent * event )**

        Reimplements: **QObject::eventFilter** (QObject *watched, QEvent
        *event).
        """
        ...

    def showShaded(self) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#showShaded

        **[slot] void QMdiSubWindow::showShaded()**

        Calling this function makes the subwindow enter the shaded mode. When
        the subwindow is shaded, only the title bar is visible.

        Although shading is not supported by all styles, this function will
        still show the subwindow as shaded, regardless of whether support for
        shading is available. However, when used with styles without shading
        support, the user will be unable to return from shaded mode through the
        user interface (e.g., through a shade button in the title bar).

        **See also** **isShaded** ().
        """
        ...

    def showSystemMenu(self) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#showSystemMenu

        **[slot] void QMdiSubWindow::showSystemMenu()**

        Shows the system menu below the system menu icon in the title bar.

        **See also** **setSystemMenu** () and **systemMenu** ().
        """
        ...

    def mdiArea(self) -> QMdiArea:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#mdiArea

        **QMdiArea *QMdiSubWindow::mdiArea() const**

        Returns the area containing this sub-window, or `nullptr` if there is
        none.

        This function was introduced in Qt 4.4.

        **See also** **QMdiArea::addSubWindow** ().
        """
        ...

    def systemMenu(self) -> "QMenu":
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#systemMenu

        **QMenu *QMdiSubWindow::systemMenu() const**

        Returns a pointer to the current system menu, or zero if no system menu
        is set. **QMdiSubWindow**  provides a default system menu, but you can
        also set the menu with **setSystemMenu** ().

        **See also** **setSystemMenu** () and **showSystemMenu** ().
        """
        ...

    def setSystemMenu(self, systemMenu: "QMenu") -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#setSystemMenu

        **void QMdiSubWindow::setSystemMenu(QMenu * systemMenu )**

        Sets **systemMenu** as the current system menu for this subwindow.

        By default, each **QMdiSubWindow**  has a standard system menu.

        QActions for the system menu created by **QMdiSubWindow**  will
        automatically be updated depending on the current window state; e.g.,
        the minimize action will be disabled after the window is minimized.

        QActions added by the user are not updated by **QMdiSubWindow** .

        **QMdiSubWindow**  takes ownership of **systemMenu** ; you do not have
        to delete it. Any existing menus will be deleted.

        **See also** **systemMenu** () and **showSystemMenu** ().
        """
        ...

    def keyboardPageStep(self) -> int:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#keyboardPageStep-prop

        **keyboardPageStep : int**

        sets how far a widget should move or resize when using the keyboard page
        keys.

        When in keyboard-interactive mode, you can use the arrow and page keys
        to either move or resize the window. This property controls the page
        keys. The common way to enter keyboard interactive mode is to enter the
        subwindow menu, and select either "resize" or "move".

        The default keyboard page step value is 20 pixels.

        **Access functions:**

        int **keyboardPageStep** () const
        void **setKeyboardPageStep** (int
        **step** )

        **See also** **keyboardSingleStep** .
        """
        ...

    def setKeyboardPageStep(self, step: int) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#keyboardPageStep-prop

        **keyboardPageStep : int**

        sets how far a widget should move or resize when using the keyboard page
        keys.

        When in keyboard-interactive mode, you can use the arrow and page keys
        to either move or resize the window. This property controls the page
        keys. The common way to enter keyboard interactive mode is to enter the
        subwindow menu, and select either "resize" or "move".

        The default keyboard page step value is 20 pixels.

        **Access functions:**

        int **keyboardPageStep** () const
        void **setKeyboardPageStep** (int
        **step** )

        **See also** **keyboardSingleStep** .
        """
        ...

    def keyboardSingleStep(self) -> int:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#keyboardSingleStep-prop

        **keyboardSingleStep : int**

        sets how far a widget should move or resize when using the keyboard
        arrow keys.

        When in keyboard-interactive mode, you can use the arrow and page keys
        to either move or resize the window. This property controls the arrow
        keys. The common way to enter keyboard interactive mode is to enter the
        subwindow menu, and select either "resize" or "move".

        The default keyboard single step value is 5 pixels.

        **Access functions:**

        int **keyboardSingleStep** () const
        void **setKeyboardSingleStep**
        (int **step** )

        **See also** **keyboardPageStep** .

        **Member Function Documentation**
        """
        ...

    def setKeyboardSingleStep(self, step: int) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#keyboardSingleStep-prop

        **keyboardSingleStep : int**

        sets how far a widget should move or resize when using the keyboard
        arrow keys.

        When in keyboard-interactive mode, you can use the arrow and page keys
        to either move or resize the window. This property controls the arrow
        keys. The common way to enter keyboard interactive mode is to enter the
        subwindow menu, and select either "resize" or "move".

        The default keyboard single step value is 5 pixels.

        **Access functions:**

        int **keyboardSingleStep** () const
        void **setKeyboardSingleStep**
        (int **step** )

        **See also** **keyboardPageStep** .

        **Member Function Documentation**
        """
        ...

    def testOption(self, a0: "QMdiSubWindow.SubWindowOption") -> bool:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#testOption

        **bool QMdiSubWindow::testOption(QMdiSubWindow::SubWindowOption option )
        const**

        Returns `true` if **option** is enabled; otherwise returns `false`.

        **See also** **SubWindowOption**  and **setOption** ().
        """
        ...

    def setOption(
        self, option: "QMdiSubWindow.SubWindowOption", on: bool = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#setOption

        **void QMdiSubWindow::setOption(QMdiSubWindow::SubWindowOption option ,
        bool on = true)**

        If **on** is true, **option** is enabled on the subwindow; otherwise it
        is disabled. See **SubWindowOption**  for the effect of each option.

        **See also** **SubWindowOption**  and **testOption** ().
        """
        ...

    def isShaded(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#isShaded

        **bool QMdiSubWindow::isShaded() const**

        Returns `true` if this window is shaded; otherwise returns `false`.

        A window is shaded if it is collapsed so that only the title bar is
        visible.
        """
        ...

    def widget(self) -> QWidget:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#widget

        **QWidget *QMdiSubWindow::widget() const**

        Returns the current internal widget.

        **See also** **setWidget** ().
        """
        ...

    def setWidget(self, widget: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#setWidget

        **void QMdiSubWindow::setWidget(QWidget * widget )**

        Sets **widget** as the internal widget of this subwindow. The internal
        widget is displayed in the center of the subwindow beneath the title
        bar.

        **QMdiSubWindow**  takes temporary ownership of **widget** ; you do not
        have to delete it. Any existing internal widget will be removed and
        reparented to the root window.

        **See also** **widget** ().
        """
        ...

    def minimumSizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#minimumSizeHint

        **[override virtual] QSize QMdiSubWindow::minimumSizeHint() const**

        Reimplements an access function for property:
        **QWidget::minimumSizeHint** .
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#sizeHint

        **[override virtual] QSize QMdiSubWindow::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .
        """
        ...

    @property
    def aboutToActivate(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#aboutToActivate

        **[signal] void QMdiSubWindow::aboutToActivate()**

        **QMdiSubWindow**  emits this signal immediately before it is activated.
        After the subwindow has been activated, the **QMdiArea**  that manages
        the subwindow will also emit the **subWindowActivated()**  signal.

        **See also** **QMdiArea::subWindowActivated** ().
        """
        ...

    @property
    def windowStateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmdisubwindow.html#windowStateChanged

        **[signal] void QMdiSubWindow::windowStateChanged(Qt::WindowStates
        oldState , Qt::WindowStates newState )**

        **QMdiSubWindow**  emits this signal after the window state changes.
        **oldState** is the window state before it changed, and **newState** is
        the new, current state.
        """
        ...
