"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QListWidgetItem(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qlistwidgetitem.html

    **Detailed Description**

    A QListWidgetItem represents a single item in a **QListWidget** . Each item
    can hold several pieces of information, and will display them appropriately.

    The item view convenience classes use a classic item-based interface rather
    than a pure model/view approach. For a more flexible list view widget,
    consider using the **QListView**  class with a standard model.

    List items can be inserted automatically into a list, when they are
    constructed, by specifying the list widget:

    new **QListWidgetItem** (tr("Hazel"), listWidget);

    Alternatively, list items can also be created without a parent widget, and
    later inserted into a list using **QListWidget::insertItem** ().

    List items are typically used to display **text** () and an **icon** ().
    These are set with the **setText** () and **setIcon** () functions. The
    appearance of the text can be customized with **setFont** (),
    **setForeground** (), and **setBackground** (). Text in list items can be
    aligned using the **setTextAlignment** () function. Tooltips, status tips
    and "What's This?" help can be added to list items with **setToolTip** (),
    **setStatusTip** (), and **setWhatsThis** ().

    By default, items are enabled, selectable, checkable, and can be the source
    of drag and drop operations.

    Each item's flags can be changed by calling **setFlags** () with the
    appropriate value (see **Qt::ItemFlags** ). Checkable items can be checked,
    unchecked and partially checked with the **setCheckState** () function. The
    corresponding **checkState** () function indicates the item's current check
    state.

    The **isHidden** () function can be used to determine whether the item is
    hidden. To hide an item, use **setHidden** ().

    **Subclassing**

    When subclassing QListWidgetItem to provide custom items, it is possible to
    define new types for them enabling them to be distinguished from standard
    items. For subclasses that require this feature, ensure that you call the
    base class constructor with a new type value equal to or greater than
    **UserType** , within **your** constructor.

    **See also** **QListWidget** , **Model/View Programming** ,
    **QTreeWidgetItem** , and **QTableWidgetItem** .
    """

    class ItemType(int):
        Type: QListWidgetItem = ...
        UserType: QListWidgetItem = ...

    @typing.overload
    def __init__(
        self, parent: typing.Optional["QListWidget"] = ..., type: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#QListWidgetItem

        **QListWidgetItem::QListWidgetItem(QListWidget * parent = nullptr, int
        type = Type)**

        Constructs an empty list widget item of the specified **type** with the
        given **parent**. If **parent** is not specified, the item will need to
        be inserted into a list widget with **QListWidget::insertItem** ().

        This constructor inserts the item into the model of the parent that is
        passed to the constructor. If the model is sorted then the behavior of
        the insert is undetermined since the model will call the `'<'` operator
        method on the item which, at this point, is not yet constructed. To
        avoid the undetermined behavior, we recommend not to specify the parent
        and use **QListWidget::insertItem** () instead.

        **See also** **type** ().
        """
        ...

    @typing.overload
    def __init__(
        self, text: str, parent: typing.Optional["QListWidget"] = ..., type: int = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#QListWidgetItem-1

        **QListWidgetItem::QListWidgetItem(const QString & text , QListWidget *
        parent = nullptr, int type = Type)**

        Constructs an empty list widget item of the specified **type** with the
        given **text** and **parent**. If the parent is not specified, the item
        will need to be inserted into a list widget with
        **QListWidget::insertItem** ().

        This constructor inserts the item into the model of the parent that is
        passed to the constructor. If the model is sorted then the behavior of
        the insert is undetermined since the model will call the `'<'` operator
        method on the item which, at this point, is not yet constructed. To
        avoid the undetermined behavior, we recommend not to specify the parent
        and use **QListWidget::insertItem** () instead.

        **See also** **type** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        icon: QtGui.QIcon,
        text: str,
        parent: typing.Optional["QListWidget"] = ...,
        type: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#QListWidgetItem-2

        **QListWidgetItem::QListWidgetItem(const QIcon & icon , const QString &
        text , QListWidget * parent = nullptr, int type = Type)**

        Constructs an empty list widget item of the specified **type** with the
        given **icon** , **text** and **parent**. If the parent is not
        specified, the item will need to be inserted into a list widget with
        **QListWidget::insertItem** ().

        This constructor inserts the item into the model of the parent that is
        passed to the constructor. If the model is sorted then the behavior of
        the insert is undetermined since the model will call the `'<'` operator
        method on the item which, at this point, is not yet constructed. To
        avoid the undetermined behavior, we recommend not to specify the parent
        and use **QListWidget::insertItem** () instead.

        **See also** **type** ().
        """
        ...

    @typing.overload
    def __init__(self, other: "QListWidgetItem") -> None:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#QListWidgetItem-3

        **QListWidgetItem::QListWidgetItem(const QListWidgetItem & other )**

        Constructs a copy of **other**. Note that **type** () and **listWidget**
        () are not copied.

        This function is useful when reimplementing **clone** ().

        This function was introduced in Qt 4.1.

        **See also** **data** () and **flags** ().
        """
        ...

    def isHidden(self) -> bool:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#isHidden

        **bool QListWidgetItem::isHidden() const**

        Returns `true` if the item is hidden; otherwise returns `false`.

        This function was introduced in Qt 4.2.

        **See also** **setHidden** ().
        """
        ...

    def setHidden(self, ahide: bool) -> None:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#setHidden

        **void QListWidgetItem::setHidden(bool hide )**

        Hides the item if **hide** is true; otherwise shows the item.

        This function was introduced in Qt 4.2.

        **See also** **isHidden** ().
        """
        ...

    def isSelected(self) -> bool:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#isSelected

        **bool QListWidgetItem::isSelected() const**

        Returns `true` if the item is selected; otherwise returns `false`.

        This function was introduced in Qt 4.2.

        **See also** **setSelected** ().
        """
        ...

    def setSelected(self, aselect: bool) -> None:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#setSelected

        **void QListWidgetItem::setSelected(bool select )**

        Sets the selected state of the item to **select**.

        This function was introduced in Qt 4.2.

        **See also** **isSelected** ().
        """
        ...

    def setForeground(
        self,
        brush: typing.Union[
            QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#setForeground

        **void QListWidgetItem::setForeground(const QBrush & brush )**

        Sets the foreground brush of the list item to the given **brush**.
        Setting a default-constructed brush will let the view use the default
        color from the style.

        This function was introduced in Qt 4.2.

        **See also** **foreground** () and **setBackground** ().
        """
        ...

    def foreground(self) -> QtGui.QBrush:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#foreground

        **QBrush QListWidgetItem::foreground() const**

        Returns the brush used to display the list item's foreground (e.g.
        text).

        This function was introduced in Qt 4.2.

        **See also** **setForeground** () and **background** ().
        """
        ...

    def setBackground(
        self,
        brush: typing.Union[
            QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#setBackground

        **void QListWidgetItem::setBackground(const QBrush & brush )**

        Sets the background brush of the list item to the given **brush**.
        Setting a default-constructed brush will let the view use the default
        color from the style.

        This function was introduced in Qt 4.2.

        **See also** **background** () and **setForeground** ().
        """
        ...

    def background(self) -> QtGui.QBrush:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#background

        **QBrush QListWidgetItem::background() const**

        Returns the brush used to display the list item's background.

        This function was introduced in Qt 4.2.

        **See also** **setBackground** () and **foreground** ().
        """
        ...

    def setFont(self, afont: QtGui.QFont) -> None:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#setFont

        **void QListWidgetItem::setFont(const QFont & font )**

        Sets the font used when painting the item to the given **font**.

        **See also** **font** ().
        """
        ...

    def setWhatsThis(self, awhatsThis: str) -> None:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#setWhatsThis

        **void QListWidgetItem::setWhatsThis(const QString & whatsThis )**

        Sets the "What's This?" help for the list item to the text specified by
        **whatsThis**.

        **See also** **whatsThis** (), **setStatusTip** (), and **setToolTip**
        ().
        """
        ...

    def setToolTip(self, atoolTip: str) -> None:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#setToolTip

        **void QListWidgetItem::setToolTip(const QString & toolTip )**

        Sets the tooltip for the list item to the text specified by **toolTip**.

        **See also** **toolTip** (), **setStatusTip** (), and **setWhatsThis**
        ().
        """
        ...

    def setStatusTip(self, astatusTip: str) -> None:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#setStatusTip

        **void QListWidgetItem::setStatusTip(const QString & statusTip )**

        Sets the status tip for the list item to the text specified by
        **statusTip**. **QListWidget**  mouseTracking needs to be enabled for
        this feature to work.

        **See also** **statusTip** (), **setToolTip** (), **setWhatsThis** (),
        and **QWidget::setMouseTracking** ().
        """
        ...

    def setIcon(self, aicon: QtGui.QIcon) -> None:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#setIcon

        **void QListWidgetItem::setIcon(const QIcon & icon )**

        Sets the icon for the list item to the given **icon**.

        **See also** **icon** (), **text** (), and **iconSize** .
        """
        ...

    def setText(self, atext: str) -> None:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#setText

        **void QListWidgetItem::setText(const QString & text )**

        Sets the text for the list widget item's to the given **text**.

        **See also** **text** ().
        """
        ...

    def setFlags(
        self, aflags: typing.Union[QtCore.Qt.ItemFlags, QtCore.Qt.ItemFlag]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#setFlags

        **void QListWidgetItem::setFlags(Qt::ItemFlags flags )**

        Sets the item flags for the list item to **flags**.

        **See also** **flags** () and **Qt::ItemFlags** .
        """
        ...

    def type(self) -> int:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#type

        **int QListWidgetItem::type() const**

        Returns the type passed to the **QListWidgetItem**  constructor.
        """
        ...

    def write(self, out: QtCore.QDataStream) -> None:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#write

        **[virtual] void QListWidgetItem::write(QDataStream & out ) const**

        Writes the item to stream **out**.

        **See also** **read** ().
        """
        ...

    def read(self, in_: QtCore.QDataStream) -> None:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#read

        **[virtual] void QListWidgetItem::read(QDataStream & in )**

        Reads the item from stream **in**.

        **See also** **write** ().
        """
        ...

    def setData(self, role: int, value: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#setData

        **[virtual] void QListWidgetItem::setData(int role , const QVariant &
        value )**

        Sets the data for a given **role** to the given **value**. Reimplement
        this function if you need extra roles or special behavior for certain
        roles.

        **Note:** The default implementation treats **Qt::EditRole**  and
        **Qt::DisplayRole**  as referring to the same data.

        **See also** **Qt::ItemDataRole**  and **data** ().
        """
        ...

    def data(self, role: int) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#data

        **[virtual] QVariant QListWidgetItem::data(int role ) const**

        Returns the item's data for a given **role**. Reimplement this function
        if you need extra roles or special behavior for certain roles.

        **See also** **Qt::ItemDataRole**  and **setData** ().
        """
        ...

    def setSizeHint(self, size: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#setSizeHint

        **void QListWidgetItem::setSizeHint(const QSize & size )**

        Sets the size hint for the list item to be **size**. If no size hint is
        set or **size** is invalid, the item delegate will compute the size hint
        based on the item data.

        This function was introduced in Qt 4.1.

        **See also** **sizeHint** ().
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#sizeHint

        **QSize QListWidgetItem::sizeHint() const**

        Returns the size hint set for the list item.

        This function was introduced in Qt 4.1.

        **See also** **setSizeHint** ().
        """
        ...

    def setCheckState(self, state: QtCore.Qt.CheckState) -> None:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#setCheckState

        **void QListWidgetItem::setCheckState(Qt::CheckState state )**

        Sets the check state of the list item to **state**.

        **See also** **checkState** ().
        """
        ...

    def checkState(self) -> QtCore.Qt.CheckState:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#checkState

        **Qt::CheckState QListWidgetItem::checkState() const**

        Returns the checked state of the list item (see **Qt::CheckState** ).

        **See also** **setCheckState** () and **flags** ().
        """
        ...

    def setTextAlignment(self, alignment: int) -> None:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#setTextAlignment

        **void QListWidgetItem::setTextAlignment(int alignment )**

        Sets the list item's text alignment to **alignment**.

        **See also** **textAlignment** () and **Qt::AlignmentFlag** .
        """
        ...

    def textAlignment(self) -> int:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#textAlignment

        **int QListWidgetItem::textAlignment() const**

        Returns the text alignment for the list item.

        **See also** **setTextAlignment** () and **Qt::AlignmentFlag** .
        """
        ...

    def font(self) -> QtGui.QFont:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#font

        **QFont QListWidgetItem::font() const**

        Returns the font used to display this list item's text.

        **See also** **setFont** ().
        """
        ...

    def whatsThis(self) -> str:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#whatsThis

        **QString QListWidgetItem::whatsThis() const**

        Returns the list item's "What's This?" help text.

        **See also** **setWhatsThis** (), **statusTip** (), and **toolTip** ().
        """
        ...

    def toolTip(self) -> str:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#toolTip

        **QString QListWidgetItem::toolTip() const**

        Returns the list item's tooltip.

        **See also** **setToolTip** (), **statusTip** (), and **whatsThis** ().
        """
        ...

    def statusTip(self) -> str:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#statusTip

        **QString QListWidgetItem::statusTip() const**

        Returns the list item's status tip.

        **See also** **setStatusTip** ().
        """
        ...

    def icon(self) -> QtGui.QIcon:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#icon

        **QIcon QListWidgetItem::icon() const**

        Returns the list item's icon.

        **See also** **setIcon** () and **iconSize** .
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#text

        **QString QListWidgetItem::text() const**

        Returns the list item's text.

        **See also** **setText** ().
        """
        ...

    def flags(self) -> QtCore.Qt.ItemFlags:
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#flags

        **Qt::ItemFlags QListWidgetItem::flags() const**

        Returns the item flags for this item (see **Qt::ItemFlags** ).

        **See also** **setFlags** ().
        """
        ...

    def listWidget(self) -> "QListWidget":
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#listWidget

        **QListWidget *QListWidgetItem::listWidget() const**

        Returns the list widget containing the item.
        """
        ...

    def clone(self) -> "QListWidgetItem":
        """
        https://doc.qt.io/qt-5/qlistwidgetitem.html#clone

        **[virtual] QListWidgetItem *QListWidgetItem::clone() const**

        Creates an exact copy of the item.
        """
        ...
