"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QListView(QAbstractItemView):
    """
    https://doc.qt.io/qt-5/qlistview.html

    **Detailed Description**

    ![](images/windows-listview.png)

    A QListView presents items stored in a model, either as a simple non-
    hierarchical list, or as a collection of icons. This class is used to
    provide lists and icon views that were previously provided by the `QListBox`
    and `QIconView` classes, but using the more flexible approach provided by
    Qt's model/view architecture.

    The QListView class is one of the **Model/View Classes**  and is part of
    Qt's **model/view framework** .

    This view does not display horizontal or vertical headers; to display a list
    of items with a horizontal header, use **QTreeView**  instead.

    QListView implements the interfaces defined by the **QAbstractItemView**
    class to allow it to display data provided by models derived from the
    **QAbstractItemModel**  class.

    Items in a list view can be displayed using one of two view modes: In
    **ListMode** , the items are displayed in the form of a simple list; in
    **IconMode** , the list view takes the form of an **icon view** in which the
    items are displayed with icons like files in a file manager. By default, the
    list view is in **ListMode** . To change the view mode, use the
    **setViewMode** () function, and to determine the current view mode, use
    **viewMode** ().

    Items in these views are laid out in the direction specified by the **flow**
    () of the list view. The items may be fixed in place, or allowed to move,
    depending on the view's **movement** () state.

    If the items in the model cannot be completely laid out in the direction of
    flow, they can be wrapped at the boundary of the view widget; this depends
    on **isWrapping** (). This property is useful when the items are being
    represented by an icon view.

    The **resizeMode** () and **layoutMode** () govern how and when the items
    are laid out. Items are spaced according to their **spacing** (), and can
    exist within a notional grid of size specified by **gridSize** (). The items
    can be rendered as large or small icons depending on their **iconSize** ().

    **Improving Performance**

    It is possible to give the view hints about the data it is handling in order
    to improve its performance when displaying large numbers of items. One
    approach that can be taken for views that are intended to display items with
    equal sizes is to set the **uniformItemSizes**  property to true.

    **See also** **View Classes** , **Item Views Puzzle Example** ,
    **QTreeView** , **QTableView** , and **QListWidget** .
    """

    class ViewMode(int):
        ListMode: QListView = ...
        IconMode: QListView = ...

    class LayoutMode(int):
        SinglePass: QListView = ...
        Batched: QListView = ...

    class ResizeMode(int):
        Fixed: QListView = ...
        Adjust: QListView = ...

    class Flow(int):
        LeftToRight: QListView = ...
        TopToBottom: QListView = ...

    class Movement(int):
        Static: QListView = ...
        Free: QListView = ...
        Snap: QListView = ...

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#QListView

        **QListView::QListView(QWidget * parent = nullptr)**

        Creates a new QListView with the given **parent** to view a model. Use
        **setModel** () to set the model.
        """
        ...

    def itemAlignment(self) -> QtCore.Qt.Alignment:
        """
        https://doc.qt.io/qt-5/qlistview.html#itemAlignment-prop

        **itemAlignment : Qt::Alignment**

        This property holds the alignment of each item in its cell

        This is only supported in **ListMode**  with **TopToBottom**  flow and
        with wrapping enabled. The default alignment is 0, which means that an
        item fills its cell entirely.

        This property was introduced in Qt 5.12.

        **Access functions:**

        Qt::Alignment **itemAlignment** () const
        void **setItemAlignment**
        (Qt::Alignment **alignment** )
        """
        ...

    def setItemAlignment(
        self, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#itemAlignment-prop

        **itemAlignment : Qt::Alignment**

        This property holds the alignment of each item in its cell

        This is only supported in **ListMode**  with **TopToBottom**  flow and
        with wrapping enabled. The default alignment is 0, which means that an
        item fills its cell entirely.

        This property was introduced in Qt 5.12.

        **Access functions:**

        Qt::Alignment **itemAlignment** () const
        void **setItemAlignment**
        (Qt::Alignment **alignment** )
        """
        ...

    def currentChanged(
        self, current: QtCore.QModelIndex, previous: QtCore.QModelIndex
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#currentChanged

        **[override virtual protected] void QListView::currentChanged(const
        QModelIndex & current , const QModelIndex & previous )**

        Reimplements: **QAbstractItemView::currentChanged** (const QModelIndex
        &current, const QModelIndex &previous).
        """
        ...

    def selectionChanged(
        self, selected: QtCore.QItemSelection, deselected: QtCore.QItemSelection
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#selectionChanged

        **[override virtual protected] void QListView::selectionChanged(const
        QItemSelection & selected , const QItemSelection & deselected )**

        Reimplements: **QAbstractItemView::selectionChanged** (const
        QItemSelection &selected, const QItemSelection &deselected).
        """
        ...

    def isSelectionRectVisible(self) -> bool:
        ...

    def setSelectionRectVisible(self, show: bool) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#selectionRectVisible-prop

        **selectionRectVisible : bool**

        if the selection rectangle should be visible

        If this property is `true` then the selection rectangle is visible;
        otherwise it will be hidden.

        **Note:** The selection rectangle will only be visible if the selection
        mode is in a mode where more than one item can be selected; i.e., it
        will not draw a selection rectangle if the selection mode is
        **QAbstractItemView::SingleSelection** .

        By default, this property is `false`.

        This property was introduced in Qt 4.3.

        **Access functions:**

        bool **isSelectionRectVisible** () const
        void
        **setSelectionRectVisible** (bool **show** )
        """
        ...

    def wordWrap(self) -> bool:
        """
        https://doc.qt.io/qt-5/qlistview.html#wordWrap-prop

        **wordWrap : bool**

        This property holds the item text word-wrapping policy

        If this property is `true` then the item text is wrapped where necessary
        at word-breaks; otherwise it is not wrapped at all. This property is
        `false` by default.

        Please note that even if wrapping is enabled, the cell will not be
        expanded to make room for the text. It will print ellipsis for text that
        cannot be shown, according to the view's **textElideMode** .

        This property was introduced in Qt 4.2.

        **Access functions:**

        bool **wordWrap** () const
        void **setWordWrap** (bool **on** )

        **Member Function Documentation**
        """
        ...

    def setWordWrap(self, on: bool) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#wordWrap-prop

        **wordWrap : bool**

        This property holds the item text word-wrapping policy

        If this property is `true` then the item text is wrapped where necessary
        at word-breaks; otherwise it is not wrapped at all. This property is
        `false` by default.

        Please note that even if wrapping is enabled, the cell will not be
        expanded to make room for the text. It will print ellipsis for text that
        cannot be shown, according to the view's **textElideMode** .

        This property was introduced in Qt 4.2.

        **Access functions:**

        bool **wordWrap** () const
        void **setWordWrap** (bool **on** )

        **Member Function Documentation**
        """
        ...

    def batchSize(self) -> int:
        """
        https://doc.qt.io/qt-5/qlistview.html#batchSize-prop

        **batchSize : int**

        This property holds the number of items laid out in each batch if
        **layoutMode**  is set to **Batched**

        The default value is 100.

        This property was introduced in Qt 4.2.

        **Access functions:**

        int **batchSize** () const
        void **setBatchSize** (int **batchSize** )
        """
        ...

    def setBatchSize(self, batchSize: int) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#batchSize-prop

        **batchSize : int**

        This property holds the number of items laid out in each batch if
        **layoutMode**  is set to **Batched**

        The default value is 100.

        This property was introduced in Qt 4.2.

        **Access functions:**

        int **batchSize** () const
        void **setBatchSize** (int **batchSize** )
        """
        ...

    def viewportSizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qlistview.html#viewportSizeHint

        **[override virtual protected] QSize QListView::viewportSizeHint()
        const**

        Reimplements: **QAbstractItemView::viewportSizeHint** () const.

        This function was introduced in Qt 5.2.
        """
        ...

    def isIndexHidden(self, index: QtCore.QModelIndex) -> bool:
        """
        https://doc.qt.io/qt-5/qlistview.html#isIndexHidden

        **[override virtual protected] bool QListView::isIndexHidden(const
        QModelIndex & index ) const**

        Reimplements: **QAbstractItemView::isIndexHidden** (const QModelIndex
        &index) const.
        """
        ...

    def updateGeometries(self) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#updateGeometries

        **[override virtual protected] void QListView::updateGeometries()**

        Reimplements: **QAbstractItemView::updateGeometries** ().
        """
        ...

    def selectedIndexes(self) -> typing.List[QtCore.QModelIndex]:
        """
        https://doc.qt.io/qt-5/qlistview.html#selectedIndexes

        **[override virtual protected] QModelIndexList
        QListView::selectedIndexes() const**

        Reimplements: **QAbstractItemView::selectedIndexes** () const.
        """
        ...

    def visualRegionForSelection(
        self, selection: QtCore.QItemSelection
    ) -> QtGui.QRegion:
        """
        https://doc.qt.io/qt-5/qlistview.html#visualRegionForSelection

        **[override virtual protected] QRegion
        QListView::visualRegionForSelection(const QItemSelection & selection )
        const**

        Reimplements: **QAbstractItemView::visualRegionForSelection** (const
        QItemSelection &selection) const.

        Since 4.7, the returned region only contains rectangles intersecting (or
        included in) the viewport.
        """
        ...

    def setSelection(
        self,
        rect: QtCore.QRect,
        command: typing.Union[
            QtCore.QItemSelectionModel.SelectionFlags,
            QtCore.QItemSelectionModel.SelectionFlag,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#setSelection

        **[override virtual protected] void QListView::setSelection(const QRect
        & rect , QItemSelectionModel::SelectionFlags command )**

        Reimplements: **QAbstractItemView::setSelection** (const QRect &rect,
        QItemSelectionModel::SelectionFlags flags).
        """
        ...

    def setPositionForIndex(
        self, position: QtCore.QPoint, index: QtCore.QModelIndex
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#setPositionForIndex

        **[protected] void QListView::setPositionForIndex(const QPoint &
        position , const QModelIndex & index )**

        Sets the contents position of the item at **index** in the model to the
        given **position**. If the list view's movement mode is Static or its
        view mode is **ListView** , this function will have no effect.

        This function was introduced in Qt 4.1.
        """
        ...

    def rectForIndex(self, index: QtCore.QModelIndex) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qlistview.html#rectForIndex

        **[protected] QRect QListView::rectForIndex(const QModelIndex & index )
        const**

        Returns the rectangle of the item at position **index** in the model.
        The rectangle is in contents coordinates.

        **See also** **visualRect** ().
        """
        ...

    def moveCursor(
        self,
        cursorAction: QAbstractItemView.CursorAction,
        modifiers: typing.Union[
            QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier
        ],
    ) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-5/qlistview.html#moveCursor

        **[override virtual protected] QModelIndex
        QListView::moveCursor(QAbstractItemView::CursorAction cursorAction ,
        Qt::KeyboardModifiers modifiers )**

        Reimplements: **QAbstractItemView::moveCursor**
        (QAbstractItemView::CursorAction cursorAction, Qt::KeyboardModifiers
        modifiers).
        """
        ...

    def verticalOffset(self) -> int:
        """
        https://doc.qt.io/qt-5/qlistview.html#verticalOffset

        **[override virtual protected] int QListView::verticalOffset() const**

        Reimplements: **QAbstractItemView::verticalOffset** () const.
        """
        ...

    def horizontalOffset(self) -> int:
        """
        https://doc.qt.io/qt-5/qlistview.html#horizontalOffset

        **[override virtual protected] int QListView::horizontalOffset() const**

        Reimplements: **QAbstractItemView::horizontalOffset** () const.
        """
        ...

    def paintEvent(self, e: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#paintEvent

        **[override virtual protected] void QListView::paintEvent(QPaintEvent *
        e )**

        Reimplements: **QAbstractScrollArea::paintEvent** (QPaintEvent *event).
        """
        ...

    def viewOptions(self) -> "QStyleOptionViewItem":
        """
        https://doc.qt.io/qt-5/qlistview.html#viewOptions

        **[override virtual protected] QStyleOptionViewItem
        QListView::viewOptions() const**

        Reimplements: **QAbstractItemView::viewOptions** () const.
        """
        ...

    def startDrag(
        self,
        supportedActions: typing.Union[QtCore.Qt.DropActions, QtCore.Qt.DropAction],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#startDrag

        **[override virtual protected] void QListView::startDrag(Qt::DropActions
        supportedActions )**

        Reimplements: **QAbstractItemView::startDrag** (Qt::DropActions
        supportedActions).
        """
        ...

    def wheelEvent(self, e: QtGui.QWheelEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#wheelEvent

        **[override virtual protected] void QListView::wheelEvent(QWheelEvent *
        e )**

        Reimplements: **QAbstractScrollArea::wheelEvent** (QWheelEvent *e).
        """
        ...

    def dropEvent(self, e: QtGui.QDropEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#dropEvent

        **[override virtual protected] void QListView::dropEvent(QDropEvent *
        event )**

        Reimplements: **QAbstractItemView::dropEvent** (QDropEvent *event).
        """
        ...

    def dragLeaveEvent(self, e: QtGui.QDragLeaveEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#dragLeaveEvent

        **[override virtual protected] void
        QListView::dragLeaveEvent(QDragLeaveEvent * e )**

        Reimplements: **QAbstractItemView::dragLeaveEvent** (QDragLeaveEvent
        *event).
        """
        ...

    def dragMoveEvent(self, e: QtGui.QDragMoveEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#dragMoveEvent

        **[override virtual protected] void
        QListView::dragMoveEvent(QDragMoveEvent * e )**

        Reimplements: **QAbstractItemView::dragMoveEvent** (QDragMoveEvent
        *event).
        """
        ...

    def resizeEvent(self, e: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#resizeEvent

        **[override virtual protected] void QListView::resizeEvent(QResizeEvent
        * e )**

        Reimplements: **QAbstractItemView::resizeEvent** (QResizeEvent *event).
        """
        ...

    def timerEvent(self, e: QtCore.QTimerEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#timerEvent

        **[override virtual protected] void QListView::timerEvent(QTimerEvent *
        e )**

        Reimplements: **QAbstractItemView::timerEvent** (QTimerEvent *event).
        """
        ...

    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#mouseReleaseEvent

        **[override virtual protected] void
        QListView::mouseReleaseEvent(QMouseEvent * e )**

        Reimplements: **QAbstractItemView::mouseReleaseEvent** (QMouseEvent
        *event).
        """
        ...

    def mouseMoveEvent(self, e: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#mouseMoveEvent

        **[override virtual protected] void
        QListView::mouseMoveEvent(QMouseEvent * e )**

        Reimplements: **QAbstractItemView::mouseMoveEvent** (QMouseEvent
        *event).
        """
        ...

    def event(self, e: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qlistview.html#event

        **[override virtual protected] bool QListView::event(QEvent * e )**

        Reimplements: **QAbstractItemView::event** (QEvent *event).
        """
        ...

    def rowsAboutToBeRemoved(
        self, parent: QtCore.QModelIndex, start: int, end: int
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#rowsAboutToBeRemoved

        **[override virtual protected] void
        QListView::rowsAboutToBeRemoved(const QModelIndex & parent , int start ,
        int end )**

        Reimplements: **QAbstractItemView::rowsAboutToBeRemoved** (const
        QModelIndex &parent, int start, int end).
        """
        ...

    def rowsInserted(self, parent: QtCore.QModelIndex, start: int, end: int) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#rowsInserted

        **[override virtual protected] void QListView::rowsInserted(const
        QModelIndex & parent , int start , int end )**

        Reimplements: **QAbstractItemView::rowsInserted** (const QModelIndex
        &parent, int start, int end).
        """
        ...

    def dataChanged(
        self,
        topLeft: QtCore.QModelIndex,
        bottomRight: QtCore.QModelIndex,
        roles: typing.Iterable[int] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#dataChanged

        **[override virtual protected] void QListView::dataChanged(const
        QModelIndex & topLeft , const QModelIndex & bottomRight , const
        QVector<int> & roles = QVector<int>())**

        Reimplements: **QAbstractItemView::dataChanged** (const QModelIndex
        &topLeft, const QModelIndex &bottomRight, const QVector<int> &roles).
        """
        ...

    def scrollContentsBy(self, dx: int, dy: int) -> None:
        ...

    def setRootIndex(self, index: QtCore.QModelIndex) -> None:
        ...

    def reset(self) -> None:
        ...

    def indexAt(self, p: QtCore.QPoint) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-5/qlistview.html#indexAt

        **[override virtual] QModelIndex QListView::indexAt(const QPoint & p )
        const**

        Reimplements: **QAbstractItemView::indexAt** (const QPoint &point)
        const.
        """
        ...

    def scrollTo(
        self, index: QtCore.QModelIndex, hint: QAbstractItemView.ScrollHint = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#scrollTo

        **[override virtual] void QListView::scrollTo(const QModelIndex & index
        , QAbstractItemView::ScrollHint hint = EnsureVisible)**

        Reimplements: **QAbstractItemView::scrollTo** (const QModelIndex &index,
        QAbstractItemView::ScrollHint hint).
        """
        ...

    def visualRect(self, index: QtCore.QModelIndex) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qlistview.html#visualRect

        **[override virtual] QRect QListView::visualRect(const QModelIndex &
        index ) const**

        Reimplements: **QAbstractItemView::visualRect** (const QModelIndex
        &index) const.
        """
        ...

    def uniformItemSizes(self) -> bool:
        """
        https://doc.qt.io/qt-5/qlistview.html#uniformItemSizes-prop

        **uniformItemSizes : bool**

        This property holds whether all items in the listview have the same size

        This property should only be set to true if it is guaranteed that all
        items in the view have the same size. This enables the view to do some
        optimizations for performance purposes.

        By default, this property is `false`.

        This property was introduced in Qt 4.1.

        **Access functions:**

        bool **uniformItemSizes** () const
        void **setUniformItemSizes** (bool
        **enable** )
        """
        ...

    def setUniformItemSizes(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#uniformItemSizes-prop

        **uniformItemSizes : bool**

        This property holds whether all items in the listview have the same size

        This property should only be set to true if it is guaranteed that all
        items in the view have the same size. This enables the view to do some
        optimizations for performance purposes.

        By default, this property is `false`.

        This property was introduced in Qt 4.1.

        **Access functions:**

        bool **uniformItemSizes** () const
        void **setUniformItemSizes** (bool
        **enable** )
        """
        ...

    def modelColumn(self) -> int:
        """
        https://doc.qt.io/qt-5/qlistview.html#modelColumn-prop

        **modelColumn : int**

        This property holds the column in the model that is visible

        By default, this property contains 0, indicating that the first column
        in the model will be shown.

        **Access functions:**

        int **modelColumn** () const
        void **setModelColumn** (int **column** )
        """
        ...

    def setModelColumn(self, column: int) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#modelColumn-prop

        **modelColumn : int**

        This property holds the column in the model that is visible

        By default, this property contains 0, indicating that the first column
        in the model will be shown.

        **Access functions:**

        int **modelColumn** () const
        void **setModelColumn** (int **column** )
        """
        ...

    def setRowHidden(self, row: int, hide: bool) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#setRowHidden

        **void QListView::setRowHidden(int row , bool hide )**

        If **hide** is true, the given **row** will be hidden; otherwise the
        **row** will be shown.

        **See also** **isRowHidden** ().
        """
        ...

    def isRowHidden(self, row: int) -> bool:
        """
        https://doc.qt.io/qt-5/qlistview.html#isRowHidden

        **bool QListView::isRowHidden(int row ) const**

        Returns `true` if the **row** is hidden; otherwise returns `false`.
        """
        ...

    def clearPropertyFlags(self) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#clearPropertyFlags

        **void QListView::clearPropertyFlags()**

        Clears the **QListView** -specific property flags. See **viewMode** .

        Properties inherited from **QAbstractItemView**  are not covered by the
        property flags. Specifically, **dragEnabled**  and **acceptsDrops**  are
        computed by **QListView**  when calling **setMovement** () or
        **setViewMode** ().
        """
        ...

    def viewMode(self) -> "QListView.ViewMode":
        """
        https://doc.qt.io/qt-5/qlistview.html#viewMode-prop

        **viewMode : ViewMode**

        This property holds the view mode of the **QListView** .

        This property will change the other unset properties to conform with the
        set view mode. **QListView** -specific properties that have already been
        set will not be changed, unless **clearPropertyFlags** () has been
        called.

        Setting the view mode will enable or disable drag and drop based on the
        selected movement. For **ListMode** , the default movement is **Static**
        (drag and drop disabled); for **IconMode** , the default movement is
        **Free**  (drag and drop enabled).

        **Access functions:**

        QListView::ViewMode **viewMode** () const
        void **setViewMode**
        (QListView::ViewMode **mode** )

        **See also** **isWrapping** , **spacing** , **gridSize** , **flow** ,
        **movement** , and **resizeMode** .
        """
        ...

    def setViewMode(self, mode: "QListView.ViewMode") -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#viewMode-prop

        **viewMode : ViewMode**

        This property holds the view mode of the **QListView** .

        This property will change the other unset properties to conform with the
        set view mode. **QListView** -specific properties that have already been
        set will not be changed, unless **clearPropertyFlags** () has been
        called.

        Setting the view mode will enable or disable drag and drop based on the
        selected movement. For **ListMode** , the default movement is **Static**
        (drag and drop disabled); for **IconMode** , the default movement is
        **Free**  (drag and drop enabled).

        **Access functions:**

        QListView::ViewMode **viewMode** () const
        void **setViewMode**
        (QListView::ViewMode **mode** )

        **See also** **isWrapping** , **spacing** , **gridSize** , **flow** ,
        **movement** , and **resizeMode** .
        """
        ...

    def gridSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qlistview.html#gridSize-prop

        **gridSize : QSize**

        This property holds the size of the layout grid

        This property is the size of the grid in which the items are laid out.
        The default is an empty size which means that there is no grid and the
        layout is not done in a grid. Setting this property to a non-empty size
        switches on the grid layout. (When a grid layout is in force the
        **spacing**  property is ignored.)

        Setting this property when the view is visible will cause the items to
        be laid out again.

        **Access functions:**

        QSize **gridSize** () const
        void **setGridSize** (const QSize &
        **size** )

        **See also** **viewMode** .
        """
        ...

    def setGridSize(self, size: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#gridSize-prop

        **gridSize : QSize**

        This property holds the size of the layout grid

        This property is the size of the grid in which the items are laid out.
        The default is an empty size which means that there is no grid and the
        layout is not done in a grid. Setting this property to a non-empty size
        switches on the grid layout. (When a grid layout is in force the
        **spacing**  property is ignored.)

        Setting this property when the view is visible will cause the items to
        be laid out again.

        **Access functions:**

        QSize **gridSize** () const
        void **setGridSize** (const QSize &
        **size** )

        **See also** **viewMode** .
        """
        ...

    def spacing(self) -> int:
        """
        https://doc.qt.io/qt-5/qlistview.html#spacing-prop

        **spacing : int**

        This property holds the space around the items in the layout

        This property is the size of the empty space that is padded around an
        item in the layout.

        Setting this property when the view is visible will cause the items to
        be laid out again.

        By default, this property contains a value of 0.

        **Access functions:**

        int **spacing** () const
        void **setSpacing** (int **space** )

        **See also** **viewMode** .
        """
        ...

    def setSpacing(self, space: int) -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#spacing-prop

        **spacing : int**

        This property holds the space around the items in the layout

        This property is the size of the empty space that is padded around an
        item in the layout.

        Setting this property when the view is visible will cause the items to
        be laid out again.

        By default, this property contains a value of 0.

        **Access functions:**

        int **spacing** () const
        void **setSpacing** (int **space** )

        **See also** **viewMode** .
        """
        ...

    def layoutMode(self) -> "QListView.LayoutMode":
        """
        https://doc.qt.io/qt-5/qlistview.html#layoutMode-prop

        **layoutMode : LayoutMode**

        determines whether the layout of items should happen immediately or be
        delayed.

        This property holds the layout mode for the items. When the mode is
        **SinglePass**  (the default), the items are laid out all in one go.
        When the mode is **Batched** , the items are laid out in batches of
        **batchSize**  items, while processing events. This makes it possible to
        instantly view and interact with the visible items while the rest are
        being laid out.

        **Access functions:**

        QListView::LayoutMode **layoutMode** () const
        void **setLayoutMode**
        (QListView::LayoutMode **mode** )

        **See also** **viewMode** .
        """
        ...

    def setLayoutMode(self, mode: "QListView.LayoutMode") -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#layoutMode-prop

        **layoutMode : LayoutMode**

        determines whether the layout of items should happen immediately or be
        delayed.

        This property holds the layout mode for the items. When the mode is
        **SinglePass**  (the default), the items are laid out all in one go.
        When the mode is **Batched** , the items are laid out in batches of
        **batchSize**  items, while processing events. This makes it possible to
        instantly view and interact with the visible items while the rest are
        being laid out.

        **Access functions:**

        QListView::LayoutMode **layoutMode** () const
        void **setLayoutMode**
        (QListView::LayoutMode **mode** )

        **See also** **viewMode** .
        """
        ...

    def resizeMode(self) -> "QListView.ResizeMode":
        """
        https://doc.qt.io/qt-5/qlistview.html#resizeMode-prop

        **resizeMode : ResizeMode**

        This property holds whether the items are laid out again when the view
        is resized.

        If this property is **Adjust** , the items will be laid out again when
        the view is resized. If the value is **Fixed** , the items will not be
        laid out when the view is resized.

        By default, this property is set to **Fixed** .

        **Access functions:**

        QListView::ResizeMode **resizeMode** () const
        void **setResizeMode**
        (QListView::ResizeMode **mode** )

        **See also** **movement** , **gridSize** , and **viewMode** .
        """
        ...

    def setResizeMode(self, mode: "QListView.ResizeMode") -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#resizeMode-prop

        **resizeMode : ResizeMode**

        This property holds whether the items are laid out again when the view
        is resized.

        If this property is **Adjust** , the items will be laid out again when
        the view is resized. If the value is **Fixed** , the items will not be
        laid out when the view is resized.

        By default, this property is set to **Fixed** .

        **Access functions:**

        QListView::ResizeMode **resizeMode** () const
        void **setResizeMode**
        (QListView::ResizeMode **mode** )

        **See also** **movement** , **gridSize** , and **viewMode** .
        """
        ...

    def isWrapping(self) -> bool:
        """
        https://doc.qt.io/qt-5/qlistview.html#isWrapping-prop

        **isWrapping : bool**

        This property holds whether the items layout should wrap.

        This property holds whether the layout should wrap when there is no more
        space in the visible area. The point at which the layout wraps depends
        on the **flow**  property.

        Setting this property when the view is visible will cause the items to
        be laid out again.

        By default, this property is `false`.

        **Access functions:**

        bool **isWrapping** () const
        void **setWrapping** (bool **enable** )

        **See also** **viewMode** .
        """
        ...

    def setWrapping(self, enable: bool) -> None:
        ...

    def flow(self) -> "QListView.Flow":
        """
        https://doc.qt.io/qt-5/qlistview.html#flow-prop

        **flow : Flow**

        This property holds which direction the items layout should flow.

        If this property is **LeftToRight** , the items will be laid out left to
        right. If the **isWrapping**  property is `true`, the layout will wrap
        when it reaches the right side of the visible area. If this property is
        **TopToBottom** , the items will be laid out from the top of the visible
        area, wrapping when it reaches the bottom.

        Setting this property when the view is visible will cause the items to
        be laid out again.

        By default, this property is set to **TopToBottom** .

        **Access functions:**

        QListView::Flow **flow** () const
        void **setFlow** (QListView::Flow
        **flow** )

        **See also** **viewMode** .
        """
        ...

    def setFlow(self, flow: "QListView.Flow") -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#flow-prop

        **flow : Flow**

        This property holds which direction the items layout should flow.

        If this property is **LeftToRight** , the items will be laid out left to
        right. If the **isWrapping**  property is `true`, the layout will wrap
        when it reaches the right side of the visible area. If this property is
        **TopToBottom** , the items will be laid out from the top of the visible
        area, wrapping when it reaches the bottom.

        Setting this property when the view is visible will cause the items to
        be laid out again.

        By default, this property is set to **TopToBottom** .

        **Access functions:**

        QListView::Flow **flow** () const
        void **setFlow** (QListView::Flow
        **flow** )

        **See also** **viewMode** .
        """
        ...

    def movement(self) -> "QListView.Movement":
        """
        https://doc.qt.io/qt-5/qlistview.html#movement-prop

        **movement : Movement**

        This property holds whether the items can be moved freely, are snapped
        to a grid, or cannot be moved at all.

        This property determines how the user can move the items in the view.
        **Static**  means that the items can't be moved the user. **Free**
        means that the user can drag and drop the items to any position in the
        view. **Snap**  means that the user can drag and drop the items, but
        only to the positions in a notional grid signified by the **gridSize**
        property.

        Setting this property when the view is visible will cause the items to
        be laid out again.

        By default, this property is set to **Static** .

        **Access functions:**

        QListView::Movement **movement** () const
        void **setMovement**
        (QListView::Movement **movement** )

        **See also** **gridSize** , **resizeMode** , and **viewMode** .
        """
        ...

    def setMovement(self, movement: "QListView.Movement") -> None:
        """
        https://doc.qt.io/qt-5/qlistview.html#movement-prop

        **movement : Movement**

        This property holds whether the items can be moved freely, are snapped
        to a grid, or cannot be moved at all.

        This property determines how the user can move the items in the view.
        **Static**  means that the items can't be moved the user. **Free**
        means that the user can drag and drop the items to any position in the
        view. **Snap**  means that the user can drag and drop the items, but
        only to the positions in a notional grid signified by the **gridSize**
        property.

        Setting this property when the view is visible will cause the items to
        be laid out again.

        By default, this property is set to **Static** .

        **Access functions:**

        QListView::Movement **movement** () const
        void **setMovement**
        (QListView::Movement **movement** )

        **See also** **gridSize** , **resizeMode** , and **viewMode** .
        """
        ...

    @property
    def indexesMoved(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlistview.html#indexesMoved

        **[signal] void QListView::indexesMoved(const QModelIndexList & indexes
        )**

        This signal is emitted when the specified **indexes** are moved in the
        view.

        This function was introduced in Qt 4.2.
        """
        ...
