"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QLineEdit(QWidget):
    """
    https://doc.qt.io/qt-5/qlineedit.html

    **Detailed Description**

    ![](images/windows-lineedit.png)

    A line edit allows the user to enter and edit a single line of plain text
    with a useful collection of editing functions, including undo and redo, cut
    and paste, and drag and drop (see **setDragEnabled** ()).

    By changing the **echoMode** () of a line edit, it can also be used as a
    "write-only" field, for inputs such as passwords.

    The length of the text can be constrained to **maxLength** (). The text can
    be arbitrarily constrained using a **validator** () or an **inputMask** (),
    or both. When switching between a validator and an input mask on the same
    line edit, it is best to clear the validator or input mask to prevent
    undefined behavior.

    A related class is **QTextEdit**  which allows multi-line, rich text
    editing.

    You can change the text with **setText** () or **insert** (). The text is
    retrieved with **text** (); the displayed text (which may be different, see
    **EchoMode** ) is retrieved with **displayText** (). Text can be selected
    with **setSelection** () or **selectAll** (), and the selection can be
    **cut** (), **copy** ()ied and **paste** ()d. The text can be aligned with
    **setAlignment** ().

    When the text changes the **textChanged** () signal is emitted; when the
    text changes other than by calling **setText** () the **textEdited** ()
    signal is emitted; when the cursor is moved the **cursorPositionChanged** ()
    signal is emitted; and when the Return or Enter key is pressed the
    **returnPressed** () signal is emitted.

    When editing is finished, either because the line edit lost focus or
    Return/Enter is pressed the **editingFinished** () signal is emitted.

    Note that if there is a validator set on the line edit, the
    **returnPressed** ()/**editingFinished** () signals will only be emitted if
    the validator returns **QValidator::Acceptable** .

    By default, QLineEdits have a frame as specified by platform style guides;
    you can turn it off by calling **setFrame** (false).

    The default key bindings are described below. The line edit also provides a
    context menu (usually invoked by a right mouse click) that presents some of
    these editing options.

    KeypressAction
    Left ArrowMoves the cursor one character to the left.
    Shift+Left ArrowMoves and selects text one character to the left.
    Right
    ArrowMoves the cursor one character to the right.
    Shift+Right ArrowMoves
    and selects text one character to the right.
    HomeMoves the cursor to the
    beginning of the line.
    EndMoves the cursor to the end of the line.
    BackspaceDeletes the character to the left of the cursor.
    Ctrl+BackspaceDeletes the word to the left of the cursor.
    DeleteDeletes
    the character to the right of the cursor.
    Ctrl+DeleteDeletes the word to
    the right of the cursor.
    Ctrl+ASelect all.
    Ctrl+CCopies the selected
    text to the clipboard.
    Ctrl+InsertCopies the selected text to the
    clipboard.
    Ctrl+KDeletes to the end of the line.
    Ctrl+VPastes the
    clipboard text into line edit.
    Shift+InsertPastes the clipboard text into
    line edit.
    Ctrl+XDeletes the selected text and copies it to the clipboard.
    Shift+DeleteDeletes the selected text and copies it to the clipboard.
    Ctrl+ZUndoes the last operation.
    Ctrl+YRedoes the last undone operation.

    Any other key sequence that represents a valid character, will cause the
    character to be inserted into the line edit.

    **See also** **QTextEdit** , **QLabel** , **QComboBox** , **GUI Design
    Handbook: Field, Entry** , and **Line Edits Example** .
    """

    class ActionPosition(int):
        LeadingPosition: QLineEdit = ...
        TrailingPosition: QLineEdit = ...

    class EchoMode(int):
        Normal: QLineEdit = ...
        NoEcho: QLineEdit = ...
        Password: QLineEdit = ...
        PasswordEchoOnEdit: QLineEdit = ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#QLineEdit

        **QLineEdit::QLineEdit(QWidget * parent = nullptr)**

        Constructs a line edit with no text.

        The maximum text length is set to 32767 characters.

        The **parent** argument is sent to the **QWidget**  constructor.

        **See also** **setText** () and **setMaxLength** ().
        """
        ...

    @typing.overload
    def __init__(self, contents: str, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#QLineEdit-1

        **QLineEdit::QLineEdit(const QString & contents , QWidget * parent =
        nullptr)**

        Constructs a line edit containing the text **contents**.

        The cursor position is set to the end of the line and the maximum text
        length to 32767 characters.

        The **parent** and argument is sent to the **QWidget**  constructor.

        **See also** **text** () and **setMaxLength** ().
        """
        ...

    def selectionLength(self) -> int:
        """
        https://doc.qt.io/qt-5/qlineedit.html#selectionLength

        **int QLineEdit::selectionLength() const**

        Returns the length of the selection.

        This function was introduced in Qt 5.10.

        **See also** **selectedText** (), **selectionStart** (), and
        **selectionEnd** ().
        """
        ...

    def selectionEnd(self) -> int:
        """
        https://doc.qt.io/qt-5/qlineedit.html#selectionEnd

        **int QLineEdit::selectionEnd() const**

        Returns the index of the character directly after the selection in the
        line edit or -1 if no text is selected.

        This function was introduced in Qt 5.10.

        **See also** **selectedText** (), **selectionStart** (), and
        **selectionLength** ().
        """
        ...

    @typing.overload
    def addAction(self, action: QAction) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#addAction

        **void QLineEdit::addAction(QAction * action , QLineEdit::ActionPosition
        position )**

        Adds the **action** to the list of actions at the **position**.

        This function was introduced in Qt 5.2.
        """
        ...

    @typing.overload
    def addAction(self, action: QAction, position: "QLineEdit.ActionPosition") -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#addAction-1

        **QAction *QLineEdit::addAction(const QIcon & icon ,
        QLineEdit::ActionPosition position )**

        This is an overloaded function.

        Creates a new action with the given **icon** at the **position**.

        This function was introduced in Qt 5.2.
        """
        ...

    @typing.overload
    def addAction(
        self, icon: QtGui.QIcon, position: "QLineEdit.ActionPosition"
    ) -> QAction:
        """
        https://doc.qt.io/qt-5/qlineedit.html#addAction

        **void QLineEdit::addAction(QAction * action , QLineEdit::ActionPosition
        position )**

        Adds the **action** to the list of actions at the **position**.

        This function was introduced in Qt 5.2.
        """
        ...

    def isClearButtonEnabled(self) -> bool:
        ...

    def setClearButtonEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#clearButtonEnabled-prop

        **clearButtonEnabled : bool**

        This property holds whether the line edit displays a clear button when
        it is not empty.

        If enabled, the line edit displays a trailing **clear** button when it
        contains some text, otherwise the line edit does not show a clear button
        (the default).

        This property was introduced in Qt 5.2.

        **Access functions:**

        bool **isClearButtonEnabled** () const
        void **setClearButtonEnabled**
        (bool **enable** )

        **See also** **addAction** () and **removeAction** ().
        """
        ...

    def cursorMoveStyle(self) -> QtCore.Qt.CursorMoveStyle:
        """
        https://doc.qt.io/qt-5/qlineedit.html#cursorMoveStyle-prop

        **cursorMoveStyle : Qt::CursorMoveStyle**

        This property holds the movement style of cursor in this line edit.

        When this property is set to **Qt::VisualMoveStyle** , the line edit
        will use visual movement style. Pressing the left arrow key will always
        cause the cursor to move left, regardless of the text's writing
        direction. The same behavior applies to right arrow key.

        When the property is **Qt::LogicalMoveStyle**  (the default), within a
        LTR text block, increase cursor position when pressing left arrow key,
        decrease cursor position when pressing the right arrow key. If the text
        block is right to left, the opposite behavior applies.

        This property was introduced in Qt 4.8.

        **Access functions:**

        Qt::CursorMoveStyle **cursorMoveStyle** () const
        void
        **setCursorMoveStyle** (Qt::CursorMoveStyle **style** )
        """
        ...

    def setCursorMoveStyle(self, style: QtCore.Qt.CursorMoveStyle) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#cursorMoveStyle-prop

        **cursorMoveStyle : Qt::CursorMoveStyle**

        This property holds the movement style of cursor in this line edit.

        When this property is set to **Qt::VisualMoveStyle** , the line edit
        will use visual movement style. Pressing the left arrow key will always
        cause the cursor to move left, regardless of the text's writing
        direction. The same behavior applies to right arrow key.

        When the property is **Qt::LogicalMoveStyle**  (the default), within a
        LTR text block, increase cursor position when pressing left arrow key,
        decrease cursor position when pressing the right arrow key. If the text
        block is right to left, the opposite behavior applies.

        This property was introduced in Qt 4.8.

        **Access functions:**

        Qt::CursorMoveStyle **cursorMoveStyle** () const
        void
        **setCursorMoveStyle** (Qt::CursorMoveStyle **style** )
        """
        ...

    def setPlaceholderText(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#placeholderText-prop

        **placeholderText : QString**

        This property holds the line edit's placeholder text.

        Setting this property makes the line edit display a grayed-out
        placeholder text as long as the line edit is empty.

        Normally, an empty line edit shows the placeholder text even when it has
        focus. However, if the content is horizontally centered, the placeholder
        text is not displayed under the cursor when the line edit has focus.

        By default, this property contains an empty string.

        This property was introduced in Qt 4.7.

        **Access functions:**

        QString **placeholderText** () const
        void **setPlaceholderText** (
        **const QString &**)

        **See also** **text** ().
        """
        ...

    def placeholderText(self) -> str:
        """
        https://doc.qt.io/qt-5/qlineedit.html#placeholderText-prop

        **placeholderText : QString**

        This property holds the line edit's placeholder text.

        Setting this property makes the line edit display a grayed-out
        placeholder text as long as the line edit is empty.

        Normally, an empty line edit shows the placeholder text even when it has
        focus. However, if the content is horizontally centered, the placeholder
        text is not displayed under the cursor when the line edit has focus.

        By default, this property contains an empty string.

        This property was introduced in Qt 4.7.

        **Access functions:**

        QString **placeholderText** () const
        void **setPlaceholderText** (
        **const QString &**)

        **See also** **text** ().
        """
        ...

    def textMargins(self) -> QtCore.QMargins:
        """
        https://doc.qt.io/qt-5/qlineedit.html#textMargins

        **QMargins QLineEdit::textMargins() const**

        Returns the widget's text margins.

        This function was introduced in Qt 4.6.

        **See also** **setTextMargins** ().
        """
        ...

    def getTextMargins(self) -> typing.Tuple[int, int, int, int]:
        ...

    @typing.overload
    def setTextMargins(self, left: int, top: int, right: int, bottom: int) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#setTextMargins

        **void QLineEdit::setTextMargins(int left , int top , int right , int
        bottom )**

        Sets the margins around the text inside the frame to have the sizes
        **left** , **top** , **right** , and **bottom**.

        See also **textMargins** ().

        This function was introduced in Qt 4.5.

        **See also** **textMargins** ().
        """
        ...

    @typing.overload
    def setTextMargins(self, margins: QtCore.QMargins) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#setTextMargins-1

        **void QLineEdit::setTextMargins(const QMargins & margins )**

        Sets the **margins** around the text inside the frame.

        See also **textMargins** ().

        This function was introduced in Qt 4.6.
        """
        ...

    def completer(self) -> QCompleter:
        """
        https://doc.qt.io/qt-5/qlineedit.html#completer

        **QCompleter *QLineEdit::completer() const**

        Returns the current **QCompleter**  that provides completions.

        This function was introduced in Qt 4.2.

        **See also** **setCompleter** ().
        """
        ...

    def setCompleter(self, completer: QCompleter) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#setCompleter

        **void QLineEdit::setCompleter(QCompleter * c )**

        Sets this line edit to provide auto completions from the completer,
        **c**. The completion mode is set using
        **QCompleter::setCompletionMode** ().

        To use a **QCompleter**  with a **QValidator**  or
        **QLineEdit::inputMask** , you need to ensure that the model provided to
        **QCompleter**  contains valid entries. You can use the
        **QSortFilterProxyModel**  to ensure that the **QCompleter** 's model
        contains only valid entries.

        If **c** == 0, setCompleter() removes the current completer, effectively
        disabling auto completion.

        This function was introduced in Qt 4.2.

        **See also** **completer** () and **QCompleter** .
        """
        ...

    def event(self, a0: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qlineedit.html#event

        **[override virtual] bool QLineEdit::event(QEvent * e )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    @typing.overload
    def inputMethodQuery(self, a0: QtCore.Qt.InputMethodQuery) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qlineedit.html#inputMethodQuery

        **[override virtual] QVariant
        QLineEdit::inputMethodQuery(Qt::InputMethodQuery property ) const**

        Reimplements: **QWidget::inputMethodQuery** (Qt::InputMethodQuery query)
        const.
        """
        ...

    @typing.overload
    def inputMethodQuery(
        self, property: QtCore.Qt.InputMethodQuery, argument: typing.Any
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qlineedit.html#inputMethodQuery

        **[override virtual] QVariant
        QLineEdit::inputMethodQuery(Qt::InputMethodQuery property ) const**

        Reimplements: **QWidget::inputMethodQuery** (Qt::InputMethodQuery query)
        const.
        """
        ...

    def cursorRect(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qlineedit.html#cursorRect

        **[protected] QRect QLineEdit::cursorRect() const**

        Returns a rectangle that includes the lineedit cursor.

        This function was introduced in Qt 4.4.
        """
        ...

    def inputMethodEvent(self, a0: QtGui.QInputMethodEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#inputMethodEvent

        **[override virtual protected] void
        QLineEdit::inputMethodEvent(QInputMethodEvent * e )**

        Reimplements: **QWidget::inputMethodEvent** (QInputMethodEvent *event).
        """
        ...

    def contextMenuEvent(self, a0: QtGui.QContextMenuEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#contextMenuEvent

        **[override virtual protected] void
        QLineEdit::contextMenuEvent(QContextMenuEvent * event )**

        Reimplements: **QWidget::contextMenuEvent** (QContextMenuEvent *event).

        Shows the standard context menu created with
        **createStandardContextMenu** ().

        If you do not want the line edit to have a context menu, you can set its
        **contextMenuPolicy**  to **Qt::NoContextMenu** . If you want to
        customize the context menu, reimplement this function. If you want to
        extend the standard context menu, reimplement this function, call
        **createStandardContextMenu** () and extend the menu returned.

        void LineEdit::contextMenuEvent(**QContextMenuEvent**  *event)
            {
        **QMenu**  *menu = createStandardContextMenu();
        menu->addAction(tr("My Menu Item"));
                //...
        menu->exec(event->globalPos());
                delete menu;
            }

        The **event** parameter is used to obtain the position where the mouse
        cursor was when the event was generated.

        **See also** **setContextMenuPolicy** ().
        """
        ...

    def changeEvent(self, a0: QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#changeEvent

        **[override virtual protected] void QLineEdit::changeEvent(QEvent * ev
        )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    def dropEvent(self, a0: QtGui.QDropEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#dropEvent

        **[override virtual protected] void QLineEdit::dropEvent(QDropEvent * e
        )**

        Reimplements: **QWidget::dropEvent** (QDropEvent *event).
        """
        ...

    def dragLeaveEvent(self, e: QtGui.QDragLeaveEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#dragLeaveEvent

        **[override virtual protected] void
        QLineEdit::dragLeaveEvent(QDragLeaveEvent * e )**

        Reimplements: **QWidget::dragLeaveEvent** (QDragLeaveEvent *event).
        """
        ...

    def dragMoveEvent(self, e: QtGui.QDragMoveEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#dragMoveEvent

        **[override virtual protected] void
        QLineEdit::dragMoveEvent(QDragMoveEvent * e )**

        Reimplements: **QWidget::dragMoveEvent** (QDragMoveEvent *event).
        """
        ...

    def dragEnterEvent(self, a0: QtGui.QDragEnterEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#dragEnterEvent

        **[override virtual protected] void
        QLineEdit::dragEnterEvent(QDragEnterEvent * e )**

        Reimplements: **QWidget::dragEnterEvent** (QDragEnterEvent *event).
        """
        ...

    def paintEvent(self, a0: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#paintEvent

        **[override virtual protected] void QLineEdit::paintEvent( QPaintEvent *
        )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    def focusOutEvent(self, a0: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#focusOutEvent

        **[override virtual protected] void QLineEdit::focusOutEvent(QFocusEvent
        * e )**

        Reimplements: **QWidget::focusOutEvent** (QFocusEvent *event).
        """
        ...

    def focusInEvent(self, a0: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#focusInEvent

        **[override virtual protected] void QLineEdit::focusInEvent(QFocusEvent
        * e )**

        Reimplements: **QWidget::focusInEvent** (QFocusEvent *event).
        """
        ...

    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#keyPressEvent

        **[override virtual protected] void QLineEdit::keyPressEvent(QKeyEvent *
        event )**

        Reimplements: **QWidget::keyPressEvent** (QKeyEvent *event).

        Converts the given key press **event** into a line edit action.

        If Return or Enter is pressed and the current text is valid (or can be
        **made valid**  by the validator), the signal **returnPressed** () is
        emitted.

        The default key bindings are listed in the class's detailed description.
        """
        ...

    def mouseDoubleClickEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#mouseDoubleClickEvent

        **[override virtual protected] void
        QLineEdit::mouseDoubleClickEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mouseDoubleClickEvent** (QMouseEvent *event).
        """
        ...

    def mouseReleaseEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#mouseReleaseEvent

        **[override virtual protected] void
        QLineEdit::mouseReleaseEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mouseReleaseEvent** (QMouseEvent *event).
        """
        ...

    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#mouseMoveEvent

        **[override virtual protected] void
        QLineEdit::mouseMoveEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mouseMoveEvent** (QMouseEvent *event).
        """
        ...

    def mousePressEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#mousePressEvent

        **[override virtual protected] void
        QLineEdit::mousePressEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mousePressEvent** (QMouseEvent *event).
        """
        ...

    def initStyleOption(self, option: "QStyleOptionFrame") -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#initStyleOption

        **[protected] void QLineEdit::initStyleOption(QStyleOptionFrame * option
        ) const**

        Initialize **option** with the values from this **QLineEdit** . This
        method is useful for subclasses when they need a **QStyleOptionFrame** ,
        but don't want to fill in all the information themselves.

        **See also** **QStyleOption::initFrom** ().
        """
        ...

    def createStandardContextMenu(self) -> "QMenu":
        """
        https://doc.qt.io/qt-5/qlineedit.html#createStandardContextMenu

        **QMenu *QLineEdit::createStandardContextMenu()**

        This function creates the standard context menu which is shown when the
        user clicks on the line edit with the right mouse button. It is called
        from the default **contextMenuEvent** () handler. The popup menu's
        ownership is transferred to the caller.
        """
        ...

    def insert(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#insert

        **void QLineEdit::insert(const QString & newText )**

        Deletes any selected text, inserts **newText** , and validates the
        result. If it is valid, it sets it as the new contents of the line edit.

        **See also** **setText** () and **clear** ().
        """
        ...

    def deselect(self) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#deselect

        **void QLineEdit::deselect()**

        Deselects any selected text.

        **See also** **setSelection** () and **selectAll** ().
        """
        ...

    def paste(self) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#paste

        **[slot] void QLineEdit::paste()**

        Inserts the clipboard's text at the cursor position, deleting any
        selected text, providing the line edit is not **read-only** .

        If the end result would be invalid to the current **validator** ,
        nothing happens.

        **See also** **copy** () and **cut** ().
        """
        ...

    def copy(self) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#copy

        **[slot] void QLineEdit::copy() const**

        Copies the selected text to the clipboard, if there is any, and if
        **echoMode** () is **Normal** .

        **See also** **cut** () and **paste** ().
        """
        ...

    def cut(self) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#cut

        **[slot] void QLineEdit::cut()**

        Copies the selected text to the clipboard and deletes it, if there is
        any, and if **echoMode** () is **Normal** .

        If the current validator disallows deleting the selected text, cut()
        will copy without deleting.

        **See also** **copy** (), **paste** (), and **setValidator** ().
        """
        ...

    def redo(self) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#redo

        **[slot] void QLineEdit::redo()**

        Redoes the last operation if redo is **available** .
        """
        ...

    def undo(self) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#undo

        **[slot] void QLineEdit::undo()**

        Undoes the last operation if undo is **available** . Deselects any
        current selection, and updates the selection start to the current cursor
        position.
        """
        ...

    def selectAll(self) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#selectAll

        **[slot] void QLineEdit::selectAll()**

        Selects all the text (i.e. highlights it) and moves the cursor to the
        end. This is useful when a default value has been inserted because if
        the user types before clicking on the widget, the selected text will be
        deleted.

        **See also** **setSelection** () and **deselect** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#clear

        **[slot] void QLineEdit::clear()**

        Clears the contents of the line edit.

        **See also** **setText** () and **insert** ().
        """
        ...

    def setText(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#text-prop

        **text : QString**

        This property holds the line edit's text.

        Setting this property clears the selection, clears the undo/redo
        history, moves the cursor to the end of the line and resets the
        **modified**  property to false. The text is not validated when inserted
        with setText().

        The text is truncated to **maxLength** () length.

        By default, this property contains an empty string.

        **Access functions:**

        QString **text** () const
        void **setText** ( **const QString &**)

        **Notifier signal:**

        void ****textChanged** ** (const QString & **text** )

        **See also** **insert** () and **clear** ().
        """
        ...

    def hasAcceptableInput(self) -> bool:
        ...

    def setInputMask(self, inputMask: str) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#inputMask-prop

        **inputMask : QString**

        This property holds the validation input mask.

        If no mask is set, inputMask() returns an empty string.

        Sets the **QLineEdit** 's validation mask. Validators can be used
        instead of, or in conjunction with masks; see **setValidator** ().

        Unset the mask and return to normal **QLineEdit**  operation by passing
        an empty string ("").

        The input mask is an input template string. It can contain the following
        elements:

        Mask CharactersDefines the **Category**  of input characters that are
        considered valid in this position
        Meta CharactersVarious special
        meanings
        SeparatorsAll other characters are regarded as immutable
        separators

        The following table shows the mask and meta characters that can be used
        in an input mask.

        Mask CharacterMeaning
        `A`character of the Letter category required,
        such as A-Z, a-z.
        `a`character of the Letter category permitted but
        not required.
        `N`character of the Letter or Number category required,
        such as A-Z, a-z, 0-9.
        `n`character of the Letter or Number category
        permitted but not required.
        `X`Any non-blank character required.
        `x`Any non-blank character permitted but not required.
        `9`character of
        the Number category required, e.g 0-9.
        `0`character of the Number
        category permitted but not required.
        `D`character of the Number
        category and larger than zero required, such as 1-9
        `d`character of
        the Number category and larger than zero permitted but not required,
        such as 1-9.
        `#`character of the Number category, or plus/minus sign
        permitted but not required.
        `H`Hexadecimal character required. A-F,
        a-f, 0-9.
        `h`Hexadecimal character permitted but not required.
        `B`Binary character required. 0-1.
        `b`Binary character permitted but
        not required.
        Meta CharacterMeaning
        `>`All following alphabetic
        characters are uppercased.
        `<`All following alphabetic characters are
        lowercased.
        `!`Switch off case conversion.
        `;c`Terminates the input
        mask and sets the **blank** character to **c**.
        `[ ] { }`Reserved.
        `\\`Use `\\` to escape the special characters listed above to use them as
        separators.

        When created or cleared, the line edit will be filled with a copy of the
        input mask string where the meta characters have been removed, and the
        mask characters have been replaced with the **blank** character (by
        default, a `space`).

        When an input mask is set, the **text** () method returns a modified
        copy of the line edit content where all the **blank** characters have
        been removed. The unmodified content can be read using **displayText**
        ().

        The **hasAcceptableInput** () method returns false if the current
        content of the line edit does not fulfil the requirements of the input
        mask.

        Examples:

        MaskNotes
        `000.000.000.000;_`IP address; blanks are `_`.
        `HH:HH:HH:HH:HH:HH;_`MAC address
        `0000-00-00`ISO Date; blanks are
        `space`
        `>AAAAA-AAAAA-AAAAA-AAAAA-AAAAA;#`License number; blanks are
        `#` and all (alphabetic) characters are converted to uppercase.

        To get range control (e.g., for an IP address) use masks together with
        **validators** .

        **Access functions:**

        QString **inputMask** () const
        void **setInputMask** (const QString &
        **inputMask** )

        **See also** **maxLength** , **QChar::isLetter** (), **QChar::isNumber**
        (), and **QChar::digitValue** ().
        """
        ...

    def inputMask(self) -> str:
        """
        https://doc.qt.io/qt-5/qlineedit.html#inputMask-prop

        **inputMask : QString**

        This property holds the validation input mask.

        If no mask is set, inputMask() returns an empty string.

        Sets the **QLineEdit** 's validation mask. Validators can be used
        instead of, or in conjunction with masks; see **setValidator** ().

        Unset the mask and return to normal **QLineEdit**  operation by passing
        an empty string ("").

        The input mask is an input template string. It can contain the following
        elements:

        Mask CharactersDefines the **Category**  of input characters that are
        considered valid in this position
        Meta CharactersVarious special
        meanings
        SeparatorsAll other characters are regarded as immutable
        separators

        The following table shows the mask and meta characters that can be used
        in an input mask.

        Mask CharacterMeaning
        `A`character of the Letter category required,
        such as A-Z, a-z.
        `a`character of the Letter category permitted but
        not required.
        `N`character of the Letter or Number category required,
        such as A-Z, a-z, 0-9.
        `n`character of the Letter or Number category
        permitted but not required.
        `X`Any non-blank character required.
        `x`Any non-blank character permitted but not required.
        `9`character of
        the Number category required, e.g 0-9.
        `0`character of the Number
        category permitted but not required.
        `D`character of the Number
        category and larger than zero required, such as 1-9
        `d`character of
        the Number category and larger than zero permitted but not required,
        such as 1-9.
        `#`character of the Number category, or plus/minus sign
        permitted but not required.
        `H`Hexadecimal character required. A-F,
        a-f, 0-9.
        `h`Hexadecimal character permitted but not required.
        `B`Binary character required. 0-1.
        `b`Binary character permitted but
        not required.
        Meta CharacterMeaning
        `>`All following alphabetic
        characters are uppercased.
        `<`All following alphabetic characters are
        lowercased.
        `!`Switch off case conversion.
        `;c`Terminates the input
        mask and sets the **blank** character to **c**.
        `[ ] { }`Reserved.
        `\\`Use `\\` to escape the special characters listed above to use them as
        separators.

        When created or cleared, the line edit will be filled with a copy of the
        input mask string where the meta characters have been removed, and the
        mask characters have been replaced with the **blank** character (by
        default, a `space`).

        When an input mask is set, the **text** () method returns a modified
        copy of the line edit content where all the **blank** characters have
        been removed. The unmodified content can be read using **displayText**
        ().

        The **hasAcceptableInput** () method returns false if the current
        content of the line edit does not fulfil the requirements of the input
        mask.

        Examples:

        MaskNotes
        `000.000.000.000;_`IP address; blanks are `_`.
        `HH:HH:HH:HH:HH:HH;_`MAC address
        `0000-00-00`ISO Date; blanks are
        `space`
        `>AAAAA-AAAAA-AAAAA-AAAAA-AAAAA;#`License number; blanks are
        `#` and all (alphabetic) characters are converted to uppercase.

        To get range control (e.g., for an IP address) use masks together with
        **validators** .

        **Access functions:**

        QString **inputMask** () const
        void **setInputMask** (const QString &
        **inputMask** )

        **See also** **maxLength** , **QChar::isLetter** (), **QChar::isNumber**
        (), and **QChar::digitValue** ().
        """
        ...

    def dragEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-5/qlineedit.html#dragEnabled-prop

        **dragEnabled : bool**

        This property holds whether the lineedit starts a drag if the user
        presses and moves the mouse on some selected text.

        Dragging is disabled by default.

        **Access functions:**

        bool **dragEnabled** () const
        void **setDragEnabled** (bool **b** )
        """
        ...

    def setDragEnabled(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#dragEnabled-prop

        **dragEnabled : bool**

        This property holds whether the lineedit starts a drag if the user
        presses and moves the mouse on some selected text.

        Dragging is disabled by default.

        **Access functions:**

        bool **dragEnabled** () const
        void **setDragEnabled** (bool **b** )
        """
        ...

    def isRedoAvailable(self) -> bool:
        ...

    def isUndoAvailable(self) -> bool:
        ...

    def selectionStart(self) -> int:
        """
        https://doc.qt.io/qt-5/qlineedit.html#selectionStart

        **int QLineEdit::selectionStart() const**

        Returns the index of the first selected character in the line edit or -1
        if no text is selected.

        **See also** **selectedText** (), **selectionEnd** (), and
        **selectionLength** ().
        """
        ...

    def selectedText(self) -> str:
        """
        https://doc.qt.io/qt-5/qlineedit.html#selectedText-prop

        **selectedText : const QString**

        This property holds the selected text.

        If there is no selected text this property's value is an empty string.

        By default, this property contains an empty string.

        **Access functions:**

        QString **selectedText** () const

        **See also** **hasSelectedText** ().
        """
        ...

    def hasSelectedText(self) -> bool:
        """
        https://doc.qt.io/qt-5/qlineedit.html#hasSelectedText-prop

        **hasSelectedText : const bool**

        This property holds whether there is any text selected.

        hasSelectedText() returns `true` if some or all of the text has been
        selected by the user; otherwise returns `false`.

        By default, this property is `false`.

        **Access functions:**

        bool **hasSelectedText** () const

        **See also** **selectedText** ().
        """
        ...

    def setSelection(self, a0: int, a1: int) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#setSelection

        **void QLineEdit::setSelection(int start , int length )**

        Selects text from position **start** and for **length** characters.
        Negative lengths are allowed.

        **See also** **deselect** (), **selectAll** (), and **selectedText** ().
        """
        ...

    def setModified(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#modified-prop

        **modified : bool**

        This property holds whether the line edit's contents has been modified
        by the user.

        The modified flag is never read by **QLineEdit** ; it has a default
        value of false and is changed to true whenever the user changes the line
        edit's contents.

        This is useful for things that need to provide a default value but do
        not start out knowing what the default should be (perhaps it depends on
        other fields on the form). Start the line edit without the best default,
        and when the default is known, if modified() returns `false` (the user
        hasn't entered any text), insert the default value.

        Calling **setText** () resets the modified flag to false.

        **Access functions:**

        bool **isModified** () const
        void **setModified** ( **bool** )
        """
        ...

    def isModified(self) -> bool:
        ...

    def end(self, mark: bool) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#end

        **void QLineEdit::end(bool mark )**

        Moves the text cursor to the end of the line unless it is already there.
        If **mark** is true, text is selected towards the last position;
        otherwise, any selected text is unselected if the cursor is moved.

        **See also** **home** ().
        """
        ...

    def home(self, mark: bool) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#home

        **void QLineEdit::home(bool mark )**

        Moves the text cursor to the beginning of the line unless it is already
        there. If **mark** is true, text is selected towards the first position;
        otherwise, any selected text is unselected if the cursor is moved.

        **See also** **end** ().
        """
        ...

    def del_(self) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#del

        **void QLineEdit::del()**

        If no text is selected, deletes the character to the right of the text
        cursor. If any text is selected, the cursor is moved to the beginning of
        the selected text and the selected text is deleted.

        **See also** **backspace** ().
        """
        ...

    def backspace(self) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#backspace

        **void QLineEdit::backspace()**

        If no text is selected, deletes the character to the left of the text
        cursor and moves the cursor one position to the left. If any text is
        selected, the cursor is moved to the beginning of the selected text and
        the selected text is deleted.

        **See also** **del** ().
        """
        ...

    def cursorWordBackward(self, mark: bool) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#cursorWordBackward

        **void QLineEdit::cursorWordBackward(bool mark )**

        Moves the cursor one word backward. If **mark** is true, the word is
        also selected.

        **See also** **cursorWordForward** ().
        """
        ...

    def cursorWordForward(self, mark: bool) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#cursorWordForward

        **void QLineEdit::cursorWordForward(bool mark )**

        Moves the cursor one word forward. If **mark** is true, the word is also
        selected.

        **See also** **cursorWordBackward** ().
        """
        ...

    def cursorBackward(self, mark: bool, steps: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#cursorBackward

        **void QLineEdit::cursorBackward(bool mark , int steps = 1)**

        Moves the cursor back **steps** characters. If **mark** is true each
        character moved over is added to the selection; if **mark** is false the
        selection is cleared.

        **See also** **cursorForward** ().
        """
        ...

    def cursorForward(self, mark: bool, steps: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#cursorForward

        **void QLineEdit::cursorForward(bool mark , int steps = 1)**

        Moves the cursor forward **steps** characters. If **mark** is true each
        character moved over is added to the selection; if **mark** is false the
        selection is cleared.

        **See also** **cursorBackward** ().
        """
        ...

    def alignment(self) -> QtCore.Qt.Alignment:
        """
        https://doc.qt.io/qt-5/qlineedit.html#alignment-prop

        **alignment : Qt::Alignment**

        This property holds the alignment of the line edit.

        Both horizontal and vertical alignment is allowed here,
        **Qt::AlignJustify**  will map to **Qt::AlignLeft** .

        By default, this property contains a combination of **Qt::AlignLeft**
        and **Qt::AlignVCenter** .

        **Access functions:**

        Qt::Alignment **alignment** () const
        void **setAlignment**
        (Qt::Alignment **flag** )

        **See also** **Qt::Alignment** .
        """
        ...

    def setAlignment(
        self, flag: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#alignment-prop

        **alignment : Qt::Alignment**

        This property holds the alignment of the line edit.

        Both horizontal and vertical alignment is allowed here,
        **Qt::AlignJustify**  will map to **Qt::AlignLeft** .

        By default, this property contains a combination of **Qt::AlignLeft**
        and **Qt::AlignVCenter** .

        **Access functions:**

        Qt::Alignment **alignment** () const
        void **setAlignment**
        (Qt::Alignment **flag** )

        **See also** **Qt::Alignment** .
        """
        ...

    def cursorPositionAt(self, pos: QtCore.QPoint) -> int:
        """
        https://doc.qt.io/qt-5/qlineedit.html#cursorPositionAt

        **int QLineEdit::cursorPositionAt(const QPoint & pos )**

        Returns the cursor position under the point **pos**.
        """
        ...

    def setCursorPosition(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#cursorPosition-prop

        **cursorPosition : int**

        This property holds the current cursor position for this line edit.

        Setting the cursor position causes a repaint when appropriate.

        By default, this property contains a value of 0.

        **Access functions:**

        int **cursorPosition** () const
        void **setCursorPosition** ( **int** )
        """
        ...

    def cursorPosition(self) -> int:
        """
        https://doc.qt.io/qt-5/qlineedit.html#cursorPosition-prop

        **cursorPosition : int**

        This property holds the current cursor position for this line edit.

        Setting the cursor position causes a repaint when appropriate.

        By default, this property contains a value of 0.

        **Access functions:**

        int **cursorPosition** () const
        void **setCursorPosition** ( **int** )
        """
        ...

    def minimumSizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qlineedit.html#minimumSizeHint

        **[override virtual] QSize QLineEdit::minimumSizeHint() const**

        Reimplements an access function for property:
        **QWidget::minimumSizeHint** .

        Returns a minimum size for the line edit.

        The width returned is usually enough for at least one character.
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qlineedit.html#sizeHint

        **[override virtual] QSize QLineEdit::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .

        Returns a recommended size for the widget.

        The width returned, in pixels, is usually enough for about 15 to 20
        characters.
        """
        ...

    def validator(self) -> QtGui.QValidator:
        """
        https://doc.qt.io/qt-5/qlineedit.html#validator

        **const QValidator *QLineEdit::validator() const**

        Returns a pointer to the current input validator, or `nullptr` if no
        validator has been set.

        **See also** **setValidator** ().
        """
        ...

    def setValidator(self, a0: QtGui.QValidator) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#setValidator

        **void QLineEdit::setValidator(const QValidator * v )**

        Sets the validator for values of line edit to **v**.

        The line edit's **returnPressed** () and **editingFinished** () signals
        will only be emitted if **v** validates the line edit's content as
        **Acceptable** . The user may change the content to any **Intermediate**
        value during editing, but will be prevented from editing the text to a
        value that **v** validates as **Invalid** .

        This allows you to constrain the text that shall finally be entered when
        editing is done, while leaving users with enough freedom to edit the
        text from one valid state to another.

        If **v** == 0, setValidator() removes the current input validator. The
        initial setting is to have no input validator (i.e. any input is
        accepted up to **maxLength** ()).

        **See also** **validator** (), **hasAcceptableInput** (),
        **QIntValidator** , **QDoubleValidator** , and **QRegExpValidator** .
        """
        ...

    def setReadOnly(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#readOnly-prop

        **readOnly : bool**

        This property holds whether the line edit is read only.

        In read-only mode, the user can still copy the text to the clipboard, or
        drag and drop the text (if **echoMode** () is **Normal** ), but cannot
        edit it.

        **QLineEdit**  does not show a cursor in read-only mode.

        By default, this property is `false`.

        **Access functions:**

        bool **isReadOnly** () const
        void **setReadOnly** ( **bool** )

        **See also** **setEnabled** ().
        """
        ...

    def isReadOnly(self) -> bool:
        ...

    def setEchoMode(self, a0: "QLineEdit.EchoMode") -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#echoMode-prop

        **echoMode : EchoMode**

        This property holds the line edit's echo mode.

        The echo mode determines how the text entered in the line edit is
        displayed (or echoed) to the user.

        The most common setting is **Normal** , in which the text entered by the
        user is displayed verbatim, but **QLineEdit**  also supports modes that
        allow the entered text to be suppressed or obscured: these include
        **NoEcho** , **Password**  and **PasswordEchoOnEdit** .

        The widget's display and the ability to copy or drag the text is
        affected by this setting.

        By default, this property is set to **Normal** .

        **Access functions:**

        QLineEdit::EchoMode **echoMode** () const
        void **setEchoMode** (
        **QLineEdit::EchoMode** )

        **See also** **EchoMode**  and **displayText** ().
        """
        ...

    def echoMode(self) -> "QLineEdit.EchoMode":
        """
        https://doc.qt.io/qt-5/qlineedit.html#echoMode-prop

        **echoMode : EchoMode**

        This property holds the line edit's echo mode.

        The echo mode determines how the text entered in the line edit is
        displayed (or echoed) to the user.

        The most common setting is **Normal** , in which the text entered by the
        user is displayed verbatim, but **QLineEdit**  also supports modes that
        allow the entered text to be suppressed or obscured: these include
        **NoEcho** , **Password**  and **PasswordEchoOnEdit** .

        The widget's display and the ability to copy or drag the text is
        affected by this setting.

        By default, this property is set to **Normal** .

        **Access functions:**

        QLineEdit::EchoMode **echoMode** () const
        void **setEchoMode** (
        **QLineEdit::EchoMode** )

        **See also** **EchoMode**  and **displayText** ().
        """
        ...

    def hasFrame(self) -> bool:
        ...

    def setFrame(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#frame-prop

        **frame : bool**

        This property holds whether the line edit draws itself with a frame.

        If enabled (the default) the line edit draws itself inside a frame,
        otherwise the line edit draws itself without any frame.

        **Access functions:**

        bool **hasFrame** () const
        void **setFrame** ( **bool** )
        """
        ...

    def setMaxLength(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qlineedit.html#maxLength-prop

        **maxLength : int**

        This property holds the maximum permitted length of the text.

        If the text is too long, it is truncated at the limit.

        If truncation occurs any selected text will be unselected, the cursor
        position is set to 0 and the first part of the string is shown.

        If the line edit has an input mask, the mask defines the maximum string
        length.

        By default, this property contains a value of 32767.

        **Access functions:**

        int **maxLength** () const
        void **setMaxLength** ( **int** )

        **See also** **inputMask** .
        """
        ...

    def maxLength(self) -> int:
        """
        https://doc.qt.io/qt-5/qlineedit.html#maxLength-prop

        **maxLength : int**

        This property holds the maximum permitted length of the text.

        If the text is too long, it is truncated at the limit.

        If truncation occurs any selected text will be unselected, the cursor
        position is set to 0 and the first part of the string is shown.

        If the line edit has an input mask, the mask defines the maximum string
        length.

        By default, this property contains a value of 32767.

        **Access functions:**

        int **maxLength** () const
        void **setMaxLength** ( **int** )

        **See also** **inputMask** .
        """
        ...

    def displayText(self) -> str:
        """
        https://doc.qt.io/qt-5/qlineedit.html#displayText-prop

        **displayText : const QString**

        This property holds the displayed text.

        If **echoMode**  is **Normal**  this returns the same as **text** (); if
        **EchoMode**  is **Password**  or **PasswordEchoOnEdit**  it returns a
        string of platform-dependent password mask characters **text**
        ().**length** () in size, e.g. "******"; if **EchoMode**  is **NoEcho**
        returns an empty string, "".

        By default, this property contains an empty string.

        **Access functions:**

        QString **displayText** () const

        **See also** **setEchoMode** (), **text** (), and **EchoMode** .
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-5/qlineedit.html#text-prop

        **text : QString**

        This property holds the line edit's text.

        Setting this property clears the selection, clears the undo/redo
        history, moves the cursor to the end of the line and resets the
        **modified**  property to false. The text is not validated when inserted
        with setText().

        The text is truncated to **maxLength** () length.

        By default, this property contains an empty string.

        **Access functions:**

        QString **text** () const
        void **setText** ( **const QString &**)

        **Notifier signal:**

        void ****textChanged** ** (const QString & **text** )

        **See also** **insert** () and **clear** ().
        """
        ...

    @property
    def cursorPositionChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlineedit.html#cursorPositionChanged

        **[signal] void QLineEdit::cursorPositionChanged(int oldPos , int newPos
        )**

        This signal is emitted whenever the cursor moves. The previous position
        is given by **oldPos** , and the new position by **newPos**.

        **See also** **setCursorPosition** () and **cursorPosition** ().
        """
        ...

    @property
    def editingFinished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlineedit.html#editingFinished

        **[signal] void QLineEdit::editingFinished()**

        This signal is emitted when the Return or Enter key is pressed or the
        line edit loses focus. Note that if there is a **validator** () or
        **inputMask** () set on the line edit and enter/return is pressed, the
        editingFinished() signal will only be emitted if the input follows the
        **inputMask** () and the **validator** () returns
        **QValidator::Acceptable** .
        """
        ...

    @property
    def inputRejected(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlineedit.html#inputRejected

        **[signal] void QLineEdit::inputRejected()**

        This signal is emitted when the user presses a key that is not
        considered to be acceptable input. For example, if a key press results
        in a validator's validate() call to return Invalid. Another case is when
        trying to enter in more characters beyond the maximum length of the line
        edit.

        Note: This signal will still be emitted in a case where part of the text
        is accepted but not all of it is. For example, if there is a maximum
        length set and the clipboard text is longer than the maximum length when
        it is pasted.

        This function was introduced in Qt 5.12.
        """
        ...

    @property
    def returnPressed(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlineedit.html#returnPressed

        **[signal] void QLineEdit::returnPressed()**

        This signal is emitted when the Return or Enter key is pressed. Note
        that if there is a **validator** () or **inputMask** () set on the line
        edit, the returnPressed() signal will only be emitted if the input
        follows the **inputMask** () and the **validator** () returns
        **QValidator::Acceptable** .
        """
        ...

    @property
    def selectionChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlineedit.html#selectionChanged

        **[signal] void QLineEdit::selectionChanged()**

        This signal is emitted whenever the selection changes.

        **See also** **hasSelectedText** () and **selectedText** ().
        """
        ...

    @property
    def textChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlineedit.html#textChanged

        **[signal] void QLineEdit::textChanged(const QString & text )**

        This signal is emitted whenever the text changes. The **text** argument
        is the new text.

        Unlike **textEdited** (), this signal is also emitted when the text is
        changed programmatically, for example, by calling **setText** ().

        **Note:** Notifier signal for property **text** .
        """
        ...

    @property
    def textEdited(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlineedit.html#textEdited

        **[signal] void QLineEdit::textEdited(const QString & text )**

        This signal is emitted whenever the text is edited. The **text**
        argument is the new text.

        Unlike **textChanged** (), this signal is not emitted when the text is
        changed programmatically, for example, by calling **setText** ().
        """
        ...
