"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtWidgets import *
from PyQt5 import sip


class QInputDialog(QDialog):
    """
    https://doc.qt.io/qt-5/qinputdialog.html

    **Detailed Description**

    The input value can be a string, a number or an item from a list. A label
    must be set to tell the user what they should enter.

    Five static convenience functions are provided: **getText** (),
    **getMultiLineText** (), **getInt** (), **getDouble** (), and **getItem**
    (). All the functions can be used in a similar way, for example:

    bool ok;
            **QString**  text = **QInputDialog** ::getText(this,
    tr("QInputDialog::getText()"),
    tr("User name:"), **QLineEdit** ::Normal,
    **QDir** ::home().dirName(), &ok);
            if (ok && !text.isEmpty())
    textLabel->setText(text);

    The `ok` variable is set to true if the user clicks **OK** ; otherwise, it
    is set to false.

    ![Input Dialogs](images/inputdialogs.png)

    The **Standard Dialogs**  example shows how to use QInputDialog as well as
    other built-in Qt dialogs.

    **See also** **QMessageBox**  and **Standard Dialogs Example** .
    """

    class InputMode(int):
        TextInput: QInputDialog = ...
        IntInput: QInputDialog = ...
        DoubleInput: QInputDialog = ...

    class InputDialogOption(int):
        NoButtons: QInputDialog = ...
        UseListViewForComboBoxItems: QInputDialog = ...
        UsePlainTextEditForTextInput: QInputDialog = ...

    class InputDialogOptions(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QInputDialog.InputDialogOptions", "QInputDialog.InputDialogOption"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QInputDialog.InputDialogOptions") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QInputDialog.InputDialogOptions":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(
        self,
        parent: typing.Optional[QWidget] = ...,
        flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#QInputDialog

        **QInputDialog::QInputDialog(QWidget * parent = nullptr, Qt::WindowFlags
        flags = Qt::WindowFlags())**

        Constructs a new input dialog with the given **parent** and window
        **flags**.

        This function was introduced in Qt 4.5.
        """
        ...

    def doubleStep(self) -> float:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#doubleStep-prop

        **doubleStep : double**

        This property holds the step by which the double value is increased and
        decreased

        This property is only relevant when the input dialog is used in
        **DoubleInput**  mode.

        This property was introduced in Qt 5.10.

        **Access functions:**

        double **doubleStep** () const
        void **setDoubleStep** (double **step**
        )
        """
        ...

    def setDoubleStep(self, step: float) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#doubleStep-prop

        **doubleStep : double**

        This property holds the step by which the double value is increased and
        decreased

        This property is only relevant when the input dialog is used in
        **DoubleInput**  mode.

        This property was introduced in Qt 5.10.

        **Access functions:**

        double **doubleStep** () const
        void **setDoubleStep** (double **step**
        )
        """
        ...

    def done(self, result: int) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#done

        **[override virtual] void QInputDialog::done(int result )**

        Reimplements: **QDialog::done** (int r).

        Closes the dialog and sets its result code to **result**. If this dialog
        is shown with **exec** (), done() causes the local event loop to finish,
        and **exec** () to return **result**.

        **See also** **QDialog::done** ().
        """
        ...

    def setVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#setVisible

        **[override virtual] void QInputDialog::setVisible(bool visible )**

        Reimplements: **QDialog::setVisible** (bool visible).
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#sizeHint

        **[override virtual] QSize QInputDialog::sizeHint() const**

        Reimplements: **QDialog::sizeHint** () const.
        """
        ...

    def minimumSizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#minimumSizeHint

        **[override virtual] QSize QInputDialog::minimumSizeHint() const**

        Reimplements: **QDialog::minimumSizeHint** () const.
        """
        ...

    @typing.overload
    def open(self) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#open

        **void QInputDialog::open(QObject * receiver , const char * member )**

        This function connects one of its signals to the slot specified by
        **receiver** and **member**. The specific signal depends on the
        arguments that are specified in **member**. These are:

        * **textValueSelected** () if **member** has a **QString**  for its
        first argument.
          * **intValueSelected** () if **member** has an int for
        its first argument.
          * **doubleValueSelected** () if **member** has a
        double for its first argument.
          * **accepted** () if **member** has NO
        arguments.

        The signal will be disconnected from the slot when the dialog is closed.

        This function was introduced in Qt 4.5.
        """
        ...

    @typing.overload
    def open(self, slot: PYQT_SLOT) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#open

        **void QInputDialog::open(QObject * receiver , const char * member )**

        This function connects one of its signals to the slot specified by
        **receiver** and **member**. The specific signal depends on the
        arguments that are specified in **member**. These are:

        * **textValueSelected** () if **member** has a **QString**  for its
        first argument.
          * **intValueSelected** () if **member** has an int for
        its first argument.
          * **doubleValueSelected** () if **member** has a
        double for its first argument.
          * **accepted** () if **member** has NO
        arguments.

        The signal will be disconnected from the slot when the dialog is closed.

        This function was introduced in Qt 4.5.
        """
        ...

    def cancelButtonText(self) -> str:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#cancelButtonText-prop

        **cancelButtonText : QString**

        This property holds the text for the button used to cancel the dialog

        This property was introduced in Qt 4.5.

        **Access functions:**

        QString **cancelButtonText** () const
        void **setCancelButtonText**
        (const QString & **text** )
        """
        ...

    def setCancelButtonText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#cancelButtonText-prop

        **cancelButtonText : QString**

        This property holds the text for the button used to cancel the dialog

        This property was introduced in Qt 4.5.

        **Access functions:**

        QString **cancelButtonText** () const
        void **setCancelButtonText**
        (const QString & **text** )
        """
        ...

    def okButtonText(self) -> str:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#okButtonText-prop

        **okButtonText : QString**

        This property holds the text for the button used to accept the entry in
        the dialog

        This property was introduced in Qt 4.5.

        **Access functions:**

        QString **okButtonText** () const
        void **setOkButtonText** (const
        QString & **text** )
        """
        ...

    def setOkButtonText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#okButtonText-prop

        **okButtonText : QString**

        This property holds the text for the button used to accept the entry in
        the dialog

        This property was introduced in Qt 4.5.

        **Access functions:**

        QString **okButtonText** () const
        void **setOkButtonText** (const
        QString & **text** )
        """
        ...

    def doubleDecimals(self) -> int:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#doubleDecimals-prop

        **doubleDecimals : int**

        sets the precision of the double spinbox in decimals

        This property was introduced in Qt 4.5.

        **Access functions:**

        int **doubleDecimals** () const
        void **setDoubleDecimals** (int
        **decimals** )

        **See also** **QDoubleSpinBox::setDecimals** ().
        """
        ...

    def setDoubleDecimals(self, decimals: int) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#doubleDecimals-prop

        **doubleDecimals : int**

        sets the precision of the double spinbox in decimals

        This property was introduced in Qt 4.5.

        **Access functions:**

        int **doubleDecimals** () const
        void **setDoubleDecimals** (int
        **decimals** )

        **See also** **QDoubleSpinBox::setDecimals** ().
        """
        ...

    def setDoubleRange(self, min: float, max: float) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#setDoubleRange

        **void QInputDialog::setDoubleRange(double min , double max )**

        Sets the range of double precision floating point values accepted by the
        dialog when used in **DoubleInput**  mode, with minimum and maximum
        values specified by **min** and **max** respectively.
        """
        ...

    def doubleMaximum(self) -> float:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#doubleMaximum-prop

        **doubleMaximum : double**

        This property holds the maximum double precision floating point value
        accepted as input

        This property is only relevant when the input dialog is used in
        **DoubleInput**  mode.

        This property was introduced in Qt 4.5.

        **Access functions:**

        double **doubleMaximum** () const
        void **setDoubleMaximum** (double
        **max** )
        """
        ...

    def setDoubleMaximum(self, max: float) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#doubleMaximum-prop

        **doubleMaximum : double**

        This property holds the maximum double precision floating point value
        accepted as input

        This property is only relevant when the input dialog is used in
        **DoubleInput**  mode.

        This property was introduced in Qt 4.5.

        **Access functions:**

        double **doubleMaximum** () const
        void **setDoubleMaximum** (double
        **max** )
        """
        ...

    def doubleMinimum(self) -> float:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#doubleMinimum-prop

        **doubleMinimum : double**

        This property holds the minimum double precision floating point value
        accepted as input

        This property is only relevant when the input dialog is used in
        **DoubleInput**  mode.

        This property was introduced in Qt 4.5.

        **Access functions:**

        double **doubleMinimum** () const
        void **setDoubleMinimum** (double
        **min** )
        """
        ...

    def setDoubleMinimum(self, min: float) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#doubleMinimum-prop

        **doubleMinimum : double**

        This property holds the minimum double precision floating point value
        accepted as input

        This property is only relevant when the input dialog is used in
        **DoubleInput**  mode.

        This property was introduced in Qt 4.5.

        **Access functions:**

        double **doubleMinimum** () const
        void **setDoubleMinimum** (double
        **min** )
        """
        ...

    def doubleValue(self) -> float:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#doubleValue-prop

        **doubleValue : int**

        This property holds the current double precision floating point value
        accepted as input

        This property is only relevant when the input dialog is used in
        **DoubleInput**  mode.

        This property was introduced in Qt 4.5.

        **Access functions:**

        double **doubleValue** () const
        void **setDoubleValue** (double
        **value** )

        **Notifier signal:**

        void ****doubleValueChanged** ** (double **value** )
        """
        ...

    def setDoubleValue(self, value: float) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#doubleValue-prop

        **doubleValue : int**

        This property holds the current double precision floating point value
        accepted as input

        This property is only relevant when the input dialog is used in
        **DoubleInput**  mode.

        This property was introduced in Qt 4.5.

        **Access functions:**

        double **doubleValue** () const
        void **setDoubleValue** (double
        **value** )

        **Notifier signal:**

        void ****doubleValueChanged** ** (double **value** )
        """
        ...

    def intStep(self) -> int:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#intStep-prop

        **intStep : int**

        This property holds the step by which the integer value is increased and
        decreased

        This property is only relevant when the input dialog is used in
        **IntInput**  mode.

        This property was introduced in Qt 4.5.

        **Access functions:**

        int **intStep** () const
        void **setIntStep** (int **step** )
        """
        ...

    def setIntStep(self, step: int) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#intStep-prop

        **intStep : int**

        This property holds the step by which the integer value is increased and
        decreased

        This property is only relevant when the input dialog is used in
        **IntInput**  mode.

        This property was introduced in Qt 4.5.

        **Access functions:**

        int **intStep** () const
        void **setIntStep** (int **step** )
        """
        ...

    def setIntRange(self, min: int, max: int) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#setIntRange

        **void QInputDialog::setIntRange(int min , int max )**

        Sets the range of integer values accepted by the dialog when used in
        **IntInput**  mode, with minimum and maximum values specified by **min**
        and **max** respectively.
        """
        ...

    def intMaximum(self) -> int:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#intMaximum-prop

        **intMaximum : int**

        This property holds the maximum integer value accepted as input

        This property is only relevant when the input dialog is used in
        **IntInput**  mode.

        This property was introduced in Qt 4.5.

        **Access functions:**

        int **intMaximum** () const
        void **setIntMaximum** (int **max** )
        """
        ...

    def setIntMaximum(self, max: int) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#intMaximum-prop

        **intMaximum : int**

        This property holds the maximum integer value accepted as input

        This property is only relevant when the input dialog is used in
        **IntInput**  mode.

        This property was introduced in Qt 4.5.

        **Access functions:**

        int **intMaximum** () const
        void **setIntMaximum** (int **max** )
        """
        ...

    def intMinimum(self) -> int:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#intMinimum-prop

        **intMinimum : int**

        This property holds the minimum integer value accepted as input

        This property is only relevant when the input dialog is used in
        **IntInput**  mode.

        This property was introduced in Qt 4.5.

        **Access functions:**

        int **intMinimum** () const
        void **setIntMinimum** (int **min** )
        """
        ...

    def setIntMinimum(self, min: int) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#intMinimum-prop

        **intMinimum : int**

        This property holds the minimum integer value accepted as input

        This property is only relevant when the input dialog is used in
        **IntInput**  mode.

        This property was introduced in Qt 4.5.

        **Access functions:**

        int **intMinimum** () const
        void **setIntMinimum** (int **min** )
        """
        ...

    def intValue(self) -> int:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#intValue-prop

        **intValue : int**

        This property holds the current integer value accepted as input

        This property is only relevant when the input dialog is used in
        **IntInput**  mode.

        This property was introduced in Qt 4.5.

        **Access functions:**

        int **intValue** () const
        void **setIntValue** (int **value** )

        **Notifier signal:**

        void ****intValueChanged** ** (int **value** )
        """
        ...

    def setIntValue(self, value: int) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#intValue-prop

        **intValue : int**

        This property holds the current integer value accepted as input

        This property is only relevant when the input dialog is used in
        **IntInput**  mode.

        This property was introduced in Qt 4.5.

        **Access functions:**

        int **intValue** () const
        void **setIntValue** (int **value** )

        **Notifier signal:**

        void ****intValueChanged** ** (int **value** )
        """
        ...

    def comboBoxItems(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#comboBoxItems-prop

        **comboBoxItems : QStringList**

        This property holds the items used in the combo box for the input dialog

        This property was introduced in Qt 4.5.

        **Access functions:**

        QStringList **comboBoxItems** () const
        void **setComboBoxItems**
        (const QStringList & **items** )
        """
        ...

    def setComboBoxItems(self, items: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#comboBoxItems-prop

        **comboBoxItems : QStringList**

        This property holds the items used in the combo box for the input dialog

        This property was introduced in Qt 4.5.

        **Access functions:**

        QStringList **comboBoxItems** () const
        void **setComboBoxItems**
        (const QStringList & **items** )
        """
        ...

    def isComboBoxEditable(self) -> bool:
        ...

    def setComboBoxEditable(self, editable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#comboBoxEditable-prop

        **comboBoxEditable : bool**

        This property holds whether or not the combo box used in the input
        dialog is editable

        This property was introduced in Qt 4.5.

        **Access functions:**

        bool **isComboBoxEditable** () const
        void **setComboBoxEditable**
        (bool **editable** )
        """
        ...

    def textEchoMode(self) -> "QLineEdit.EchoMode":
        """
        https://doc.qt.io/qt-5/qinputdialog.html#textEchoMode-prop

        **textEchoMode : QLineEdit::EchoMode**

        This property holds the echo mode for the text value

        This property is only relevant when the input dialog is used in
        **TextInput**  mode.

        This property was introduced in Qt 4.5.

        **Access functions:**

        QLineEdit::EchoMode **textEchoMode** () const
        void **setTextEchoMode**
        (QLineEdit::EchoMode **mode** )
        """
        ...

    def setTextEchoMode(self, mode: "QLineEdit.EchoMode") -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#textEchoMode-prop

        **textEchoMode : QLineEdit::EchoMode**

        This property holds the echo mode for the text value

        This property is only relevant when the input dialog is used in
        **TextInput**  mode.

        This property was introduced in Qt 4.5.

        **Access functions:**

        QLineEdit::EchoMode **textEchoMode** () const
        void **setTextEchoMode**
        (QLineEdit::EchoMode **mode** )
        """
        ...

    def textValue(self) -> str:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#textValue-prop

        **textValue : QString**

        This property holds the text value for the input dialog

        This property is only relevant when the input dialog is used in
        **TextInput**  mode.

        This property was introduced in Qt 4.5.

        **Access functions:**

        QString **textValue** () const
        void **setTextValue** (const QString &
        **text** )

        **Notifier signal:**

        void ****textValueChanged** ** (const QString & **text** )

        **Member Function Documentation**
        """
        ...

    def setTextValue(self, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#textValue-prop

        **textValue : QString**

        This property holds the text value for the input dialog

        This property is only relevant when the input dialog is used in
        **TextInput**  mode.

        This property was introduced in Qt 4.5.

        **Access functions:**

        QString **textValue** () const
        void **setTextValue** (const QString &
        **text** )

        **Notifier signal:**

        void ****textValueChanged** ** (const QString & **text** )

        **Member Function Documentation**
        """
        ...

    def options(self) -> "QInputDialog.InputDialogOptions":
        """
        https://doc.qt.io/qt-5/qinputdialog.html#options-prop

        **options : InputDialogOptions**

        This property holds the various options that affect the look and feel of
        the dialog

        By default, all options are disabled.

        This property was introduced in Qt 4.5.

        **Access functions:**

        QInputDialog::InputDialogOptions **options** () const
        void
        **setOptions** (QInputDialog::InputDialogOptions **options** )

        **See also** **setOption** () and **testOption** ().
        """
        ...

    def setOptions(
        self,
        options: typing.Union[
            "QInputDialog.InputDialogOptions", "QInputDialog.InputDialogOption"
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#options-prop

        **options : InputDialogOptions**

        This property holds the various options that affect the look and feel of
        the dialog

        By default, all options are disabled.

        This property was introduced in Qt 4.5.

        **Access functions:**

        QInputDialog::InputDialogOptions **options** () const
        void
        **setOptions** (QInputDialog::InputDialogOptions **options** )

        **See also** **setOption** () and **testOption** ().
        """
        ...

    def testOption(self, option: "QInputDialog.InputDialogOption") -> bool:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#testOption

        **bool QInputDialog::testOption(QInputDialog::InputDialogOption option )
        const**

        Returns `true` if the given **option** is enabled; otherwise, returns
        false.

        **See also** **options**  and **setOption** ().
        """
        ...

    def setOption(
        self, option: "QInputDialog.InputDialogOption", on: bool = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#setOption

        **void QInputDialog::setOption(QInputDialog::InputDialogOption option ,
        bool on = true)**

        Sets the given **option** to be enabled if **on** is true; otherwise,
        clears the given **option**.

        **See also** **options**  and **testOption** ().
        """
        ...

    def labelText(self) -> str:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#labelText-prop

        **labelText : QString**

        This property holds the label's text which describes what needs to be
        input

        This property was introduced in Qt 4.5.

        **Access functions:**

        QString **labelText** () const
        void **setLabelText** (const QString &
        **text** )
        """
        ...

    def setLabelText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#labelText-prop

        **labelText : QString**

        This property holds the label's text which describes what needs to be
        input

        This property was introduced in Qt 4.5.

        **Access functions:**

        QString **labelText** () const
        void **setLabelText** (const QString &
        **text** )
        """
        ...

    def inputMode(self) -> "QInputDialog.InputMode":
        """
        https://doc.qt.io/qt-5/qinputdialog.html#inputMode-prop

        **inputMode : InputMode**

        This property holds the mode used for input

        This property helps determine which widget is used for entering input
        into the dialog.

        This property was introduced in Qt 4.5.

        **Access functions:**

        QInputDialog::InputMode **inputMode** () const
        void **setInputMode**
        (QInputDialog::InputMode **mode** )
        """
        ...

    def setInputMode(self, mode: "QInputDialog.InputMode") -> None:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#inputMode-prop

        **inputMode : InputMode**

        This property holds the mode used for input

        This property helps determine which widget is used for entering input
        into the dialog.

        This property was introduced in Qt 4.5.

        **Access functions:**

        QInputDialog::InputMode **inputMode** () const
        void **setInputMode**
        (QInputDialog::InputMode **mode** )
        """
        ...

    @staticmethod
    def getMultiLineText(
        parent: QWidget,
        title: str,
        label: str,
        text: str = ...,
        flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...,
        inputMethodHints: typing.Union[
            QtCore.Qt.InputMethodHints, QtCore.Qt.InputMethodHint
        ] = ...,
    ) -> typing.Tuple[str, bool]:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#getMultiLineText

        **[static] QString QInputDialog::getMultiLineText(QWidget * parent ,
        const QString & title , const QString & label , const QString & text =
        QString(), bool * ok = nullptr, Qt::WindowFlags flags =
        Qt::WindowFlags(), Qt::InputMethodHints inputMethodHints =
        Qt::ImhNone)**

        Static convenience function to get a multiline string from the user.

        **title** is the text which is displayed in the title bar of the dialog.
        **label** is the text which is shown to the user (it should say what
        should be entered). **text** is the default text which is placed in the
        plain text edit. **inputMethodHints** is the input method hints that
        will be used in the edit widget if an input method is active.

        If **ok** is nonnull ***ok** will be set to true if the user pressed
        **OK** and to false if the user pressed **Cancel**. The dialog's parent
        is **parent**. The dialog will be modal and uses the specified widget
        **flags**.

        If the dialog is accepted, this function returns the text in the
        dialog's plain text edit. If the dialog is rejected, a null **QString**
        is returned.

        Use this static function like this:

        bool ok;
                **QString**  text = **QInputDialog**
        ::getMultiLineText(this, tr("QInputDialog::getMultiLineText()"),
        tr("Address:"), "John Doe\\nFreedom Street", &ok);
                if (ok &&
        !text.isEmpty())
                    multiLineTextLabel->setText(text);

        This function was introduced in Qt 5.2.

        **See also** **getInt** (), **getDouble** (), **getItem** (), and
        **getText** ().
        """
        ...

    @staticmethod
    def getItem(
        parent: QWidget,
        title: str,
        label: str,
        items: typing.Iterable[str],
        current: int = ...,
        editable: bool = ...,
        flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...,
        inputMethodHints: typing.Union[
            QtCore.Qt.InputMethodHints, QtCore.Qt.InputMethodHint
        ] = ...,
    ) -> typing.Tuple[str, bool]:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#getItem

        **[static] QString QInputDialog::getItem(QWidget * parent , const
        QString & title , const QString & label , const QStringList & items ,
        int current = 0, bool editable = true, bool * ok = nullptr,
        Qt::WindowFlags flags = Qt::WindowFlags(), Qt::InputMethodHints
        inputMethodHints = Qt::ImhNone)**

        Static convenience function to let the user select an item from a string
        list.

        **title** is the text which is displayed in the title bar of the dialog.
        **label** is the text which is shown to the user (it should say what
        should be entered). **items** is the string list which is inserted into
        the combo box. **current** is the number of the item which should be the
        current item. **inputMethodHints** is the input method hints that will
        be used if the combo box is editable and an input method is active.

        If **editable** is true the user can enter their own text; otherwise,
        the user may only select one of the existing items.

        If **ok** is nonnull ***ok** will be set to true if the user pressed
        **OK** and to false if the user pressed **Cancel**. The dialog's parent
        is **parent**. The dialog will be modal and uses the widget **flags**.

        This function returns the text of the current item, or if **editable**
        is true, the current text of the combo box.

        Use this static function like this:

        **QStringList**  items;
                items << tr("Spring") << tr("Summer") <<
        tr("Fall") << tr("Winter");

                bool ok;
                **QString**
        item = **QInputDialog** ::getItem(this, tr("QInputDialog::getItem()"),
        tr("Season:"), items, 0, false, &ok);
                if (ok && !item.isEmpty())
        itemLabel->setText(item);

        **See also** **getText** (), **getInt** (), **getDouble** (), and
        **getMultiLineText** ().
        """
        ...

    @typing.overload
    @staticmethod
    def getDouble(
        parent: QWidget,
        title: str,
        label: str,
        value: float = ...,
        min: float = ...,
        max: float = ...,
        decimals: int = ...,
        flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...,
    ) -> typing.Tuple[float, bool]:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#getDouble

        **[static] double QInputDialog::getDouble(QWidget * parent , const
        QString & title , const QString & label , double value = 0, double min =
        -2147483647, double max = 2147483647, int decimals = 1, bool * ok =
        nullptr, Qt::WindowFlags flags = Qt::WindowFlags(), double step = 1)**

        Static convenience function to get a floating point number from the
        user.

        **title** is the text which is displayed in the title bar of the dialog.
        **label** is the text which is shown to the user (it should say what
        should be entered). **value** is the default floating point number that
        the line edit will be set to. **min** and **max** are the minimum and
        maximum values the user may choose. **decimals** is the maximum number
        of decimal places the number may have. **step** is the amount by which
        the values change as the user presses the arrow buttons to increment or
        decrement the value.

        If **ok** is nonnull, * **ok** will be set to true if the user pressed
        **OK** and to false if the user pressed **Cancel**. The dialog's parent
        is **parent**. The dialog will be modal and uses the widget **flags**.

        This function returns the floating point number which has been entered
        by the user.

        Use this static function like this:

        bool ok;
                double d = **QInputDialog** ::getDouble(this,
        tr("QInputDialog::getDouble()"),
        tr("Amount:"), 37.56, -10000, 10000, 2, &ok,
        Qt::WindowFlags(), 1);
                if (ok)
        doubleLabel->setText(**QString** ("$%1").arg(d));

        **See also** **getText** (), **getInt** (), **getItem** (), and
        **getMultiLineText** ().
        """
        ...

    @typing.overload
    @staticmethod
    def getDouble(
        parent: QWidget,
        title: str,
        label: str,
        value: float,
        minValue: float,
        maxValue: float,
        decimals: int,
        flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType],
        step: float,
    ) -> typing.Tuple[float, bool]:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#getDouble

        **[static] double QInputDialog::getDouble(QWidget * parent , const
        QString & title , const QString & label , double value = 0, double min =
        -2147483647, double max = 2147483647, int decimals = 1, bool * ok =
        nullptr, Qt::WindowFlags flags = Qt::WindowFlags(), double step = 1)**

        Static convenience function to get a floating point number from the
        user.

        **title** is the text which is displayed in the title bar of the dialog.
        **label** is the text which is shown to the user (it should say what
        should be entered). **value** is the default floating point number that
        the line edit will be set to. **min** and **max** are the minimum and
        maximum values the user may choose. **decimals** is the maximum number
        of decimal places the number may have. **step** is the amount by which
        the values change as the user presses the arrow buttons to increment or
        decrement the value.

        If **ok** is nonnull, * **ok** will be set to true if the user pressed
        **OK** and to false if the user pressed **Cancel**. The dialog's parent
        is **parent**. The dialog will be modal and uses the widget **flags**.

        This function returns the floating point number which has been entered
        by the user.

        Use this static function like this:

        bool ok;
                double d = **QInputDialog** ::getDouble(this,
        tr("QInputDialog::getDouble()"),
        tr("Amount:"), 37.56, -10000, 10000, 2, &ok,
        Qt::WindowFlags(), 1);
                if (ok)
        doubleLabel->setText(**QString** ("$%1").arg(d));

        **See also** **getText** (), **getInt** (), **getItem** (), and
        **getMultiLineText** ().
        """
        ...

    @staticmethod
    def getInt(
        parent: QWidget,
        title: str,
        label: str,
        value: int = ...,
        min: int = ...,
        max: int = ...,
        step: int = ...,
        flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...,
    ) -> typing.Tuple[int, bool]:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#getInt

        **[static] int QInputDialog::getInt(QWidget * parent , const QString &
        title , const QString & label , int value = 0, int min = -2147483647,
        int max = 2147483647, int step = 1, bool * ok = nullptr, Qt::WindowFlags
        flags = Qt::WindowFlags())**

        Static convenience function to get an integer input from the user.

        **title** is the text which is displayed in the title bar of the dialog.
        **label** is the text which is shown to the user (it should say what
        should be entered). **value** is the default integer which the spinbox
        will be set to. **min** and **max** are the minimum and maximum values
        the user may choose. **step** is the amount by which the values change
        as the user presses the arrow buttons to increment or decrement the
        value.

        If **ok** is nonnull * **ok** will be set to true if the user pressed
        **OK** and to false if the user pressed **Cancel**. The dialog's parent
        is **parent**. The dialog will be modal and uses the widget **flags**.

        On success, this function returns the integer which has been entered by
        the user; on failure, it returns the initial **value**.

        Use this static function like this:

        bool ok;
                int i = **QInputDialog** ::getInt(this,
        tr("QInputDialog::getInt()"),
        tr("Percentage:"), 25, 0, 100, 1, &ok);
                if (ok)
        integerLabel->setText(tr("%1%").arg(i));

        This function was introduced in Qt 4.5.

        **See also** **getText** (), **getDouble** (), **getItem** (), and
        **getMultiLineText** ().
        """
        ...

    @staticmethod
    def getText(
        parent: QWidget,
        title: str,
        label: str,
        echo: "QLineEdit.EchoMode" = ...,
        text: str = ...,
        flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...,
        inputMethodHints: typing.Union[
            QtCore.Qt.InputMethodHints, QtCore.Qt.InputMethodHint
        ] = ...,
    ) -> typing.Tuple[str, bool]:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#getText

        **[static] QString QInputDialog::getText(QWidget * parent , const
        QString & title , const QString & label , QLineEdit::EchoMode mode =
        QLineEdit::Normal, const QString & text = QString(), bool * ok =
        nullptr, Qt::WindowFlags flags = Qt::WindowFlags(), Qt::InputMethodHints
        inputMethodHints = Qt::ImhNone)**

        Static convenience function to get a string from the user.

        **title** is the text which is displayed in the title bar of the dialog.
        **label** is the text which is shown to the user (it should say what
        should be entered). **text** is the default text which is placed in the
        line edit. **mode** is the echo mode the line edit will use.
        **inputMethodHints** is the input method hints that will be used in the
        edit widget if an input method is active.

        If **ok** is nonnull ***ok** will be set to true if the user pressed
        **OK** and to false if the user pressed **Cancel**. The dialog's parent
        is **parent**. The dialog will be modal and uses the specified widget
        **flags**.

        If the dialog is accepted, this function returns the text in the
        dialog's line edit. If the dialog is rejected, a null **QString**  is
        returned.

        Use this static function like this:

        bool ok;
                **QString**  text = **QInputDialog** ::getText(this,
        tr("QInputDialog::getText()"),
        tr("User name:"), **QLineEdit** ::Normal,
        **QDir** ::home().dirName(), &ok);
                if (ok && !text.isEmpty())
        textLabel->setText(text);

        **See also** **getInt** (), **getDouble** (), **getItem** (), and
        **getMultiLineText** ().
        """
        ...

    @property
    def doubleValueChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#doubleValueChanged

        **[signal] void QInputDialog::doubleValueChanged(double value )**

        This signal is emitted whenever the double value changes in the dialog.
        The current value is specified by **value**.

        This signal is only relevant when the input dialog is used in
        **DoubleInput**  mode.

        **Note:** Notifier signal for property **doubleValue** .
        """
        ...

    @property
    def doubleValueSelected(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#doubleValueSelected

        **[signal] void QInputDialog::doubleValueSelected(double value )**

        This signal is emitted whenever the user selects a double value by
        accepting the dialog; for example, by clicking the **OK** button. The
        selected value is specified by **value**.

        This signal is only relevant when the input dialog is used in
        **DoubleInput**  mode.
        """
        ...

    @property
    def intValueChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#intValueChanged

        **[signal] void QInputDialog::intValueChanged(int value )**

        This signal is emitted whenever the integer value changes in the dialog.
        The current value is specified by **value**.

        This signal is only relevant when the input dialog is used in
        **IntInput**  mode.

        **Note:** Notifier signal for property **intValue** .
        """
        ...

    @property
    def intValueSelected(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#intValueSelected

        **[signal] void QInputDialog::intValueSelected(int value )**

        This signal is emitted whenever the user selects a integer value by
        accepting the dialog; for example, by clicking the **OK** button. The
        selected value is specified by **value**.

        This signal is only relevant when the input dialog is used in
        **IntInput**  mode.
        """
        ...

    @property
    def textValueChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#textValueChanged

        **[signal] void QInputDialog::textValueChanged(const QString & text )**

        This signal is emitted whenever the text string changes in the dialog.
        The current string is specified by **text**.

        This signal is only relevant when the input dialog is used in
        **TextInput**  mode.

        **Note:** Notifier signal for property **textValue** .
        """
        ...

    @property
    def textValueSelected(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qinputdialog.html#textValueSelected

        **[signal] void QInputDialog::textValueSelected(const QString & text )**

        This signal is emitted whenever the user selects a text string by
        accepting the dialog; for example, by clicking the **OK** button. The
        selected string is specified by **text**.

        This signal is only relevant when the input dialog is used in
        **TextInput**  mode.
        """
        ...
