"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QGraphicsScale(QGraphicsTransform):
    """
    https://doc.qt.io/qt-5/qgraphicsscale.html

    **Detailed Description**

    **QGraphicsScene**  provides certain parameters to help control how the
    scale should be applied.

    The origin is the point that the item is scaled from (i.e., it stays fixed
    relative to the parent as the rest of the item grows). By default the origin
    is **QPointF** (0, 0).

    The parameters **xScale** , **yScale** , and **zScale**  describe the scale
    factors to apply in horizontal, vertical, and depth directions. They can
    take on any value, including 0 (to collapse the item to a point) or negative
    value. A negative **xScale**  value will mirror the item horizontally. A
    negative **yScale**  value will flip the item vertically. A negative
    **zScale**  will flip the item end for end.

    **See also** **QGraphicsTransform** , **QGraphicsItem::setScale** (), and
    **QTransform::scale** ().
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscale.html#QGraphicsScale

        **QGraphicsScale::QGraphicsScale(QObject * parent = nullptr)**

        Constructs an empty QGraphicsScale object with the given **parent**.
        """
        ...

    def applyTo(self, matrix: QtGui.QMatrix4x4) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscale.html#applyTo

        **[override virtual] void QGraphicsScale::applyTo(QMatrix4x4 * matrix )
        const**

        Reimplements: **QGraphicsTransform::applyTo** (QMatrix4x4 *matrix)
        const.
        """
        ...

    def setZScale(self, a0: float) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscale.html#zScale-prop

        **zScale : qreal**

        This property holds the depth scale factor.

        The scale factor can be any real number; the default value is 1.0. If
        you set the factor to 0.0, the item will be collapsed to a single point.
        If you provide a negative value, the item will be flipped end for end
        around its origin.

        **Access functions:**

        qreal **zScale** () const
        void **setZScale** ( **qreal** )

        **Notifier signal:**

        void ****zScaleChanged** ** ()

        **See also** **xScale** , **yScale** , and **origin** .

        **Member Function Documentation**
        """
        ...

    def zScale(self) -> float:
        """
        https://doc.qt.io/qt-5/qgraphicsscale.html#zScale-prop

        **zScale : qreal**

        This property holds the depth scale factor.

        The scale factor can be any real number; the default value is 1.0. If
        you set the factor to 0.0, the item will be collapsed to a single point.
        If you provide a negative value, the item will be flipped end for end
        around its origin.

        **Access functions:**

        qreal **zScale** () const
        void **setZScale** ( **qreal** )

        **Notifier signal:**

        void ****zScaleChanged** ** ()

        **See also** **xScale** , **yScale** , and **origin** .

        **Member Function Documentation**
        """
        ...

    def setYScale(self, a0: float) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscale.html#yScale-prop

        **yScale : qreal**

        This property holds the vertical scale factor.

        The scale factor can be any real number; the default value is 1.0. If
        you set the factor to 0.0, the item will be collapsed to a single point.
        If you provide a negative value, the item will be flipped vertically
        around its origin.

        **Access functions:**

        qreal **yScale** () const
        void **setYScale** ( **qreal** )

        **Notifier signal:**

        void ****yScaleChanged** ** ()

        **See also** **xScale** , **zScale** , and **origin** .
        """
        ...

    def yScale(self) -> float:
        """
        https://doc.qt.io/qt-5/qgraphicsscale.html#yScale-prop

        **yScale : qreal**

        This property holds the vertical scale factor.

        The scale factor can be any real number; the default value is 1.0. If
        you set the factor to 0.0, the item will be collapsed to a single point.
        If you provide a negative value, the item will be flipped vertically
        around its origin.

        **Access functions:**

        qreal **yScale** () const
        void **setYScale** ( **qreal** )

        **Notifier signal:**

        void ****yScaleChanged** ** ()

        **See also** **xScale** , **zScale** , and **origin** .
        """
        ...

    def setXScale(self, a0: float) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscale.html#xScale-prop

        **xScale : qreal**

        This property holds the horizontal scale factor.

        The scale factor can be any real number; the default value is 1.0. If
        you set the factor to 0.0, the item will be collapsed to a single point.
        If you provide a negative value, the item will be mirrored horizontally
        around its origin.

        **Access functions:**

        qreal **xScale** () const
        void **setXScale** ( **qreal** )

        **Notifier signal:**

        void ****xScaleChanged** ** ()

        **See also** **yScale** , **zScale** , and **origin** .
        """
        ...

    def xScale(self) -> float:
        """
        https://doc.qt.io/qt-5/qgraphicsscale.html#xScale-prop

        **xScale : qreal**

        This property holds the horizontal scale factor.

        The scale factor can be any real number; the default value is 1.0. If
        you set the factor to 0.0, the item will be collapsed to a single point.
        If you provide a negative value, the item will be mirrored horizontally
        around its origin.

        **Access functions:**

        qreal **xScale** () const
        void **setXScale** ( **qreal** )

        **Notifier signal:**

        void ****xScaleChanged** ** ()

        **See also** **yScale** , **zScale** , and **origin** .
        """
        ...

    def setOrigin(self, point: QtGui.QVector3D) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsscale.html#origin-prop

        **origin : QVector3D**

        This property holds the origin of the scale in 3D space.

        All scaling will be done relative to this point (i.e., this point will
        stay fixed, relative to the parent, when the item is scaled).

        **Access functions:**

        QVector3D **origin** () const
        void **setOrigin** (const QVector3D &
        **point** )

        **Notifier signal:**

        void ****originChanged** ** ()

        **See also** **xScale** , **yScale** , and **zScale** .
        """
        ...

    def origin(self) -> QtGui.QVector3D:
        """
        https://doc.qt.io/qt-5/qgraphicsscale.html#origin-prop

        **origin : QVector3D**

        This property holds the origin of the scale in 3D space.

        All scaling will be done relative to this point (i.e., this point will
        stay fixed, relative to the parent, when the item is scaled).

        **Access functions:**

        QVector3D **origin** () const
        void **setOrigin** (const QVector3D &
        **point** )

        **Notifier signal:**

        void ****originChanged** ** ()

        **See also** **xScale** , **yScale** , and **zScale** .
        """
        ...

    @property
    def originChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsscale.html#originChanged

        **[signal] void QGraphicsScale::originChanged()**

        **QGraphicsScale**  emits this signal when its origin changes.

        **Note:** Notifier signal for property **origin** .

        **See also** **QGraphicsScale::origin** .
        """
        ...

    @property
    def scaleChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsscale.html#scaleChanged

        **[signal] void QGraphicsScale::scaleChanged()**

        This signal is emitted whenever the **xScale** , **yScale** , or
        **zScale**  of the object changes.

        **See also** **QGraphicsScale::xScale** , **QGraphicsScale::yScale** ,
        and **QGraphicsScale::zScale** .
        """
        ...

    @property
    def xScaleChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsscale.html#xScaleChanged

        **[signal] void QGraphicsScale::xScaleChanged()**

        This signal is emitted whenever the **xScale**  property changes.

        **Note:** Notifier signal for property **xScale** .

        This function was introduced in Qt 4.7.
        """
        ...

    @property
    def yScaleChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsscale.html#yScaleChanged

        **[signal] void QGraphicsScale::yScaleChanged()**

        This signal is emitted whenever the **yScale**  property changes.

        **Note:** Notifier signal for property **yScale** .

        This function was introduced in Qt 4.7.
        """
        ...

    @property
    def zScaleChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsscale.html#zScaleChanged

        **[signal] void QGraphicsScale::zScaleChanged()**

        This signal is emitted whenever the **zScale**  property changes.

        **Note:** Notifier signal for property **zScale** .

        This function was introduced in Qt 4.7.
        """
        ...
