"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QGraphicsPixmapItem(QGraphicsItem):
    """
    https://doc.qt.io/qt-5/qgraphicspixmapitem.html

    **Detailed Description**

    To set the item's pixmap, pass a **QPixmap**  to QGraphicsPixmapItem's
    constructor, or call the **setPixmap** () function. The **pixmap** ()
    function returns the current pixmap.

    QGraphicsPixmapItem uses pixmap's optional alpha mask to provide a
    reasonable implementation of **boundingRect** (), **shape** (), and
    **contains** ().

    ![](images/graphicsview-pixmapitem.png)

    The pixmap is drawn at the item's (0, 0) coordinate, as returned by
    **offset** (). You can change the drawing offset by calling **setOffset**
    ().

    You can set the pixmap's transformation mode by calling
    **setTransformationMode** (). By default, **Qt::FastTransformation**  is
    used, which provides fast, non-smooth scaling. **Qt::SmoothTransformation**
    enables **QPainter::SmoothPixmapTransform**  on the painter, and the quality
    depends on the platform and viewport. The result is usually not as good as
    calling QPixmap::scale() directly. Call **transformationMode** () to get the
    current transformation mode for the item.

    **See also** **QGraphicsPathItem** , **QGraphicsRectItem** ,
    **QGraphicsEllipseItem** , **QGraphicsTextItem** , **QGraphicsPolygonItem**
    , **QGraphicsLineItem** , and **Graphics View Framework** .
    """

    class ShapeMode(int):
        MaskShape: QGraphicsPixmapItem = ...
        BoundingRectShape: QGraphicsPixmapItem = ...
        HeuristicMaskShape: QGraphicsPixmapItem = ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicspixmapitem.html#QGraphicsPixmapItem

        **QGraphicsPixmapItem::QGraphicsPixmapItem(QGraphicsItem * parent =
        nullptr)**

        Constructs a QGraphicsPixmapItem. **parent** is passed to
        **QGraphicsItem** 's constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    @typing.overload
    def __init__(
        self, pixmap: QtGui.QPixmap, parent: typing.Optional[QGraphicsItem] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicspixmapitem.html#QGraphicsPixmapItem-1

        **QGraphicsPixmapItem::QGraphicsPixmapItem(const QPixmap & pixmap ,
        QGraphicsItem * parent = nullptr)**

        Constructs a QGraphicsPixmapItem, using **pixmap** as the default
        pixmap. **parent** is passed to **QGraphicsItem** 's constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    def setShapeMode(self, mode: "QGraphicsPixmapItem.ShapeMode") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicspixmapitem.html#setShapeMode

        **void QGraphicsPixmapItem::setShapeMode(QGraphicsPixmapItem::ShapeMode
        mode )**

        Sets the item's shape mode to **mode**. The shape mode describes how
        **QGraphicsPixmapItem**  calculates its shape. The default mode is
        **MaskShape** .

        **See also** **shapeMode** () and **ShapeMode** .
        """
        ...

    def shapeMode(self) -> "QGraphicsPixmapItem.ShapeMode":
        """
        https://doc.qt.io/qt-5/qgraphicspixmapitem.html#shapeMode

        **QGraphicsPixmapItem::ShapeMode QGraphicsPixmapItem::shapeMode()
        const**

        Returns the item's shape mode. The shape mode describes how
        **QGraphicsPixmapItem**  calculates its shape. The default mode is
        **MaskShape** .

        **See also** **setShapeMode** () and **ShapeMode** .
        """
        ...

    def type(self) -> int:
        """
        https://doc.qt.io/qt-5/qgraphicspixmapitem.html#type

        **[override virtual] int QGraphicsPixmapItem::type() const**

        Reimplements: **QGraphicsItem::type** () const.
        """
        ...

    def opaqueArea(self) -> QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-5/qgraphicspixmapitem.html#opaqueArea

        **[override virtual] QPainterPath QGraphicsPixmapItem::opaqueArea()
        const**

        Reimplements: **QGraphicsItem::opaqueArea** () const.
        """
        ...

    def isObscuredBy(self, item: QGraphicsItem) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicspixmapitem.html#isObscuredBy

        **[override virtual] bool QGraphicsPixmapItem::isObscuredBy(const
        QGraphicsItem * item ) const**

        Reimplements: **QGraphicsItem::isObscuredBy** (const QGraphicsItem
        *item) const.
        """
        ...

    def paint(
        self,
        painter: QtGui.QPainter,
        option: "QStyleOptionGraphicsItem",
        widget: QWidget,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicspixmapitem.html#paint

        **[override virtual] void QGraphicsPixmapItem::paint(QPainter * painter
        , const QStyleOptionGraphicsItem * option , QWidget * widget )**

        Reimplements: **QGraphicsItem::paint** (QPainter *painter, const
        QStyleOptionGraphicsItem *option, QWidget *widget).
        """
        ...

    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicspixmapitem.html#contains

        **[override virtual] bool QGraphicsPixmapItem::contains(const QPointF &
        point ) const**

        Reimplements: **QGraphicsItem::contains** (const QPointF &point) const.
        """
        ...

    def shape(self) -> QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-5/qgraphicspixmapitem.html#shape

        **[override virtual] QPainterPath QGraphicsPixmapItem::shape() const**

        Reimplements: **QGraphicsItem::shape** () const.
        """
        ...

    def boundingRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qgraphicspixmapitem.html#boundingRect

        **[override virtual] QRectF QGraphicsPixmapItem::boundingRect() const**

        Reimplements: **QGraphicsItem::boundingRect** () const.
        """
        ...

    @typing.overload
    def setOffset(self, offset: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicspixmapitem.html#setOffset

        **void QGraphicsPixmapItem::setOffset(const QPointF & offset )**

        Sets the pixmap item's offset to **offset**. **QGraphicsPixmapItem**
        will draw its pixmap using **offset** for its top-left corner.

        **See also** **offset** ().
        """
        ...

    @typing.overload
    def setOffset(self, ax: float, ay: float) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicspixmapitem.html#setOffset-1

        **void QGraphicsPixmapItem::setOffset(qreal x , qreal y )**

        This convenience function is equivalent to calling setOffset(**QPointF**
        ( **x** , **y** )).

        This function was introduced in Qt 4.3.
        """
        ...

    def offset(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qgraphicspixmapitem.html#offset

        **QPointF QGraphicsPixmapItem::offset() const**

        Returns the pixmap item's **offset** , which defines the point of the
        top-left corner of the pixmap, in local coordinates.

        **See also** **setOffset** ().
        """
        ...

    def setTransformationMode(self, mode: QtCore.Qt.TransformationMode) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicspixmapitem.html#setTransformationMode

        **void QGraphicsPixmapItem::setTransformationMode(Qt::TransformationMode
        mode )**

        Sets the pixmap item's transformation mode to **mode** , and toggles an
        update of the item. The default mode is **Qt::FastTransformation** ,
        which provides quick transformation with no smoothing.

        **Qt::SmoothTransformation**  enables
        **QPainter::SmoothPixmapTransform**  on the painter, and the quality
        depends on the platform and viewport. The result is usually not as good
        as calling QPixmap::scale() directly.

        **See also** **transformationMode** ().
        """
        ...

    def transformationMode(self) -> QtCore.Qt.TransformationMode:
        """
        https://doc.qt.io/qt-5/qgraphicspixmapitem.html#transformationMode

        **Qt::TransformationMode QGraphicsPixmapItem::transformationMode()
        const**

        Returns the transformation mode of the pixmap. The default mode is
        **Qt::FastTransformation** , which provides quick transformation with no
        smoothing.

        **See also** **setTransformationMode** ().
        """
        ...

    def setPixmap(self, pixmap: QtGui.QPixmap) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicspixmapitem.html#setPixmap

        **void QGraphicsPixmapItem::setPixmap(const QPixmap & pixmap )**

        Sets the item's pixmap to **pixmap**.

        **See also** **pixmap** ().
        """
        ...

    def pixmap(self) -> QtGui.QPixmap:
        """
        https://doc.qt.io/qt-5/qgraphicspixmapitem.html#pixmap

        **QPixmap QGraphicsPixmapItem::pixmap() const**

        Returns the item's pixmap, or an invalid **QPixmap**  if no pixmap has
        been set.

        **See also** **setPixmap** ().
        """
        ...
