"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QGraphicsObject(QtCore.QObject, QGraphicsItem):
    """
    https://doc.qt.io/qt-5/qgraphicsobject.html

    **Detailed Description**

    The class extends a **QGraphicsItem**  with **QObject** 's signal/slot and
    property mechanisms. It maps many of **QGraphicsItem** 's basic setters and
    getters to properties and adds notification signals for many of them.

    **Parents and Children**

    Each graphics object can be constructed with a parent item. This ensures
    that the item will be destroyed when its parent item is destroyed. Although
    QGraphicsObject inherits from both **QObject**  and **QGraphicsItem** , you
    should use the functions provided by **QGraphicsItem** , **not** **QObject**
    , to manage the relationships between parent and child items.

    The relationships between items can be explored using the **parentItem** ()
    and **childItems** () functions. In the hierarchy of items in a scene, the
    **parentObject** () and **parentWidget** () functions are the equivalent of
    the **QWidget::parent** () and **QWidget::parentWidget** () functions for
    **QWidget**  subclasses.

    **See also** **QGraphicsWidget** .
    """

    def __init__(self, parent: typing.Optional[QGraphicsItem] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsobject.html#QGraphicsObject

        **QGraphicsObject::QGraphicsObject(QGraphicsItem * parent = nullptr)**

        Constructs a QGraphicsObject with **parent**.
        """
        ...

    def event(self, ev: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicsobject.html#event

        **[override virtual protected] bool QGraphicsObject::event(QEvent * ev
        )**

        Reimplements: **QObject::event** (QEvent *e).
        """
        ...

    def updateMicroFocus(self) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsobject.html#updateMicroFocus

        **[protected slot] void QGraphicsObject::updateMicroFocus()**

        Updates the item's micro focus. This is slot for convenience.

        This function was introduced in Qt 4.7.

        **See also** **QInputMethod** .
        """
        ...

    def ungrabGesture(self, type: QtCore.Qt.GestureType) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsobject.html#ungrabGesture

        **void QGraphicsObject::ungrabGesture(Qt::GestureType gesture )**

        Unsubscribes the graphics object from the given **gesture**.

        **See also** **grabGesture** () and **QGestureEvent** .
        """
        ...

    def grabGesture(
        self,
        type: QtCore.Qt.GestureType,
        flags: typing.Union[QtCore.Qt.GestureFlags, QtCore.Qt.GestureFlag] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsobject.html#grabGesture

        **void QGraphicsObject::grabGesture(Qt::GestureType gesture ,
        Qt::GestureFlags flags = Qt::GestureFlags())**

        Subscribes the graphics object to the given **gesture** with specific
        **flags**.

        **See also** **ungrabGesture** () and **QGestureEvent** .
        """
        ...

    @property
    def enabledChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsobject.html#enabledChanged

        **[signal] void QGraphicsObject::enabledChanged()**

        This signal gets emitted whenever the item get's enabled or disabled.

        **Note:** Notifier signal for property **enabled** .

        **See also** **isEnabled** ().
        """
        ...

    @property
    def opacityChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsobject.html#opacityChanged

        **[signal] void QGraphicsObject::opacityChanged()**

        This signal gets emitted whenever the opacity of the item changes

        **Note:** Notifier signal for property **opacity** .

        **See also** **QGraphicsItem::opacity** ().
        """
        ...

    @property
    def parentChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsobject.html#parentChanged

        **[signal] void QGraphicsObject::parentChanged()**

        This signal gets emitted whenever the parent of the item changes

        **Note:** Notifier signal for property **parent** .
        """
        ...

    @property
    def rotationChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsobject.html#rotationChanged

        **[signal] void QGraphicsObject::rotationChanged()**

        This signal gets emitted whenever the roation of the item changes.

        **Note:** Notifier signal for property **rotation** .
        """
        ...

    @property
    def scaleChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsobject.html#scaleChanged

        **[signal] void QGraphicsObject::scaleChanged()**

        This signal is emitted when the scale of the item changes.

        **Note:** Notifier signal for property **scale** .
        """
        ...

    @property
    def visibleChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsobject.html#visibleChanged

        **[signal] void QGraphicsObject::visibleChanged()**

        This signal gets emitted whenever the visibility of the item changes

        **Note:** Notifier signal for property **visible** .

        **See also** **visible** .
        """
        ...

    @property
    def xChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsobject.html#xChanged

        **[signal] void QGraphicsObject::xChanged()**

        This signal gets emitted whenever the x position of the item changes

        **Note:** Notifier signal for property **x** .

        **See also** **pos** ().
        """
        ...

    @property
    def yChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsobject.html#yChanged

        **[signal] void QGraphicsObject::yChanged()**

        This signal gets emitted whenever the y position of the item changes.

        **Note:** Notifier signal for property **y** .

        **See also** **pos** ().
        """
        ...

    @property
    def zChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsobject.html#zChanged

        **[signal] void QGraphicsObject::zChanged()**

        This signal gets emitted whenever the z value of the item changes.

        **Note:** Notifier signal for property **z** .

        **See also** **pos** ().
        """
        ...
