"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QGraphicsLineItem(QGraphicsItem):
    """
    https://doc.qt.io/qt-5/qgraphicslineitem.html

    **Detailed Description**

    To set the item's line, pass a **QLineF**  to QGraphicsLineItem's
    constructor, or call the **setLine** () function. The **line** () function
    returns the current line. By default the line is black with a width of 0,
    but you can change this by calling **setPen** ().

    ![](images/graphicsview-lineitem.png)

    QGraphicsLineItem uses the line and the pen width to provide a reasonable
    implementation of **boundingRect** (), **shape** (), and **contains** ().
    The **paint** () function draws the line using the item's associated pen.

    **See also** **QGraphicsPathItem** , **QGraphicsRectItem** ,
    **QGraphicsEllipseItem** , **QGraphicsTextItem** , **QGraphicsPolygonItem**
    , **QGraphicsPixmapItem** , and **Graphics View Framework** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QGraphicsItem] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicslineitem.html#QGraphicsLineItem

        **QGraphicsLineItem::QGraphicsLineItem(QGraphicsItem * parent =
        nullptr)**

        Constructs a QGraphicsLineItem. **parent** is passed to
        **QGraphicsItem** 's constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    @typing.overload
    def __init__(
        self, line: QtCore.QLineF, parent: typing.Optional[QGraphicsItem] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicslineitem.html#QGraphicsLineItem-1

        **QGraphicsLineItem::QGraphicsLineItem(const QLineF & line ,
        QGraphicsItem * parent = nullptr)**

        Constructs a QGraphicsLineItem, using **line** as the default line.
        **parent** is passed to **QGraphicsItem** 's constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        x1: float,
        y1: float,
        x2: float,
        y2: float,
        parent: typing.Optional[QGraphicsItem] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicslineitem.html#QGraphicsLineItem-2

        **QGraphicsLineItem::QGraphicsLineItem(qreal x1 , qreal y1 , qreal x2 ,
        qreal y2 , QGraphicsItem * parent = nullptr)**

        Constructs a QGraphicsLineItem, using the line between ( **x1** , **y1**
        ) and ( **x2** , **y2** ) as the default line. **parent** is passed to
        **QGraphicsItem** 's constructor.

        **See also** **QGraphicsScene::addItem** ().
        """
        ...

    def type(self) -> int:
        """
        https://doc.qt.io/qt-5/qgraphicslineitem.html#type

        **[override virtual] int QGraphicsLineItem::type() const**

        Reimplements: **QGraphicsItem::type** () const.
        """
        ...

    def opaqueArea(self) -> QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-5/qgraphicslineitem.html#opaqueArea

        **[override virtual] QPainterPath QGraphicsLineItem::opaqueArea()
        const**

        Reimplements: **QGraphicsItem::opaqueArea** () const.
        """
        ...

    def isObscuredBy(self, item: QGraphicsItem) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicslineitem.html#isObscuredBy

        **[override virtual] bool QGraphicsLineItem::isObscuredBy(const
        QGraphicsItem * item ) const**

        Reimplements: **QGraphicsItem::isObscuredBy** (const QGraphicsItem
        *item) const.
        """
        ...

    def paint(
        self,
        painter: QtGui.QPainter,
        option: "QStyleOptionGraphicsItem",
        widget: typing.Optional[QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicslineitem.html#paint

        **[override virtual] void QGraphicsLineItem::paint(QPainter * painter ,
        const QStyleOptionGraphicsItem * option , QWidget * widget = nullptr)**

        Reimplements: **QGraphicsItem::paint** (QPainter *painter, const
        QStyleOptionGraphicsItem *option, QWidget *widget).
        """
        ...

    def contains(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> bool:
        """
        https://doc.qt.io/qt-5/qgraphicslineitem.html#contains

        **[override virtual] bool QGraphicsLineItem::contains(const QPointF &
        point ) const**

        Reimplements: **QGraphicsItem::contains** (const QPointF &point) const.
        """
        ...

    def shape(self) -> QtGui.QPainterPath:
        """
        https://doc.qt.io/qt-5/qgraphicslineitem.html#shape

        **[override virtual] QPainterPath QGraphicsLineItem::shape() const**

        Reimplements: **QGraphicsItem::shape** () const.
        """
        ...

    def boundingRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qgraphicslineitem.html#boundingRect

        **[override virtual] QRectF QGraphicsLineItem::boundingRect() const**

        Reimplements: **QGraphicsItem::boundingRect** () const.
        """
        ...

    @typing.overload
    def setLine(self, line: QtCore.QLineF) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicslineitem.html#setLine

        **void QGraphicsLineItem::setLine(const QLineF & line )**

        Sets the item's line to be the given **line**.

        **See also** **line** ().
        """
        ...

    @typing.overload
    def setLine(self, x1: float, y1: float, x2: float, y2: float) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicslineitem.html#setLine-1

        **void QGraphicsLineItem::setLine(qreal x1 , qreal y1 , qreal x2 , qreal
        y2 )**

        This is an overloaded function.

        Sets the item's line to be the line between ( **x1** , **y1** ) and (
        **x2** , **y2** ).

        This is the same as calling `setLine(QLineF(x1, y1, x2, y2))`.
        """
        ...

    def line(self) -> QtCore.QLineF:
        """
        https://doc.qt.io/qt-5/qgraphicslineitem.html#line

        **QLineF QGraphicsLineItem::line() const**

        Returns the item's line, or a null line if no line has been set.

        **See also** **setLine** ().
        """
        ...

    def setPen(
        self,
        pen: typing.Union[
            QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicslineitem.html#setPen

        **void QGraphicsLineItem::setPen(const QPen & pen )**

        Sets the item's pen to **pen**. If no pen is set, the line will be
        painted using a black solid 0-width pen.

        **See also** **pen** ().
        """
        ...

    def pen(self) -> QtGui.QPen:
        """
        https://doc.qt.io/qt-5/qgraphicslineitem.html#pen

        **QPen QGraphicsLineItem::pen() const**

        Returns the item's pen, or a black solid 0-width pen if no pen has been
        set.

        **See also** **setPen** ().
        """
        ...
