"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QGesture(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qgesture.html

    **Detailed Description**

    Gesture objects are not constructed directly by developers. They are created
    by the **QGestureRecognizer**  object that is registered with the
    application; see **QGestureRecognizer::registerRecognizer** ().

    For an overview of gesture handling in Qt and information on using gestures
    in your applications, see the **Gestures in Widgets and Graphics View**
    document.

    **Gesture Properties**

    The class has a list of properties that can be queried by the user to get
    some gesture-specific arguments. For example, the pinch gesture has a scale
    factor that is exposed as a property.

    Developers of custom gesture recognizers can add additional properties in
    order to provide additional information about a gesture. This can be done by
    adding new dynamic properties to a QGesture object, or by subclassing the
    QGesture class (or one of its subclasses).

    **Lifecycle of a Gesture Object**

    A QGesture instance is implicitly created when needed and is owned by Qt.
    Developers should never destroy them or store them for later use as Qt may
    destroy particular instances of them and create new ones to replace them.

    The registered gesture recognizer monitors the input events for the target
    object via its **recognize()**  function, updating the properties of the
    gesture object as required.

    The gesture object may be delivered to the target object in a
    **QGestureEvent**  if the corresponding gesture is active or has just been
    canceled. Each event that is delivered contains a list of gesture objects,
    since support for more than one gesture may be enabled for the target
    object. Due to the way events are handled in Qt, gesture events may be
    filtered by other objects.

    **See also** **QGestureEvent**  and **QGestureRecognizer** .
    """

    class GestureCancelPolicy(int):
        CancelNone: QGesture = ...
        CancelAllInContext: QGesture = ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qgesture.html#QGesture

        **QGesture::QGesture(QObject * parent = nullptr)**

        Constructs a new gesture object with the given **parent**.

        QGesture objects are created by gesture recognizers in the
        **QGestureRecognizer::create** () function.
        """
        ...

    def gestureCancelPolicy(self) -> "QGesture.GestureCancelPolicy":
        """
        https://doc.qt.io/qt-5/qgesture.html#gestureCancelPolicy-prop

        **gestureCancelPolicy : QGesture::GestureCancelPolicy**

        This property holds the policy for deciding what happens on accepting a
        gesture

        On accepting one gesture Qt can automatically cancel other gestures that
        belong to other targets. The policy is normally set to not cancel any
        other gestures and can be set to cancel all active gestures in the
        context. For example for all child widgets.

        **Access functions:**

        QGesture::GestureCancelPolicy **gestureCancelPolicy** () const
        void
        **setGestureCancelPolicy** (QGesture::GestureCancelPolicy **policy** )
        """
        ...

    def setGestureCancelPolicy(self, policy: "QGesture.GestureCancelPolicy") -> None:
        """
        https://doc.qt.io/qt-5/qgesture.html#gestureCancelPolicy-prop

        **gestureCancelPolicy : QGesture::GestureCancelPolicy**

        This property holds the policy for deciding what happens on accepting a
        gesture

        On accepting one gesture Qt can automatically cancel other gestures that
        belong to other targets. The policy is normally set to not cancel any
        other gestures and can be set to cancel all active gestures in the
        context. For example for all child widgets.

        **Access functions:**

        QGesture::GestureCancelPolicy **gestureCancelPolicy** () const
        void
        **setGestureCancelPolicy** (QGesture::GestureCancelPolicy **policy** )
        """
        ...

    def unsetHotSpot(self) -> None:
        ...

    def hasHotSpot(self) -> bool:
        """
        https://doc.qt.io/qt-5/qgesture.html#hasHotSpot-prop

        **hasHotSpot : const bool**

        This property holds whether the gesture has a hot-spot

        **Access functions:**

        bool **hasHotSpot** () const
        """
        ...

    def setHotSpot(self, value: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None:
        """
        https://doc.qt.io/qt-5/qgesture.html#hotSpot-prop

        **hotSpot : QPointF**

        This property holds the point that is used to find the receiver for the
        gesture event.

        The hot-spot is a point in the global coordinate system, use
        **QWidget::mapFromGlobal** () or **QGestureEvent::mapToGraphicsScene**
        () to get a local hot-spot.

        The hot-spot should be set by the gesture recognizer to allow gesture
        event delivery to a **QGraphicsObject** .

        **Access functions:**

        QPointF **hotSpot** () const
        void **setHotSpot** (const QPointF &
        **value** )
        void **unsetHotSpot** ()
        """
        ...

    def hotSpot(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qgesture.html#hotSpot-prop

        **hotSpot : QPointF**

        This property holds the point that is used to find the receiver for the
        gesture event.

        The hot-spot is a point in the global coordinate system, use
        **QWidget::mapFromGlobal** () or **QGestureEvent::mapToGraphicsScene**
        () to get a local hot-spot.

        The hot-spot should be set by the gesture recognizer to allow gesture
        event delivery to a **QGraphicsObject** .

        **Access functions:**

        QPointF **hotSpot** () const
        void **setHotSpot** (const QPointF &
        **value** )
        void **unsetHotSpot** ()
        """
        ...

    def state(self) -> QtCore.Qt.GestureState:
        """
        https://doc.qt.io/qt-5/qgesture.html#state-prop

        **state : const Qt::GestureState**

        This property holds the current state of the gesture

        **Access functions:**

        Qt::GestureState **state** () const

        **Member Function Documentation**
        """
        ...

    def gestureType(self) -> QtCore.Qt.GestureType:
        """
        https://doc.qt.io/qt-5/qgesture.html#gestureType-prop

        **gestureType : const Qt::GestureType**

        This property holds the type of the gesture

        **Access functions:**

        Qt::GestureType **gestureType** () const
        """
        ...
