"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *
from PyQt5 import sip


class QFileSystemModel(QtCore.QAbstractItemModel):
    """
    https://doc.qt.io/qt-5/qfilesystemmodel.html

    **Detailed Description**

    This class provides access to the local filesystem, providing functions for
    renaming and removing files and directories, and for creating new
    directories. In the simplest case, it can be used with a suitable display
    widget as part of a browser or filter.

    QFileSystemModel can be accessed using the standard interface provided by
    **QAbstractItemModel** , but it also provides some convenience functions
    that are specific to a directory model. The **fileInfo** (), **isDir** (),
    **fileName** () and **filePath** () functions provide information about the
    underlying files and directories related to items in the model. Directories
    can be created and removed using **mkdir** (), **rmdir** ().

    **Note:** QFileSystemModel requires an instance of **QApplication** .

    **Example Usage**

    A directory model that displays the contents of a default directory is
    usually constructed with a parent object:

    **QFileSystemModel**  *model = new **QFileSystemModel** ;
    model->setRootPath(**QDir** ::currentPath());

    A tree view can be used to display the contents of the model

    **QTreeView**  *tree = new **QTreeView** (splitter);
    tree->setModel(model);

    and the contents of a particular directory can be displayed by setting the
    tree view's root index:

    tree->setRootIndex(model->index(**QDir** ::currentPath()));

    The view's root index can be used to control how much of a hierarchical
    model is displayed. QFileSystemModel provides a convenience function that
    returns a suitable model index for a path to a directory within the model.

    **Caching and Performance**

    QFileSystemModel will not fetch any files or directories until
    **setRootPath** () is called. This will prevent any unnecessary querying on
    the file system until that point such as listing the drives on Windows.

    Unlike QDirModel, QFileSystemModel uses a separate thread to populate itself
    so it will not cause the main thread to hang as the file system is being
    queried. Calls to **rowCount** () will return 0 until the model populates a
    directory.

    QFileSystemModel keeps a cache with file information. The cache is
    automatically kept up to date using the **QFileSystemWatcher** .

    **See also** **Model Classes** .
    """

    class Option(int):
        DontWatchForChanges: QFileSystemModel = ...
        DontResolveSymlinks: QFileSystemModel = ...
        DontUseCustomDirectoryIcons: QFileSystemModel = ...

    class Roles(int):
        FileIconRole: QFileSystemModel = ...
        FilePathRole: QFileSystemModel = ...
        FileNameRole: QFileSystemModel = ...
        FilePermissions: QFileSystemModel = ...

    class Options(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, f: typing.Union["QFileSystemModel.Options", "QFileSystemModel.Option"]
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QFileSystemModel.Options") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QFileSystemModel.Options":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#QFileSystemModel

        **QFileSystemModel::QFileSystemModel(QObject * parent = nullptr)**

        Constructs a file system model with the given **parent**.
        """
        ...

    def options(self) -> "QFileSystemModel.Options":
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#options-prop

        **options : Options**

        This property holds the various options that affect the model

        By default, all options are disabled.

        Options should be set before changing properties.

        This property was introduced in Qt 5.14.

        **Access functions:**

        QFileSystemModel::Options **options** () const
        void **setOptions**
        (QFileSystemModel::Options **options** )

        **See also** **setOption** () and **testOption** ().
        """
        ...

    def setOptions(
        self,
        options: typing.Union["QFileSystemModel.Options", "QFileSystemModel.Option"],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#options-prop

        **options : Options**

        This property holds the various options that affect the model

        By default, all options are disabled.

        Options should be set before changing properties.

        This property was introduced in Qt 5.14.

        **Access functions:**

        QFileSystemModel::Options **options** () const
        void **setOptions**
        (QFileSystemModel::Options **options** )

        **See also** **setOption** () and **testOption** ().
        """
        ...

    def testOption(self, option: "QFileSystemModel.Option") -> bool:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#testOption

        **bool QFileSystemModel::testOption(QFileSystemModel::Option option )
        const**

        Returns `true` if the given **option** is enabled; otherwise, returns
        false.

        This function was introduced in Qt 5.14.

        **See also** **options**  and **setOption** ().
        """
        ...

    def setOption(self, option: "QFileSystemModel.Option", on: bool = ...) -> None:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#setOption

        **void QFileSystemModel::setOption(QFileSystemModel::Option option ,
        bool on = true)**

        Sets the given **option** to be enabled if **on** is true; otherwise,
        clears the given **option**.

        Options should be set before changing properties.

        This function was introduced in Qt 5.14.

        **See also** **options**  and **testOption** ().
        """
        ...

    def sibling(
        self, row: int, column: int, idx: QtCore.QModelIndex
    ) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#sibling

        **[override virtual] QModelIndex QFileSystemModel::sibling(int row , int
        column , const QModelIndex & idx ) const**

        Reimplements: **QAbstractItemModel::sibling** (int row, int column,
        const QModelIndex &index) const.
        """
        ...

    def timerEvent(self, event: QtCore.QTimerEvent) -> None:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#timerEvent

        **[override virtual protected] void
        QFileSystemModel::timerEvent(QTimerEvent * event )**

        Reimplements: **QObject::timerEvent** (QTimerEvent *event).
        """
        ...

    def event(self, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#event

        **[override virtual protected] bool QFileSystemModel::event(QEvent *
        event )**

        Reimplements: **QObject::event** (QEvent *e).
        """
        ...

    def remove(self, index: QtCore.QModelIndex) -> bool:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#remove

        **bool QFileSystemModel::remove(const QModelIndex & index )**

        Removes the model item **index** from the file system model and
        **deletes the corresponding file from the file system** , returning true
        if successful. If the item cannot be removed, false is returned.

        **Warning:** This function deletes files from the file system; it does
        **not** move them to a location where they can be recovered.

        **See also** **rmdir** ().
        """
        ...

    def fileInfo(self, aindex: QtCore.QModelIndex) -> QtCore.QFileInfo:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#fileInfo

        **QFileInfo QFileSystemModel::fileInfo(const QModelIndex & index )
        const**

        Returns the **QFileInfo**  for the item stored in the model under the
        given **index**.
        """
        ...

    def fileIcon(self, aindex: QtCore.QModelIndex) -> QtGui.QIcon:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#fileIcon

        **QIcon QFileSystemModel::fileIcon(const QModelIndex & index ) const**

        Returns the icon for the item stored in the model under the given
        **index**.
        """
        ...

    def fileName(self, aindex: QtCore.QModelIndex) -> str:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#fileName

        **QString QFileSystemModel::fileName(const QModelIndex & index ) const**

        Returns the file name for the item stored in the model under the given
        **index**.
        """
        ...

    def rmdir(self, index: QtCore.QModelIndex) -> bool:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#rmdir

        **bool QFileSystemModel::rmdir(const QModelIndex & index )**

        Removes the directory corresponding to the model item **index** in the
        file system model and **deletes the corresponding directory from the
        file system** , returning true if successful. If the directory cannot be
        removed, false is returned.

        **Warning:** This function deletes directories from the file system; it
        does **not** move them to a location where they can be recovered.

        **See also** **remove** ().
        """
        ...

    def permissions(self, index: QtCore.QModelIndex) -> QtCore.QFileDevice.Permissions:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#permissions

        **QFile::Permissions QFileSystemModel::permissions(const QModelIndex &
        index ) const**

        Returns the complete OR-ed together combination of **QFile::Permission**
        for the **index**.
        """
        ...

    def mkdir(self, parent: QtCore.QModelIndex, name: str) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#mkdir

        **QModelIndex QFileSystemModel::mkdir(const QModelIndex & parent , const
        QString & name )**

        Create a directory with the **name** in the **parent** model index.
        """
        ...

    def lastModified(self, index: QtCore.QModelIndex) -> QtCore.QDateTime:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#lastModified

        **QDateTime QFileSystemModel::lastModified(const QModelIndex & index )
        const**

        Returns the date and time when **index** was last modified.
        """
        ...

    def type(self, index: QtCore.QModelIndex) -> str:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#type

        **QString QFileSystemModel::type(const QModelIndex & index ) const**

        Returns the type of file **index** such as "Directory" or "JPEG file".
        """
        ...

    def size(self, index: QtCore.QModelIndex) -> int:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#size

        **qint64 QFileSystemModel::size(const QModelIndex & index ) const**

        Returns the size in bytes of **index**. If the file does not exist, 0 is
        returned.
        """
        ...

    def isDir(self, index: QtCore.QModelIndex) -> bool:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#isDir

        **bool QFileSystemModel::isDir(const QModelIndex & index ) const**

        Returns `true` if the model item **index** represents a directory;
        otherwise returns `false`.
        """
        ...

    def filePath(self, index: QtCore.QModelIndex) -> str:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#filePath

        **QString QFileSystemModel::filePath(const QModelIndex & index ) const**

        Returns the path of the item stored in the model under the **index**
        given.
        """
        ...

    def nameFilters(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#nameFilters

        **QStringList QFileSystemModel::nameFilters() const**

        Returns a list of filters applied to the names in the model.

        **See also** **setNameFilters** ().
        """
        ...

    def setNameFilters(self, filters: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#setNameFilters

        **void QFileSystemModel::setNameFilters(const QStringList & filters )**

        Sets the name **filters** to apply against the existing files.

        **See also** **nameFilters** ().
        """
        ...

    def nameFilterDisables(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#nameFilterDisables-prop

        **nameFilterDisables : bool**

        This property holds whether files that don't pass the name filter are
        hidden or disabled

        This property is `true` by default

        **Access functions:**

        bool **nameFilterDisables** () const
        void **setNameFilterDisables**
        (bool **enable** )
        """
        ...

    def setNameFilterDisables(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#nameFilterDisables-prop

        **nameFilterDisables : bool**

        This property holds whether files that don't pass the name filter are
        hidden or disabled

        This property is `true` by default

        **Access functions:**

        bool **nameFilterDisables** () const
        void **setNameFilterDisables**
        (bool **enable** )
        """
        ...

    def isReadOnly(self) -> bool:
        ...

    def setReadOnly(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#readOnly-prop

        **readOnly : bool**

        This property holds whether the directory model allows writing to the
        file system

        If this property is set to false, the directory model will allow
        renaming, copying and deleting of files and directories.

        This property is `true` by default

        **Access functions:**

        bool **isReadOnly** () const
        void **setReadOnly** (bool **enable** )
        """
        ...

    def resolveSymlinks(self) -> bool:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#resolveSymlinks-prop

        **resolveSymlinks : bool**

        This property holds whether the directory model should resolve symbolic
        links

        This is only relevant on Windows.

        By default, this property is `true`.

        **Access functions:**

        bool **resolveSymlinks** () const
        void **setResolveSymlinks** (bool
        **enable** )

        **See also** **QFileSystemModel::Options** .

        **Member Function Documentation**
        """
        ...

    def setResolveSymlinks(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#resolveSymlinks-prop

        **resolveSymlinks : bool**

        This property holds whether the directory model should resolve symbolic
        links

        This is only relevant on Windows.

        By default, this property is `true`.

        **Access functions:**

        bool **resolveSymlinks** () const
        void **setResolveSymlinks** (bool
        **enable** )

        **See also** **QFileSystemModel::Options** .

        **Member Function Documentation**
        """
        ...

    def filter(self) -> QtCore.QDir.Filters:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#filter

        **QDir::Filters QFileSystemModel::filter() const**

        Returns the filter specified for the directory model.

        If a filter has not been set, the default filter is **QDir::AllEntries**
        | **QDir::NoDotAndDotDot**  | **QDir::AllDirs** .

        **See also** **setFilter** () and **QDir::Filters** .
        """
        ...

    def setFilter(
        self, filters: typing.Union[QtCore.QDir.Filters, QtCore.QDir.Filter]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#setFilter

        **void QFileSystemModel::setFilter(QDir::Filters filters )**

        Sets the directory model's filter to that specified by **filters**.

        Note that the filter you set should always include the **QDir::AllDirs**
        enum value, otherwise **QFileSystemModel**  won't be able to read the
        directory structure.

        **See also** **filter** () and **QDir::Filters** .
        """
        ...

    def iconProvider(self) -> QFileIconProvider:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#iconProvider

        **QFileIconProvider *QFileSystemModel::iconProvider() const**

        Returns the file icon provider for this directory model.

        **See also** **setIconProvider** ().
        """
        ...

    def setIconProvider(self, provider: QFileIconProvider) -> None:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#setIconProvider

        **void QFileSystemModel::setIconProvider(QFileIconProvider * provider
        )**

        Sets the **provider** of file icons for the directory model.

        **See also** **iconProvider** ().
        """
        ...

    def rootDirectory(self) -> QtCore.QDir:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#rootDirectory

        **QDir QFileSystemModel::rootDirectory() const**

        The currently set directory

        **See also** **rootPath** ().
        """
        ...

    def rootPath(self) -> str:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#rootPath

        **QString QFileSystemModel::rootPath() const**

        The currently set root path

        **See also** **setRootPath** () and **rootDirectory** ().
        """
        ...

    def setRootPath(self, path: str) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#setRootPath

        **QModelIndex QFileSystemModel::setRootPath(const QString & newPath )**

        Sets the directory that is being watched by the model to **newPath** by
        installing a **file system watcher**  on it. Any changes to files and
        directories within this directory will be reflected in the model.

        If the path is changed, the **rootPathChanged** () signal will be
        emitted.

        **Note:** This function does not change the structure of the model or
        modify the data available to views. In other words, the "root" of the
        model is **not** changed to include only files and directories within
        the directory specified by **newPath** in the file system.

        **See also** **rootPath** ().
        """
        ...

    def supportedDropActions(self) -> QtCore.Qt.DropActions:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#supportedDropActions

        **[override virtual] Qt::DropActions
        QFileSystemModel::supportedDropActions() const**

        Reimplements: **QAbstractItemModel::supportedDropActions** () const.
        """
        ...

    def dropMimeData(
        self,
        data: QtCore.QMimeData,
        action: QtCore.Qt.DropAction,
        row: int,
        column: int,
        parent: QtCore.QModelIndex,
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#dropMimeData

        **[override virtual] bool QFileSystemModel::dropMimeData(const QMimeData
        * data , Qt::DropAction action , int row , int column , const
        QModelIndex & parent )**

        Reimplements: **QAbstractItemModel::dropMimeData** (const QMimeData
        *data, Qt::DropAction action, int row, int column, const QModelIndex
        &parent).

        Handles the **data** supplied by a drag and drop operation that ended
        with the given **action** over the row in the model specified by the
        **row** and **column** and by the **parent** index. Returns true if the
        operation was successful.

        **See also** **supportedDropActions** ().
        """
        ...

    def mimeData(
        self, indexes: typing.Iterable[QtCore.QModelIndex]
    ) -> QtCore.QMimeData:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#mimeData

        **[override virtual] QMimeData *QFileSystemModel::mimeData(const
        QModelIndexList & indexes ) const**

        Reimplements: **QAbstractItemModel::mimeData** (const QModelIndexList
        &indexes) const.

        Returns an object that contains a serialized description of the
        specified **indexes**. The format used to describe the items
        corresponding to the indexes is obtained from the **mimeTypes** ()
        function.

        If the list of indexes is empty, `nullptr` is returned rather than a
        serialized empty list.
        """
        ...

    def mimeTypes(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#mimeTypes

        **[override virtual] QStringList QFileSystemModel::mimeTypes() const**

        Reimplements: **QAbstractItemModel::mimeTypes** () const.

        Returns a list of MIME types that can be used to describe a list of
        items in the model.
        """
        ...

    def sort(self, column: int, order: QtCore.Qt.SortOrder = ...) -> None:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#sort

        **[override virtual] void QFileSystemModel::sort(int column ,
        Qt::SortOrder order = Qt::AscendingOrder)**

        Reimplements: **QAbstractItemModel::sort** (int column, Qt::SortOrder
        order).
        """
        ...

    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#flags

        **[override virtual] Qt::ItemFlags QFileSystemModel::flags(const
        QModelIndex & index ) const**

        Reimplements: **QAbstractItemModel::flags** (const QModelIndex &index)
        const.
        """
        ...

    def headerData(
        self, section: int, orientation: QtCore.Qt.Orientation, role: int = ...
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#headerData

        **[override virtual] QVariant QFileSystemModel::headerData(int section ,
        Qt::Orientation orientation , int role = Qt::DisplayRole) const**

        Reimplements: **QAbstractItemModel::headerData** (int section,
        Qt::Orientation orientation, int role) const.
        """
        ...

    def setData(
        self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#setData

        **[override virtual] bool QFileSystemModel::setData(const QModelIndex &
        idx , const QVariant & value , int role = Qt::EditRole)**

        Reimplements: **QAbstractItemModel::setData** (const QModelIndex &index,
        const QVariant &value, int role).

        **See also** **data** ().
        """
        ...

    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#data

        **[override virtual] QVariant QFileSystemModel::data(const QModelIndex &
        index , int role = Qt::DisplayRole) const**

        Reimplements: **QAbstractItemModel::data** (const QModelIndex &index,
        int role) const.

        **See also** **setData** ().
        """
        ...

    def myComputer(self, role: int = ...) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#myComputer

        **QVariant QFileSystemModel::myComputer(int role = Qt::DisplayRole)
        const**

        Returns the data stored under the given **role** for the item "My
        Computer".

        **See also** **Qt::ItemDataRole** .
        """
        ...

    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#columnCount

        **[override virtual] int QFileSystemModel::columnCount(const QModelIndex
        & parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::columnCount** (const QModelIndex
        &parent) const.
        """
        ...

    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#rowCount

        **[override virtual] int QFileSystemModel::rowCount(const QModelIndex &
        parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::rowCount** (const QModelIndex
        &parent) const.
        """
        ...

    def fetchMore(self, parent: QtCore.QModelIndex) -> None:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#fetchMore

        **[override virtual] void QFileSystemModel::fetchMore(const QModelIndex
        & parent )**

        Reimplements: **QAbstractItemModel::fetchMore** (const QModelIndex
        &parent).
        """
        ...

    def canFetchMore(self, parent: QtCore.QModelIndex) -> bool:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#canFetchMore

        **[override virtual] bool QFileSystemModel::canFetchMore(const
        QModelIndex & parent ) const**

        Reimplements: **QAbstractItemModel::canFetchMore** (const QModelIndex
        &parent) const.
        """
        ...

    def hasChildren(self, parent: QtCore.QModelIndex = ...) -> bool:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#hasChildren

        **[override virtual] bool QFileSystemModel::hasChildren(const
        QModelIndex & parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::hasChildren** (const QModelIndex
        &parent) const.
        """
        ...

    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#parent

        **[override virtual] QModelIndex QFileSystemModel::parent(const
        QModelIndex & index ) const**

        Reimplements: **QAbstractItemModel::parent** (const QModelIndex &index)
        const.
        """
        ...

    @typing.overload
    def index(
        self, row: int, column: int, parent: QtCore.QModelIndex = ...
    ) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#index

        **[override virtual] QModelIndex QFileSystemModel::index(int row , int
        column , const QModelIndex & parent = QModelIndex()) const**

        Reimplements: **QAbstractItemModel::index** (int row, int column, const
        QModelIndex &parent) const.
        """
        ...

    @typing.overload
    def index(self, path: str, column: int = ...) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#index-1

        **QModelIndex QFileSystemModel::index(const QString & path , int column
        = 0) const**

        This is an overloaded function.

        Returns the model item index for the given **path** and **column**.
        """
        ...

    @property
    def directoryLoaded(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#directoryLoaded

        **[signal] void QFileSystemModel::directoryLoaded(const QString & path
        )**

        This signal is emitted when the gatherer thread has finished to load the
        **path**.

        This function was introduced in Qt 4.7.
        """
        ...

    @property
    def fileRenamed(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#fileRenamed

        **[signal] void QFileSystemModel::fileRenamed(const QString & path ,
        const QString & oldName , const QString & newName )**

        This signal is emitted whenever a file with the **oldName** is
        successfully renamed to **newName**. The file is located in in the
        directory **path**.
        """
        ...

    @property
    def rootPathChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qfilesystemmodel.html#rootPathChanged

        **[signal] void QFileSystemModel::rootPathChanged(const QString &
        newPath )**

        This signal is emitted whenever the root path has been changed to a
        **newPath**.
        """
        ...
