"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QDialog(QWidget):
    """
    https://doc.qt.io/qt-5/qdialog.html

    **Detailed Description**

    A dialog window is a top-level window mostly used for short-term tasks and
    brief communications with the user. QDialogs may be modal or modeless.
    QDialogs can provide a **return value** , and they can have **default
    buttons** . QDialogs can also have a **QSizeGrip**  in their lower-right
    corner, using **setSizeGripEnabled** ().

    Note that QDialog (and any other widget that has type `Qt::Dialog`) uses the
    parent widget slightly differently from other classes in Qt. A dialog is
    always a top-level widget, but if it has a parent, its default location is
    centered on top of the parent's top-level widget (if it is not top-level
    itself). It will also share the parent's taskbar entry.

    Use the overload of the **QWidget::setParent** () function to change the
    ownership of a QDialog widget. This function allows you to explicitly set
    the window flags of the reparented widget; using the overloaded function
    will clear the window flags specifying the window-system properties for the
    widget (in particular it will reset the **Qt::Dialog**  flag).

    **Note:** The parent relationship of the dialog does **not** imply that the
    dialog will always be stacked on top of the parent window. To ensure that
    the dialog is always on top, make the dialog modal. This also applies for
    child windows of the dialog itself. To ensure that child windows of the
    dialog stay on top of the dialog, make the child windows modal as well.

    **Modal Dialogs**

    A **modal** dialog is a dialog that blocks input to other visible windows in
    the same application. Dialogs that are used to request a file name from the
    user or that are used to set application preferences are usually modal.
    Dialogs can be **application modal**  (the default) or **window modal** .

    When an application modal dialog is opened, the user must finish interacting
    with the dialog and close it before they can access any other window in the
    application. Window modal dialogs only block access to the window associated
    with the dialog, allowing the user to continue to use other windows in an
    application.

    The most common way to display a modal dialog is to call its **exec** ()
    function. When the user closes the dialog, **exec** () will provide a useful
    **return value** . To close the dialog and return the appropriate value, you
    must connect a default button, e.g. an **OK** button to the **accept** ()
    slot and a **Cancel** button to the **reject** () slot. Alternatively, you
    can call the **done** () slot with `Accepted` or `Rejected`.

    An alternative is to call **setModal** (true) or **setWindowModality** (),
    then **show** (). Unlike **exec** (), **show** () returns control to the
    caller immediately. Calling **setModal** (true) is especially useful for
    progress dialogs, where the user must have the ability to interact with the
    dialog, e.g. to cancel a long running operation. If you use **show** () and
    **setModal** (true) together to perform a long operation, you must call
    **QCoreApplication::processEvents** () periodically during processing to
    enable the user to interact with the dialog. (See **QProgressDialog** .)

    **Modeless Dialogs**

    A **modeless** dialog is a dialog that operates independently of other
    windows in the same application. Find and replace dialogs in word-processors
    are often modeless to allow the user to interact with both the application's
    main window and with the dialog.

    Modeless dialogs are displayed using **show** (), which returns control to
    the caller immediately.

    If you invoke the **show()**  function after hiding a dialog, the dialog
    will be displayed in its original position. This is because the window
    manager decides the position for windows that have not been explicitly
    placed by the programmer. To preserve the position of a dialog that has been
    moved by the user, save its position in your **closeEvent()**  handler and
    then move the dialog to that position, before showing it again.

    **Default Button**

    A dialog's **default** button is the button that's pressed when the user
    presses Enter (Return). This button is used to signify that the user accepts
    the dialog's settings and wants to close the dialog. Use
    **QPushButton::setDefault** (), **QPushButton::isDefault** () and
    **QPushButton::autoDefault** () to set and control the dialog's default
    button.

    **Escape Key**

    If the user presses the Esc key in a dialog, **QDialog::reject** () will be
    called. This will cause the window to close: The **close event**  cannot be
    **ignored** .

    **Extensibility**

    Extensibility is the ability to show the dialog in two ways: a partial
    dialog that shows the most commonly used options, and a full dialog that
    shows all the options. Typically an extensible dialog will initially appear
    as a partial dialog, but with a **More** toggle button. If the user presses
    the **More** button down, the dialog is expanded. The **Extension Example**
    shows how to achieve extensible dialogs using Qt.

    **Return Value (Modal Dialogs)**

    Modal dialogs are often used in situations where a return value is required,
    e.g. to indicate whether the user pressed **OK** or **Cancel**. A dialog can
    be closed by calling the **accept** () or the **reject** () slots, and
    **exec** () will return `Accepted` or `Rejected` as appropriate. The
    **exec** () call returns the result of the dialog. The result is also
    available from **result** () if the dialog has not been destroyed.

    In order to modify your dialog's close behavior, you can reimplement the
    functions **accept** (), **reject** () or **done** (). The **closeEvent()**
    function should only be reimplemented to preserve the dialog's position or
    to override the standard close or reject behavior.

    **Code Examples**

    A modal dialog:

    void EditorWindow::countWords()
        {
            WordCountDialog dialog(this);
    dialog.setWordCount(document().wordCount());
            dialog.exec();
        }

    A modeless dialog:

    void EditorWindow::find()
        {
            if (!findDialog) {
    findDialog = new FindDialog(this);
                connect(findDialog,
    &FindDialog::findNext,
                        this, &EditorWindow::findNext);
    }

            findDialog->show();
            findDialog->raise();
    findDialog->activateWindow();
        }

    **See also** **QDialogButtonBox** , **QTabWidget** , **QWidget** ,
    **QProgressDialog** , **GUI Design Handbook: Dialogs, Standard** ,
    **Extension Example** , and **Standard Dialogs Example** .
    """

    class DialogCode(int):
        Rejected: QDialog = ...
        Accepted: QDialog = ...

    def __init__(
        self,
        parent: typing.Optional[QWidget] = ...,
        flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qdialog.html#QDialog

        **QDialog::QDialog(QWidget * parent = nullptr, Qt::WindowFlags f =
        Qt::WindowFlags())**

        Constructs a dialog with parent **parent**.

        A dialog is always a top-level widget, but if it has a parent, its
        default location is centered on top of the parent. It will also share
        the parent's taskbar entry.

        The widget flags **f** are passed on to the **QWidget**  constructor.
        If, for example, you don't want a What's This button in the title bar of
        the dialog, pass **Qt::WindowTitleHint**  | **Qt::WindowSystemMenuHint**
        in **f**.

        **See also** **QWidget::setWindowFlags** ().
        """
        ...

    def eventFilter(self, a0: QtCore.QObject, a1: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qdialog.html#eventFilter

        **[override virtual protected] bool QDialog::eventFilter(QObject * o ,
        QEvent * e )**

        Reimplements: **QObject::eventFilter** (QObject *watched, QEvent
        *event).
        """
        ...

    def contextMenuEvent(self, a0: QtGui.QContextMenuEvent) -> None:
        """
        https://doc.qt.io/qt-5/qdialog.html#contextMenuEvent

        **[override virtual protected] void
        QDialog::contextMenuEvent(QContextMenuEvent * e )**

        Reimplements: **QWidget::contextMenuEvent** (QContextMenuEvent *event).
        """
        ...

    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-5/qdialog.html#resizeEvent

        **[override virtual protected] void QDialog::resizeEvent( QResizeEvent *
        )**

        Reimplements: **QWidget::resizeEvent** (QResizeEvent *event).
        """
        ...

    def showEvent(self, a0: QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-5/qdialog.html#showEvent

        **[override virtual protected] void QDialog::showEvent(QShowEvent *
        event )**

        Reimplements: **QWidget::showEvent** (QShowEvent *event).
        """
        ...

    def closeEvent(self, a0: QtGui.QCloseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qdialog.html#closeEvent

        **[override virtual protected] void QDialog::closeEvent(QCloseEvent * e
        )**

        Reimplements: **QWidget::closeEvent** (QCloseEvent *event).
        """
        ...

    def keyPressEvent(self, a0: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-5/qdialog.html#keyPressEvent

        **[override virtual protected] void QDialog::keyPressEvent(QKeyEvent * e
        )**

        Reimplements: **QWidget::keyPressEvent** (QKeyEvent *event).
        """
        ...

    def open(self) -> None:
        """
        https://doc.qt.io/qt-5/qdialog.html#open

        **[virtual slot] void QDialog::open()**

        Shows the dialog as a **window modal dialog** , returning immediately.

        This function was introduced in Qt 4.5.

        **See also** **exec** (), **show** (), **result** (), and
        **setWindowModality** ().
        """
        ...

    def reject(self) -> None:
        """
        https://doc.qt.io/qt-5/qdialog.html#reject

        **[virtual slot] void QDialog::reject()**

        Hides the modal dialog and sets the result code to `Rejected`.

        **See also** **accept** () and **done** ().
        """
        ...

    def accept(self) -> None:
        """
        https://doc.qt.io/qt-5/qdialog.html#accept

        **[virtual slot] void QDialog::accept()**

        Hides the modal dialog and sets the result code to `Accepted`.

        **See also** **reject** () and **done** ().
        """
        ...

    def done(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qdialog.html#done

        **[virtual slot] void QDialog::done(int r )**

        Closes the dialog and sets its result code to **r**. The **finished** ()
        signal will emit **r** ; if **r** is **QDialog::Accepted**  or
        **QDialog::Rejected** , the **accepted** () or the **rejected** ()
        signals will also be emitted, respectively.

        If this dialog is shown with **exec** (), done() also causes the local
        event loop to finish, and **exec** () to return **r**.

        As with **QWidget::close** (), done() deletes the dialog if the
        **Qt::WA_DeleteOnClose**  flag is set. If the dialog is the
        application's main widget, the application terminates. If the dialog is
        the last window closed, the **QApplication::lastWindowClosed** () signal
        is emitted.

        **See also** **accept** (), **reject** (),
        **QApplication::activeWindow** (), and **QCoreApplication::quit** ().
        """
        ...

    def exec(self) -> int:
        """
        https://doc.qt.io/qt-5/qdialog.html#exec

        **[virtual slot] int QDialog::exec()**

        Shows the dialog as a **modal dialog** , blocking until the user closes
        it. The function returns a **DialogCode**  result.

        If the dialog is **application modal** , users cannot interact with any
        other window in the same application until they close the dialog. If the
        dialog is **window modal** , only interaction with the parent window is
        blocked while the dialog is open. By default, the dialog is application
        modal.

        **Note:** Avoid using this function; instead, use `open()`. Unlike
        exec(), **open** () is asynchronous, and does not spin an additional
        event loop. This prevents a series of dangerous bugs from happening
        (e.g. deleting the dialog's parent while the dialog is open via exec()).
        When using **open** () you can connect to the **finished** () signal of
        **QDialog**  to be notified when the dialog is closed.

        **See also** **open** (), **show** (), **result** (), and
        **setWindowModality** ().
        """
        ...

    def exec_(self) -> int:
        """
        https://doc.qt.io/qt-5/qdialog.html#exec

        **[virtual slot] int QDialog::exec()**

        Shows the dialog as a **modal dialog** , blocking until the user closes
        it. The function returns a **DialogCode**  result.

        If the dialog is **application modal** , users cannot interact with any
        other window in the same application until they close the dialog. If the
        dialog is **window modal** , only interaction with the parent window is
        blocked while the dialog is open. By default, the dialog is application
        modal.

        **Note:** Avoid using this function; instead, use `open()`. Unlike
        exec(), **open** () is asynchronous, and does not spin an additional
        event loop. This prevents a series of dangerous bugs from happening
        (e.g. deleting the dialog's parent while the dialog is open via exec()).
        When using **open** () you can connect to the **finished** () signal of
        **QDialog**  to be notified when the dialog is closed.

        **See also** **open** (), **show** (), **result** (), and
        **setWindowModality** ().
        """
        ...

    def setResult(self, r: int) -> None:
        """
        https://doc.qt.io/qt-5/qdialog.html#setResult

        **void QDialog::setResult(int i )**

        Sets the modal dialog's result code to **i**.

        **Note:** We recommend that you use one of the values defined by
        **QDialog::DialogCode** .

        **See also** **result** ().
        """
        ...

    def setModal(self, modal: bool) -> None:
        """
        https://doc.qt.io/qt-5/qdialog.html#modal-prop

        **modal : bool**

        This property holds whether **show** () should pop up the dialog as
        modal or modeless

        By default, this property is `false` and **show** () pops up the dialog
        as modeless. Setting this property to true is equivalent to setting
        **QWidget::windowModality**  to **Qt::ApplicationModal** .

        **exec** () ignores the value of this property and always pops up the
        dialog as modal.

        **Access functions:**

        bool ****isModal** ** () const
        void **setModal** (bool **modal** )

        **See also** **QWidget::windowModality** , **show** (), and **exec** ().
        """
        ...

    def isSizeGripEnabled(self) -> bool:
        ...

    def setSizeGripEnabled(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qdialog.html#sizeGripEnabled-prop

        **sizeGripEnabled : bool**

        This property holds whether the size grip is enabled

        A **QSizeGrip**  is placed in the bottom-right corner of the dialog when
        this property is enabled. By default, the size grip is disabled.

        **Access functions:**

        bool **isSizeGripEnabled** () const
        void **setSizeGripEnabled** (
        **bool** )

        **Member Function Documentation**
        """
        ...

    def minimumSizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qdialog.html#minimumSizeHint

        **[override virtual] QSize QDialog::minimumSizeHint() const**

        Reimplements an access function for property:
        **QWidget::minimumSizeHint** .
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qdialog.html#sizeHint

        **[override virtual] QSize QDialog::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .
        """
        ...

    def setVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-5/qdialog.html#setVisible

        **[override virtual] void QDialog::setVisible(bool visible )**

        Reimplements an access function for property: **QWidget::visible** .
        """
        ...

    def result(self) -> int:
        """
        https://doc.qt.io/qt-5/qdialog.html#result

        **int QDialog::result() const**

        In general returns the modal dialog's result code, `Accepted` or
        `Rejected`.

        **Note:** When called on a **QMessageBox**  instance, the returned value
        is a value of the **QMessageBox::StandardButton**  enum.

        Do not call this function if the dialog was constructed with the
        **Qt::WA_DeleteOnClose**  attribute.

        **See also** **setResult** ().
        """
        ...

    @property
    def accepted(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qdialog.html#accepted

        **[signal] void QDialog::accepted()**

        This signal is emitted when the dialog has been accepted either by the
        user or by calling **accept** () or **done** () with the
        **QDialog::Accepted**  argument.

        Note that this signal is **not** emitted when hiding the dialog with
        **hide** () or **setVisible** (false). This includes deleting the dialog
        while it is visible.

        This function was introduced in Qt 4.1.

        **See also** **finished** () and **rejected** ().
        """
        ...

    @property
    def finished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qdialog.html#finished

        **[signal] void QDialog::finished(int result )**

        This signal is emitted when the dialog's **result** code has been set,
        either by the user or by calling **done** (), **accept** (), or
        **reject** ().

        Note that this signal is **not** emitted when hiding the dialog with
        **hide** () or **setVisible** (false). This includes deleting the dialog
        while it is visible.

        This function was introduced in Qt 4.1.

        **See also** **accepted** () and **rejected** ().
        """
        ...

    @property
    def rejected(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qdialog.html#rejected

        **[signal] void QDialog::rejected()**

        This signal is emitted when the dialog has been rejected either by the
        user or by calling **reject** () or **done** () with the
        **QDialog::Rejected**  argument.

        Note that this signal is **not** emitted when hiding the dialog with
        **hide** () or **setVisible** (false). This includes deleting the dialog
        while it is visible.

        This function was introduced in Qt 4.1.

        **See also** **finished** () and **accepted** ().
        """
        ...
