"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QCompleter(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qcompleter.html

    **Detailed Description**

    You can use QCompleter to provide auto completions in any Qt widget, such as
    **QLineEdit**  and **QComboBox** . When the user starts typing a word,
    QCompleter suggests possible ways of completing the word, based on a word
    list. The word list is provided as a **QAbstractItemModel** . (For simple
    applications, where the word list is static, you can pass a **QStringList**
    to QCompleter's constructor.)

    **Basic Usage**

    A QCompleter is used typically with a **QLineEdit**  or **QComboBox** . For
    example, here's how to provide auto completions from a simple word list in a
    **QLineEdit** :

    **QStringList**  wordList;
        wordList << "alpha" << "omega" << "omicron"
    << "zeta";

        **QLineEdit**  *lineEdit = new **QLineEdit** (this);
    **QCompleter**  *completer = new **QCompleter** (wordList, this);
    completer->setCaseSensitivity(Qt::CaseInsensitive);
    lineEdit->setCompleter(completer);

    A **QFileSystemModel**  can be used to provide auto completion of file
    names. For example:

    **QCompleter**  *completer = new **QCompleter** (this);
    completer->setModel(new **QFileSystemModel** (completer));
    lineEdit->setCompleter(completer);

    To set the model on which QCompleter should operate, call **setModel** ().
    By default, QCompleter will attempt to match the **completion prefix**
    (i.e., the word that the user has started typing) against the
    **Qt::EditRole**  data stored in column 0 in the model case sensitively.
    This can be changed using **setCompletionRole** (), **setCompletionColumn**
    (), and **setCaseSensitivity** ().

    If the model is sorted on the column and role that are used for completion,
    you can call **setModelSorting** () with either
    **QCompleter::CaseSensitivelySortedModel**  or
    **QCompleter::CaseInsensitivelySortedModel**  as the argument. On large
    models, this can lead to significant performance improvements, because
    QCompleter can then use binary search instead of linear search. The binary
    search only works when the **filterMode**  is **Qt::MatchStartsWith** .

    The model can be a **list model** , a **table model** , or a **tree model**
    . Completion on tree models is slightly more involved and is covered in the
    **Handling Tree Models**  section below.

    The **completionMode** () determines the mode used to provide completions to
    the user.

    **Iterating Through Completions**

    To retrieve a single candidate string, call **setCompletionPrefix** () with
    the text that needs to be completed and call **currentCompletion** (). You
    can iterate through the list of completions as below:

    for (int i = 0; completer->setCurrentRow(i); i++)
            **qDebug** () <<
    completer->currentCompletion() << " is match number " << i;

    **completionCount** () returns the total number of completions for the
    current prefix. **completionCount** () should be avoided when possible,
    since it requires a scan of the entire model.

    **The Completion Model**

    **completionModel** () return a list model that contains all possible
    completions for the current completion prefix, in the order in which they
    appear in the model. This model can be used to display the current
    completions in a custom view. Calling **setCompletionPrefix** ()
    automatically refreshes the completion model.

    **Handling Tree Models**

    QCompleter can look for completions in tree models, assuming that any item
    (or sub-item or sub-sub-item) can be unambiguously represented as a string
    by specifying the path to the item. The completion is then performed one
    level at a time.

    Let's take the example of a user typing in a file system path. The model is
    a (hierarchical) **QFileSystemModel** . The completion occurs for every
    element in the path. For example, if the current text is `C:\\Wind`,
    QCompleter might suggest `Windows` to complete the current path element.
    Similarly, if the current text is `C:\\Windows\\Sy`, QCompleter might suggest
    `System`.

    For this kind of completion to work, QCompleter needs to be able to split
    the path into a list of strings that are matched at each level. For
    `C:\\Windows\\Sy`, it needs to be split as "C:", "Windows" and "Sy". The
    default implementation of **splitPath** (), splits the **completionPrefix**
    using **QDir::separator** () if the model is a **QFileSystemModel** .

    To provide completions, QCompleter needs to know the path from an index.
    This is provided by **pathFromIndex** (). The default implementation of
    **pathFromIndex** (), returns the data for the **edit role**  for list
    models and the absolute file path if the mode is a **QFileSystemModel** .

    **See also** **QAbstractItemModel** , **QLineEdit** , **QComboBox** , and
    **Completer Example** .
    """

    class ModelSorting(int):
        UnsortedModel: QCompleter = ...
        CaseSensitivelySortedModel: QCompleter = ...
        CaseInsensitivelySortedModel: QCompleter = ...

    class CompletionMode(int):
        PopupCompletion: QCompleter = ...
        UnfilteredPopupCompletion: QCompleter = ...
        InlineCompletion: QCompleter = ...

    @typing.overload
    def __init__(
        self,
        model: QtCore.QAbstractItemModel,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcompleter.html#QCompleter

        **QCompleter::QCompleter(QObject * parent = nullptr)**

        Constructs a completer object with the given **parent**.
        """
        ...

    @typing.overload
    def __init__(
        self, list: typing.Iterable[str], parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcompleter.html#QCompleter-1

        **QCompleter::QCompleter(QAbstractItemModel * model , QObject * parent =
        nullptr)**

        Constructs a completer object with the given **parent** that provides
        completions from the specified **model**.
        """
        ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcompleter.html#QCompleter-2

        **QCompleter::QCompleter(const QStringList & list , QObject * parent =
        nullptr)**

        Constructs a QCompleter object with the given **parent** that uses the
        specified **list** as a source of possible completions.
        """
        ...

    def filterMode(self) -> QtCore.Qt.MatchFlags:
        """
        https://doc.qt.io/qt-5/qcompleter.html#filterMode-prop

        **filterMode : Qt::MatchFlags**

        how the filtering is performed

        If filterMode is set to **Qt::MatchStartsWith** , only those entries
        that start with the typed characters will be displayed.
        **Qt::MatchContains**  will display the entries that contain the typed
        characters, and **Qt::MatchEndsWith**  the ones that end with the typed
        characters.

        Currently, only these three modes are implemented. Setting filterMode to
        any other **Qt::MatchFlag**  will issue a warning, and no action will be
        performed.

        The default mode is **Qt::MatchStartsWith** .

        This property was introduced in Qt 5.2.

        **Access functions:**

        Qt::MatchFlags **filterMode** () const
        void **setFilterMode**
        (Qt::MatchFlags **filterMode** )
        """
        ...

    def setFilterMode(
        self, filterMode: typing.Union[QtCore.Qt.MatchFlags, QtCore.Qt.MatchFlag]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcompleter.html#filterMode-prop

        **filterMode : Qt::MatchFlags**

        how the filtering is performed

        If filterMode is set to **Qt::MatchStartsWith** , only those entries
        that start with the typed characters will be displayed.
        **Qt::MatchContains**  will display the entries that contain the typed
        characters, and **Qt::MatchEndsWith**  the ones that end with the typed
        characters.

        Currently, only these three modes are implemented. Setting filterMode to
        any other **Qt::MatchFlag**  will issue a warning, and no action will be
        performed.

        The default mode is **Qt::MatchStartsWith** .

        This property was introduced in Qt 5.2.

        **Access functions:**

        Qt::MatchFlags **filterMode** () const
        void **setFilterMode**
        (Qt::MatchFlags **filterMode** )
        """
        ...

    def setMaxVisibleItems(self, maxItems: int) -> None:
        """
        https://doc.qt.io/qt-5/qcompleter.html#maxVisibleItems-prop

        **maxVisibleItems : int**

        This property holds the maximum allowed size on screen of the completer,
        measured in items

        By default, this property has a value of 7.

        This property was introduced in Qt 4.6.

        **Access functions:**

        int **maxVisibleItems** () const
        void **setMaxVisibleItems** (int
        **maxItems** )
        """
        ...

    def maxVisibleItems(self) -> int:
        """
        https://doc.qt.io/qt-5/qcompleter.html#maxVisibleItems-prop

        **maxVisibleItems : int**

        This property holds the maximum allowed size on screen of the completer,
        measured in items

        By default, this property has a value of 7.

        This property was introduced in Qt 4.6.

        **Access functions:**

        int **maxVisibleItems** () const
        void **setMaxVisibleItems** (int
        **maxItems** )
        """
        ...

    def event(self, a0: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qcompleter.html#event

        **[override virtual protected] bool QCompleter::event(QEvent * ev )**

        Reimplements: **QObject::event** (QEvent *e).
        """
        ...

    def eventFilter(self, o: QtCore.QObject, e: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qcompleter.html#eventFilter

        **[override virtual protected] bool QCompleter::eventFilter(QObject * o
        , QEvent * e )**

        Reimplements: **QObject::eventFilter** (QObject *watched, QEvent
        *event).
        """
        ...

    def setWrapAround(self, wrap: bool) -> None:
        """
        https://doc.qt.io/qt-5/qcompleter.html#wrapAround-prop

        **wrapAround : bool**

        This property holds the completions wrap around when navigating through
        items

        The default is true.

        This property was introduced in Qt 4.3.

        **Access functions:**

        bool **wrapAround** () const
        void **setWrapAround** (bool **wrap** )

        **Member Function Documentation**
        """
        ...

    def setCompletionPrefix(self, prefix: str) -> None:
        """
        https://doc.qt.io/qt-5/qcompleter.html#completionPrefix-prop

        **completionPrefix : QString**

        This property holds the completion prefix used to provide completions.

        The **completionModel** () is updated to reflect the list of possible
        matches for **prefix**.

        **Access functions:**

        QString **completionPrefix** () const
        void **setCompletionPrefix**
        (const QString & **prefix** )
        """
        ...

    def complete(self, rect: QtCore.QRect = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcompleter.html#complete

        **[slot] void QCompleter::complete(const QRect & rect = QRect())**

        For **QCompleter::PopupCompletion**  and
        QCompletion::UnfilteredPopupCompletion modes, calling this function
        displays the popup displaying the current completions. By default, if
        **rect** is not specified, the popup is displayed on the bottom of the
        **widget** (). If **rect** is specified the popup is displayed on the
        left edge of the rectangle.

        For **QCompleter::InlineCompletion**  mode, the **highlighted** ()
        signal is fired with the current completion.
        """
        ...

    def wrapAround(self) -> bool:
        """
        https://doc.qt.io/qt-5/qcompleter.html#wrapAround-prop

        **wrapAround : bool**

        This property holds the completions wrap around when navigating through
        items

        The default is true.

        This property was introduced in Qt 4.3.

        **Access functions:**

        bool **wrapAround** () const
        void **setWrapAround** (bool **wrap** )

        **Member Function Documentation**
        """
        ...

    def splitPath(self, path: str) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qcompleter.html#splitPath

        **[virtual] QStringList QCompleter::splitPath(const QString & path )
        const**

        Splits the given **path** into strings that are used to match at each
        level in the **model** ().

        The default implementation of splitPath() splits a file system path
        based on **QDir::separator** () when the sourceModel() is a
        **QFileSystemModel** .

        When used with list models, the first item in the returned list is used
        for matching.

        **See also** **pathFromIndex** () and **Handling Tree Models** .
        """
        ...

    def pathFromIndex(self, index: QtCore.QModelIndex) -> str:
        """
        https://doc.qt.io/qt-5/qcompleter.html#pathFromIndex

        **[virtual] QString QCompleter::pathFromIndex(const QModelIndex & index
        ) const**

        Returns the path for the given **index**. The completer object uses this
        to obtain the completion text from the underlying model.

        The default implementation returns the **edit role**  of the item for
        list models. It returns the absolute file path if the model is a
        **QFileSystemModel** .

        **See also** **splitPath** ().
        """
        ...

    def completionPrefix(self) -> str:
        """
        https://doc.qt.io/qt-5/qcompleter.html#completionPrefix-prop

        **completionPrefix : QString**

        This property holds the completion prefix used to provide completions.

        The **completionModel** () is updated to reflect the list of possible
        matches for **prefix**.

        **Access functions:**

        QString **completionPrefix** () const
        void **setCompletionPrefix**
        (const QString & **prefix** )
        """
        ...

    def completionModel(self) -> QtCore.QAbstractItemModel:
        """
        https://doc.qt.io/qt-5/qcompleter.html#completionModel

        **QAbstractItemModel *QCompleter::completionModel() const**

        Returns the completion model. The completion model is a read-only list
        model that contains all the possible matches for the current completion
        prefix. The completion model is auto-updated to reflect the current
        completions.

        **Note:** The return value of this function is defined to be an
        **QAbstractItemModel**  purely for generality. This actual kind of model
        returned is an instance of an **QAbstractProxyModel**  subclass.

        **See also** **completionPrefix**  and **model** ().
        """
        ...

    def currentCompletion(self) -> str:
        """
        https://doc.qt.io/qt-5/qcompleter.html#currentCompletion

        **QString QCompleter::currentCompletion() const**

        Returns the current completion string. This includes the
        **completionPrefix** . When used alongside **setCurrentRow** (), it can
        be used to iterate through all the matches.

        **See also** **setCurrentRow** () and **currentIndex** ().
        """
        ...

    def currentIndex(self) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-5/qcompleter.html#currentIndex

        **QModelIndex QCompleter::currentIndex() const**

        Returns the model index of the current completion in the
        **completionModel** ().

        **See also** **setCurrentRow** (), **currentCompletion** (), and
        **model** ().
        """
        ...

    def currentRow(self) -> int:
        """
        https://doc.qt.io/qt-5/qcompleter.html#currentRow

        **int QCompleter::currentRow() const**

        Returns the current row.

        **See also** **setCurrentRow** ().
        """
        ...

    def setCurrentRow(self, row: int) -> bool:
        """
        https://doc.qt.io/qt-5/qcompleter.html#setCurrentRow

        **bool QCompleter::setCurrentRow(int row )**

        Sets the current row to the **row** specified. Returns `true` if
        successful; otherwise returns `false`.

        This function may be used along with **currentCompletion** () to iterate
        through all the possible completions.

        **See also** **currentRow** (), **currentCompletion** (), and
        **completionCount** ().
        """
        ...

    def completionCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qcompleter.html#completionCount

        **int QCompleter::completionCount() const**

        Returns the number of completions for the current prefix. For an
        unsorted model with a large number of items this can be expensive. Use
        **setCurrentRow** () and **currentCompletion** () to iterate through all
        the completions.
        """
        ...

    def completionRole(self) -> int:
        """
        https://doc.qt.io/qt-5/qcompleter.html#completionRole-prop

        **completionRole : int**

        This property holds the item role to be used to query the contents of
        items for matching.

        The default role is **Qt::EditRole** .

        **Access functions:**

        int **completionRole** () const
        void **setCompletionRole** (int
        **role** )

        **See also** **completionColumn**  and **caseSensitivity** .
        """
        ...

    def setCompletionRole(self, role: int) -> None:
        """
        https://doc.qt.io/qt-5/qcompleter.html#completionRole-prop

        **completionRole : int**

        This property holds the item role to be used to query the contents of
        items for matching.

        The default role is **Qt::EditRole** .

        **Access functions:**

        int **completionRole** () const
        void **setCompletionRole** (int
        **role** )

        **See also** **completionColumn**  and **caseSensitivity** .
        """
        ...

    def completionColumn(self) -> int:
        """
        https://doc.qt.io/qt-5/qcompleter.html#completionColumn-prop

        **completionColumn : int**

        This property holds the column in the model in which completions are
        searched for.

        If the **popup** () is a **QListView** , it is automatically setup to
        display this column.

        By default, the match column is 0.

        **Access functions:**

        int **completionColumn** () const
        void **setCompletionColumn** (int
        **column** )

        **See also** **completionRole**  and **caseSensitivity** .
        """
        ...

    def setCompletionColumn(self, column: int) -> None:
        """
        https://doc.qt.io/qt-5/qcompleter.html#completionColumn-prop

        **completionColumn : int**

        This property holds the column in the model in which completions are
        searched for.

        If the **popup** () is a **QListView** , it is automatically setup to
        display this column.

        By default, the match column is 0.

        **Access functions:**

        int **completionColumn** () const
        void **setCompletionColumn** (int
        **column** )

        **See also** **completionRole**  and **caseSensitivity** .
        """
        ...

    def modelSorting(self) -> "QCompleter.ModelSorting":
        """
        https://doc.qt.io/qt-5/qcompleter.html#modelSorting-prop

        **modelSorting : ModelSorting**

        This property holds the way the model is sorted

        By default, no assumptions are made about the order of the items in the
        model that provides the completions.

        If the model's data for the **completionColumn** () and
        **completionRole** () is sorted in ascending order, you can set this
        property to **CaseSensitivelySortedModel**  or
        **CaseInsensitivelySortedModel** . On large models, this can lead to
        significant performance improvements because the completer object can
        then use a binary search algorithm instead of linear search algorithm.

        The sort order (i.e ascending or descending order) of the model is
        determined dynamically by inspecting the contents of the model.

        **Note:** The performance improvements described above cannot take place
        when the completer's **caseSensitivity**  is different to the case
        sensitivity used by the model's when sorting.

        **Access functions:**

        QCompleter::ModelSorting **modelSorting** () const
        void
        **setModelSorting** (QCompleter::ModelSorting **sorting** )

        **See also** **setCaseSensitivity** () and **QCompleter::ModelSorting**
        .
        """
        ...

    def setModelSorting(self, sorting: "QCompleter.ModelSorting") -> None:
        """
        https://doc.qt.io/qt-5/qcompleter.html#modelSorting-prop

        **modelSorting : ModelSorting**

        This property holds the way the model is sorted

        By default, no assumptions are made about the order of the items in the
        model that provides the completions.

        If the model's data for the **completionColumn** () and
        **completionRole** () is sorted in ascending order, you can set this
        property to **CaseSensitivelySortedModel**  or
        **CaseInsensitivelySortedModel** . On large models, this can lead to
        significant performance improvements because the completer object can
        then use a binary search algorithm instead of linear search algorithm.

        The sort order (i.e ascending or descending order) of the model is
        determined dynamically by inspecting the contents of the model.

        **Note:** The performance improvements described above cannot take place
        when the completer's **caseSensitivity**  is different to the case
        sensitivity used by the model's when sorting.

        **Access functions:**

        QCompleter::ModelSorting **modelSorting** () const
        void
        **setModelSorting** (QCompleter::ModelSorting **sorting** )

        **See also** **setCaseSensitivity** () and **QCompleter::ModelSorting**
        .
        """
        ...

    def caseSensitivity(self) -> QtCore.Qt.CaseSensitivity:
        """
        https://doc.qt.io/qt-5/qcompleter.html#caseSensitivity-prop

        **caseSensitivity : Qt::CaseSensitivity**

        This property holds the case sensitivity of the matching

        The default is **Qt::CaseSensitive** .

        **Access functions:**

        Qt::CaseSensitivity **caseSensitivity** () const
        void
        **setCaseSensitivity** (Qt::CaseSensitivity **caseSensitivity** )

        **See also** **completionColumn** , **completionRole** , and
        **modelSorting** .
        """
        ...

    def setCaseSensitivity(self, caseSensitivity: QtCore.Qt.CaseSensitivity) -> None:
        """
        https://doc.qt.io/qt-5/qcompleter.html#caseSensitivity-prop

        **caseSensitivity : Qt::CaseSensitivity**

        This property holds the case sensitivity of the matching

        The default is **Qt::CaseSensitive** .

        **Access functions:**

        Qt::CaseSensitivity **caseSensitivity** () const
        void
        **setCaseSensitivity** (Qt::CaseSensitivity **caseSensitivity** )

        **See also** **completionColumn** , **completionRole** , and
        **modelSorting** .
        """
        ...

    def setPopup(self, popup: QAbstractItemView) -> None:
        """
        https://doc.qt.io/qt-5/qcompleter.html#setPopup

        **void QCompleter::setPopup(QAbstractItemView * popup )**

        Sets the popup used to display completions to **popup**. **QCompleter**
        takes ownership of the view.

        A **QListView**  is automatically created when the **completionMode** ()
        is set to **QCompleter::PopupCompletion**  or
        **QCompleter::UnfilteredPopupCompletion** . The default popup displays
        the **completionColumn** ().

        Ensure that this function is called before the view settings are
        modified. This is required since view's properties may require that a
        model has been set on the view (for example, hiding columns in the view
        requires a model to be set on the view).

        **See also** **popup** ().
        """
        ...

    def popup(self) -> QAbstractItemView:
        """
        https://doc.qt.io/qt-5/qcompleter.html#popup

        **QAbstractItemView *QCompleter::popup() const**

        Returns the popup used to display completions.

        **See also** **setPopup** ().
        """
        ...

    def completionMode(self) -> "QCompleter.CompletionMode":
        """
        https://doc.qt.io/qt-5/qcompleter.html#completionMode-prop

        **completionMode : CompletionMode**

        how the completions are provided to the user

        The default value is **QCompleter::PopupCompletion** .

        **Access functions:**

        QCompleter::CompletionMode **completionMode** () const
        void
        **setCompletionMode** (QCompleter::CompletionMode **mode** )
        """
        ...

    def setCompletionMode(self, mode: "QCompleter.CompletionMode") -> None:
        """
        https://doc.qt.io/qt-5/qcompleter.html#completionMode-prop

        **completionMode : CompletionMode**

        how the completions are provided to the user

        The default value is **QCompleter::PopupCompletion** .

        **Access functions:**

        QCompleter::CompletionMode **completionMode** () const
        void
        **setCompletionMode** (QCompleter::CompletionMode **mode** )
        """
        ...

    def model(self) -> QtCore.QAbstractItemModel:
        """
        https://doc.qt.io/qt-5/qcompleter.html#model

        **QAbstractItemModel *QCompleter::model() const**

        Returns the model that provides completion strings.

        **See also** **setModel** () and **completionModel** ().
        """
        ...

    def setModel(self, c: QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-5/qcompleter.html#setModel

        **void QCompleter::setModel(QAbstractItemModel * model )**

        Sets the model which provides completions to **model**. The **model**
        can be list model or a tree model. If a model has been already
        previously set and it has the **QCompleter**  as its parent, it is
        deleted.

        For convenience, if **model** is a **QFileSystemModel** , **QCompleter**
        switches its **caseSensitivity**  to **Qt::CaseInsensitive**  on Windows
        and **Qt::CaseSensitive**  on other platforms.

        **See also** **completionModel** (), **modelSorting** , and **Handling
        Tree Models** .
        """
        ...

    def widget(self) -> QWidget:
        """
        https://doc.qt.io/qt-5/qcompleter.html#widget

        **QWidget *QCompleter::widget() const**

        Returns the widget for which the completer object is providing
        completions.

        **See also** **setWidget** ().
        """
        ...

    def setWidget(self, widget: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qcompleter.html#setWidget

        **void QCompleter::setWidget(QWidget * widget )**

        Sets the widget for which completion are provided for to **widget**.
        This function is automatically called when a **QCompleter**  is set on a
        **QLineEdit**  using **QLineEdit::setCompleter** () or on a
        **QComboBox**  using **QComboBox::setCompleter** (). The widget needs to
        be set explicitly when providing completions for custom widgets.

        **See also** **widget** (), **setModel** (), and **setPopup** ().
        """
        ...

    @property
    def activated(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcompleter.html#activated

        **[signal] void QCompleter::activated(const QString & text )**

        This signal is sent when an item in the **popup** () is activated by the
        user (by clicking or pressing return). The item's **text** is given.

        **Note:** Signal **activated** is overloaded in this class. To connect
        to this signal by using the function pointer syntax, Qt provides a
        convenient helper for obtaining the function pointer as shown in this
        example:

        connect(completer, QOverload<const **QString**  &>::of(&**QCompleter**
        ::activated),
                [=](const **QString**  &text){ /* ... */ });
        """
        ...

    @property
    def activated(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcompleter.html#activated-1

        **[signal] void QCompleter::activated(const QModelIndex & index )**

        This signal is sent when an item in the **popup** () is activated by the
        user. (by clicking or pressing return). The item's **index** in the
        **completionModel** () is given.

        **Note:** Signal **activated** is overloaded in this class. To connect
        to this signal by using the function pointer syntax, Qt provides a
        convenient helper for obtaining the function pointer as shown in this
        example:

        connect(completer, QOverload<const **QModelIndex**
        &>::of(&**QCompleter** ::activated),
                [=](const **QModelIndex**
        &index){ /* ... */ });
        """
        ...

    @property
    def highlighted(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcompleter.html#highlighted

        **[signal] void QCompleter::highlighted(const QString & text )**

        This signal is sent when an item in the **popup** () is highlighted by
        the user. It is also sent if **complete** () is called with the
        **completionMode** () set to **QCompleter::InlineCompletion** . The
        item's **text** is given.

        **Note:** Signal **highlighted** is overloaded in this class. To connect
        to this signal by using the function pointer syntax, Qt provides a
        convenient helper for obtaining the function pointer as shown in this
        example:

        connect(completer, QOverload<const **QString**  &>::of(&**QCompleter**
        ::highlighted),
                [=](const **QString**  &text){ /* ... */ });
        """
        ...

    @property
    def highlighted(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcompleter.html#highlighted-1

        **[signal] void QCompleter::highlighted(const QModelIndex & index )**

        This signal is sent when an item in the **popup** () is highlighted by
        the user. It is also sent if **complete** () is called with the
        **completionMode** () set to **QCompleter::InlineCompletion** . The
        item's **index** in the **completionModel** () is given.

        **Note:** Signal **highlighted** is overloaded in this class. To connect
        to this signal by using the function pointer syntax, Qt provides a
        convenient helper for obtaining the function pointer as shown in this
        example:

        connect(completer, QOverload<const **QModelIndex**
        &>::of(&**QCompleter** ::highlighted),
                [=](const **QModelIndex**
        &index){ /* ... */ });
        """
        ...
