"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtTest import *


class QAbstractItemModelTester(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qabstractitemmodeltester.html

    **Detailed Description**

    The QAbstractItemModelTester class is a utility class to test item models.

    When implementing an item model (that is, a concrete **QAbstractItemModel**
    subclass) one must abide to a very strict set of rules that ensure
    consistency for users of the model (views, proxy models, and so on).

    For instance, for a given index, a model's reimplementation of
    **hasChildren()**  must be consistent with the values returned by
    **rowCount()**  and **columnCount()** .

    QAbstractItemModelTester helps catching the most common errors in custom
    item model classes. By performing a series of tests, it will try to check
    that the model status is consistent at all times. The tests will be repeated
    automatically every time the model is modified.

    QAbstractItemModelTester employs non-destructive tests, which typically
    consist in reading data and metadata out of a given item model.
    QAbstractItemModelTester will also attempt illegal modifications of the
    model. In models which are properly implemented, such attempts should be
    rejected, and no data should be changed as a consequence.

    **Usage**

    Using QAbstractItemModelTester is straightforward. In a **test case**  it is
    sufficient to create an instance, passing the model that needs to be tested
    to the constructor:

    MyModel *modelToBeTested = ...;
        auto tester = new
    **QAbstractItemModelTester** (modelToBeTested);

    QAbstractItemModelTester will report testing failures through the Qt Test
    logging mechanisms.

    It is also possible to use QAbstractItemModelTester outside of a test case.
    For instance, it may be useful to test an item model used by an application
    without the need of building an explicit unit test for such a model (which
    might be challenging). In order to use QAbstractItemModelTester outside of a
    test case, pass one of the `QAbstractItemModelTester::FailureReportingMode`
    enumerators to its constructor, therefore specifying how failures should be
    logged.

    QAbstractItemModelTester may also report additional debugging information as
    logging messages under the `qt.modeltest` logging category. Such debug
    logging is disabled by default; refer to the **QLoggingCategory**
    documentation to learn how to enable it.

    **Note:** While QAbstractItemModelTester is a valid help for development and
    testing of custom item models, it does not (and cannot) catch all possible
    problems in **QAbstractItemModel**  subclasses. Notably, it will never
    perform meaningful destructive testing of a model, which must be therefore
    tested separately.

    **See also** **Model/View Programming**  and **QAbstractItemModel** .
    """

    class FailureReportingMode(int):
        QtTest: QAbstractItemModelTester = ...
        Warning: QAbstractItemModelTester = ...
        Fatal: QAbstractItemModelTester = ...

    @typing.overload
    def __init__(
        self,
        model: QtCore.QAbstractItemModel,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qabstractitemmodeltester.html#QAbstractItemModelT
        ester

        **QAbstractItemModelTester::QAbstractItemModelTester(QAbstractItemModel
        * model , QObject * parent = nullptr)**

        Creates a model tester instance, with the given **parent** , that will
        test the model **model**.
        """
        ...

    @typing.overload
    def __init__(
        self,
        model: QtCore.QAbstractItemModel,
        mode: "QAbstractItemModelTester.FailureReportingMode",
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qabstractitemmodeltester.html#QAbstractItemModelT
        ester-1

        **QAbstractItemModelTester::QAbstractItemModelTester(QAbstractItemModel
        * model , QAbstractItemModelTester::FailureReportingMode mode , QObject
        * parent = nullptr)**

        Creates a model tester instance, with the given **parent** , that will
        test the model **model** , using the specified **mode** to report test
        failures.

        **See also** **QAbstractItemModelTester::FailureReportingMode** .
        """
        ...

    def failureReportingMode(self) -> "QAbstractItemModelTester.FailureReportingMode":
        """
        https://doc.qt.io/qt-5/qabstractitemmodeltester.html#failureReportingMod
        e

        **QAbstractItemModelTester::FailureReportingMode
        QAbstractItemModelTester::failureReportingMode() const**

        Returns the mode that this instancing is using to report test failures.

        **See also** **QAbstractItemModelTester::FailureReportingMode** .
        """
        ...

    def model(self) -> QtCore.QAbstractItemModel:
        """
        https://doc.qt.io/qt-5/qabstractitemmodeltester.html#model

        **QAbstractItemModel *QAbstractItemModelTester::model() const**

        Returns the model that this instance is testing.
        """
        ...
