"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import QtWidgets
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtSvg import *


class QGraphicsSvgItem(QtWidgets.QGraphicsObject):
    """
    https://doc.qt.io/qt-5/qgraphicssvgitem.html

    **Detailed Description**

    QGraphicsSvgItem provides a way of rendering SVG files onto
    **QGraphicsView** . QGraphicsSvgItem can be created by passing the SVG file
    to be rendered to its constructor or by explicit setting a shared
    **QSvgRenderer**  on it.

    Note that setting **QSvgRenderer**  on a QGraphicsSvgItem doesn't make the
    item take ownership of the renderer, therefore if using
    **setSharedRenderer** () method one has to make sure that the lifetime of
    the **QSvgRenderer**  object will be at least as long as that of the
    QGraphicsSvgItem.

    QGraphicsSvgItem provides a way of rendering only parts of the SVG files via
    the **setElementId** . If **setElementId** () method is called, only the SVG
    element (and its children) with the passed id will be renderer. This
    provides a convenient way of selectively rendering large SVG files that
    contain a number of discrete elements. For example the following code
    renders only jokers from a SVG file containing a whole card deck:

    **QSvgRenderer**  *renderer = new **QSvgRenderer**
    (QLatin1String("SvgCardDeck.svg"));
        **QGraphicsSvgItem**  *black = new
    **QGraphicsSvgItem** ();
        **QGraphicsSvgItem**  *red   = new
    **QGraphicsSvgItem** ();

        black->setSharedRenderer(renderer);
    black->setElementId(QLatin1String("black_joker"));
    red->setSharedRenderer(renderer);
    red->setElementId(QLatin1String("red_joker"));

    Size of the item can be set via direct manipulation of the items
    transformation matrix.

    By default the SVG rendering is cached using
    **QGraphicsItem::DeviceCoordinateCache**  mode to speedup the display of
    items. Caching can be disabled by passing **QGraphicsItem::NoCache**  to the
    **QGraphicsItem::setCacheMode** () method.

    **See also** **QSvgWidget** , **Qt SVG C++ Classes** , **QGraphicsItem** ,
    and **QGraphicsView** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QtWidgets.QGraphicsItem] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicssvgitem.html#QGraphicsSvgItem

        **QGraphicsSvgItem::QGraphicsSvgItem(QGraphicsItem * parent = nullptr)**

        Constructs a new SVG item with the given **parent**.
        """
        ...

    @typing.overload
    def __init__(
        self, fileName: str, parent: typing.Optional[QtWidgets.QGraphicsItem] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicssvgitem.html#QGraphicsSvgItem-1

        **QGraphicsSvgItem::QGraphicsSvgItem(const QString & fileName ,
        QGraphicsItem * parent = nullptr)**

        Constructs a new item with the given **parent** and loads the contents
        of the SVG file with the specified **fileName**.
        """
        ...

    def type(self) -> int:
        """
        https://doc.qt.io/qt-5/qgraphicssvgitem.html#type

        **[override virtual] int QGraphicsSvgItem::type() const**

        Reimplements: **QGraphicsItem::type** () const.
        """
        ...

    def paint(
        self,
        painter: QtGui.QPainter,
        option: QtWidgets.QStyleOptionGraphicsItem,
        widget: typing.Optional[QtWidgets.QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicssvgitem.html#paint

        **[override virtual] void QGraphicsSvgItem::paint(QPainter * painter ,
        const QStyleOptionGraphicsItem * option , QWidget * widget = nullptr)**

        Reimplements: **QGraphicsItem::paint** (QPainter *painter, const
        QStyleOptionGraphicsItem *option, QWidget *widget).
        """
        ...

    def boundingRect(self) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qgraphicssvgitem.html#boundingRect

        **[override virtual] QRectF QGraphicsSvgItem::boundingRect() const**

        Reimplements: **QGraphicsItem::boundingRect** () const.

        Returns the bounding rectangle of this item.
        """
        ...

    def maximumCacheSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qgraphicssvgitem.html#maximumCacheSize

        **QSize QGraphicsSvgItem::maximumCacheSize() const**

        Returns the current maximum size of the device coordinate cache for this
        item. If the item is cached using
        **QGraphicsItem::DeviceCoordinateCache**  mode, caching is bypassed if
        the extension of the item in device coordinates is larger than the
        maximum size.

        The default maximum cache size is 1024x768. **QPixmapCache::cacheLimit**
        () gives the cumulative bounds of the whole cache, whereas
        maximumCacheSize() refers to a maximum cache size for this particular
        item.

        **Note:** Getter function for property maximumCacheSize.

        **See also** **setMaximumCacheSize** () and **QGraphicsItem::cacheMode**
        ().
        """
        ...

    def setMaximumCacheSize(self, size: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicssvgitem.html#setMaximumCacheSize

        **void QGraphicsSvgItem::setMaximumCacheSize(const QSize & size )**

        Sets the maximum device coordinate cache size of the item to **size**.
        If the item is cached using **QGraphicsItem::DeviceCoordinateCache**
        mode, caching is bypassed if the extension of the item in device
        coordinates is larger than **size**.

        The cache corresponds to the **QPixmap**  which is used to cache the
        results of the rendering. Use **QPixmapCache::setCacheLimit** () to set
        limitations on the whole cache and use setMaximumCacheSize() when
        setting cache size for individual items.

        **Note:** Setter function for property **maximumCacheSize** .

        **See also** **maximumCacheSize** () and **QGraphicsItem::cacheMode**
        ().
        """
        ...

    def elementId(self) -> str:
        """
        https://doc.qt.io/qt-5/qgraphicssvgitem.html#elementId

        **QString QGraphicsSvgItem::elementId() const**

        Returns the XML ID the element that is currently being rendered. Returns
        an empty string if the whole file is being rendered.

        **Note:** Getter function for property elementId.

        **See also** **setElementId** ().
        """
        ...

    def setElementId(self, id: str) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicssvgitem.html#setElementId

        **void QGraphicsSvgItem::setElementId(const QString & id )**

        Sets the XML ID of the element to **id**.

        **Note:** Setter function for property **elementId** .

        **See also** **elementId** ().
        """
        ...

    def renderer(self) -> "QSvgRenderer":
        """
        https://doc.qt.io/qt-5/qgraphicssvgitem.html#renderer

        **QSvgRenderer *QGraphicsSvgItem::renderer() const**

        Returns the currently use **QSvgRenderer** .
        """
        ...

    def setSharedRenderer(self, renderer: "QSvgRenderer") -> None:
        """
        https://doc.qt.io/qt-5/qgraphicssvgitem.html#setSharedRenderer

        **void QGraphicsSvgItem::setSharedRenderer(QSvgRenderer * renderer )**

        Sets **renderer** to be a shared **QSvgRenderer**  on the item. By using
        this method one can share the same **QSvgRenderer**  on a number of
        items. This means that the SVG file will be parsed only once.
        **QSvgRenderer**  passed to this method has to exist for as long as this
        item is used.
        """
        ...
