"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5 import sip


class QSqlRelation(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qsqlrelation.html

    **Detailed Description**

    QSqlRelation is a helper class for **QSqlRelationalTableModel** . See
    **QSqlRelationalTableModel::setRelation** () and
    **QSqlRelationalTableModel::relation** () for details.

    **See also** **QSqlRelationalTableModel** , **QSqlRelationalDelegate** , and
    **Relational Table Model Example** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qsqlrelation.html#QSqlRelation

        **QSqlRelation::QSqlRelation()**

        Constructs an invalid QSqlRelation object.

        For such an object, the **tableName** (), **indexColumn** (), and
        **displayColumn** () functions return an empty string.

        **See also** **isValid** ().
        """
        ...

    @typing.overload
    def __init__(self, aTableName: str, indexCol: str, displayCol: str) -> None:
        """
        https://doc.qt.io/qt-5/qsqlrelation.html#QSqlRelation-1

        **QSqlRelation::QSqlRelation(const QString & tableName , const QString &
        indexColumn , const QString & displayColumn )**

        Constructs a QSqlRelation object, where **tableName** is the SQL table
        name to which a foreign key refers, **indexColumn** is the foreign key,
        and **displayColumn** is the field that should be presented to the user.

        **See also** **tableName** (), **indexColumn** (), and **displayColumn**
        ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QSqlRelation") -> None:
        """
        https://doc.qt.io/qt-5/qsqlrelation.html#QSqlRelation

        **QSqlRelation::QSqlRelation()**

        Constructs an invalid QSqlRelation object.

        For such an object, the **tableName** (), **indexColumn** (), and
        **displayColumn** () functions return an empty string.

        **See also** **isValid** ().
        """
        ...

    def swap(self, other: "QSqlRelation") -> None:
        """
        https://doc.qt.io/qt-5/qsqlrelation.html#swap

        **void QSqlRelation::swap(QSqlRelation & other )**

        Swaps `this` with **other**.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsqlrelation.html#isValid

        **bool QSqlRelation::isValid() const**

        Returns `true` if the **QSqlRelation**  object is valid; otherwise
        returns `false`.
        """
        ...

    def displayColumn(self) -> str:
        """
        https://doc.qt.io/qt-5/qsqlrelation.html#displayColumn

        **QString QSqlRelation::displayColumn() const**

        Returns the column from table **tableName** () that should be presented
        to the user instead of a foreign key.
        """
        ...

    def indexColumn(self) -> str:
        """
        https://doc.qt.io/qt-5/qsqlrelation.html#indexColumn

        **QString QSqlRelation::indexColumn() const**

        Returns the index column from table **tableName** () to which a foreign
        key refers.
        """
        ...

    def tableName(self) -> str:
        """
        https://doc.qt.io/qt-5/qsqlrelation.html#tableName

        **QString QSqlRelation::tableName() const**

        Returns the name of the table to which a foreign key refers.
        """
        ...
