"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

Generated by BaiJiFeiLong@gmail.com

Licence: GPLv3
"""
import typing
from PyQt5.QtSerialPort import *
from PyQt5 import sip


class QSerialPortInfo(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qserialportinfo.html

    **Detailed Description**

    Use the static functions to generate a list of QSerialPortInfo objects. Each
    QSerialPortInfo object in the list represents a single serial port and can
    be queried for the port name, system location, description, and
    manufacturer. The QSerialPortInfo class can also be used as an input
    parameter for the setPort() method of the **QSerialPort**  class.

    **See also** **QSerialPort** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qserialportinfo.html#QSerialPortInfo

        **QSerialPortInfo::QSerialPortInfo()**

        Constructs an empty QSerialPortInfo object.

        **See also** **isNull** ().
        """
        ...

    @typing.overload
    def __init__(self, port: QSerialPort) -> None:
        """
        https://doc.qt.io/qt-5/qserialportinfo.html#QSerialPortInfo-1

        **QSerialPortInfo::QSerialPortInfo(const QSerialPort & port )**

        Constructs a QSerialPortInfo object from serial **port**.
        """
        ...

    @typing.overload
    def __init__(self, name: str) -> None:
        """
        https://doc.qt.io/qt-5/qserialportinfo.html#QSerialPortInfo-2

        **QSerialPortInfo::QSerialPortInfo(const QString & name )**

        Constructs a QSerialPortInfo object from serial port **name**.

        This constructor finds the relevant serial port among the available ones
        according to the port name **name** , and constructs the serial port
        info instance for that port.
        """
        ...

    @typing.overload
    def __init__(self, other: "QSerialPortInfo") -> None:
        """
        https://doc.qt.io/qt-5/qserialportinfo.html#QSerialPortInfo-3

        **QSerialPortInfo::QSerialPortInfo(const QSerialPortInfo & other )**

        Constructs a copy of **other**.
        """
        ...

    def serialNumber(self) -> str:
        """
        https://doc.qt.io/qt-5/qserialportinfo.html#serialNumber

        **QString QSerialPortInfo::serialNumber() const**

        Returns the serial number string of the serial port, if available;
        otherwise returns an empty string.

        **Note:** The serial number may include letters.

        This function was introduced in Qt 5.3.

        **See also** **description** () and **manufacturer** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qserialportinfo.html#isNull

        **bool QSerialPortInfo::isNull() const**

        Returns whether this **QSerialPortInfo**  object holds a serial port
        definition.

        **See also** **isBusy** ().
        """
        ...

    @staticmethod
    def availablePorts() -> typing.List["QSerialPortInfo"]:
        """
        https://doc.qt.io/qt-5/qserialportinfo.html#availablePorts

        **[static] QList<QSerialPortInfo> QSerialPortInfo::availablePorts()**

        Returns a list of available serial ports on the system.
        """
        ...

    @staticmethod
    def standardBaudRates() -> typing.List[int]:
        """
        https://doc.qt.io/qt-5/qserialportinfo.html#standardBaudRates

        **[static] QList<qint32> QSerialPortInfo::standardBaudRates()**

        Returns a list of available standard baud rates supported by the target
        platform.
        """
        ...

    def isValid(self) -> bool:
        ...

    def isBusy(self) -> bool:
        ...

    def hasProductIdentifier(self) -> bool:
        """
        https://doc.qt.io/qt-5/qserialportinfo.html#hasProductIdentifier

        **bool QSerialPortInfo::hasProductIdentifier() const**

        Returns `true` if there is a valid `16-bit` product number present;
        otherwise returns `false`.

        **See also** **productIdentifier** (), **vendorIdentifier** (), and
        **hasVendorIdentifier** ().
        """
        ...

    def hasVendorIdentifier(self) -> bool:
        """
        https://doc.qt.io/qt-5/qserialportinfo.html#hasVendorIdentifier

        **bool QSerialPortInfo::hasVendorIdentifier() const**

        Returns `true` if there is a valid `16-bit` vendor number present;
        otherwise returns `false`.

        **See also** **vendorIdentifier** (), **productIdentifier** (), and
        **hasProductIdentifier** ().
        """
        ...

    def productIdentifier(self) -> int:
        """
        https://doc.qt.io/qt-5/qserialportinfo.html#productIdentifier

        **quint16 QSerialPortInfo::productIdentifier() const**

        Returns the 16-bit product number for the serial port, if available;
        otherwise returns zero.

        **See also** **hasProductIdentifier** (), **vendorIdentifier** (), and
        **hasVendorIdentifier** ().
        """
        ...

    def vendorIdentifier(self) -> int:
        """
        https://doc.qt.io/qt-5/qserialportinfo.html#vendorIdentifier

        **quint16 QSerialPortInfo::vendorIdentifier() const**

        Returns the 16-bit vendor number for the serial port, if available;
        otherwise returns zero.

        **See also** **hasVendorIdentifier** (), **productIdentifier** (), and
        **hasProductIdentifier** ().
        """
        ...

    def manufacturer(self) -> str:
        """
        https://doc.qt.io/qt-5/qserialportinfo.html#manufacturer

        **QString QSerialPortInfo::manufacturer() const**

        Returns the manufacturer string of the serial port, if available;
        otherwise returns an empty string.

        **See also** **description** () and **serialNumber** ().
        """
        ...

    def description(self) -> str:
        """
        https://doc.qt.io/qt-5/qserialportinfo.html#description

        **QString QSerialPortInfo::description() const**

        Returns the description string of the serial port, if available;
        otherwise returns an empty string.

        **See also** **manufacturer** () and **serialNumber** ().
        """
        ...

    def systemLocation(self) -> str:
        """
        https://doc.qt.io/qt-5/qserialportinfo.html#systemLocation

        **QString QSerialPortInfo::systemLocation() const**

        Returns the system location of the serial port.

        **See also** **portName** ().
        """
        ...

    def portName(self) -> str:
        """
        https://doc.qt.io/qt-5/qserialportinfo.html#portName

        **QString QSerialPortInfo::portName() const**

        Returns the name of the serial port.

        **See also** **systemLocation** ().
        """
        ...

    def swap(self, other: "QSerialPortInfo") -> None:
        """
        https://doc.qt.io/qt-5/qserialportinfo.html#swap

        **void QSerialPortInfo::swap(QSerialPortInfo & other )**

        Swaps **QSerialPortInfo**  **other** with this **QSerialPortInfo** .
        This operation is very fast and never fails.
        """
        ...
